/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.buildingblocks;

import java.io.FileInputStream;
import java.util.Hashtable;
import m2m.backend.buildingblocks.BuildingBlock;

public class BuildingBlockLoader
extends ClassLoader {
    private static BuildingBlockLoader instance = null;
    private Hashtable<String, Class<?>> classes = new Hashtable();
    private String m_dir;
    private String m_packageName;

    public static BuildingBlockLoader getInstance() {
        if (instance == null) {
            instance = new BuildingBlockLoader();
        }
        return instance;
    }

    public void setDir(String dir) {
        this.m_dir = dir;
    }

    public void setPackageName(String name) {
        this.m_packageName = name;
    }

    private byte[] getClassImplFromDataBase(String className) {
        try {
            FileInputStream fi = new FileInputStream(String.valueOf(this.m_dir) + "/" + className + ".class");
            byte[] result = new byte[fi.available()];
            fi.read(result);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> c = this.loadClass(className, true);
        return c;
    }

    public BuildingBlock newInstance(String className) throws ClassNotFoundException {
        try {
            Object o = this.loadClass(className).newInstance();
            BuildingBlock b = (BuildingBlock)o;
            return b;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public synchronized Class<?> loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        try {
            Class<?> t = Class.forName(className);
            return t;
        }
        catch (Exception exception) {
            Class<?> result = this.classes.get(className);
            if (result != null) {
                return result;
            }
            try {
                result = super.findSystemClass(className);
                return result;
            }
            catch (ClassNotFoundException classNotFoundException) {
                byte[] classData = this.getClassImplFromDataBase(className);
                if (classData == null) {
                    throw new ClassNotFoundException();
                }
                result = this.defineClass(String.valueOf(this.m_packageName) + "." + className, classData, 0, classData.length);
                if (result == null) {
                    throw new ClassFormatError();
                }
                if (resolveIt) {
                    this.resolveClass(result);
                }
                try {
                    this.classes.put(className, result);
                }
                catch (NullPointerException nullPointerException) {}
                return result;
            }
        }
    }
}

