/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.processing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.processing.Errors;
import m2m.backend.processing.OctaveScriptCreator;
import m2m.backend.processing.ProcessWatcher;
import m2m.backend.processing.SystemVerilogCreator;
import m2m.backend.project.ExternalToolsProperties;
import m2m.backend.project.M2MProject;
import m2m.backend.project.SimulationResult;
import m2m.backend.structure.StructTreatment;
import m2m.backend.utils.FileUtils;
import m2m.backend.verifpga.ISETCLGenerator;
import m2m.backend.verifpga.M2MClient;

public class ExternalRuns {
    private static ExternalRuns instance = null;
    private static int nbSimErrors;

    public static ExternalRuns getInstance() {
        if (instance == null) {
            instance = new ExternalRuns();
        }
        return instance;
    }

    private ExternalRuns() {
    }

    public static boolean runAll(M2MProject project) {
        project.checkFolders();
        project.monitoring.subTask(project, "Generating VHDL...");
        if (!project.generateVHDL()) {
            Errors.setLastErrorMessage("VHDL files could not be created. Please check the Math2mat library location with the menu Configure...External tools.");
            return false;
        }
        project.monitoring.workedVhdlGeneration();
        project.monitoring.subTask(project, "Generating Octave...");
        if (project.getStructTreatment().getMonitor()) {
            if (!project.reGenerateOctave()) {
                return false;
            }
            project.monitoring.subTask(project, "Running Octave...");
            if (!ExternalRuns.runOctave(project, true)) {
                return false;
            }
        } else {
            project.monitoring.subTask(project, "Running Octave...");
            if (!ExternalRuns.runOctave(project, false)) {
                return false;
            }
        }
        project.monitoring.workedOctave();
        return ExternalRuns.runQuesta(project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean runOctave(M2MProject project, boolean codeRegen) {
        BufferedReader brErrOctave;
        if (project.isModified()) {
            Errors.setLastError(Errors.ErrorNum.OCTAVEGEN);
            return false;
        }
        String projectPath = project.getProperties().getProjectPath();
        ExternalToolsProperties externalToolsProperties = ExternalToolsProperties.getReference();
        String line = "";
        Process process = null;
        FileUtils.copyFile(String.valueOf(M2MProject.getLibPath()) + "/m2m/m2m_doall.m", String.valueOf(project.getOctavePath()) + "/m2m_doall.m");
        FileUtils.copyFile(String.valueOf(M2MProject.getLibPath()) + "/m2m/m2m_generatesamples.m", String.valueOf(project.getOctavePath()) + "/m2m_generatesamples.m");
        if (project.getProperties().getOptimisationProperties().getOptimisationDataType() == BuildingBlock.NumType.FLOAT32) {
            FileUtils.copyFile(String.valueOf(M2MProject.getLibPath()) + "/m2m/m2m_readvarfromfile.m", String.valueOf(project.getOctavePath()) + "/m2m_readvarfromfile.m");
            FileUtils.copyFile(String.valueOf(M2MProject.getLibPath()) + "/m2m/m2m_writevartofile.m", String.valueOf(project.getOctavePath()) + "/m2m_writevartofile.m");
        } else if (project.getProperties().getOptimisationProperties().getOptimisationDataType() == BuildingBlock.NumType.FLOAT64) {
            FileUtils.copyFile(String.valueOf(M2MProject.getLibPath()) + "/m2m/m2m_readvarfromfile_float64.m", String.valueOf(project.getOctavePath()) + "/m2m_readvarfromfile.m");
            FileUtils.copyFile(String.valueOf(M2MProject.getLibPath()) + "/m2m/m2m_writevartofile_float64.m", String.valueOf(project.getOctavePath()) + "/m2m_writevartofile.m");
        } else {
            System.out.println("Error with the type of data to be processed.");
        }
        StructTreatment struct = project.getStructTreatment();
        OctaveScriptCreator octaveScriptCreator = new OctaveScriptCreator(struct.getTop(), project.getSimulationProperties(), codeRegen);
        octaveScriptCreator.createOctaveScript(project, project.getSourceFile());
        project.checkFolders();
        try {
            System.out.println("Starting Octave...\n");
            process = externalToolsProperties.getOctavePath() != null ? Runtime.getRuntime().exec(String.valueOf(externalToolsProperties.getOctavePath()) + " -q") : Runtime.getRuntime().exec("octave -q");
            ProcessWatcher.getInstance().addProcess(process);
            BufferedWriter bwOctave = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            BufferedReader brOctave = new BufferedReader(new InputStreamReader(process.getInputStream()));
            brErrOctave = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                bwOctave.write("cd \"" + project.getOctavePath() + "\"" + "\n");
                bwOctave.flush();
                File m2mScript = new File(String.valueOf(project.getOctavePath()) + "/m2m_doall.m");
                if (!m2mScript.exists()) {
                    System.err.println("Octave script error: cannot find \"m2m_doall.m\" script in " + projectPath);
                    return false;
                }
                bwOctave.write("m2m_doall\n");
                bwOctave.flush();
                bwOctave.write("quit\n");
                bwOctave.flush();
                bwOctave.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (brOctave == null || brErrOctave == null) {
                return false;
            }
            while (true) {
                try {
                    while ((line = brOctave.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            System.err.println("Error launching Octave\nOctave path is not well configured, configure it correctly before continue");
            Errors.setLastError(Errors.ErrorNum.OCTAVENOTFOUND);
            return false;
        }
        while (true) {
            try {
                while ((line = brErrOctave.readLine()) != null) {
                    System.err.println(line);
                }
                System.out.println("Octave generation finished");
                project.setLastMonitoring(project.getStructTreatment().getMonitor());
            }
            catch (IOException e1) {
                e1.printStackTrace();
                continue;
            }
            break;
        }
        ProcessWatcher.getInstance().removeProcess(process);
        return true;
    }

    public static boolean runDot(String dotFile, String pngFile) {
        Process dotProcess = null;
        try {
            String[] cmdArray = new String[]{ExternalToolsProperties.getReference().getDotPath(), "-Tpng", dotFile, "-o", pngFile};
            dotProcess = new ProcessBuilder(cmdArray[0], cmdArray[1], cmdArray[2], cmdArray[3], cmdArray[4]).start();
        }
        catch (IOException iOException) {
            System.out.println("Error lauching dot");
            Errors.setLastError(Errors.ErrorNum.DOTNOTFOUND);
            return false;
        }
        try {
            dotProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("dot interrupted\n");
            Errors.setLastErrorMessage("Dot process interrupted");
            return false;
        }
        if (dotProcess.exitValue() != 0) {
            Errors.setLastErrorMessage("Error with Dot execution. exit code is " + dotProcess.exitValue());
            return false;
        }
        return true;
    }

    public static int getNbSimErrors() {
        return nbSimErrors;
    }

    public static boolean runQuesta(M2MProject project) {
        nbSimErrors = 0;
        SimulationResult simResult = new SimulationResult();
        String projectPath = project.getProperties().getProjectPath();
        String reportPath = String.valueOf(project.getReportPath()) + "/";
        SystemVerilogCreator SVCreator = new SystemVerilogCreator(project.getStructTreatment().getTop());
        String line = "";
        Process process = null;
        FileWriter fwNote = null;
        FileWriter fwError = null;
        FileWriter fwFailure = null;
        FileWriter fwWarning = null;
        File reportFolder = new File(reportPath);
        if (reportFolder.exists() && reportFolder.isDirectory()) {
            FileUtils.deleteDirContent(reportFolder, null);
        }
        project.checkFolders();
        File noteFile = new File(String.valueOf(reportPath) + "Note_Report.txt");
        File errorFile = new File(String.valueOf(reportPath) + "Error_Report.txt");
        File failureFile = new File(String.valueOf(reportPath) + "Failure_Report.txt");
        File warningFile = new File(String.valueOf(reportPath) + "Warning_Report.txt");
        try {
            fwNote = new FileWriter(noteFile);
            fwError = new FileWriter(errorFile);
            fwFailure = new FileWriter(failureFile);
            fwWarning = new FileWriter(warningFile);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        SVCreator.createSystemVerilog(project);
        File simulation = new File(String.valueOf(project.getSimPath()) + "/simulation.do");
        if (!simulation.exists()) {
            System.err.println("File not Found\nFile \"simulation.do\" not found in " + projectPath);
            return false;
        }
        try {
            ExternalToolsProperties externalToolsProperties = ExternalToolsProperties.getReference();
            String vsimPath = externalToolsProperties.getVsimPath();
            ProcessBuilder pb = new ProcessBuilder(vsimPath, "-c", "-l", String.valueOf(project.getSimPath()) + "/transcript.txt");
            pb.directory(new File(project.getSimPath()));
            process = pb.start();
        }
        catch (IOException iOException) {
            System.err.println("Error launching vsim\nvsim path is not well configured, configure it correctly before continue");
            Errors.setLastError(Errors.ErrorNum.QUESTANOTFOUND);
            return false;
        }
        ProcessWatcher.getInstance().addProcess(process);
        BufferedWriter bwQuesta = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        BufferedReader brQuesta = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader brErrQuesta = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        try {
            bwQuesta.write("do \"" + project.getSimPath() + "/simulation.do" + "\"");
            bwQuesta.flush();
            bwQuesta.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (brQuesta == null || brErrQuesta == null) {
            return false;
        }
        String prefix = ExternalToolsProperties.getReference().getSimulationFiles() == 2 ? "UVM_" : (ExternalToolsProperties.getReference().getSimulationFiles() == 1 ? "M2M_" : "OVM_");
        simResult.setPrefix(prefix);
        project.monitoring.subTask(project, "Compiling...");
        while (true) {
            try {
                while ((line = brQuesta.readLine()) != null) {
                    if (line.contains(String.valueOf(prefix) + "WARNING") || line.contains("Warning")) {
                        System.out.println(line);
                        if (!line.contains(String.valueOf(prefix) + "WARNING")) continue;
                        fwWarning.write(String.valueOf(line) + "\r\n");
                        continue;
                    }
                    if (line.contains(String.valueOf(prefix) + "FATAL")) {
                        ++nbSimErrors;
                        System.err.println(line);
                        fwFailure.write(String.valueOf(line) + "\r\n");
                        continue;
                    }
                    if (line.contains(String.valueOf(prefix) + "ERROR")) {
                        ++nbSimErrors;
                        System.err.println(line);
                        fwError.write(String.valueOf(line) + "\r\n");
                        continue;
                    }
                    if (line.contains(String.valueOf(prefix) + "INFO")) {
                        fwNote.write(String.valueOf(line) + "\r\n");
                        continue;
                    }
                    if (line.contains("M2MVar(")) {
                        int valueInt;
                        int pos1 = line.indexOf("(");
                        int pos2 = line.indexOf(")");
                        String variable = line.substring(pos1 + 1, pos2);
                        String value = line.substring(pos2 + 2);
                        try {
                            valueInt = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            valueInt = 0;
                        }
                        if (variable.equals("Latency")) {
                            simResult.setLatency(valueInt);
                            continue;
                        }
                        if (variable.equals("TotalTime")) {
                            simResult.setTotalTime(valueInt);
                            continue;
                        }
                        if (variable.equals("NbInputs")) {
                            simResult.setNbInputs(valueInt);
                            continue;
                        }
                        if (variable.equals("MaxBitError")) {
                            simResult.setMaxBitError(valueInt);
                            continue;
                        }
                        if (variable.equals("Progress")) {
                            project.monitoring.workedSimulationStep();
                            continue;
                        }
                        if (!variable.equals("StartSim")) continue;
                        project.monitoring.workedCompilation();
                        project.monitoring.subTask(project, "Simulating...");
                        continue;
                    }
                    System.out.println(line);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                continue;
            }
            break;
        }
        while (true) {
            try {
                while ((line = brErrQuesta.readLine()) != null) {
                }
                System.out.println("Questa verification finished");
            }
            catch (IOException e1) {
                e1.printStackTrace();
                continue;
            }
            break;
        }
        try {
            fwNote.close();
            fwError.close();
            fwFailure.close();
            fwWarning.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        System.out.println("Questa return value: " + process.exitValue() + "\n");
        if (process.exitValue() == 4) {
            Errors.setLastError(Errors.ErrorNum.QUESTALICENSE);
            return false;
        }
        ProcessWatcher.getInstance().removeProcess(process);
        simResult.setNbErrors(nbSimErrors - 2);
        project.setSimulationResult(simResult);
        System.out.println("-- Simulation results ---------------------------------------");
        if (simResult.getNbErrors() == 0) {
            System.out.println("Number of errors : " + simResult.getNbErrors());
        } else {
            System.err.println("Number of errors : " + simResult.getNbErrors());
        }
        System.out.println("Number of wrong bits (from Lowest) : " + simResult.getMaxBitError());
        if (simResult.getMaxBitError() != 0) {
            if (project.getProperties().getOptimisationProperties().getOptimisationDataType() == BuildingBlock.NumType.FLOAT32) {
                System.out.print("    ");
                int i = 0;
                while (i < 36) {
                    System.out.print("-");
                    ++i;
                }
                System.out.print("\n");
                System.out.print("    ");
                System.out.print("|");
                i = 0;
                while (i < 32) {
                    if (i < 32 - simResult.getMaxBitError()) {
                        System.out.print("v");
                    } else {
                        System.err.print("x");
                    }
                    if (i == 0) {
                        System.out.print("|");
                    }
                    if (i == 8) {
                        System.out.print("|");
                    }
                    ++i;
                }
                System.out.print("|\n");
                System.out.print("    ");
                i = 0;
                while (i < 36) {
                    System.out.print("-");
                    ++i;
                }
                System.out.print("\n\n");
            } else {
                System.out.print("    ");
                int i = 0;
                while (i < 68) {
                    System.out.print("-");
                    ++i;
                }
                System.out.print("\n");
                System.out.print("    ");
                System.out.print("|");
                i = 0;
                while (i < 64) {
                    if (i < 64 - simResult.getMaxBitError()) {
                        System.out.print("v");
                    } else {
                        System.err.print("x");
                    }
                    if (i == 0) {
                        System.out.print("|");
                    }
                    if (i == 11) {
                        System.out.print("|");
                    }
                    ++i;
                }
                System.out.print("|\n");
                System.out.print("    ");
                i = 0;
                while (i < 68) {
                    System.out.print("-");
                    ++i;
                }
                System.out.print("\n\n");
            }
        }
        System.out.println("Latency          : " + simResult.getLatency() + " clock cycles");
        System.out.println("Total time for " + simResult.getNbInputs() + " inputs : " + simResult.getTotalTime() + " clock cycles");
        System.out.println("-- End of simulation ----------------------------------------");
        return true;
    }

    public static boolean runXilinxUbidule(M2MProject project) {
        ISETCLGenerator iseTclGen = new ISETCLGenerator();
        if (!iseTclGen.generateTCLISE(project)) {
            return false;
        }
        return M2MClient.generateXSVF(project);
    }

    public static boolean runAllUbidule(M2MProject project) {
        if (!ExternalRuns.runXilinxUbidule(project)) {
            return false;
        }
        return ExternalRuns.runUbidule(project);
    }

    public static boolean runUbidule(M2MProject project) {
        int nbrInput = project.getStructTreatment().getInput().size();
        int nbrOutput = project.getStructTreatment().getOutput().size();
        int nbrSamples = project.getSimulationProperties().getNumberOfSamples();
        M2MClient client = new M2MClient();
        return client.testOnUbidule(nbrInput, nbrOutput, nbrSamples, project);
    }
}

