/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.processing;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import m2m.backend.project.M2MProject;
import m2m.backend.project.SimulationProperties;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;

public class OctaveScriptCreator {
    private Function top;
    private SimulationProperties simProp;
    private boolean codeRegen;

    public OctaveScriptCreator(Function top, SimulationProperties simProp, boolean regen) {
        this.top = top;
        this.simProp = simProp;
        this.codeRegen = regen;
    }

    public boolean createOctaveScript(M2MProject project, File sourceFile) {
        String parameterPath = String.valueOf(project.getOctavePath()) + "/m2m_parameters.m";
        String samplesPath = String.valueOf(project.getOctavePath()) + "/m2m_computesample.m";
        String projectPath = project.getProperties().getProjectPath();
        this.writeParameters(parameterPath, String.valueOf(projectPath) + project.subfolder(), sourceFile);
        this.writeSamples(samplesPath, sourceFile);
        if (this.codeRegen) {
            this.completeMainScript(project);
        }
        return true;
    }

    private void completeMainScript(M2MProject project) {
        File mainScript = new File(String.valueOf(project.getOctavePath()) + "/m2m_doall.m");
        String sOutputRegen = new String();
        sOutputRegen = String.valueOf(sOutputRegen) + "\n\nprintf(\"\\nCreation of output_regen verification files:\\n\");\n";
        sOutputRegen = String.valueOf(sOutputRegen) + "printf(\"--------------------------------------------\\n\");\n";
        sOutputRegen = String.valueOf(sOutputRegen) + "\nfor i=1:length(outputs_regen)\n";
        sOutputRegen = String.valueOf(sOutputRegen) + "\tfname=sprintf(\"%sfile_%s.dat\",filedir,outputs_regen(i).name);\n";
        sOutputRegen = String.valueOf(sOutputRegen) + "\tm2m_writevartofile(fname,outputs_regen(i).values);\n";
        sOutputRegen = String.valueOf(sOutputRegen) + "\tprintf(\"file_%s.dat was written\\n\", outputs_regen(i).name);\n";
        sOutputRegen = String.valueOf(sOutputRegen) + "endfor\n";
        if (this.top.getMonitoringElement().size() != 0) {
            sOutputRegen = String.valueOf(sOutputRegen) + "\nprintf(\"\\nCreation of intern verification files:\\n\");\n";
            sOutputRegen = String.valueOf(sOutputRegen) + "printf(\"--------------------------------------\\n\");\n";
            sOutputRegen = String.valueOf(sOutputRegen) + "\nfor i=1:length(interns)\n";
            sOutputRegen = String.valueOf(sOutputRegen) + "\tfname=sprintf(\"%sfile_%s.dat\",filedir,interns(i).name);\n";
            sOutputRegen = String.valueOf(sOutputRegen) + "\tm2m_writevartofile(fname,interns(i).values);\n";
            sOutputRegen = String.valueOf(sOutputRegen) + "\tprintf(\"file_%s.dat was written\\n\", interns(i).name);\n";
            sOutputRegen = String.valueOf(sOutputRegen) + "endfor\n\n";
        }
        try {
            int readChar;
            FileReader fr = new FileReader(mainScript);
            String readText = new String();
            while ((readChar = fr.read()) != -1) {
                readText = String.valueOf(readText) + (char)readChar;
            }
            fr.close();
            FileWriter fw = new FileWriter(mainScript);
            fw.write(String.valueOf(readText) + sOutputRegen);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeParameters(String samplesPath, String path, File sourceFile) {
        File file = new File(samplesPath);
        try {
            String samples = this.createParameters(path, sourceFile);
            FileWriter fw = new FileWriter(file);
            fw.write(samples);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Cannot open file : " + samplesPath);
        }
    }

    private String createParameters(String path, File sourceFile) {
        String sSamples = new String();
        sSamples = String.valueOf(sSamples) + "%inputs\n";
        int i = 0;
        while (i < this.top.getInput().size()) {
            sSamples = String.valueOf(sSamples) + "inputs(" + (i + 1) + ").name=\"input" + (i + 1) + "\";\n";
            sSamples = String.valueOf(sSamples) + "inputs(" + (i + 1) + ").size=1;\n";
            ++i;
        }
        sSamples = String.valueOf(sSamples) + "%outputs\n";
        i = 0;
        while (i < this.top.getOutput().size()) {
            sSamples = String.valueOf(sSamples) + "outputs(" + (i + 1) + ").name=\"output" + (i + 1) + "\";\n";
            sSamples = String.valueOf(sSamples) + "outputs(" + (i + 1) + ").size=1;\n";
            ++i;
        }
        if (this.codeRegen) {
            i = 0;
            while (i < this.top.getOutput().size()) {
                sSamples = String.valueOf(sSamples) + "outputs_regen(" + (i + 1) + ").name=\"output_regen" + (i + 1) + "\";\n";
                sSamples = String.valueOf(sSamples) + "outputs_regen(" + (i + 1) + ").size=1;\n";
                ++i;
            }
        }
        Vector<Element> internals = this.top.getMonitoringElement();
        sSamples = String.valueOf(sSamples) + "%interns\n";
        int i2 = 0;
        while (i2 < internals.size()) {
            sSamples = String.valueOf(sSamples) + "interns(" + (i2 + 1) + ").name=\"internal" + (i2 + 1) + "\";\n";
            sSamples = String.valueOf(sSamples) + "interns(" + (i2 + 1) + ").sname=\"" + internals.get(i2).getName() + "\";\n";
            sSamples = String.valueOf(sSamples) + "interns(" + (i2 + 1) + ").size=1;\n";
            ++i2;
        }
        sSamples = String.valueOf(sSamples) + "% number of samples\n";
        sSamples = String.valueOf(sSamples) + "nbsamples=" + this.simProp.getNumberOfSamples() + ";\n\n";
        sSamples = String.valueOf(sSamples) + "filedir=\"" + path + M2MProject.getIOFilesDirName() + "/\";\n";
        sSamples = String.valueOf(sSamples) + "generate_input=true;\n";
        sSamples = String.valueOf(sSamples) + "addpath(\"" + sourceFile.getParent().replace("\\", "/") + "\");";
        return sSamples;
    }

    private void writeSamples(String parameterPath, File sourceFile) {
        File file = new File(parameterPath);
        String sParameters = new String();
        sParameters = String.valueOf(sParameters) + "[";
        int i = 0;
        while (i < this.top.getOutput().size()) {
            sParameters = i == 0 ? String.valueOf(sParameters) + "outputs(" + (i + 1) + ").values(i,:)" : String.valueOf(sParameters) + ", outputs(" + (i + 1) + ").values(i,:)";
            ++i;
        }
        sParameters = String.valueOf(sParameters) + "]=" + sourceFile.getName().substring(0, sourceFile.getName().lastIndexOf(".")) + "(";
        i = 0;
        while (i < this.top.getInput().size()) {
            sParameters = i == 0 ? String.valueOf(sParameters) + "inputs(" + (i + 1) + ").values(i,:)" : String.valueOf(sParameters) + ", inputs(" + (i + 1) + ").values(i,:)";
            ++i;
        }
        sParameters = String.valueOf(sParameters) + ");\n";
        if (this.codeRegen) {
            sParameters = String.valueOf(sParameters) + "[";
            i = 0;
            while (i < this.top.getOutput().size()) {
                sParameters = i == 0 ? String.valueOf(sParameters) + "outputs_regen(" + (i + 1) + ").values(i,:)" : String.valueOf(sParameters) + ", outputs_regen(" + (i + 1) + ").values(i,:)";
                ++i;
            }
            sParameters = String.valueOf(sParameters) + "]=" + sourceFile.getName().substring(0, sourceFile.getName().lastIndexOf(".")) + "_regen(";
            i = 0;
            while (i < this.top.getInput().size()) {
                sParameters = i == 0 ? String.valueOf(sParameters) + "inputs(" + (i + 1) + ").values(i,:)" : String.valueOf(sParameters) + ", inputs(" + (i + 1) + ").values(i,:)";
                ++i;
            }
            if (this.top.getMonitoringElement().size() != 0) {
                sParameters = String.valueOf(sParameters) + ", i";
            }
            sParameters = String.valueOf(sParameters) + ");\n";
        }
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(sParameters);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Cannot open file : " + parameterPath);
        }
    }
}

