/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.processing;

import java.io.File;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import m2m.backend.octaveparser.ParsingException;
import m2m.backend.processing.ExternalRuns;
import m2m.backend.processing.ProgressMonitoring;
import m2m.backend.project.M2MProject;

public class ProjectsValidator {
    public int nbProjects;
    protected String curDir;
    protected LinkedList<M2MProject> plist;

    private int internalNbWorkingSteps(String dir) {
        File dirFile = new File(dir);
        File[] files = dirFile.listFiles();
        int result = 0;
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                result += this.internalNbWorkingSteps(files[i].getAbsolutePath());
            } else {
                String ext;
                File file = files[i];
                String string = ext = file.getName().lastIndexOf(".") == -1 ? "" : file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length());
                if (ext.equalsIgnoreCase("m2m") && file.exists()) {
                    ++this.nbProjects;
                    M2MProject project = new M2MProject();
                    project.openProject(file.getAbsolutePath());
                    this.plist.add(project);
                    result += ProgressMonitoring.workingTimeAll(project);
                }
            }
            ++i;
        }
        return result;
    }

    public int nbWorkingSteps(String dir) {
        this.nbProjects = 0;
        this.plist = new LinkedList();
        this.curDir = dir;
        return this.internalNbWorkingSteps(dir);
    }

    private void testDirInternal(String dir, Vector<String> errors, ProgressMonitoring monitor) {
        File dirFile = new File(dir);
        File[] files = dirFile.listFiles();
        int i = 0;
        while (i < files.length) {
            if (monitor.isCanceled()) {
                return;
            }
            if (files[i].isDirectory()) {
                this.testDirInternal(files[i].getAbsolutePath(), errors, monitor);
            } else {
                String ext;
                File file = files[i];
                String string = ext = file.getName().lastIndexOf(".") == -1 ? "" : file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length());
                if (ext.equalsIgnoreCase("m2m") && file.exists()) {
                    System.out.println("********************************************************************************");
                    System.out.println("Testing project " + file.getAbsolutePath());
                    System.out.println("--------------------------------------------------------------------------------");
                    M2MProject project = new M2MProject();
                    project.openProject(file.getAbsolutePath());
                    try {
                        project.getStructTreatment().parse(project.getSourceFile());
                        project.getStructTreatment().modifyNumType(project.getProperties().getOptimisationProperties().getOptimisationDataType());
                        project.clear();
                        project.monitoring = monitor;
                        if (ExternalRuns.runAll(project)) {
                            if (project.getSimulationResult().getNbErrors() > 0) {
                                errors.add("Number of simulation errors for " + project.getProperties().getProjectFullFilename() + " : " + project.getSimulationResult().getNbErrors());
                            }
                            System.out.println("--------------------------------------------------------------------------------");
                            System.out.println("End of test for project " + file.getAbsolutePath());
                            System.out.println("********************************************************************************");
                        } else {
                            errors.add("Can not launch simulation for " + project.getProperties().getProjectFullFilename());
                        }
                    }
                    catch (ParsingException parsingException) {
                        errors.add("Can not parse file of " + project.getProperties().getProjectFullFilename());
                    }
                    project.clear();
                }
            }
            ++i;
        }
    }

    private void testProjects(Vector<String> errors, ProgressMonitoring monitor) {
        ListIterator iter = this.plist.listIterator();
        while (iter.hasNext()) {
            M2MProject project = (M2MProject)iter.next();
            if (monitor.isCanceled()) {
                return;
            }
            System.out.println("********************************************************************************");
            System.out.println("Testing project " + project.getProjectFilename());
            System.out.println("--------------------------------------------------------------------------------");
            project.clear();
            project.monitoring = monitor;
            if (ExternalRuns.runAll(project)) {
                if (project.getSimulationResult().getNbErrors() > 0) {
                    errors.add("Number of simulation errors for " + project.getProperties().getProjectFullFilename() + " : " + project.getSimulationResult().getNbErrors());
                }
                System.out.println("--------------------------------------------------------------------------------");
                System.out.println("End of test for project " + project.getProjectFilename());
                System.out.println("********************************************************************************");
            } else {
                errors.add("Can not launch simulation for " + project.getProperties().getProjectFullFilename());
            }
            project.clear();
        }
    }

    public boolean testDir(String dir, ProgressMonitoring monitor) {
        Vector<String> errors = new Vector<String>();
        if (this.curDir != dir) {
            this.nbWorkingSteps(dir);
        }
        this.testProjects(errors, monitor);
        if (monitor.isCanceled()) {
            System.out.println("********************************************************************************");
            System.out.println("Test canceled");
            System.out.println("********************************************************************************");
            return false;
        }
        System.out.println("********************************************************************************");
        System.out.println("Simulation results");
        System.out.println("--------------------------------------------------------------------------------");
        if (errors.size() == 0) {
            System.out.println("There are no errors in the different projects");
        }
        int i = 0;
        while (i < errors.size()) {
            System.out.println(String.valueOf(errors.elementAt(i)) + "\n");
            ++i;
        }
        System.out.println("--------------------------------------------------------------------------------");
        System.out.println("End of Simulation results");
        System.out.println("********************************************************************************");
        return true;
    }
}

