/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.project;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import m2m.backend.octaveparser.ParsingException;
import m2m.backend.processing.OptimizeOperators;
import m2m.backend.processing.ProgressMonitoring;
import m2m.backend.project.ExternalToolsProperties;
import m2m.backend.project.OptimisationProperties;
import m2m.backend.project.ProjectProperties;
import m2m.backend.project.SimulationProperties;
import m2m.backend.project.SimulationResult;
import m2m.backend.structure.StructTreatment;
import m2m.backend.utils.FileUtils;
import m2m.backend.utils.XMLUtils;
import m2m.backend.vhdl.CompileScriptCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class M2MProject {
    public static final String CURRENTVERSION = "0.5.0";
    public ProgressMonitoring monitoring;
    private boolean last_monitoring = false;
    private boolean modified;
    private SimulationResult simResult;
    private static final String SIMPATH = "sim";
    private static final String IOFILESPATH = "sim/iofiles";
    private static final String UBIDULEPATH = "ubidule";
    private static final String SRCPATH = "src_m2m";
    private static final String VHDLPATH = "src_VHDL";
    private static final String OCTPATH = "src_OCT";
    private static final String SVPATH = "src_SV";
    private static final String REPORTPATH = "report";
    private static final String COMPPATH = "sim/comp";
    private StructTreatment structTreatment = new StructTreatment();
    private ProjectProperties properties = new ProjectProperties();
    private boolean useFifo = false;

    public String subfolder() {
        return "/m2m_" + this.getProperties().getFunctionName() + "/";
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public SimulationResult getSimulationResult() {
        return this.simResult;
    }

    public void setSimulationResult(SimulationResult simResult) {
        this.simResult = simResult;
    }

    public void setLastMonitoring(boolean monitor) {
        this.last_monitoring = monitor;
    }

    public static String getLibPath() {
        return ExternalToolsProperties.getReference().getLibPath();
    }

    public boolean openProject(String fileName) {
        File file = new File(fileName);
        this.properties.setProjectFile(file);
        if (file.exists()) {
            if (!this.loadFile(file)) {
                return false;
            }
            if (this.getStructTreatment().isEmpty()) {
                try {
                    this.structTreatment.parse(new File(this.properties.getAbsoluteSourceFilename()));
                    this.structTreatment.modifyNumType(this.properties.getOptimisationProperties().getOptimisationDataType());
                    return true;
                }
                catch (ParsingException parsingException) {
                    return true;
                }
            }
            if (!this.checkSourceFile()) {
                this.checkFolders();
                this.restoreOctave();
            }
            return true;
        }
        return false;
    }

    public boolean CreateEmptyProject(String fileName) {
        File sourceFile;
        File file;
        block5: {
            file = new File(fileName);
            this.properties.setProjectFile(file);
            try {
                String projectPath = file.getAbsolutePath().replace("\\", "/").substring(0, file.getAbsolutePath().replace("\\", "/").lastIndexOf("/") + 1);
                this.checkFolders();
                sourceFile = new File(String.valueOf(projectPath) + this.subfolder() + M2MProject.getSourceDirName() + "/" + file.getName().substring(0, file.getName().lastIndexOf(".") + 1) + "m");
                if (this.checkFolders()) break block5;
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        FileWriter sourceFileWriter = new FileWriter(sourceFile.getAbsolutePath());
        String functionName = file.getName().substring(0, file.getName().lastIndexOf("."));
        String source = "% Here is a simple function that adds two numbers\n";
        source = String.valueOf(source) + "% Feel free to modify it\n\n";
        source = String.valueOf(source) + "function s=" + functionName + "(a,b)\n\ts=a+b;\nendfunction\n";
        char[] buffer = new char[source.length()];
        source.getChars(0, source.length(), buffer, 0);
        sourceFileWriter.write(buffer);
        sourceFileWriter.close();
        this.getProperties().setSourceFilePath(String.valueOf(this.subfolder()) + M2MProject.getSourceDirName() + "/" + sourceFile.getName());
        this.saveFile(file);
        try {
            this.structTreatment.parse(sourceFile);
            this.structTreatment.modifyNumType(this.properties.getOptimisationProperties().getOptimisationDataType());
            this.saveFile(file);
        }
        catch (ParsingException parsingException) {}
        return true;
    }

    public boolean CreateNewProjectFromMath(String fileName, String fileNameOctave) {
        File file = new File(fileName);
        this.properties.setProjectFile(file);
        if (!this.checkFolders()) {
            return false;
        }
        this.getProperties().setSourceFilePath(String.valueOf(this.subfolder()) + M2MProject.getSourceDirName() + "/" + new File(fileNameOctave).getName());
        if (!FileUtils.copyFile(fileNameOctave, this.getProperties().getAbsoluteSourceFilename())) {
            return false;
        }
        if (!this.saveFile(file)) {
            return false;
        }
        try {
            this.structTreatment.parse(this.getSourceFile());
            this.structTreatment.modifyNumType(this.properties.getOptimisationProperties().getOptimisationDataType());
            this.saveFile(file);
        }
        catch (ParsingException parsingException) {}
        return true;
    }

    public boolean getUseFifo() {
        return this.useFifo;
    }

    public void setUseFifo(boolean bool) {
        this.useFifo = bool;
    }

    public OptimisationProperties getOptimisationProperties() {
        return this.properties.getOptimisationProperties();
    }

    public SimulationProperties getSimulationProperties() {
        return this.properties.getSimulationProperties();
    }

    public File getSourceFile() {
        File sourceFile = new File(this.properties.getAbsoluteSourceFilename());
        if (sourceFile.exists()) {
            return sourceFile;
        }
        return null;
    }

    public String getProjectFilename() {
        return this.properties.getProjectFile().getPath();
    }

    public static String getUbiduleDirName() {
        return UBIDULEPATH;
    }

    public static String getVHDLDirName() {
        return VHDLPATH;
    }

    public String getVHDLPath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getVHDLDirName();
    }

    public String getVHDLSubFolder() {
        return String.valueOf(this.subfolder()) + M2MProject.getVHDLDirName();
    }

    public String getUbidulePath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getUbiduleDirName();
    }

    public static String getSVDirName() {
        return SVPATH;
    }

    public String getSVPath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getSVDirName();
    }

    public static String getOctaveDirName() {
        return OCTPATH;
    }

    public String getOctavePath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getOctaveDirName();
    }

    public static String getReportDirName() {
        return REPORTPATH;
    }

    public String getReportPath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getReportDirName();
    }

    public static String getSimDirName() {
        return SIMPATH;
    }

    public String getSimPath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getSimDirName();
    }

    public static String getIOFilesDirName() {
        return IOFILESPATH;
    }

    public String getIOFilesPath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getIOFilesDirName();
    }

    public static String getCompDirName() {
        return COMPPATH;
    }

    public String getCompPath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getCompDirName();
    }

    public static String getSourceDirName() {
        return SRCPATH;
    }

    public String getSourcePath() {
        return String.valueOf(this.properties.getProjectPath()) + this.subfolder() + M2MProject.getSourceDirName();
    }

    public ProjectProperties getProperties() {
        return this.properties;
    }

    public String getSourceFilePath() {
        return this.properties.getRelativeSourceFilename();
    }

    public void setProperties(ProjectProperties properties) {
        this.properties = properties;
    }

    public void setFile(File file) {
        this.properties.setProjectFile(file);
    }

    public boolean compare(M2MProject project) {
        return project.properties.getProjectFile().getAbsolutePath().equalsIgnoreCase(this.properties.getProjectFile().getAbsolutePath()) && project.properties.getRelativeSourceFilename().equalsIgnoreCase(this.properties.getRelativeSourceFilename());
    }

    public boolean checkFolders() {
        return M2MProject.checkFolders(String.valueOf(this.properties.getProjectPath()) + this.subfolder());
    }

    public static boolean checkFolders(String basePath) {
        try {
            File srcFolder;
            File ubiduleFolder;
            File compFolder;
            File ioFilesFolder;
            File simFolder;
            File reportFolder;
            File octFolder;
            File svFolder;
            File vhdlFolder;
            File baseFolder = new File(basePath);
            if (!baseFolder.exists() || !baseFolder.isDirectory()) {
                baseFolder.mkdir();
            }
            if (!(vhdlFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getVHDLDirName())).exists() || !vhdlFolder.isDirectory()) {
                vhdlFolder.mkdir();
            }
            if (!(svFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getSVDirName())).exists() || !svFolder.isDirectory()) {
                svFolder.mkdir();
            }
            if (!(octFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getOctaveDirName())).exists() || !octFolder.isDirectory()) {
                octFolder.mkdir();
            }
            if (!(reportFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getReportDirName())).exists() || !reportFolder.isDirectory()) {
                reportFolder.mkdir();
            }
            if (!(simFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getSimDirName())).exists() || !simFolder.isDirectory()) {
                simFolder.mkdir();
            }
            if (!(ioFilesFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getIOFilesDirName())).exists() || !ioFilesFolder.isDirectory()) {
                ioFilesFolder.mkdir();
            }
            if (!(compFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getCompDirName())).exists() || !compFolder.isDirectory()) {
                compFolder.mkdir();
            }
            if (!(ubiduleFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getUbiduleDirName())).exists() || !ubiduleFolder.isDirectory()) {
                ubiduleFolder.mkdir();
            }
            if (!(srcFolder = new File(String.valueOf(basePath) + "/" + M2MProject.getSourceDirName())).exists() || !srcFolder.isDirectory()) {
                srcFolder.mkdir();
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void clear() {
        File reportDir;
        File vhdlSrcDir;
        File svSrcDir;
        File octSrcDir;
        File ubiduleDir;
        File simDir = new File(this.getSimPath());
        if (simDir.exists() && simDir.isDirectory() && !FileUtils.deleteDirContent(simDir, null)) {
            System.err.println("Cannot delete files");
        }
        if ((ubiduleDir = new File(this.getUbidulePath())).exists() && ubiduleDir.isDirectory() && !FileUtils.deleteDirContent(ubiduleDir, null)) {
            System.err.println("Cannot delete files");
        }
        if ((octSrcDir = new File(this.getOctavePath())).exists() && octSrcDir.isDirectory() && !FileUtils.deleteDirContent(octSrcDir, null)) {
            System.err.println("Cannot delete files");
        }
        if ((svSrcDir = new File(this.getSVPath())).exists() && svSrcDir.isDirectory() && !FileUtils.deleteDirContent(svSrcDir, null)) {
            System.err.println("Cannot delete files");
        }
        if ((vhdlSrcDir = new File(this.getVHDLPath())).exists() && vhdlSrcDir.isDirectory() && !FileUtils.deleteDirContent(vhdlSrcDir, null)) {
            System.err.println("Cannot delete files");
        }
        if ((reportDir = new File(this.getReportPath())).exists() && reportDir.isDirectory()) {
            if (!FileUtils.deleteDirContent(reportDir, null)) {
                System.err.println("Cannot delete files");
            }
            reportDir.delete();
        }
    }

    public boolean generateVHDL() {
        this.structTreatment.setProject(this);
        String outFilePath = String.valueOf(this.getVHDLPath()) + "/" + this.structTreatment.getTop().getName() + ".vhd";
        if (!this.structTreatment.writeVHDL(String.valueOf(this.getVHDLPath()) + "/")) {
            return false;
        }
        CompileScriptCreator scriptCreator = new CompileScriptCreator(this.structTreatment.getTop());
        scriptCreator.createCompileScript(this, this.properties.getProjectPath(), outFilePath);
        return true;
    }

    public StructTreatment getStructTreatment() {
        return this.structTreatment;
    }

    public void clearStructTreatment() {
        this.structTreatment = new StructTreatment();
    }

    public boolean compareOctaveResult() {
        String origOutputPath = String.valueOf(this.getIOFilesPath()) + "/file_output";
        String regenOutputPath = String.valueOf(this.getIOFilesPath()) + "/file_output_regen";
        int i = 0;
        while (i < this.getStructTreatment().getTop().getOutput().size()) {
            File regenFile;
            File orig = new File(String.valueOf(origOutputPath) + (i + 1) + ".dat");
            if (FileUtils.compareDataFiles(orig, regenFile = new File(String.valueOf(regenOutputPath) + (i + 1) + ".dat"))) {
                System.out.println("Original file(s) and regenerated file(s) give the same results");
            } else {
                System.err.println("Original file and regenerated file do not give the same results on output " + this.getStructTreatment().getTop().getOutput().elementAt(i).getName());
            }
            ++i;
        }
        return true;
    }

    public boolean reGenerateOctave() {
        int dotPos = this.getSourceFile().getAbsolutePath().lastIndexOf(".");
        String srcFile = this.getSourceFile().getAbsolutePath().substring(0, dotPos);
        String generateFile = String.valueOf(srcFile) + "_regen.m";
        System.out.println("source file path : " + srcFile);
        System.out.println("gen file path : " + generateFile);
        String fname = this.structTreatment.getTop().getName();
        this.structTreatment.getTop().setName(String.valueOf(fname) + "_regen");
        if (!this.structTreatment.writeOctaveFile(generateFile)) {
            return false;
        }
        this.structTreatment.getTop().setName(fname);
        System.out.println("Math2Mat file regenerated");
        return true;
    }

    public boolean generateFlatDotFile() {
        File file = this.getSourceFile();
        String path = file.getAbsolutePath().lastIndexOf(".") == -1 ? "" : file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf("."));
        String flatFileName = String.valueOf(path) + "_flat.gv";
        StructTreatment treatment = this.getStructTreatment();
        return treatment.writeSchematic(flatFileName);
    }

    public boolean generateTreeDotFile() {
        StructTreatment struct = new StructTreatment();
        try {
            struct.parseNoFlat(new File(this.getProperties().getAbsoluteSourceFilename()));
        }
        catch (ParsingException parsingException) {}
        File file = this.getSourceFile();
        String path = file.getAbsolutePath().lastIndexOf(".") == -1 ? "" : file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf("."));
        String treeFileName = String.valueOf(path) + "_tree.gv";
        return struct.writeSchematic(treeFileName);
    }

    public boolean generateCopyTreeDotFile() {
        File file = this.getSourceFile();
        String path = file.getAbsolutePath().lastIndexOf(".") == -1 ? "" : file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf("."));
        String treeFileName = String.valueOf(path) + "_copy_tree.gv";
        StructTreatment treatment = this.getStructTreatment().copy();
        this.getStructTreatment().getTop().modifAllNames("orig_");
        return treatment.writeSchematic(treeFileName);
    }

    public boolean launchDotGeneration() {
        if (!this.generateTreeDotFile()) {
            return false;
        }
        return this.generateFlatDotFile();
    }

    public boolean optimize() {
        OptimizeOperators optimise = new OptimizeOperators(this.structTreatment);
        optimise.opTreeDepth();
        return true;
    }

    public boolean save() {
        File f = new File(this.properties.getProjectFullFilename());
        this.saveFile(f);
        this.setModified(false);
        return true;
    }

    public boolean saveFile(File f) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            dom.appendChild(this.toXml(dom));
            TransformerFactory transfac = TransformerFactory.newInstance();
            transfac.setAttribute("indent-number", new Integer(4));
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("media-type", "text/xml");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(dom);
            trans.transform(source, result);
            String xmlString = sw.toString();
            try {
                FileWriter fstream = new FileWriter(f);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write(xmlString);
                out.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
        catch (ParserConfigurationException pce) {
            System.out.println("Error while trying to instantiate DocumentBuilder " + pce);
            return false;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean compatibleVersion(String version1, String version2) {
        String[] splitV1 = version1.split("\\p{Punct}", 3);
        String[] splitV2 = version2.split("\\p{Punct}", 3);
        int[] v1 = new int[3];
        int[] v2 = new int[3];
        int i = 0;
        while (i < 3) {
            v1[i] = Integer.parseInt(splitV1[i]);
            v2[i] = Integer.parseInt(splitV2[i]);
            ++i;
        }
        if (v1[0] > v2[0]) {
            return false;
        }
        if (v1[0] < v2[0]) {
            return true;
        }
        if (v1[1] > v2[1]) {
            return false;
        }
        if (v1[1] < v2[1]) {
            return true;
        }
        if (v1[2] > v2[2]) {
            return false;
        }
        if (v1[2] < v2[2]) {
            return true;
        }
        return true;
    }

    public boolean loadFile(File f) {
        Element docEl;
        block5: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(f);
            dom.getDocumentElement().normalize();
            docEl = dom.getDocumentElement();
            String version = docEl.getAttribute("version");
            if (version.isEmpty() || this.compatibleVersion(version, CURRENTVERSION)) break block5;
            System.out.println("The files corresponds to a newer version of Math2mat. Please update your software.");
            return false;
        }
        try {
            this.fromXml(docEl);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return false;
        }
        catch (SAXException se) {
            se.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    public void restoreOctave() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.properties.getAbsoluteSourceFilename()));
            out.write(this.structTreatment.getSourceCode());
            out.close();
        }
        catch (IOException iOException) {
            System.out.println("Can not regenerate the Octave source file from the project file.");
        }
    }

    public boolean sourceFileExist() {
        File file = this.getSourceFile();
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public boolean checkSourceFile() {
        String sourceMd5;
        if (this.structTreatment == null) {
            return true;
        }
        if (this.structTreatment.getSourceMd5() == null) {
            return true;
        }
        if (this.structTreatment.getSourceMd5().isEmpty()) {
            return true;
        }
        File file = this.getSourceFile();
        if (file == null) {
            return false;
        }
        return !file.exists() || (sourceMd5 = FileUtils.getMd5(file.getAbsolutePath())).equals(this.structTreatment.getSourceMd5());
    }

    public String getXmlTagName() {
        return "M2MProject";
    }

    public boolean fromXml(Element el) {
        String source = XMLUtils.getTextValue(el, "SourceFile", "");
        Node node = el.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equalsIgnoreCase(this.properties.getOptimisationProperties().getXmlTagName())) {
                this.properties.getOptimisationProperties().fromXml((Element)node);
            } else if (node.getNodeName().equalsIgnoreCase(this.properties.getSimulationProperties().getXmlTagName())) {
                this.properties.getSimulationProperties().fromXml((Element)node);
            }
            if (node.getNodeName().equalsIgnoreCase(this.structTreatment.getXmlTagName())) {
                this.structTreatment.fromXml((Element)node);
            }
            node = node.getNextSibling();
        }
        File f = new File(source);
        this.properties.setSourceFilePath(String.valueOf(this.subfolder()) + M2MProject.getSourceDirName() + "/" + f.getName());
        return true;
    }

    public Element toXml(Document dom) {
        Element el = dom.createElement(this.getXmlTagName());
        el.setAttribute("version", CURRENTVERSION);
        el.appendChild(XMLUtils.createTextElement(dom, "SourceFile", this.properties.getRelativeSourceFilename()));
        el.appendChild(this.properties.getOptimisationProperties().toXml(dom));
        el.appendChild(this.properties.getSimulationProperties().toXml(dom));
        if (this.structTreatment != null) {
            el.appendChild(this.structTreatment.toXml(dom));
        }
        return el;
    }

    public boolean isUbiduleFilesUpToDate() {
        long timeFileRef;
        File file = this.getSourceFile();
        long timeCurrent = file.lastModified();
        return timeCurrent < (timeFileRef = new File(String.valueOf(this.getUbidulePath()) + "/M2M_XSVF_generated.xsvf").lastModified());
    }

    public boolean isOctaveUpToDate() {
        if (!this.last_monitoring && this.structTreatment.getMonitor()) {
            return false;
        }
        File file = this.getSourceFile();
        long timeCurrent = file.lastModified();
        long timeFileDoAll = new File(String.valueOf(this.getOctavePath()) + "/m2m_doall.m").lastModified();
        long timeFileOutput = new File(String.valueOf(this.getIOFilesPath()) + "/file_output1.dat").lastModified();
        return timeCurrent < timeFileDoAll && timeCurrent < timeFileOutput;
    }

    public boolean isVHDLUpToDate() {
        long timeFilepkg;
        File file = this.getSourceFile();
        long timeCurrent = file.lastModified();
        return timeCurrent < (timeFilepkg = new File(String.valueOf(this.getVHDLPath()) + "/pkg_cellule.vhd").lastModified());
    }
}

