/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.project;

import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptimisationProperties {
    private String optimisationType;
    private BuildingBlock.NumType optimisationDataType;
    private int optimisationFrequency;
    private String fifoType;
    private boolean optimizeFifo;
    private int fifoSize;
    private boolean fifoComp;

    public OptimisationProperties() {
        this.optimisationType = "";
        this.optimisationDataType = BuildingBlock.NumType.FLOAT32;
        this.optimisationFrequency = 0;
        this.fifoType = "Standard";
        this.optimizeFifo = true;
        this.fifoSize = 64;
        this.fifoComp = true;
    }

    public OptimisationProperties(String type, BuildingBlock.NumType dataSize, int frequency, String fType, boolean optFifo, int fifoSize, boolean fifoComp) {
        this.optimisationType = type;
        this.optimisationDataType = dataSize;
        this.optimisationFrequency = frequency;
        this.fifoType = fType;
        this.optimizeFifo = optFifo;
        this.fifoSize = fifoSize;
        this.fifoComp = fifoComp;
    }

    public String getXmlTagName() {
        return "Optimisation";
    }

    public boolean fromXml(Element el) {
        this.setOptimisationType(XMLUtils.getTextValue(el, "Type", ""));
        this.setOptimisationDataType(BuildingBlock.NumType.getNum(XMLUtils.getTextValue(el, "DataType", "FLOAT32")));
        this.setOptimisationFrequency(XMLUtils.getIntValue(el, "Frequency", 0));
        this.setFifoType(XMLUtils.getTextValue(el, "FifoType", "Standard"));
        this.setFifoSize(XMLUtils.getIntValue(el, "FifoSize", 64));
        this.setOptimizeFifo(XMLUtils.getBoolValue(el, "OptFifo", true));
        this.setFifoCompensation(XMLUtils.getBoolValue(el, "FifoCompensation", true));
        return true;
    }

    public Element toXml(Document dom) {
        Element el = dom.createElement(this.getXmlTagName());
        el.appendChild(XMLUtils.createTextElement(dom, "Type", this.getOptimisationtype()));
        el.appendChild(XMLUtils.createTextElement(dom, "DataType", this.optimisationDataType.name()));
        el.appendChild(XMLUtils.createIntElement(dom, "Frequency", this.getOptimisationfrequency()));
        el.appendChild(XMLUtils.createTextElement(dom, "FifoType", this.getFifoType()));
        el.appendChild(XMLUtils.createBoolElement(dom, "OptFifo", this.getOptimizeFifo()));
        el.appendChild(XMLUtils.createIntElement(dom, "FifoSize", this.getFifoSize()));
        el.appendChild(XMLUtils.createBoolElement(dom, "FifoCompensation", this.getFifoCompensation()));
        return el;
    }

    public String getOptimisationtype() {
        if (this.optimisationType != null) {
            return this.optimisationType;
        }
        return new String("");
    }

    public BuildingBlock.NumType getOptimisationDataType() {
        return this.optimisationDataType;
    }

    public int getOptimisationfrequency() {
        return this.optimisationFrequency;
    }

    public String getFifoType() {
        return this.fifoType;
    }

    public boolean getOptimizeFifo() {
        return this.optimizeFifo;
    }

    public boolean getFifoCompensation() {
        return this.fifoComp;
    }

    public int getFifoSize() {
        return this.fifoSize;
    }

    public void setFifoSize(int size) {
        this.fifoSize = size;
    }

    public void setOptimizeFifo(boolean optimize) {
        this.optimizeFifo = optimize;
    }

    public void setFifoCompensation(boolean compensate) {
        this.fifoComp = compensate;
    }

    public void setOptimisationType(String type) {
        this.optimisationType = type;
    }

    public void setOptimisationDataType(BuildingBlock.NumType dataType) {
        this.optimisationDataType = dataType;
    }

    public void setOptimisationFrequency(int frequency) {
        this.optimisationFrequency = frequency;
    }

    public void setFifoType(String fType) {
        this.fifoType = fType;
    }
}

