/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.project;

import java.io.File;
import m2m.backend.project.OptimisationProperties;
import m2m.backend.project.SimulationProperties;

public class ProjectProperties {
    private File file;
    private String path;
    private String relativeSourceFileName;
    private OptimisationProperties optimisationProperties;
    private SimulationProperties simulationProperties;

    public void setProjectFile(File file) {
        this.file = file;
        this.path = file.getAbsolutePath().replace("\\", "/").substring(0, file.getAbsolutePath().replace("\\", "/").lastIndexOf("/") + 1);
    }

    public File getProjectFile() {
        return this.file;
    }

    public String getProjectPath() {
        return this.path;
    }

    public String getFunctionName() {
        return this.file.getName().substring(0, this.file.getName().length() - 4);
    }

    public void setSourceFile(File file) {
        this.setSourceFilePath(this.getRelativePath(file.getAbsolutePath().replace("\\", "/")));
    }

    private String getRelativePath(String absolutePath) {
        String relativePath = new String();
        String commonPath = new String();
        String subPath = new String();
        int index = 0;
        int subFolders = 0;
        int i = 0;
        while (i < this.path.length()) {
            if (this.path.charAt(i) != absolutePath.charAt(i)) break;
            ++index;
            commonPath = String.valueOf(commonPath) + this.path.charAt(i);
            ++i;
        }
        subPath = this.path.substring(index);
        while (subPath.indexOf("/") != -1) {
            ++subFolders;
            subPath = subPath.substring(subPath.indexOf("/") + 1);
        }
        i = 0;
        while (i < subFolders) {
            relativePath = String.valueOf(relativePath) + "../";
            ++i;
        }
        subPath = absolutePath.substring(index);
        relativePath = String.valueOf(relativePath) + subPath;
        return relativePath;
    }

    public ProjectProperties() {
        this.relativeSourceFileName = null;
        this.optimisationProperties = new OptimisationProperties();
        this.simulationProperties = new SimulationProperties();
    }

    public ProjectProperties(String sourceFilePath, OptimisationProperties optimProp, SimulationProperties simProp) {
        this.relativeSourceFileName = sourceFilePath;
        this.optimisationProperties = optimProp;
        this.simulationProperties = simProp;
    }

    public OptimisationProperties getOptimisationProperties() {
        return this.optimisationProperties;
    }

    public SimulationProperties getSimulationProperties() {
        return this.simulationProperties;
    }

    public String getRelativeSourceFilename() {
        return this.relativeSourceFileName;
    }

    public String getAbsoluteSourceFilename() {
        return String.valueOf(this.path) + this.relativeSourceFileName;
    }

    public String getProjectShortFilename() {
        return this.file.getName();
    }

    public String getProjectFullFilename() {
        return this.file.getAbsolutePath();
    }

    public void setOptimisationProperties(OptimisationProperties optimProp) {
        this.optimisationProperties = optimProp;
    }

    public void setSimulationProperties(SimulationProperties simProp) {
        this.simulationProperties = simProp;
    }

    public void setSourceFilePath(String path) {
        this.relativeSourceFileName = path;
    }
}

