/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.project;

import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimulationProperties {
    private int simulationCalcPrecision = 0;
    private int nbSamples = 5000;
    private float systemFrequency = 100.0f;
    private float inputFrequency = 100.0f;
    private float outputFrequency = 100.0f;
    private int inactivityTimeout = 10000;

    public String getXmlTagName() {
        return "Simulation";
    }

    public int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public void setInactivityTimeout(int timeout) {
        this.inactivityTimeout = timeout;
    }

    public boolean fromXml(Element el) {
        this.setSimulationCalcPrecision(XMLUtils.getIntValue(el, "Precision", 0));
        this.setNumberOfSamples(XMLUtils.getIntValue(el, "NbSamples", 5000));
        this.setInputFrequency(XMLUtils.getFloatValue(el, "InputFrequency", 100.0f));
        this.setOutputFrequency(XMLUtils.getFloatValue(el, "OutputFrequency", 100.0f));
        this.setSystemFrequency(XMLUtils.getFloatValue(el, "SystemFrequency", 100.0f));
        this.setInactivityTimeout(XMLUtils.getIntValue(el, "InactivityTimeout", 10000));
        return true;
    }

    public Element toXml(Document dom) {
        Element el = dom.createElement(this.getXmlTagName());
        el.appendChild(XMLUtils.createIntElement(dom, "Precision", this.getSimulationCalcPrecision()));
        el.appendChild(XMLUtils.createIntElement(dom, "NbSamples", this.getNumberOfSamples()));
        el.appendChild(XMLUtils.createFloatElement(dom, "InputFrequency", this.getInputFrequency()));
        el.appendChild(XMLUtils.createFloatElement(dom, "OutputFrequency", this.getOutputFrequency()));
        el.appendChild(XMLUtils.createFloatElement(dom, "SystemFrequency", this.getSystemFrequency()));
        return el;
    }

    public int getSimulationCalcPrecision() {
        return this.simulationCalcPrecision;
    }

    public int getNumberOfSamples() {
        return this.nbSamples;
    }

    public float getSystemFrequency() {
        return this.systemFrequency;
    }

    public float getInputFrequency() {
        return this.inputFrequency;
    }

    public float getOutputFrequency() {
        return this.outputFrequency;
    }

    public void setSimulationCalcPrecision(int precision) {
        this.simulationCalcPrecision = precision;
    }

    public void setNumberOfSamples(int samples) {
        this.nbSamples = samples;
    }

    public void setSystemFrequency(float freq) {
        this.systemFrequency = freq;
    }

    public void setInputFrequency(float freq) {
        this.inputFrequency = freq;
    }

    public void setOutputFrequency(float freq) {
        this.outputFrequency = freq;
    }
}

