/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.GraphParams;
import m2m.backend.structure.Variable;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Case
extends Element {
    private Vector<Variable> cond = null;
    private Vector<Element> body = null;

    @Override
    public void modifyNumType(BuildingBlock.NumType type) {
        super.modifyNumType(type);
        for (Element element : this.cond) {
            element.modifyNumType(type);
        }
        for (Element element : this.body) {
            element.modifyNumType(type);
        }
    }

    @Override
    public String getXmlTagName() {
        return "Case";
    }

    @Override
    public Element copy(Function newFunc) {
        Case ccopy = new Case();
        this.copyTo(ccopy, newFunc);
        return ccopy;
    }

    @Override
    public void copyTo(Element to, Function newFunc) {
        Case ccopy = (Case)to;
        super.copyTo(ccopy, newFunc);
        for (Variable variable : this.cond) {
            ccopy.cond.add((Variable)variable.copy(newFunc));
        }
        for (Element element : this.body) {
            ccopy.body.add(element.copy(newFunc));
        }
    }

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        this.name = XMLUtils.getTextValue(el, "Name", "");
        this.monitor = XMLUtils.getBoolValue(el, "Monitor", false);
        Node node = el.getFirstChild();
        while (node != null) {
            Element element;
            Node nodeIn;
            org.w3c.dom.Element inputEl;
            if (node.getNodeName().equalsIgnoreCase("Cond")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.cond.add((Variable)element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("Body")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.body.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        return false;
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        super.insideToXml(el, dom, shortRef);
        org.w3c.dom.Element condEl = dom.createElement("Cond");
        for (Element element : this.cond) {
            condEl.appendChild(element.toXml(dom, false));
        }
        el.appendChild(condEl);
        org.w3c.dom.Element element = dom.createElement("Body");
        for (Element e : this.body) {
            element.appendChild(e.toXml(dom, false));
        }
        el.appendChild(element);
    }

    public void setCond(Vector<Variable> cond) {
        this.cond = cond;
    }

    public Vector<Variable> getCond() {
        return this.cond;
    }

    public void setBody(Vector<Element> body) {
        this.body = body;
    }

    public Vector<Element> getBody() {
        return this.body;
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + ">>===COND===<<";
        if (this.cond == null) {
            s = String.valueOf(s) + "\n" + this.tab(level + 1) + "Otherwise";
        } else {
            for (Element element : this.cond) {
                s = String.valueOf(s) + "\n" + element.toString(level + 1);
            }
        }
        s = String.valueOf(s) + "\n" + this.tab(level) + ">>===BODY===<<";
        if (this.body != null) {
            for (Element element : this.body) {
                s = String.valueOf(s) + "\n" + element.toString(level + 1);
            }
        }
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        if (this.cond == null || this.cond.isEmpty()) {
            s = String.valueOf(s) + this.tab(level) + prefix + "[shape = " + boxFormat + ", label = \"Otherwise\" color=\"" + GraphParams.otherwColor + "\" style=\"filled\"]";
        } else {
            String list = new String();
            boolean first = true;
            for (Variable var : this.cond) {
                if (!first) {
                    list = String.valueOf(list) + ", ";
                }
                list = var.getName().isEmpty() ? String.valueOf(list) + var.getVal() : String.valueOf(list) + var.getName();
                first = false;
            }
            s = String.valueOf(s) + this.tab(level) + prefix + "[shape = " + boxFormat + ", label = \"" + list + "\" color=\"" + GraphParams.otherwColor + "\" style=\"filled\"]";
        }
        if (!this.body.isEmpty()) {
            int cpt = 0;
            for (Element el : this.body) {
                s = String.valueOf(s) + "\n" + el.toSchematic(level, String.valueOf(prefix) + "_" + cpt, "box", GraphParams.defaultColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_" + cpt;
                ++cpt;
            }
        }
        return s;
    }
}

