/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.util.HashMap;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.structure.Addition;
import m2m.backend.structure.And;
import m2m.backend.structure.Assignment;
import m2m.backend.structure.Case;
import m2m.backend.structure.Delay;
import m2m.backend.structure.Division;
import m2m.backend.structure.DotDivision;
import m2m.backend.structure.DotMultiplication;
import m2m.backend.structure.Equal;
import m2m.backend.structure.Function;
import m2m.backend.structure.GenericOperation;
import m2m.backend.structure.Greater;
import m2m.backend.structure.GreaterEqual;
import m2m.backend.structure.IfThenElse;
import m2m.backend.structure.Less;
import m2m.backend.structure.LessEqual;
import m2m.backend.structure.LoopFor;
import m2m.backend.structure.LoopWhile;
import m2m.backend.structure.Multiplexer;
import m2m.backend.structure.Multiplication;
import m2m.backend.structure.Negation;
import m2m.backend.structure.Not;
import m2m.backend.structure.Or;
import m2m.backend.structure.Power;
import m2m.backend.structure.SQRT;
import m2m.backend.structure.SimpleVariable;
import m2m.backend.structure.StructTreatment;
import m2m.backend.structure.Subtraction;
import m2m.backend.structure.Switch;
import m2m.backend.structure.VectorVariable;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;

public abstract class Element
implements Cloneable {
    protected String name = new String();
    protected boolean monitor = false;

    public abstract String getXmlTagName();

    public org.w3c.dom.Element toXml(Document dom, boolean shortRef) {
        org.w3c.dom.Element el = dom.createElement(this.getXmlTagName());
        this.insideToXml(el, dom, shortRef);
        return el;
    }

    public Element getElement(org.w3c.dom.Element el, Function newFunc) {
        HashMap<String, Class> OperationMap = new HashMap<String, Class>();
        OperationMap.put("add", Addition.class);
        OperationMap.put("ass", Assignment.class);
        OperationMap.put("delay", Delay.class);
        OperationMap.put("div", Division.class);
        OperationMap.put("dotdiv", DotDivision.class);
        OperationMap.put("dotmult", DotMultiplication.class);
        OperationMap.put("equal", Equal.class);
        OperationMap.put("great", Greater.class);
        OperationMap.put("greateq", GreaterEqual.class);
        OperationMap.put("less", Less.class);
        OperationMap.put("lesseq", LessEqual.class);
        OperationMap.put("mult", Multiplication.class);
        OperationMap.put("neg", Negation.class);
        OperationMap.put("power", Power.class);
        OperationMap.put("sqrt", SQRT.class);
        OperationMap.put("sub", Subtraction.class);
        HashMap<String, Class<Not>> LogicOperationMap = new HashMap<String, Class<Not>>();
        LogicOperationMap.put("and", And.class);
        LogicOperationMap.put("or", Or.class);
        LogicOperationMap.put("not", Not.class);
        if (el.getTagName().equalsIgnoreCase("Operation")) {
            String name = XMLUtils.getTextValue(el, "OpName", "");
            Class cl = (Class)OperationMap.get(name);
            if (cl != null) {
                try {
                    Element e = (Element)cl.newInstance();
                    e.insideFromXml(el, newFunc);
                    return e;
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("Error at instantiation");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("Error at instantiation 2");
                }
            }
        } else if (el.getTagName().equalsIgnoreCase("LogicOperation")) {
            String name = XMLUtils.getTextValue(el, "OpName", "");
            Class cl = (Class)LogicOperationMap.get(name);
            if (cl != null) {
                try {
                    Element e = (Element)cl.newInstance();
                    e.insideFromXml(el, newFunc);
                    return e;
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("Error at instantiation");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("Error at instantiation 2");
                }
            }
        } else {
            if (el.getTagName().equalsIgnoreCase("Case")) {
                Case var = new Case();
                var.insideFromXml(el, newFunc);
                return var;
            }
            if (el.getTagName().equalsIgnoreCase("IfThenElse")) {
                IfThenElse var = new IfThenElse();
                var.insideFromXml(el, newFunc);
                return var;
            }
            if (el.getTagName().equalsIgnoreCase("LoopFor")) {
                LoopFor var = new LoopFor();
                var.insideFromXml(el, newFunc);
                return var;
            }
            if (el.getTagName().equalsIgnoreCase("LoopWhile")) {
                LoopWhile var = new LoopWhile();
                var.insideFromXml(el, newFunc);
                return var;
            }
            if (el.getTagName().equalsIgnoreCase("Multiplexer")) {
                Multiplexer var = new Multiplexer();
                var.insideFromXml(el, newFunc);
                return var;
            }
            if (el.getTagName().equalsIgnoreCase("Switch")) {
                Switch var = new Switch();
                var.insideFromXml(el, newFunc);
                return var;
            }
            if (el.getTagName().equalsIgnoreCase("SimpleVariable")) {
                SimpleVariable var = new SimpleVariable();
                var.insideFromXml(el, newFunc);
                Element newEl = newFunc.findElement(var.getName());
                if (newEl != null) {
                    return newEl;
                }
                return var;
            }
            if (el.getTagName().equalsIgnoreCase("VectorVariable")) {
                VectorVariable var = new VectorVariable();
                var.insideFromXml(el, newFunc);
                Element newEl = newFunc.findElement(var.getName());
                if (newEl != null) {
                    return newEl;
                }
                return var;
            }
            if (el.getTagName().equalsIgnoreCase("GenericOperation")) {
                GenericOperation var = new GenericOperation();
                var.insideFromXml(el, newFunc);
                return var;
            }
        }
        return null;
    }

    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        this.name = XMLUtils.getTextValue(el, "Name", "");
        this.monitor = XMLUtils.getBoolValue(el, "Monitor", false);
        return !this.name.isEmpty();
    }

    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        el.appendChild(XMLUtils.createTextElement(dom, "Name", this.name));
        el.appendChild(XMLUtils.createBoolElement(dom, "Monitor", this.monitor));
    }

    public abstract Element copy(Function var1);

    public Element findElement(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        return null;
    }

    protected void copyTo(Element e, Function newFunc) {
        e.name = this.name;
        e.monitor = this.monitor;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    protected String tab(int nb) {
        String sTab = new String();
        int i = 0;
        while (i < nb) {
            sTab = String.valueOf(sTab) + "\t";
            ++i;
        }
        return sTab;
    }

    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[Element]\tName: " + this.name + "\n";
        return s;
    }

    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        return s;
    }

    public String toOctave(int level) {
        String s = new String();
        return s;
    }

    public boolean getMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean monitor, StructTreatment struct) {
        if (this.monitor != monitor) {
            struct.modifyMonitor(monitor);
        }
        this.monitor = monitor;
    }

    public void modifyNumType(BuildingBlock.NumType type) {
    }
}

