/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.GraphParams;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IfThenElse
extends Function {
    private Vector<Element> cond;
    private Vector<Element> bodyTrue;
    private Vector<Element> bodyFalse;

    public IfThenElse() {
        this.setName("ifthen");
        this.cond = new Vector();
        this.bodyTrue = new Vector();
        this.bodyFalse = new Vector();
    }

    @Override
    public void modifyNumType(BuildingBlock.NumType type) {
        super.modifyNumType(type);
        for (Element e : this.cond) {
            e.modifyNumType(type);
        }
        for (Element e : this.bodyTrue) {
            e.modifyNumType(type);
        }
        for (Element e : this.bodyFalse) {
            e.modifyNumType(type);
        }
    }

    @Override
    public String getXmlTagName() {
        return "IfThenElse";
    }

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        this.name = XMLUtils.getTextValue(el, "Name", "");
        this.monitor = XMLUtils.getBoolValue(el, "Monitor", false);
        Node node = el.getFirstChild();
        while (node != null) {
            Element element;
            Node nodeIn;
            org.w3c.dom.Element inputEl;
            if (node.getNodeName().equalsIgnoreCase("Cond")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.cond.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("BodyTrue")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.bodyTrue.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("BodyFalse") && (inputEl = (org.w3c.dom.Element)node) != null && inputEl.getFirstChild() != null) {
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.bodyFalse.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        return false;
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        super.insideToXml(el, dom, shortRef);
        org.w3c.dom.Element condEl = dom.createElement("Cond");
        for (Element e : this.cond) {
            condEl.appendChild(e.toXml(dom, false));
        }
        el.appendChild(condEl);
        org.w3c.dom.Element bodyTEl = dom.createElement("BodyTrue");
        for (Element e : this.bodyTrue) {
            bodyTEl.appendChild(e.toXml(dom, false));
        }
        el.appendChild(bodyTEl);
        org.w3c.dom.Element bodyFEl = dom.createElement("BodyFalse");
        for (Element e : this.bodyFalse) {
            bodyFEl.appendChild(e.toXml(dom, false));
        }
        el.appendChild(bodyFEl);
    }

    @Override
    public Element copy(Function newFunc) {
        IfThenElse newIf = new IfThenElse();
        super.copyTo(newIf, newFunc);
        for (Element e : this.cond) {
            newIf.cond.add(e.copy(newFunc));
        }
        for (Element e : this.bodyTrue) {
            newIf.bodyTrue.add(e.copy(newFunc));
        }
        for (Element e : this.bodyFalse) {
            newIf.bodyFalse.add(e.copy(newFunc));
        }
        return newIf;
    }

    public void setBodyTrue(Vector<Element> body) {
        this.bodyTrue = body;
    }

    public Vector<Element> getBodyTrue() {
        return this.bodyTrue;
    }

    public void setBodyFalse(Vector<Element> body) {
        this.bodyFalse = body;
    }

    public Vector<Element> getBodyFalse() {
        return this.bodyFalse;
    }

    public void setCond(Vector<Element> cond) {
        this.cond = cond;
    }

    public Vector<Element> getCond() {
        return this.cond;
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[IfThenElse]\tName: " + this.name;
        s = String.valueOf(s) + "\n" + this.toStringParam(level + 1);
        s = String.valueOf(s) + "\n" + this.tab(level) + ">>===COND===<<";
        for (Element el : this.cond) {
            s = String.valueOf(s) + "\n" + el.toString(level + 1);
        }
        s = String.valueOf(s) + "\n" + this.tab(level) + ">>===TRUE===<<";
        for (Element el : this.bodyTrue) {
            s = String.valueOf(s) + "\n" + el.toString(level + 1);
        }
        if (!this.bodyFalse.isEmpty()) {
            s = String.valueOf(s) + "\n" + this.tab(level) + ">>===FALSE==<<";
            for (Element el : this.bodyFalse) {
                s = String.valueOf(s) + "\n" + el.toString(level + 1);
            }
        }
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        int cpt = 0;
        s = String.valueOf(s) + super.toSchematic(level, prefix, "box", color);
        if (!this.cond.isEmpty()) {
            cpt = 0;
            for (Element el : this.cond) {
                s = String.valueOf(s) + "\n" + el.toSchematic(level, String.valueOf(prefix) + "_cond_" + cpt, "box", GraphParams.defaultColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_cond_" + cpt;
                ++cpt;
            }
        }
        if (!this.bodyTrue.isEmpty()) {
            cpt = 0;
            for (Element el : this.bodyTrue) {
                s = String.valueOf(s) + "\n" + el.toSchematic(level, String.valueOf(prefix) + "_bodyTrue_" + cpt, "box", GraphParams.defaultColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_bodyTrue_" + cpt + "[label = \"bodyTrue\"]";
                ++cpt;
            }
        }
        if (!this.bodyFalse.isEmpty()) {
            cpt = 0;
            for (Element el : this.bodyFalse) {
                s = String.valueOf(s) + "\n" + el.toSchematic(level, String.valueOf(prefix) + "_bodyFalse_" + cpt, "box", GraphParams.defaultColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_bodyFalse_" + cpt + "[label = \"bodyFalse\"]";
                ++cpt;
            }
        }
        return s;
    }

    @Override
    public String toOctave(int level) {
        String sOctave = new String();
        if (!this.name.contains("loopfor")) {
            for (Element e : this.cond) {
                sOctave = String.valueOf(sOctave) + e.toOctave(level) + "\n";
            }
            for (Element e : this.bodyTrue) {
                sOctave = String.valueOf(sOctave) + e.toOctave(level) + "\n";
            }
            for (Element e : this.bodyFalse) {
                sOctave = String.valueOf(sOctave) + e.toOctave(level) + "\n";
            }
        }
        return sOctave;
    }

    @Override
    public Element findElement(String name) {
        for (Element e : this.inputVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.outputVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.internalVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.body) {
            if (e.findElement(name) == null) continue;
            return e.findElement(name);
        }
        return null;
    }
}

