/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.structure.Assignment;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.GraphParams;
import m2m.backend.structure.IfThenElse;
import m2m.backend.structure.Operation;
import m2m.backend.structure.SimpleVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LoopFor
extends Function {
    private SimpleVariable start;
    private SimpleVariable incr;
    private SimpleVariable end;
    private Vector<SimpleVariable> loopVariables;
    private Operation iterOperation;

    @Override
    public String getXmlTagName() {
        return "LoopFor";
    }

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        Node node = el.getFirstChild();
        while (node != null) {
            Element element;
            Node nodeIn;
            org.w3c.dom.Element inputEl;
            if (node.getNodeName().equalsIgnoreCase("Start")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, this)) != null) {
                        this.start = (SimpleVariable)element;
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("Incr")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, this)) != null) {
                        this.incr = (SimpleVariable)element;
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("End")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, this)) != null) {
                        this.end = (SimpleVariable)element;
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("IterOp")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, this)) != null) {
                        this.iterOperation = (Operation)element;
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        return false;
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        super.insideToXml(el, dom, shortRef);
        org.w3c.dom.Element startEl = dom.createElement("Start");
        startEl.appendChild(this.start.toXml(dom, false));
        el.appendChild(startEl);
        org.w3c.dom.Element incrEl = dom.createElement("Incr");
        incrEl.appendChild(this.incr.toXml(dom, false));
        el.appendChild(incrEl);
        org.w3c.dom.Element endEl = dom.createElement("End");
        endEl.appendChild(this.end.toXml(dom, false));
        el.appendChild(endEl);
        org.w3c.dom.Element iterEl = dom.createElement("IterOp");
        iterEl.appendChild(this.iterOperation.toXml(dom, false));
        el.appendChild(iterEl);
    }

    public LoopFor() {
        this.setName("loopfor");
        this.start = new SimpleVariable("", 1.0);
        this.incr = new SimpleVariable("", 1.0);
        this.end = new SimpleVariable("", 1.0);
    }

    @Override
    public Element copy(Function newFunc) {
        LoopFor newLoop = new LoopFor();
        newLoop.start = (SimpleVariable)this.start.copy(newFunc);
        newLoop.incr = (SimpleVariable)this.incr.copy(newFunc);
        newLoop.end = (SimpleVariable)this.end.copy(newFunc);
        super.copyTo(newLoop, newFunc);
        newLoop.iterOperation = (Operation)this.iterOperation.copy(newLoop);
        return newLoop;
    }

    @Override
    public Element findElement(String name) {
        for (Element e : this.inputVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.outputVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.internalVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.body) {
            if (e.findElement(name) == null) continue;
            return e.findElement(name);
        }
        if (this.start.findElement(name) != null) {
            return this.start.findElement(name);
        }
        if (this.incr.findElement(name) != null) {
            return this.incr.findElement(name);
        }
        if (this.end.findElement(name) != null) {
            return this.end.findElement(name);
        }
        return null;
    }

    public void setStart(SimpleVariable start) {
        this.start = start;
    }

    public SimpleVariable getStart() {
        return this.start;
    }

    public void setIncr(SimpleVariable incr) {
        this.incr = incr;
    }

    public SimpleVariable getIncr() {
        return this.incr;
    }

    public void setEnd(SimpleVariable end) {
        this.end = end;
    }

    public SimpleVariable getEnd() {
        return this.end;
    }

    public void setLoopVariables(Vector<SimpleVariable> vector) {
        this.loopVariables = vector;
    }

    public Vector<SimpleVariable> getLoopVariables() {
        return this.loopVariables;
    }

    public void setIterOperation(Operation op) {
        this.iterOperation = op;
    }

    public Operation getIterOperation() {
        return this.iterOperation;
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[LoopFor]\tName: " + this.name;
        s = String.valueOf(s) + "\tInterval: ";
        s = this.start.getType().equals("const") ? String.valueOf(s) + this.start.getVal() : String.valueOf(s) + this.start.getName();
        s = String.valueOf(s) + " -> ";
        s = this.incr.getType().equals("const") ? String.valueOf(s) + this.incr.getVal() : String.valueOf(s) + this.incr.getName();
        s = String.valueOf(s) + " -> ";
        s = this.end.getType().equals("const") ? String.valueOf(s) + this.end.getVal() : String.valueOf(s) + this.end.getName();
        s = String.valueOf(s) + "\n" + this.toStringParam(level + 1);
        s = String.valueOf(s) + "\n" + this.tab(level) + ">>==========<<";
        for (Element el : this.body) {
            s = String.valueOf(s) + "\n" + el.toString(level + 1);
        }
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        s = String.valueOf(s) + super.toSchematic(level, prefix, "box", color);
        s = String.valueOf(s) + this.start.toSchematic(level, String.valueOf(prefix) + "_start", "box", GraphParams.loopIndColor);
        s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_start [label = \"start\"]";
        s = String.valueOf(s) + this.incr.toSchematic(level, String.valueOf(prefix) + "_incr", "box", GraphParams.loopIndColor);
        s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_incr [label = \"incr\"]";
        s = String.valueOf(s) + this.end.toSchematic(level, String.valueOf(prefix) + "_end", "box", GraphParams.loopIndColor);
        s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_end [label = \"end\"]";
        return s;
    }

    @Override
    public String toOctave(int level) {
        String sOctave = new String();
        sOctave = String.valueOf(sOctave) + this.tab(level) + "for ";
        sOctave = String.valueOf(sOctave) + ((Element)this.internalVars.firstElement()).getName() + "=";
        sOctave = String.valueOf(sOctave) + (this.start.getType().equals("const") ? Double.valueOf(this.start.getVal()) : this.start.getName());
        sOctave = String.valueOf(sOctave) + ":" + (this.incr.getType().equals("const") ? Double.valueOf(this.incr.getVal()) : this.incr.getName());
        sOctave = String.valueOf(sOctave) + ":" + (this.end.getType().equals("const") ? Double.valueOf(this.end.getVal()) : this.end.getName()) + "\n";
        for (Element e : this.body) {
            if (e instanceof IfThenElse && e.getName().contains("loopfor")) {
                SimpleVariable varIn = (SimpleVariable)((Assignment)((IfThenElse)e).getBodyTrue().firstElement()).getInputAt(0);
                SimpleVariable varOut = (SimpleVariable)((Assignment)((IfThenElse)e).getBodyTrue().firstElement()).getOutputAt(0);
                SimpleVariable varloop = (SimpleVariable)((Assignment)((IfThenElse)e).getBodyFalse().firstElement()).getInputAt(0);
                sOctave = String.valueOf(sOctave) + this.tab(level + 1) + "if (" + ((Element)this.internalVars.firstElement()).getName() + " == " + (this.start.getType().equals("const") ? Double.valueOf(this.start.getVal()) : this.start.getName()) + ")\n";
                sOctave = String.valueOf(sOctave) + this.tab(level + 2) + varOut.getName() + " = " + varIn.getName() + ";\n";
                sOctave = String.valueOf(sOctave) + this.tab(level + 1) + "else\n";
                sOctave = String.valueOf(sOctave) + this.tab(level + 2) + varOut.getName() + " = " + varloop.getName() + ";\n";
                sOctave = String.valueOf(sOctave) + this.tab(level + 1) + "endif;";
            }
            sOctave = String.valueOf(sOctave) + e.toOctave(level + 1) + "\n";
        }
        sOctave = String.valueOf(sOctave) + this.tab(level) + "endfor;";
        return sOctave;
    }

    public SimpleVariable getLoopVariable(SimpleVariable var) {
        for (Element e : this.body) {
            if (!(e instanceof IfThenElse) || !e.getName().contains("loopfor") || !((IfThenElse)e).getOutput().firstElement().equals(var)) continue;
            return (SimpleVariable)((Assignment)((IfThenElse)e).getBodyFalse().firstElement()).getInputAt(0);
        }
        return null;
    }

    public SimpleVariable getInitVariable(SimpleVariable var) {
        for (Element e : this.body) {
            if (!(e instanceof IfThenElse) || !e.getName().contains("loopfor") || !((IfThenElse)e).getOutput().firstElement().equals(var)) continue;
            return (SimpleVariable)((Assignment)((IfThenElse)e).getBodyTrue().firstElement()).getInputAt(0);
        }
        return null;
    }

    public boolean isInitVariable(SimpleVariable var) {
        for (Element e : this.body) {
            if (!(e instanceof IfThenElse) || !e.getName().contains("loopfor") || !((SimpleVariable)((Assignment)((IfThenElse)e).getBodyTrue().firstElement()).getInputAt(0)).equals(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void modifyNumType(BuildingBlock.NumType type) {
        this.iterOperation.modifyNumType(type);
        super.modifyNumType(type);
    }
}

