/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.util.List;
import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.buildingblocks.BuildingBlocksManager;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.GraphParams;
import m2m.backend.structure.SimpleVariable;
import m2m.backend.structure.Variable;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Operation
extends Element {
    protected Vector<Element> input = new Vector();
    protected Vector<Element> output = new Vector();
    protected BuildingBlock block = null;
    protected String opName = "void";
    protected boolean generic = false;

    @Override
    public String getXmlTagName() {
        return "Operation";
    }

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        Node node = el.getFirstChild();
        while (node != null) {
            Element element;
            Node nodeIn;
            org.w3c.dom.Element inputEl;
            if (node.getNodeName().equalsIgnoreCase("Input")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.input.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("Output")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.output.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        String bl = XMLUtils.getTextValue(el, "Block", "");
        BuildingBlocksManager manager = BuildingBlocksManager.getInstance();
        List<BuildingBlock> list = null;
        this.block = null;
        if (this.opName != null) {
            list = manager.blockNamed(this.opName);
            for (BuildingBlock b : list) {
                if (!b.getClass().getName().equals(bl)) continue;
                this.block = b;
            }
        }
        return true;
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        super.insideToXml(el, dom, shortRef);
        el.appendChild(XMLUtils.createTextElement(dom, "OpName", this.opName));
        el.appendChild(XMLUtils.createBoolElement(dom, "Generic", this.generic));
        if (this.block != null) {
            el.appendChild(XMLUtils.createTextElement(dom, "Block", this.block.getClass().getName()));
        }
        org.w3c.dom.Element inputEl = dom.createElement("Input");
        for (Element e : this.input) {
            inputEl.appendChild(e.toXml(dom, shortRef));
        }
        el.appendChild(inputEl);
        org.w3c.dom.Element outputEl = dom.createElement("Output");
        for (Element e : this.output) {
            outputEl.appendChild(e.toXml(dom, shortRef));
        }
        el.appendChild(outputEl);
    }

    public Operation() {
    }

    @Override
    public Element findElement(String name) {
        Element result = super.findElement(name);
        if (result != null) {
            return result;
        }
        for (Element e : this.input) {
            result = e.findElement(name);
            if (result == null) continue;
            return result;
        }
        for (Element e : this.output) {
            result = e.findElement(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void copyTo(Element e, Function newFunc) {
        Element found;
        Operation op = (Operation)e;
        super.copyTo(op, newFunc);
        op.opName = this.opName;
        op.block = this.block;
        for (Element el : this.input) {
            found = newFunc.findElement(el.getName());
            if (el.getName().contains("Add")) {
                found = new SimpleVariable(el.getName(), 0.0, "");
            }
            op.input.add(found);
        }
        for (Element el : this.output) {
            found = newFunc.findElement(el.getName());
            if (el.getName().contains("Add")) {
                found = new SimpleVariable(el.getName(), 0.0, "");
            }
            op.output.add(found);
        }
    }

    public Operation(String opName) {
        this();
        this.opName = opName;
        this.block = this.getFirstPipelined(BuildingBlock.NumType.FLOAT32);
    }

    public Operation(String opName, boolean gen) {
        this();
        this.generic = gen;
        this.opName = opName;
        this.block = this.getFirstPipelined(BuildingBlock.NumType.FLOAT32);
    }

    public BuildingBlock getFirstPipelined(BuildingBlock.NumType type) {
        BuildingBlocksManager manager = BuildingBlocksManager.getInstance();
        List<BuildingBlock> list = null;
        if (this.opName != null) {
            list = manager.blockNamed(this.opName);
            for (BuildingBlock b : list) {
                if (b.numType() != type || b.implType() != BuildingBlock.ImplType.PIPELINE) continue;
                return b;
            }
            return this.getFirst();
        }
        return null;
    }

    @Override
    public void modifyNumType(BuildingBlock.NumType type) {
        this.setBlock(this.getFirstPipelined(type));
    }

    public BuildingBlock getFirst() {
        BuildingBlocksManager manager = BuildingBlocksManager.getInstance();
        List<BuildingBlock> list = null;
        if (this.opName != null && !(list = manager.blockNamed(this.opName)).isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public void addInput(Element op) {
        this.input.add(op);
    }

    public void setInput(Vector<Element> op) {
        this.input = op;
    }

    public void setInputAt(int i, Element op) {
        this.input.set(i, op);
    }

    public Vector<Element> getInput() {
        return this.input;
    }

    public int getNbInput() {
        return this.input.size();
    }

    public Element getInputAt(int i) {
        Element el = null;
        try {
            el = this.input.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return el;
    }

    public void addOutput(Element op) {
        this.output.add(op);
    }

    public void setOutput(Vector<Element> op) {
        this.output = op;
    }

    public void setOutputAt(int i, Element op) {
        this.output.set(i, op);
    }

    public Vector<Element> getOutput() {
        return this.output;
    }

    public int getNbOutput() {
        return this.output.size();
    }

    public Element getOutputAt(int i) {
        Element el = null;
        try {
            el = this.output.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return el;
    }

    public void setBlock(BuildingBlock block) {
        this.block = block;
    }

    public BuildingBlock getBlock() {
        return this.block;
    }

    public void setOpName(String name) {
        this.opName = name;
    }

    public String getOpName() {
        return this.opName;
    }

    public String getOpSymbol() {
        return "op";
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[" + (this.generic ? "fun_" : "") + this.opName + "]\tName: " + this.name;
        if (this.block != null) {
            s = String.valueOf(s) + this.tab(level) + "BlockName : " + this.block.entityName();
        }
        s = String.valueOf(s) + "\n" + this.toStringParam(level + 1);
        return s;
    }

    protected String toStringParam(int level) {
        String s = new String();
        if (!this.output.isEmpty()) {
            s = String.valueOf(s) + this.tab(level) + "Output:";
            for (Element el : this.output) {
                if (el == null) continue;
                s = String.valueOf(s) + "\n" + el.toString(level + 1);
            }
        }
        if (!this.input.isEmpty()) {
            s = String.valueOf(s) + "\n" + this.tab(level) + "Input:";
            for (Element el : this.input) {
                if (el == null) continue;
                s = String.valueOf(s) + "\n" + el.toString(level + 1);
            }
        }
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        if (prefix.isEmpty()) {
            prefix = "top";
        }
        int cpt = 0;
        s = String.valueOf(s) + this.tab(level) + prefix + "[shape = \"" + boxFormat + "\", label = \"" + (this.generic ? "fun_" : "") + this.opName + " : " + this.getName() + "\" color=\"" + color + "\" style=\"filled\"]";
        if (!this.input.isEmpty()) {
            cpt = 0;
            for (Element var : this.input) {
                s = var instanceof Variable ? String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_in_" + cpt, GraphParams.inputShape, GraphParams.inputColor) : String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_in_" + cpt, boxFormat, GraphParams.defaultColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_in_" + cpt;
                ++cpt;
            }
        }
        if (!this.output.isEmpty()) {
            cpt = 0;
            for (Element var : this.output) {
                s = var instanceof Variable ? String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_out_" + cpt, GraphParams.outputShape, GraphParams.outputColor) : String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_out_" + cpt, boxFormat, GraphParams.defaultColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_out_" + cpt;
                ++cpt;
            }
        }
        return s;
    }

    public String toOctave(int level, String op) {
        String sOctave = new String();
        Element out = this.output.firstElement();
        sOctave = String.valueOf(sOctave) + this.tab(level) + out.getName() + "\t= ";
        boolean first = true;
        for (Element e : this.input) {
            if (e instanceof SimpleVariable) {
                sOctave = String.valueOf(sOctave) + (first ? "" : " " + op + " ") + (((SimpleVariable)e).getType().equals("const") ? Double.valueOf(((SimpleVariable)e).getVal()) : e.getName());
            }
            first = false;
        }
        if (!this.monitor) {
            sOctave = String.valueOf(sOctave) + ";";
        }
        if (out instanceof SimpleVariable & out.monitor) {
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level) + "for j_m2m_regen=1:length(interns)";
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 1) + "if(length(interns(j_m2m_regen).sname) == length(\"" + out.getName() + "\") && interns(j_m2m_regen).sname == \"" + out.getName() + "\")";
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 2) + "interns(j_m2m_regen).values(i_m2m_regen,:) = " + out.getName() + ";";
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 1) + "endif";
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level) + "endfor";
        }
        return sOctave;
    }
}

