/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import m2m.backend.project.M2MProject;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.Variable;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SimpleVariable
extends Variable {
    private ArrayList<Double> values;
    private String type;
    private int size;
    private int cost;
    private HashMap<Function, MapVHDLSimpleVariable> variableMap = new HashMap();
    private Vector<Integer> multiCost = new Vector();
    private Vector<Element> variablesDependencies = new Vector();
    private boolean simpleFifo = false;
    private int simpleFifoCost = 0;
    private HashMap<Function, SimpleVariable> inputLoopVariable = new HashMap();
    private SimpleVariable outputLoopVariable;
    private HashMap<Function, SimpleVariable> varFunctionMapping = new HashMap();
    private HashMap<Function, Integer> loopOutputCost = new HashMap();
    private HashMap<Function, Boolean> loopOutputConnect = new HashMap();

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        this.size = XMLUtils.getIntValue(el, "Size", 0);
        this.type = XMLUtils.getTextValue(el, "Type", "");
        if (this.name.isEmpty()) {
            return false;
        }
        Node node = el.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equalsIgnoreCase("Value")) {
                org.w3c.dom.Element inputEl = (org.w3c.dom.Element)node;
                String textVal = inputEl.getFirstChild().getNodeValue();
                this.values.add(Double.parseDouble(textVal));
            }
            node = node.getNextSibling();
        }
        return true;
    }

    @Override
    public String getXmlTagName() {
        return "SimpleVariable";
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        if (shortRef && !this.type.equals("const")) {
            el.appendChild(XMLUtils.createTextElement(dom, "Name", this.name));
        } else {
            super.insideToXml(el, dom, shortRef);
            el.appendChild(XMLUtils.createIntElement(dom, "Size", this.size));
            el.appendChild(XMLUtils.createTextElement(dom, "Type", this.type));
            for (double v : this.values) {
                el.appendChild(XMLUtils.createDoubleElement(dom, "Value", v));
            }
        }
    }

    @Override
    public Element copy(Function newFunc) {
        Element e = newFunc.findElement(this.name);
        if (e != null) {
            return e;
        }
        SimpleVariable newVar = new SimpleVariable();
        newVar.name = this.name;
        newVar.values = (ArrayList)this.values.clone();
        newVar.type = this.type;
        newVar.size = this.size;
        newVar.cost = this.cost;
        newVar.variablesDependencies = this.variablesDependencies;
        return newVar;
    }

    public SimpleVariable() {
        this.name = new String();
        this.values = new ArrayList();
        this.type = "";
        this.size = 0;
    }

    public SimpleVariable(String n) {
        this.name = n;
        this.values = new ArrayList();
        this.type = "";
    }

    public SimpleVariable(double v) {
        this.values = new ArrayList();
        this.values.add(v);
        this.name = "";
        this.type = "";
        this.size = 1;
    }

    public SimpleVariable(ArrayList<Double> v) {
        this.values = v;
        this.name = "";
        this.type = "";
        this.size = v.size();
    }

    public SimpleVariable(String n, double v) {
        this.values = new ArrayList();
        this.values.add(v);
        this.name = n;
        this.type = "";
    }

    public SimpleVariable(SimpleVariable var) {
        this.values = new ArrayList<Double>(var.values);
        this.type = var.getType();
        this.name = var.getName();
        this.size = var.size;
    }

    public SimpleVariable(String n, double v, String t) {
        this.values = new ArrayList();
        this.values.add(v);
        this.name = n;
        this.type = t == null ? "" : t;
        this.size = 1;
    }

    public SimpleVariable(String n, ArrayList<Double> v, String t) {
        this.values = v;
        this.name = n;
        this.type = t;
        this.size = v.size();
    }

    @Override
    public void setVal(double v) {
        this.values.clear();
        this.values.add(v);
        this.size = 1;
    }

    public void setVal(ArrayList<Double> v) {
        this.values = v;
        this.size = v.size();
    }

    @Override
    public double getVal() {
        if (this.values == null || !this.values.isEmpty()) {
            return this.values.get(0);
        }
        return Double.NaN;
    }

    public double getVal(int pos) {
        if (pos < this.values.size()) {
            this.values.get(pos);
        }
        return Double.NaN;
    }

    public ArrayList<Double> getValues() {
        return this.values;
    }

    public void addVal(double v) {
        this.values.add(v);
        ++this.size;
    }

    @Override
    public void setType(String t) {
        this.type = t;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[SimpleVariable]";
        s = !this.type.equals("const") ? String.valueOf(s) + "\tName: " + this.name + "\tType: " + this.type : String.valueOf(s) + "\tName: " + this.name + "\tVal: " + this.values;
        s = String.valueOf(s) + "\tSize: " + this.size;
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        if (prefix.isEmpty()) {
            prefix = "var";
        }
        s = this.type.equals("const") ? String.valueOf(s) + "\n" + this.tab(level) + prefix + "[shape=\"" + boxFormat + "\" label = \"" + this.getName() + ":\\n" + this.getVal() + "\" color=\"" + color + "\" style=\"filled\"]" : String.valueOf(s) + "\n" + this.tab(level) + prefix + "[shape=\"" + boxFormat + "\" label = \"" + this.getName() + "\" color=\"" + color + "\" style=\"filled\"]";
        return s;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public int getCost() {
        return this.cost;
    }

    public Vector<Integer> getMultiCost() {
        return this.multiCost;
    }

    public HashMap<Function, MapVHDLSimpleVariable> getVariableMap() {
        return this.variableMap;
    }

    public Vector<Element> getVariableDependencies() {
        return this.variablesDependencies;
    }

    public void setSimpleFifo(boolean value) {
        this.simpleFifo = value;
    }

    public boolean getSimpleFifo() {
        return this.simpleFifo;
    }

    public int getSimpleFifoCost(M2MProject project) {
        if (project.getOptimisationProperties().getOptimizeFifo()) {
            return this.simpleFifo ? this.simpleFifoCost + 1 : this.simpleFifoCost;
        }
        return project.getOptimisationProperties().getFifoSize() - 2;
    }

    public void setSimpleFifoCost(int value) {
        this.simpleFifoCost = value;
    }

    public void setOutputLoopVariable(SimpleVariable var) {
        this.outputLoopVariable = var;
    }

    public SimpleVariable getOutputLoopVariable() {
        return this.outputLoopVariable;
    }

    public void setInputLoopVariable(SimpleVariable var, Function f) {
        this.inputLoopVariable.put(f, var);
    }

    public SimpleVariable getInputLoopVariable(Function f) {
        return this.inputLoopVariable.get(f);
    }

    public void setVarFunctionMapping(SimpleVariable var, Function f) {
        this.varFunctionMapping.put(f, var);
    }

    public SimpleVariable getVarFunctionMapping(Function f) {
        return this.varFunctionMapping.get(f);
    }

    public void setLoopOutputCost(Function f, int value) {
        this.loopOutputCost.put(f, value);
    }

    public int getLoopOutputCost(Function f) {
        if (this.loopOutputCost.get(f) != null) {
            return this.loopOutputCost.get(f);
        }
        return 0;
    }

    public void setLoopOutputConnect(Function f, boolean value) {
        this.loopOutputConnect.put(f, value);
    }

    public boolean getLoopOutputConnect(Function f) {
        if (this.loopOutputConnect.get(f) != null) {
            return this.loopOutputConnect.get(f);
        }
        return false;
    }

    public class MapVHDLSimpleVariable {
        private Vector<SimpleVariable> multSimpleVar = new Vector();
        private int multSimpleVarIndex = 0;

        public SimpleVariable getMapVHDLSimpleVariable(int cost) {
            int i = this.multSimpleVarIndex;
            while (i < this.multSimpleVar.size()) {
                if (this.multSimpleVar.elementAt(i).getCost() == cost) {
                    this.multSimpleVar.add(0, this.multSimpleVar.elementAt(i));
                    this.multSimpleVar.removeElementAt(i + 1);
                    ++this.multSimpleVarIndex;
                    return this.multSimpleVar.elementAt(0);
                }
                ++i;
            }
            return null;
        }

        public Vector<SimpleVariable> getMultSimpleVar() {
            return this.multSimpleVar;
        }
    }
}

