/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.structure.Case;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.GraphParams;
import m2m.backend.structure.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Switch
extends Function {
    private Vector<Case> cases;
    private Variable switchVar;

    public Switch() {
        this.setName("switch");
        this.cases = new Vector();
    }

    @Override
    public void modifyNumType(BuildingBlock.NumType type) {
        super.modifyNumType(type);
        for (Element element : this.cases) {
            element.modifyNumType(type);
        }
    }

    @Override
    public String getXmlTagName() {
        return "Switch";
    }

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        Node node = el.getFirstChild();
        while (node != null) {
            Element element;
            Node nodeIn;
            org.w3c.dom.Element inputEl;
            if (node.getNodeName().equalsIgnoreCase("Cases")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.cases.add((Case)element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("SwitchVar")) {
                inputEl = (org.w3c.dom.Element)node;
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.switchVar = (Variable)element;
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        return false;
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        super.insideToXml(el, dom, shortRef);
        org.w3c.dom.Element casesEl = dom.createElement("Cases");
        for (Element e : this.inputVars) {
            casesEl.appendChild(e.toXml(dom, false));
        }
        el.appendChild(casesEl);
        org.w3c.dom.Element switchVarEl = dom.createElement("SwitchVar");
        switchVarEl.appendChild(this.switchVar.toXml(dom, false));
        el.appendChild(switchVarEl);
    }

    public void setSwitchVar(Variable var) {
        this.switchVar = var;
    }

    public Variable getSwitchVar() {
        return this.switchVar;
    }

    public void addCase(Vector<Variable> cond, Vector<Element> body) {
        Case c = new Case();
        c.setBody(body);
        c.setCond(cond);
        this.cases.add(c);
    }

    public void addCase(Case cas) {
        this.cases.add(cas);
    }

    public void setCases(Vector<Case> cases) {
        this.cases = cases;
    }

    public Vector<Case> getCases() {
        return this.cases;
    }

    public Case getCaseAt(int ind) {
        if (ind < 0 || ind >= this.cases.size()) {
            return null;
        }
        return this.cases.elementAt(ind);
    }

    public int getSize() {
        return this.cases.size();
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[Switch]\tName: " + this.name;
        if (this.switchVar != null) {
            s = String.valueOf(s) + "\n" + this.tab(level + 1) + "Switch Var:";
            s = String.valueOf(s) + "\n" + this.switchVar.toString(level + 2);
        }
        s = String.valueOf(s) + "\n" + this.tab(level + 1) + ">>===CASES===<<";
        for (Case cas : this.cases) {
            s = String.valueOf(s) + "\n" + cas.toString(level + 2);
        }
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        int cpt = 0;
        s = String.valueOf(s) + this.tab(level) + prefix + "[shape = " + boxFormat + ", label = \"" + this.getName() + "\" color=\"" + color + "\" style=\"filled\"]";
        if (this.switchVar != null) {
            s = String.valueOf(s) + "\n" + this.tab(level) + prefix + "_switchVar [shape = " + GraphParams.inputShape + ", label = \"" + this.switchVar.getName() + "\" color=\"" + GraphParams.inputColor + "\" style=\"filled\"]";
            s = String.valueOf(s) + "\n" + this.tab(level) + prefix + "->" + prefix + "_switchVar [label = \"Sel\"]";
        }
        for (Case c : this.cases) {
            s = String.valueOf(s) + "\n" + c.toSchematic(level, String.valueOf(prefix) + "_case_" + cpt, boxFormat, color);
            s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_case_" + cpt;
            ++cpt;
        }
        return s;
    }
}

