/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.verifpga;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

public final class BinaryIn {
    private BufferedInputStream in;
    private final int EOF = -1;
    private int buffer;
    private int N;

    private void fillBuffer() {
        try {
            this.buffer = this.in.read();
            this.N = 8;
        }
        catch (IOException iOException) {
            System.err.println("EOF");
            this.buffer = -1;
            this.N = -1;
        }
    }

    public BinaryIn() {
        this.in = new BufferedInputStream(System.in);
        this.fillBuffer();
    }

    public BinaryIn(InputStream is) {
        this.in = new BufferedInputStream(is);
        this.fillBuffer();
    }

    public BinaryIn(Socket socket) {
        try {
            InputStream is = socket.getInputStream();
            this.in = new BufferedInputStream(is);
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + socket);
        }
        System.out.println("BinaryIn...");
    }

    public BinaryIn(URL url) {
        try {
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            this.in = new BufferedInputStream(is);
            this.fillBuffer();
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + url);
        }
    }

    public BinaryIn(String s) {
        try {
            File file = new File(s);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                this.in = new BufferedInputStream(fis);
                this.fillBuffer();
                return;
            }
            URL url = this.getClass().getResource(s);
            if (url == null) {
                url = new URL(s);
            }
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            this.in = new BufferedInputStream(is);
            this.fillBuffer();
        }
        catch (IOException iOException) {
            System.err.println("Could not open " + s);
        }
    }

    public boolean exists() {
        return this.in != null;
    }

    public boolean isEmpty() {
        return this.buffer == -1;
    }

    public boolean readBoolean() {
        boolean bit;
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        --this.N;
        boolean bl = bit = (this.buffer >> this.N & 1) == 1;
        if (this.N == 0) {
            this.fillBuffer();
        }
        return bit;
    }

    public char readChar() {
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        if (this.N == 8) {
            int x = this.buffer;
            this.fillBuffer();
            return (char)(x & 0xFF);
        }
        int x = this.buffer;
        x <<= 8 - this.N;
        int oldN = this.N;
        this.fillBuffer();
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        this.N = oldN;
        return (char)((x |= this.buffer >>> this.N) & 0xFF);
    }

    public char readChar(int r) {
        if (r < 1 || r > 16) {
            throw new RuntimeException("Illegal value of r = " + r);
        }
        if (r == 8) {
            return this.readChar();
        }
        char x = '\u0000';
        int i = 0;
        while (i < r) {
            x = (char)(x << 1);
            boolean bit = this.readBoolean();
            if (bit) {
                x = (char)(x | '\u0001');
            }
            ++i;
        }
        return x;
    }

    public String readString() {
        if (this.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        StringBuilder sb = new StringBuilder();
        while (!this.isEmpty()) {
            char c = this.readChar();
            sb.append(c);
        }
        return sb.toString();
    }

    public short readShort() {
        short x = 0;
        int i = 0;
        while (i < 2) {
            char c = this.readChar();
            x = (short)(x << 8);
            x = (short)(x | c);
            ++i;
        }
        return x;
    }

    public int readInt() {
        int x = 0;
        int i = 0;
        while (i < 4) {
            char c = this.readChar();
            x <<= 8;
            x |= c;
            ++i;
        }
        return x;
    }

    public int readIntOther() {
        int x = 0;
        int i = 0;
        while (i < 4) {
            int c;
            int y = c = this.readChar();
            int j = 1;
            while (j < i) {
                y <<= 8;
                ++j;
            }
            x |= y;
            ++i;
        }
        return x;
    }

    public int readInt(int r) {
        if (r < 1 || r > 32) {
            throw new RuntimeException("Illegal value of r = " + r);
        }
        if (r == 32) {
            return this.readInt();
        }
        int x = 0;
        int i = 0;
        while (i < r) {
            x <<= 1;
            boolean bit = this.readBoolean();
            if (bit) {
                x |= 1;
            }
            ++i;
        }
        return x;
    }

    public long readLong() {
        long x = 0L;
        int i = 0;
        while (i < 8) {
            char c = this.readChar();
            x <<= 8;
            x |= (long)c;
            ++i;
        }
        return x;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public byte readByte() {
        char c = this.readChar();
        byte x = (byte)(c & 0xFF);
        return x;
    }
}

