/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.verifpga;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.LinkedList;
import m2m.backend.project.ExternalToolsProperties;
import m2m.backend.project.M2MProject;
import m2m.backend.utils.FileUtils;

public class ISETCLGenerator {
    public static final String PROJECT_PATH_TCL = "<PROJECTPATH>";
    private String projectPath;
    private String templatesPath;
    private String ubiduleSourcePath;
    private String isePath;
    private String vhdlPath;

    public boolean generateTCLISE(M2MProject project) {
        System.out.println("Generation ise tcl script...");
        project.checkFolders();
        this.templatesPath = String.valueOf(M2MProject.getLibPath()) + "/ubidule/templates/";
        this.ubiduleSourcePath = String.valueOf(M2MProject.getLibPath()) + "/ubidule/";
        this.projectPath = project.getProperties().getProjectPath();
        this.isePath = String.valueOf(project.getProperties().getProjectPath()) + M2MProject.getUbiduleDirName() + "/";
        this.vhdlPath = String.valueOf(project.getVHDLPath()) + "/";
        FileUtils.copyFile(String.valueOf(this.ubiduleSourcePath) + "M2M_Test", String.valueOf(project.getVHDLPath()) + "/M2M_Test", ".svn");
        this.processTemplate("script_gen_xsvf", "");
        FileUtils.copyFile(String.valueOf(this.templatesPath) + "part1.tcl", String.valueOf(this.isePath) + "part1.tcl");
        this.processTemplate("part2", ".tcl");
        this.generateTCL("part3");
        FileUtils.copyFile(String.valueOf(this.templatesPath) + "part4.tcl", String.valueOf(this.isePath) + "part4.tcl");
        this.processTemplate("part5", ".tcl");
        FileUtils.copyFile(String.valueOf(this.templatesPath) + "part6.tcl", String.valueOf(this.isePath) + "part6.tcl");
        this.concatenateTCLParts();
        FileUtils.copyFile(String.valueOf(this.ubiduleSourcePath) + "M2M_Test.ucf", String.valueOf(this.isePath) + "M2M_Test.ucf");
        FileUtils.copyFile(String.valueOf(this.ubiduleSourcePath) + "PROM2_xcf32p.mcs", String.valueOf(this.isePath) + "PROM2_xcf32p.mcs");
        FileUtils.copyFile(String.valueOf(this.ubiduleSourcePath) + "batch_test.cmd", String.valueOf(this.isePath) + "batch_test.cmd");
        return true;
    }

    private void processTemplate(String tclName, String outputExtension) {
        System.out.println("processTemplate" + this.templatesPath + tclName);
        String newline = System.getProperty("line.separator");
        LinkedList<String> list = new LinkedList<String>();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(String.valueOf(this.templatesPath) + tclName);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                list.add(strLine);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(String.valueOf(this.isePath) + tclName + outputExtension));
            for (String line : list) {
                line = line.replace(PROJECT_PATH_TCL, this.projectPath);
                line = line.replace("<XILINXDIR>", ExternalToolsProperties.getReference().getIsePath());
                line = line.replace("<UBIDULEDIRNAME>", M2MProject.getUbiduleDirName());
                line = line.replace("<XILINXLICENSE>", ExternalToolsProperties.getReference().getXilinxLicense());
                output.write(String.valueOf(line) + newline);
                System.out.println("after: " + line);
            }
            ((Writer)output).close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private void populateVHDL(String dirName, LinkedList<String> list) {
        File dir = new File(dirName);
        String[] children = dir.list();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                File subdir;
                String filename = children[i];
                if (filename.contains(".vhd")) {
                    list.add(String.valueOf(dirName) + filename);
                }
                if ((subdir = new File(String.valueOf(dirName) + filename)).isDirectory()) {
                    this.populateVHDL(String.valueOf(dirName) + filename + "/", list);
                }
                ++i;
            }
        }
    }

    private void generateTCL(String tclName) {
        LinkedList<String> listVHDLFiles = new LinkedList<String>();
        String newline = System.getProperty("line.separator");
        this.populateVHDL(this.vhdlPath, listVHDLFiles);
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(String.valueOf(this.isePath) + tclName + ".tcl"));
            for (String line : listVHDLFiles) {
                output.write("   xfile add \"" + line + "\"" + newline);
            }
            ((Writer)output).close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private void concatenateTCLParts() {
        LinkedList<String> partsList = new LinkedList<String>();
        partsList.add(String.valueOf(this.isePath) + "part1.tcl");
        partsList.add(String.valueOf(this.isePath) + "part2.tcl");
        partsList.add(String.valueOf(this.isePath) + "part3.tcl");
        partsList.add(String.valueOf(this.isePath) + "part4.tcl");
        partsList.add(String.valueOf(this.isePath) + "part5.tcl");
        partsList.add(String.valueOf(this.isePath) + "part6.tcl");
        this.concatenateTCLParts(partsList);
    }

    private void concatenateTCLParts(LinkedList<String> list) {
        String newline = System.getProperty("line.separator");
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(String.valueOf(this.isePath) + "M2M_Test.tcl"));
            for (String line : list) {
                String strLine;
                BufferedReader reader = new BufferedReader(new FileReader(line));
                while ((strLine = reader.readLine()) != null) {
                    output.write(String.valueOf(strLine) + newline);
                }
            }
            ((Writer)output).close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}

