/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.verifpga;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.LinkedList;
import m2m.backend.processing.Errors;
import m2m.backend.processing.ProcessWatcher;
import m2m.backend.project.ExternalToolsProperties;
import m2m.backend.project.M2MProject;
import m2m.backend.verifpga.BinaryIn;
import m2m.backend.verifpga.BinaryOut;
import m2m.backend.verifpga.M2MData;

public class M2MClient {
    public static final int M2M_TEST_PORT = 55444;
    public static final int COMMAND_DEBUG = 2;
    public static final int COMMAND_NBTESTS = 3;
    public static final int COMMAND_INPUTDATA = 4;
    public static final int COMMAND_STARTM2M = 5;
    public static final int COMMAND_XSVF = 6;
    public static final int COMMAND_NBINPUTS = 7;
    public static final int COMMAND_NBOUTPUTS = 8;
    private M2MData m2mData;
    private String isePath;
    private M2MProject project;

    public boolean testOnUbidule(int nbrInput, int nbrOutput, int nbrSamples, M2MProject project) {
        Socket sock;
        this.m2mData = new M2MData(nbrSamples, nbrInput, nbrOutput, String.valueOf(project.getIOFilesPath()) + "/");
        this.m2mData.readInputData();
        this.isePath = String.valueOf(project.getProperties().getProjectPath()) + "/" + M2MProject.getUbiduleDirName();
        this.project = project;
        try {
            sock = new Socket(ExternalToolsProperties.getReference().getUbiduleIP(), 55444);
        }
        catch (IOException e) {
            System.err.println(e);
            Errors.setLastError(Errors.ErrorNum.UBIDULECONNECTIONERROR);
            return false;
        }
        BinaryOut os = new BinaryOut(sock);
        BinaryIn is = new BinaryIn(sock);
        this.sendXSVF(os);
        this.sendNbInputs(os);
        this.sendNbOutputs(os);
        this.sendNbTests(os);
        this.sendInputData(os);
        this.sendM2MStart(os);
        os.flush();
        this.receiveM2MData(is);
        this.compareOctaveFPGA();
        try {
            sock.close();
        }
        catch (IOException iOException) {}
        return true;
    }

    private void receiveM2MData(BinaryIn is) {
        LinkedList<Float> dataList = new LinkedList<Float>();
        System.out.println("Waiting for the reception of M2MData...");
        int sizeBlock = is.readInt();
        is.readInt();
        int nbData = is.readInt();
        int i = 0;
        while (i < nbData) {
            float data = is.readFloat();
            dataList.add(Float.valueOf(data));
            ++i;
        }
        int time = is.readInt();
        System.out.println("Time of treatement: " + time);
        is.readInt();
        DataOutputStream[] os = new DataOutputStream[this.m2mData.getNbOutputs()];
        try {
            int i2 = 0;
            while (i2 < this.m2mData.getNbOutputs()) {
                os[i2] = new DataOutputStream(new FileOutputStream(String.valueOf(this.project.getIOFilesPath()) + "/file_output" + (i2 + 1) + "_FPGA.dat"));
                os[i2].writeInt((sizeBlock / 4 - 1) / this.m2mData.getNbOutputs());
                os[i2].writeInt(1);
                ++i2;
            }
            i2 = 0;
            while (i2 < dataList.size()) {
                os[0].writeFloat(((Float)dataList.get(i2)).floatValue());
                ++i2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("There is a problem into M2MClient.receiveM2MData...");
        }
    }

    private boolean compareOctaveFPGA() {
        int cnt = 0;
        BinaryIn[] isFiles = new BinaryIn[this.m2mData.getNbOutputs()];
        BinaryIn[] isFilesFPGA = new BinaryIn[this.m2mData.getNbOutputs()];
        int i = 0;
        while (i < this.m2mData.getNbOutputs()) {
            isFiles[i] = new BinaryIn(String.valueOf(this.project.getIOFilesPath()) + "/file_output" + (i + 1) + ".dat");
            isFilesFPGA[i] = new BinaryIn(String.valueOf(this.project.getIOFilesPath()) + "/file_output" + (i + 1) + "_FPGA.dat");
            ++i;
        }
        System.out.println("file_output1.dat, nbsamples: " + isFiles[0].readInt());
        System.out.println("file_output1.dat, size: " + isFiles[0].readInt());
        int nbTests = isFilesFPGA[0].readInt();
        System.out.println("file_output1_FPGA.dat, nbsamples: " + nbTests);
        System.out.println("file_output1_FPGA.dat, size: " + isFilesFPGA[0].readInt());
        int currentNbOut = 0;
        while (currentNbOut < this.m2mData.getNbOutputs()) {
            int currentNbSample = 0;
            while (currentNbSample < this.m2mData.getNbTests() - 1) {
                float dataFPGA;
                float dataOctave = isFiles[currentNbOut].readFloat();
                float absVal = dataOctave - (dataFPGA = isFilesFPGA[currentNbOut].readFloat());
                if (absVal < 0.0f) {
                    absVal = -absVal;
                }
                if ((double)absVal > 0.1) {
                    System.err.println("Files nbr " + currentNbOut + " ,sample nbr " + currentNbSample + " " + dataOctave + " vs " + dataFPGA);
                    ++cnt;
                }
                ++currentNbSample;
            }
            ++currentNbOut;
        }
        System.err.println("There are " + cnt + " errors in " + this.m2mData.getNbOutputs() * this.m2mData.getNbTests() + " samples");
        return true;
    }

    private void sendNbTests(BinaryOut os) {
        System.out.println("sendNbTest...");
        os.write(3);
        os.write(4);
        os.write(this.m2mData.getNbTests());
        os.flush();
    }

    private void sendNbInputs(BinaryOut os) {
        System.out.println("sendNbInputs...");
        os.write(7);
        os.write(4);
        os.write(this.m2mData.getNbInputs());
        os.flush();
    }

    private void sendNbOutputs(BinaryOut os) {
        System.out.println("sendNbOutputs...");
        os.write(8);
        os.write(4);
        os.write(this.m2mData.getNbOutputs());
        os.flush();
    }

    private void sendInputData(BinaryOut os) {
        System.out.println("sendInputData...");
        int inputSize = this.m2mData.getNbTests() * this.m2mData.getNbInputs() * 4;
        os.write(4);
        os.write(inputSize);
        int currentTest = 0;
        while (currentTest < this.m2mData.getNbTests()) {
            int currentIn = 0;
            while (currentIn < this.m2mData.getNbInputs()) {
                float entry = this.m2mData.getInputData()[currentIn].get(currentTest).floatValue();
                os.write(entry);
                ++currentIn;
            }
            ++currentTest;
        }
        os.flush();
    }

    private void sendM2MStart(BinaryOut os) {
        System.out.println("sendM2MStart...");
        os.write(5);
        os.write(0);
        os.flush();
    }

    private void sendXSVF(BinaryOut os) {
        System.out.println("sendXSVF...");
        os.write(6);
        File myFile = new File(String.valueOf(this.isePath) + "/M2M_XSVF_generated.xsvf");
        byte[] mybytearray = new byte[(int)myFile.length()];
        System.out.println("File length: " + myFile.length());
        os.write((int)myFile.length());
        try {
            FileInputStream fis = new FileInputStream(myFile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            bis.read(mybytearray, 0, mybytearray.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Sending xsvf...");
        int i = 0;
        while (i < mybytearray.length) {
            os.write(mybytearray[i]);
            ++i;
        }
        os.flush();
    }

    public static boolean generateXSVF(M2MProject project) {
        BufferedReader brErrOctave;
        BufferedReader brOctave;
        Process process;
        String line;
        block12: {
            String isePath = String.valueOf(project.getProperties().getProjectPath()) + M2MProject.getUbiduleDirName();
            line = "";
            Errors.clearError();
            File scriptGenXSVF = new File(String.valueOf(isePath) + "/script_gen_xsvf");
            scriptGenXSVF.setExecutable(true);
            process = new ProcessBuilder(String.valueOf(isePath) + "/script_gen_xsvf").start();
            ProcessWatcher.getInstance().addProcess(process);
            brOctave = new BufferedReader(new InputStreamReader(process.getInputStream()));
            brErrOctave = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (brOctave != null && brErrOctave != null) break block12;
            return false;
        }
        try {
            while (true) {
                try {
                    while ((line = brOctave.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    continue;
                }
                break;
            }
            while (true) {
                try {
                    while ((line = brErrOctave.readLine()) != null) {
                        System.err.println(line);
                    }
                    System.out.println("XSVF generating finished...");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    continue;
                }
                break;
            }
            process.waitFor();
            System.out.println("Process exit code: " + process.exitValue() + "\n");
            if (process.exitValue() == 127) {
                Errors.setLastError(Errors.ErrorNum.ISENOTFOUND);
            }
            ProcessWatcher.getInstance().removeProcess(process);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return true;
    }

    public void generateXSVF() {
        M2MClient.generateXSVF(this.project);
    }
}

