/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.vhdl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryFloatingPoint {
    private static BinaryFloatingPoint instance = null;
    private int sizeMant = 23;
    private int sizeExp = 8;

    protected BinaryFloatingPoint() {
    }

    public static BinaryFloatingPoint getInstance() {
        if (instance == null) {
            instance = new BinaryFloatingPoint();
        }
        return instance;
    }

    private String toBinary(double value) {
        String sVal = new String();
        String hex = Double.toHexString(value);
        Pattern p = Pattern.compile("(-?)0x(1|0).(.*)p(.*)");
        Matcher m = p.matcher(hex);
        boolean b = m.matches();
        if (!b) {
            return sVal;
        }
        Boolean sign = m.group(1).equals("-");
        long mant = Long.parseLong(m.group(3), 16);
        long exp = Long.parseLong(m.group(4), 16);
        sVal = String.valueOf(sVal) + (sign != false ? "1" : "0");
        if (m.group(2).equals("1")) {
            sVal = String.valueOf(sVal) + this.createBinaryExp(exp);
            sVal = String.valueOf(sVal) + this.createBinaryMant(mant);
        } else {
            sVal = String.valueOf(sVal) + (this.sizeExp == 8 ? this.createBinaryExp(-127L) : this.createBinaryExp(-1023L));
            sVal = String.valueOf(sVal) + this.createBinaryMant(0L);
        }
        return sVal;
    }

    private double toFloat(String valueBit) {
        double val = 0.0;
        double biais = Math.pow(2.0, (double)this.sizeExp - 1.0) - 1.0;
        String sVal = new String();
        String sign = new String();
        String sExp = new String();
        String sMant = new String();
        String hexExp = new String();
        String hexMant = new String();
        try {
            sign = valueBit.substring(0, 1).equals("1") ? "-" : "";
            sExp = valueBit.substring(1, this.sizeExp + 1);
            sMant = valueBit.substring(this.sizeExp + 1, this.sizeExp + this.sizeMant + 1);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("#Not a correct format number");
            e.printStackTrace();
            return 0.0;
        }
        int i = 0;
        while (i < 4 - this.sizeMant % 4) {
            sMant = String.valueOf(sMant) + "0";
            ++i;
        }
        int exp = Integer.parseInt(sExp, 2);
        int mant = Integer.parseInt(sMant, 2);
        if (exp == 0 && mant == 0) {
            System.out.println("#Null number");
            sVal = String.valueOf(sign) + "0x0.0p0";
            val = 0.0;
        } else if (exp == 0) {
            System.out.println("#Denormalized number");
            hexMant = Integer.toHexString(mant);
            sVal = String.valueOf(sign) + "0x0." + hexMant + "p0";
            val = Double.valueOf(sVal);
        } else {
            hexExp = Integer.toHexString(exp - (int)biais);
            hexMant = Integer.toHexString(mant);
            sVal = String.valueOf(sign) + "0x1." + hexMant + "p" + hexExp;
            val = Double.valueOf(sVal);
        }
        return val;
    }

    private String createBinaryExp(long exp) {
        String sExp = new String();
        double biais = Math.pow(2.0, (double)this.sizeExp - 1.0) - 1.0;
        String convert = Long.toBinaryString(exp + (long)((int)biais));
        int length = convert.length();
        if (length < this.sizeExp) {
            int i = 0;
            while (i < this.sizeExp - length) {
                sExp = String.valueOf(sExp) + "0";
                ++i;
            }
            sExp = String.valueOf(sExp) + convert;
        } else if (length > this.sizeExp) {
            convert = convert.substring(0, this.sizeExp);
            sExp = String.valueOf(sExp) + convert;
        } else {
            sExp = convert;
        }
        return sExp;
    }

    private String createBinaryMant(long mant) {
        int length;
        String sMant = new String();
        String convertTmp = Long.toBinaryString(mant);
        String sMantTmp = Long.toHexString(mant);
        String convert = new String();
        if (convertTmp.length() < sMantTmp.length() * 4) {
            while (convertTmp.length() < sMantTmp.length() * 4) {
                convertTmp = "0" + convertTmp;
            }
        }
        if ((length = (convert = String.valueOf(convert) + convertTmp).length()) < this.sizeMant) {
            sMant = String.valueOf(sMant) + convert;
            int i = 0;
            while (i < this.sizeMant - length) {
                sMant = String.valueOf(sMant) + "0";
                ++i;
            }
        } else if (length > this.sizeMant) {
            convert = convert.substring(0, this.sizeMant);
            sMant = String.valueOf(sMant) + convert;
        } else {
            sMant = convert;
        }
        return sMant;
    }

    public String getBinary(double value) {
        return this.toBinary(value);
    }

    public double getValue(String valBit) {
        return this.toFloat(valBit);
    }

    public void setSizeMant(int size) {
        this.sizeMant = size;
    }

    public int getSizeMant() {
        return this.sizeMant;
    }

    public void setSizeExp(int size) {
        this.sizeExp = size;
    }

    public int getSizeExp() {
        return this.sizeExp;
    }
}

