/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.vhdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.project.M2MProject;
import m2m.backend.project.ProjectRef;
import m2m.backend.structure.Addition;
import m2m.backend.structure.Assignment;
import m2m.backend.structure.Comparison;
import m2m.backend.structure.Element;
import m2m.backend.structure.Equal;
import m2m.backend.structure.Function;
import m2m.backend.structure.Greater;
import m2m.backend.structure.GreaterEqual;
import m2m.backend.structure.IfThenElse;
import m2m.backend.structure.Less;
import m2m.backend.structure.LessEqual;
import m2m.backend.structure.LogicOperation;
import m2m.backend.structure.LoopFor;
import m2m.backend.structure.Multiplexer;
import m2m.backend.structure.Negation;
import m2m.backend.structure.Operation;
import m2m.backend.structure.SimpleVariable;
import m2m.backend.vhdl.BadElementException;
import m2m.backend.vhdl.BinaryFloatingPoint;
import m2m.backend.vhdl.NoNameException;
import m2m.backend.vhdl.VHDLException;

public class VHDLCreator
extends ProjectRef {
    private Function top;
    private HashMap<Function, MultiUseSignals> multUseSignal;
    private BuildingBlock.NumType numType;

    public VHDLCreator(Function top, M2MProject project) {
        this.top = top;
        this.setProject(project);
        this.multUseSignal = new HashMap();
        this.findMultiUseSignals(top);
        this.numType = project.getOptimisationProperties().getOptimisationDataType();
    }

    public VHDLCreator(Function top, M2MProject project, int significand, int exp) {
        this.top = top;
        this.setProject(project);
        this.multUseSignal = new HashMap();
        this.findMultiUseSignals(top);
        this.numType = project.getOptimisationProperties().getOptimisationDataType();
    }

    private void parse(Function f, Function parentFunction) {
        if (f instanceof LoopFor) {
            int minCost = 0;
            Vector<SimpleVariable> inputs = new Vector<SimpleVariable>();
            int i = 0;
            while (i < f.getInput().size()) {
                inputs.add((SimpleVariable)f.getInput().elementAt(i));
                ++i;
            }
            Vector<Boolean> dependFlag = new Vector<Boolean>();
            int i2 = 0;
            while (i2 < f.getInput().size()) {
                dependFlag.add(false);
                int j = 0;
                while (j < f.getInput().size()) {
                    if (j != i2) {
                        for (Element e : ((SimpleVariable)inputs.elementAt(j)).getVariableDependencies()) {
                            if (!((SimpleVariable)inputs.elementAt(i2)).getVariableDependencies().contains(e)) continue;
                            dependFlag.setElementAt(true, i2);
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            int cost = ((SimpleVariable)f.getOutput().elementAt(0)).getCost() - f.getRelativeMaxCost();
            MultiUseSignals mus = this.multUseSignal.get(parentFunction);
            int i3 = 0;
            while (i3 < inputs.size()) {
                SimpleVariable var = (SimpleVariable)inputs.elementAt(i3);
                if (mus.variables.contains(var)) {
                    var.setVarFunctionMapping(var.getVariableMap().get(parentFunction).getMapVHDLSimpleVariable(var.getCost()), f);
                    minCost = mus.getMinCost(mus.variables.indexOf(inputs.elementAt(i3)));
                } else {
                    var.setVarFunctionMapping(var, f);
                }
                int j = 0;
                while (j < inputs.size()) {
                    if (i3 != j && ((SimpleVariable)inputs.elementAt(i3)).getCost() < ((SimpleVariable)inputs.elementAt(j)).getCost() && (this.project.getProperties().getOptimisationProperties().getFifoCompensation() || parentFunction instanceof LoopFor || ((Boolean)dependFlag.elementAt(i3)).booleanValue() || mus.variables.contains(inputs.elementAt(i3)) && cost - ((SimpleVariable)inputs.elementAt(i3)).getCost() != minCost)) {
                        var.getVarFunctionMapping(f).setSimpleFifoCost(cost - ((SimpleVariable)inputs.elementAt(i3)).getCost() + 1);
                    }
                    ++j;
                }
                ++i3;
            }
        }
        for (Element e : f.getInternalVars()) {
            if (!(e instanceof SimpleVariable) || !this.multUseSignal.get(f).variables.contains((SimpleVariable)e)) continue;
            ((SimpleVariable)e).getVariableMap().put(f, (SimpleVariable)e.new SimpleVariable.MapVHDLSimpleVariable());
            this.multUseSignal.get(f).setNbrMultSimpleVariable(f, (SimpleVariable)e);
        }
        this.parse(f.getBody(), f);
    }

    private void parse(Vector<Element> elements, Function parentFunction) {
        for (Element e : elements) {
            if (e instanceof Operation) {
                this.parse((Operation)e, parentFunction);
                continue;
            }
            if (e instanceof IfThenElse) {
                this.parse((IfThenElse)e, parentFunction);
                continue;
            }
            if (!(e instanceof Function)) continue;
            this.parse((Function)e, parentFunction);
        }
    }

    private void parse(Operation op, Function parentFunction) {
        int minCost = 0;
        Vector<SimpleVariable> inputs = new Vector<SimpleVariable>();
        Vector<Boolean> dependFlag = new Vector<Boolean>();
        if (op instanceof Comparison) {
            ((SimpleVariable)op.getOutputAt(0)).setType("resultComp");
        } else if (op instanceof LogicOperation) {
            ((SimpleVariable)op.getOutputAt(0)).setType("cond");
        }
        int i = 0;
        while (i < op.getInput().size()) {
            inputs.add((SimpleVariable)op.getInputAt(i));
            ++i;
        }
        if (op instanceof Multiplexer) {
            inputs.add((SimpleVariable)((Multiplexer)op).getSel());
        }
        i = 0;
        while (i < inputs.size()) {
            dependFlag.add(false);
            int j = 0;
            while (j < inputs.size()) {
                if (j != i) {
                    for (Element e : ((SimpleVariable)inputs.elementAt(j)).getVariableDependencies()) {
                        if (!((SimpleVariable)inputs.elementAt(i)).getVariableDependencies().contains(e)) continue;
                        dependFlag.setElementAt(true, i);
                    }
                }
                ++j;
            }
            ++i;
        }
        MultiUseSignals mus = this.multUseSignal.get(parentFunction);
        if (op.getBlock() != null) {
            int cost = ((SimpleVariable)op.getOutputAt(0)).getCost() - op.getBlock().latencyTime() - 1;
            int internCost = parentFunction instanceof LoopFor && parentFunction.getOutput().contains((SimpleVariable)op.getOutputAt(0)) ? ((LoopFor)parentFunction).getRelativeMaxCost() - op.getBlock().latencyTime() - 2 : cost;
            int i2 = 0;
            while (i2 < inputs.size()) {
                int costI = parentFunction instanceof LoopFor && parentFunction.getInput().contains(inputs.elementAt(i2)) ? 0 : ((SimpleVariable)inputs.elementAt(i2)).getCost();
                costI = parentFunction instanceof LoopFor && parentFunction.getOutput().contains(inputs.elementAt(i2)) && ((SimpleVariable)inputs.elementAt(i2)).getLoopOutputCost(parentFunction) != 0 ? ((SimpleVariable)inputs.elementAt(i2)).getLoopOutputCost(parentFunction) : costI;
                SimpleVariable var = (SimpleVariable)inputs.elementAt(i2);
                if (mus.variables.contains(inputs.elementAt(i2))) {
                    var = ((SimpleVariable)inputs.elementAt(i2)).getVariableMap().get(parentFunction).getMapVHDLSimpleVariable(cost);
                    if (i2 == 2) {
                        ((Multiplexer)op).setSel(var);
                    } else {
                        op.setInputAt(op.getInput().indexOf(inputs.elementAt(i2)), var);
                    }
                    minCost = mus.getMinCost(mus.variables.indexOf(inputs.elementAt(i2)));
                }
                int j = 0;
                while (j < inputs.size()) {
                    int costJ = parentFunction instanceof LoopFor && parentFunction.getInput().contains(inputs.elementAt(j)) ? 0 : ((SimpleVariable)inputs.elementAt(j)).getCost();
                    int n = costJ = parentFunction instanceof LoopFor && parentFunction.getOutput().contains(inputs.elementAt(j)) && ((SimpleVariable)inputs.elementAt(j)).getLoopOutputCost(parentFunction) != 0 ? ((SimpleVariable)inputs.elementAt(j)).getLoopOutputCost(parentFunction) : costJ;
                    if (i2 != j && costI < costJ && (this.project.getProperties().getOptimisationProperties().getFifoCompensation() || parentFunction instanceof LoopFor || ((Boolean)dependFlag.elementAt(i2)).booleanValue() || mus.variables.contains(inputs.elementAt(i2)) && cost - costI != minCost)) {
                        var.setSimpleFifoCost(internCost - costI);
                    }
                    ++j;
                }
                ++i2;
            }
        } else if (op instanceof Assignment) {
            int cost = ((SimpleVariable)op.getOutputAt(0)).getCost();
            if (op.getInputAt(0) instanceof SimpleVariable && mus.variables.contains((SimpleVariable)op.getInputAt(0))) {
                SimpleVariable var = ((SimpleVariable)op.getInputAt(0)).getVariableMap().get(parentFunction).getMapVHDLSimpleVariable(cost);
                op.setInputAt(op.getInput().indexOf(op.getInputAt(0)), var);
            }
        }
    }

    private void parse(IfThenElse ite, Function parentFunction) {
        if (ite.getName().contains("loopfor")) {
            if (parentFunction.getBody().firstElement().equals(ite)) {
                this.parse(ite.getCond(), parentFunction);
            }
        } else {
            this.parse(ite.getCond(), parentFunction);
        }
        this.parse(ite.getBodyTrue(), parentFunction);
        this.parse(ite.getBodyFalse(), parentFunction);
    }

    private void findMultiUseSignals(Function f) {
        Vector<SimpleVariable> multSignals = new Vector<SimpleVariable>();
        Vector<Vector<Integer>> costMultSignals = new Vector<Vector<Integer>>();
        MultiUseSignals multiUseSignals = new MultiUseSignals(multSignals, costMultSignals);
        this.multUseSignal.put(f, multiUseSignals);
        Vector<Operation> operations = this.findOperations(f.getBody());
        Vector<SimpleVariable> variables = this.findVariables(operations);
        Vector<SimpleVariable> loopVariables = new Vector<SimpleVariable>();
        if (f instanceof LoopFor) {
            SimpleVariable var;
            for (Element e : f.getInput()) {
                var = (SimpleVariable)e;
                if (var.getType().equalsIgnoreCase("const") || ((LoopFor)f).isInitVariable(var)) continue;
                var.getMultiCost().add(f.getMaxCost());
                loopVariables.add(var);
            }
            var = (SimpleVariable)f.getInternalVars().elementAt(0);
            if (var.getType().equalsIgnoreCase("iter")) {
                SimpleVariable startVar = ((LoopFor)f).getStart();
                SimpleVariable incrVar = ((LoopFor)f).getIncr();
                var.getMultiCost().add(startVar.getType().equalsIgnoreCase("const") ? 0 : startVar.getCost());
                if (!startVar.getType().equalsIgnoreCase("const")) {
                    startVar.getMultiCost().add(0);
                    variables.add(startVar);
                }
                if (!incrVar.getType().equalsIgnoreCase("const")) {
                    incrVar.getMultiCost().add(0);
                    variables.add(incrVar);
                }
                loopVariables.add(var);
            }
            for (Element e : f.getBody()) {
                if (!(e instanceof IfThenElse) || !e.getName().contains("loopfor")) continue;
                var = (SimpleVariable)((IfThenElse)e).getOutput().firstElement();
                SimpleVariable varLoop = (SimpleVariable)((Assignment)((IfThenElse)e).getBodyFalse().firstElement()).getInputAt(0);
                varLoop.setInputLoopVariable(var, f);
                if (varLoop.getCost() != f.getRelativeMaxCost() - 1 && !f.getOutput().contains(varLoop)) {
                    varLoop.setLoopOutputCost(f, varLoop.getCost());
                    varLoop.setLoopOutputConnect(f, true);
                }
                var.getMultiCost().add(f.getMaxCost());
                loopVariables.add(var);
            }
            var = (SimpleVariable)((IfThenElse)f.getBody().elementAt(0)).getInternalVars().firstElement();
            if (var.getCost() != f.getMaxCost()) {
                var.setSimpleFifo(true);
                var.setSimpleFifoCost(f.getMaxCost() - var.getCost() + 1);
            }
            variables.addAll(loopVariables);
            ((LoopFor)f).setLoopVariables(loopVariables);
        }
        int i = 0;
        while (i < variables.size() - 1) {
            int j = i + 1;
            while (j < variables.size()) {
                if (variables.elementAt(i).equals(variables.elementAt(j)) && !variables.elementAt(i).getType().equalsIgnoreCase("const")) {
                    if (!multSignals.contains(variables.elementAt(i))) {
                        multSignals.add(variables.elementAt(i));
                        costMultSignals.add(new Vector());
                        costMultSignals.elementAt(multSignals.indexOf(variables.elementAt(i))).addAll(variables.elementAt(i).getMultiCost());
                    }
                    variables.remove(j--);
                }
                ++j;
            }
            variables.elementAt(i).getMultiCost().clear();
            ++i;
        }
    }

    private Vector<Element> findComponent(Vector<Element> elements) throws VHDLException {
        Vector<Element> components = new Vector<Element>();
        for (Element e : elements) {
            if (e instanceof IfThenElse) {
                components.addAll(this.findComponent(((IfThenElse)e).getBodyFalse()));
                components.addAll(this.findComponent(((IfThenElse)e).getBodyTrue()));
                components.addAll(this.findComponent(((IfThenElse)e).getCond()));
                continue;
            }
            components.add(e);
        }
        int i = 0;
        while (i < components.size() - 1) {
            int j = i + 1;
            while (j < components.size()) {
                if (components.elementAt(i) instanceof Operation && components.elementAt(j) instanceof Operation && !(components.elementAt(i) instanceof Assignment) && !(components.elementAt(j) instanceof Assignment)) {
                    Element op1 = components.elementAt(i);
                    Element op2 = components.elementAt(j);
                    BuildingBlock blockOp1 = ((Operation)op1).getBlock();
                    BuildingBlock blockOp2 = ((Operation)op2).getBlock();
                    if (blockOp1 == null || blockOp2 == null) {
                        if (blockOp1 == null && !(op1 instanceof Function)) {
                            throw new VHDLException("No material description for the operation : " + op1.getName());
                        }
                        if (blockOp2 == null && !(op2 instanceof Function)) {
                            throw new VHDLException("No material description for the operation : " + op2.getName());
                        }
                    } else if (((Operation)op1).getBlock().entityName().equalsIgnoreCase(((Operation)op2).getBlock().entityName())) {
                        components.remove(j--);
                    }
                }
                ++j;
            }
            ++i;
        }
        return components;
    }

    private Vector<Operation> findOperations(Vector<Element> elements) {
        Vector<Operation> operations = new Vector<Operation>();
        for (Element e : elements) {
            if (e instanceof Function) {
                if (e instanceof IfThenElse) {
                    operations.addAll(this.findOperations(((IfThenElse)e).getBodyFalse()));
                    operations.addAll(this.findOperations(((IfThenElse)e).getBodyTrue()));
                    operations.addAll(this.findOperations(((IfThenElse)e).getCond()));
                    continue;
                }
                if (!(e instanceof LoopFor)) continue;
                this.findMultiUseSignals((Function)e);
                for (Element var : ((LoopFor)e).getInput()) {
                    Assignment ass = new Assignment();
                    ass.addInput(var);
                    ass.addOutput(var);
                    operations.add(ass);
                }
                continue;
            }
            if (!(e instanceof Operation)) continue;
            operations.add((Operation)e);
        }
        return operations;
    }

    private Vector<SimpleVariable> findVariables(Vector<Operation> operations) {
        Vector<SimpleVariable> variables = new Vector<SimpleVariable>();
        for (Operation op : operations) {
            if (op instanceof Multiplexer && ((Multiplexer)op).getSel() instanceof SimpleVariable) {
                variables.add((SimpleVariable)((Multiplexer)op).getSel());
                ((SimpleVariable)((Multiplexer)op).getSel()).getMultiCost().add(((SimpleVariable)op.getOutputAt(0)).getCost() - op.getBlock().latencyTime() - 1);
            }
            int i = 0;
            while (i < op.getNbInput()) {
                if (!(!(op.getInputAt(i) instanceof SimpleVariable) || ((SimpleVariable)op.getInputAt(i)).getType().equals("iter") && variables.contains((SimpleVariable)op.getInputAt(i)))) {
                    variables.add((SimpleVariable)op.getInputAt(i));
                    if (op.getBlock() != null) {
                        ((SimpleVariable)op.getInputAt(i)).getMultiCost().add(((SimpleVariable)op.getOutputAt(0)).getCost() - op.getBlock().latencyTime() - 1);
                    } else if (op instanceof Assignment) {
                        ((SimpleVariable)op.getInputAt(i)).getMultiCost().add(((SimpleVariable)op.getOutputAt(0)).getCost());
                    }
                }
                ++i;
            }
        }
        return variables;
    }

    public void wrapTop(String vhdlPath) throws VHDLException {
        Element el;
        String wrapperPath = String.valueOf(vhdlPath) + "wrappers/";
        File wrapDir = new File(wrapperPath);
        wrapDir.mkdir();
        String common = new String();
        String sWrapVhdl = new String();
        String sPackVhdl = new String();
        String sGenericWrapVhdl = new String();
        String sGenericPackVhdl = new String();
        String sRecomsVhdl = new String();
        String wrapFileName = "wrapper_" + this.top.getName() + ".vhd";
        String packFileName = "wrapper_" + this.top.getName() + "_pkg.vhd";
        String genericWrapFileName = "m2m_generic_wrapper.vhd";
        String genericPackFileName = "m2m_generic_wrapper_pkg.vhd";
        File wrapFile = new File(String.valueOf(wrapperPath) + wrapFileName);
        File packFile = new File(String.valueOf(wrapperPath) + packFileName);
        File genericWrapFile = new File(String.valueOf(wrapperPath) + genericWrapFileName);
        File genericPackFile = new File(String.valueOf(wrapperPath) + genericPackFileName);
        File recomsFile = new File(String.valueOf(wrapperPath) + "wrapper_Recoms_" + this.top.getName() + ".vhd");
        String description = "";
        description = String.valueOf(description) + "-- Description: This file contains the declaration of 2 constants:\n";
        description = String.valueOf(description) + "--                - The number of inputs of the generated core.\n";
        description = String.valueOf(description) + "--                - The number of outputs of the generated core.\n";
        description = String.valueOf(description) + "--              It also defines generic types that are used by the\n";
        description = String.valueOf(description) + "--              specific wrapper.\n";
        sPackVhdl = String.valueOf(sPackVhdl) + this.createHeader(packFileName, description);
        description = "";
        description = String.valueOf(description) + "-- Description: This file contains the declaration of 2 constants:\n";
        description = String.valueOf(description) + "--                - The number of inputs of the generated core.\n";
        description = String.valueOf(description) + "--                - The number of outputs of the generated core.\n";
        description = String.valueOf(description) + "--              It also defines generic types that are used by the\n";
        description = String.valueOf(description) + "--              generic wrapper.\n";
        sGenericPackVhdl = String.valueOf(sGenericPackVhdl) + this.createHeader(genericPackFileName, description);
        common = "library ieee;\n";
        common = String.valueOf(common) + "\tuse ieee.std_logic_1164.all;\n";
        sPackVhdl = String.valueOf(sPackVhdl) + common;
        sGenericPackVhdl = String.valueOf(sGenericPackVhdl) + common;
        sPackVhdl = String.valueOf(sPackVhdl) + "package m2m_" + this.top.getName() + "_inout_definition_pkg is\n\n";
        sGenericPackVhdl = String.valueOf(sGenericPackVhdl) + "package m2m_inout_definition_pkg is\n\n";
        common = "\tconstant M2M_Nb_Inputs_c  : positive := " + this.top.getInput().size() + ";\n";
        common = String.valueOf(common) + "\tconstant M2M_Nb_Outputs_c : positive := " + this.top.getOutput().size() + ";\n";
        common = String.valueOf(common) + "\ttype M2M_Data is array(natural range <>) of std_logic_vector(" + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
        common = String.valueOf(common) + "\ttype M2M_Control is array(natural range <>) of std_logic;\n";
        common = String.valueOf(common) + "\tconstant M2M_Function_Name_c : String := \"" + this.top.getName() + "\";\n";
        sPackVhdl = String.valueOf(sPackVhdl) + common;
        sGenericPackVhdl = String.valueOf(sGenericPackVhdl) + common;
        sPackVhdl = String.valueOf(sPackVhdl) + "\nend package m2m_" + this.top.getName() + "_inout_definition_pkg;";
        sGenericPackVhdl = String.valueOf(sGenericPackVhdl) + "\nend package m2m_inout_definition_pkg;";
        description = "";
        description = String.valueOf(description) + "-- Description: This file contains a wrapper for the generated core.\n";
        description = String.valueOf(description) + "--              This wrapper can be used if better suited for a\n";
        description = String.valueOf(description) + "--              particular application.\n";
        sWrapVhdl = String.valueOf(sWrapVhdl) + this.createHeader(wrapFileName, description);
        description = "";
        description = String.valueOf(description) + "-- Description: This file contains a wrapper for the generated core.\n";
        description = String.valueOf(description) + "--              This wrapper is generic, its name being always the same.\n";
        description = String.valueOf(description) + "--              It can be used if only one instance of a Math2mat core\n";
        description = String.valueOf(description) + "--              is used in a design.\n";
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + this.createHeader(genericWrapFileName, description);
        description = "";
        description = String.valueOf(description) + "-- Description: This file contains a wrapper for the generated core.\n";
        description = String.valueOf(description) + "--              This wrapper is specific for Recoms applications,\n";
        description = String.valueOf(description) + "--              it names the clock specifically and adds a clock enable signal.\n";
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + this.createHeader(genericWrapFileName, description);
        common = "library ieee;\n";
        common = String.valueOf(common) + "\tuse ieee.std_logic_1164.all;\n";
        sWrapVhdl = String.valueOf(sWrapVhdl) + common;
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + common;
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + common;
        sWrapVhdl = String.valueOf(sWrapVhdl) + "\tuse work.m2m_" + this.top.getName() + "_inout_definition_pkg.all;\n";
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + "\tuse work.m2m_inout_definition_pkg.all;\n";
        sWrapVhdl = String.valueOf(sWrapVhdl) + "\nentity wrapper_" + this.top.getName() + " is\n";
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + "\nentity m2m_generic_wrapper is\n";
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\nentity wrapper_Recoms_" + this.top.getName() + " is\n";
        common = "\tport( Clock_i          : in std_logic;\n";
        common = String.valueOf(common) + "\t      Reset_i        : in std_logic;\n";
        common = String.valueOf(common) + "\t      Input_i        : in M2M_Data(M2M_Nb_Inputs_c-1 downto 0);\n";
        common = String.valueOf(common) + "\t      Input_Valid_i  : in M2M_Control(M2M_Nb_Inputs_c-1 downto 0);\n";
        common = String.valueOf(common) + "\t      Input_Ready_o  : out M2M_Control(M2M_Nb_Inputs_c-1 downto 0);\n";
        common = String.valueOf(common) + "\t      Result_o       : out M2M_Data(M2M_Nb_Outputs_c-1 downto 0);\n";
        common = String.valueOf(common) + "\t      Result_Valid_o : out M2M_Control(M2M_Nb_Outputs_c-1 downto 0);\n";
        common = String.valueOf(common) + "\t      Result_Ready_i : in M2M_Control(M2M_Nb_Outputs_c-1 downto 0)\n";
        common = String.valueOf(common) + "\t     );\n";
        sWrapVhdl = String.valueOf(sWrapVhdl) + common;
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + common;
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\tport( m2m_clk         : in std_logic;\n";
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t      Reset_i         : in std_logic;\n";
        int i = 0;
        while (i < this.top.getInput().size()) {
            sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t      Input" + (i + 1) + "_i        : in std_logic_vector(" + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t      Input" + (i + 1) + "_Valid_i  : in std_logic;\n";
            sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t      Input" + (i + 1) + "_Ready_o  : out std_logic;\n";
            ++i;
        }
        i = 0;
        while (i < this.top.getOutput().size()) {
            sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t      Result" + (i + 1) + "_o       : out std_logic_vector(" + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t      Result" + (i + 1) + "_Valid_o : out std_logic;\n";
            sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t      Result" + (i + 1) + "_Ready_i : in std_logic";
            sRecomsVhdl = String.valueOf(sRecomsVhdl) + (i == this.top.getOutput().size() - 1 ? ";\n" : "\n");
            ++i;
        }
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t      m2m_ce          : in std_logic\n";
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\t     );\n";
        sWrapVhdl = String.valueOf(sWrapVhdl) + "end wrapper_" + this.top.getName() + ";\n";
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + "end m2m_generic_wrapper;\n";
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + "end wrapper_Recoms_" + this.top.getName() + ";\n";
        sWrapVhdl = String.valueOf(sWrapVhdl) + "\narchitecture mapping of wrapper_" + this.top.getName() + " is\n";
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + "\narchitecture mapping of m2m_generic_wrapper is\n";
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\narchitecture mapping of wrapper_Recoms_" + this.top.getName() + " is\n";
        common = "\ncomponent " + this.top.getName() + " is\n";
        common = String.valueOf(common) + "\tport(\n";
        common = String.valueOf(common) + "\t\tClock_i:\tin std_logic;\n";
        common = String.valueOf(common) + "\t\tReset_i:\tin std_logic;\n";
        for (Element el2 : this.top.getInput()) {
            if (el2.getName().isEmpty()) {
                throw new NoNameException("input");
            }
            common = String.valueOf(common) + "\t\t" + el2.getName() + "_i :\tin " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            common = String.valueOf(common) + "\t\t" + el2.getName() + "_Valid_i : \tin std_logic;\n";
            common = String.valueOf(common) + "\t\t" + el2.getName() + "_Ready_o : \tout std_logic;\n";
        }
        i = 0;
        while (i < this.top.getOutput().size()) {
            el = this.top.getOutput().elementAt(i);
            if (el.getName().isEmpty()) {
                throw new NoNameException("output");
            }
            common = String.valueOf(common) + "\t\t" + el.getName() + "_o :\tout " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            common = String.valueOf(common) + "\t\t" + el.getName() + "_Ready_i : \tin std_logic;\n";
            common = String.valueOf(common) + "\t\t" + el.getName() + "_Valid_o : \tout std_logic";
            if (i != this.top.getOutput().size() - 1) {
                common = String.valueOf(common) + ";";
            }
            common = String.valueOf(common) + "\n";
            ++i;
        }
        common = String.valueOf(common) + "\t\t);\n\tend component;\n";
        common = String.valueOf(common) + "\nbegin\n\n";
        common = String.valueOf(common) + "top : " + this.top.getName() + "\n";
        sWrapVhdl = String.valueOf(sWrapVhdl) + common;
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + common;
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + common;
        sWrapVhdl = String.valueOf(sWrapVhdl) + "\tport map( Clock_i => Clock_i,\n";
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + "\tport map( Clock_i => Clock_i,\n";
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + "\tport map( Clock_i => m2m_clk,\n";
        common = "\t          Reset_i => Reset_i,\n";
        i = 0;
        while (i < this.top.getInput().size()) {
            el = this.top.getInput().elementAt(i);
            if (el.getName().isEmpty()) {
                throw new NoNameException("input");
            }
            common = String.valueOf(common) + "\t\t" + el.getName() + "_i => Input_i(" + i + "),\n";
            common = String.valueOf(common) + "\t\t" + el.getName() + "_Valid_i => Input_Valid_i(" + i + "),\n";
            common = String.valueOf(common) + "\t\t" + el.getName() + "_Ready_o => Input_Ready_o(" + i + "),\n";
            ++i;
        }
        i = 0;
        while (i < this.top.getOutput().size()) {
            el = this.top.getOutput().elementAt(i);
            if (el.getName().isEmpty()) {
                throw new NoNameException("output");
            }
            common = String.valueOf(common) + "\t\t" + el.getName() + "_o => Result_o(" + i + "),\n";
            common = String.valueOf(common) + "\t\t" + el.getName() + "_Valid_o => Result_Valid_o(" + i + "),\n";
            common = i == this.top.getOutput().size() - 1 ? String.valueOf(common) + "\t\t" + el.getName() + "_Ready_i => Result_Ready_i(" + i + ")\n" : String.valueOf(common) + "\t\t" + el.getName() + "_Ready_i => Result_Ready_i(" + i + "),\n";
            ++i;
        }
        sWrapVhdl = String.valueOf(sWrapVhdl) + common;
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + common;
        common = "\t          Reset_i => Reset_i,\n";
        i = 0;
        while (i < this.top.getInput().size()) {
            el = this.top.getInput().elementAt(i);
            if (el.getName().isEmpty()) {
                throw new NoNameException("input");
            }
            common = String.valueOf(common) + "\t\t" + el.getName() + " => Input" + (i + 1) + "_i,\n";
            common = String.valueOf(common) + "\t\t" + el.getName() + "_Valid => Input" + (i + 1) + "_Valid_i,\n";
            common = String.valueOf(common) + "\t\t" + el.getName() + "_Ready => Input" + (i + 1) + "_Ready_o,\n";
            ++i;
        }
        i = 0;
        while (i < this.top.getOutput().size()) {
            el = this.top.getOutput().elementAt(i);
            if (el.getName().isEmpty()) {
                throw new NoNameException("output");
            }
            common = String.valueOf(common) + "\t\t" + el.getName() + " => Result" + (i + 1) + "_o,\n";
            common = String.valueOf(common) + "\t\t" + el.getName() + "_Valid => Result" + (i + 1) + "_Valid_o,\n";
            common = i == this.top.getOutput().size() - 1 ? String.valueOf(common) + "\t\t" + el.getName() + "_Ready => Result" + (i + 1) + "_Ready_i\n" : String.valueOf(common) + "\t\t" + el.getName() + "_Ready => Result" + (i + 1) + "_Ready_i,\n";
            ++i;
        }
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + common;
        common = "\t        );\n\n";
        common = String.valueOf(common) + "end mapping;\n";
        sWrapVhdl = String.valueOf(sWrapVhdl) + common;
        sGenericWrapVhdl = String.valueOf(sGenericWrapVhdl) + common;
        sRecomsVhdl = String.valueOf(sRecomsVhdl) + common;
        try {
            FileWriter wrapFw = new FileWriter(wrapFile);
            FileWriter packFw = new FileWriter(packFile);
            FileWriter genericWrapFw = new FileWriter(genericWrapFile);
            FileWriter genericPackFw = new FileWriter(genericPackFile);
            FileWriter recomsFw = new FileWriter(recomsFile);
            wrapFw.write(sWrapVhdl);
            packFw.write(sPackVhdl);
            genericWrapFw.write(sGenericWrapVhdl);
            genericPackFw.write(sGenericPackVhdl);
            recomsFw.write(sRecomsVhdl);
            wrapFw.close();
            packFw.close();
            genericWrapFw.close();
            genericPackFw.close();
            recomsFw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String createVHDL(String fileName) throws VHDLException {
        this.parse(this.top, null);
        this.wrapComponents(this.top.getBody());
        String description = "";
        description = String.valueOf(description) + "-- Description: This file contains the top level block generated by the\n";
        description = String.valueOf(description) + "--              Math2mat tool. The architecture is composed of instantiations of\n";
        description = String.valueOf(description) + "--              the different operatores, as well as of the control logic.\n";
        String sVhdl = new String();
        sVhdl = String.valueOf(sVhdl) + this.createHeader(fileName, description);
        sVhdl = String.valueOf(sVhdl) + this.createFunctionEntity(this.top, 0);
        sVhdl = String.valueOf(sVhdl) + "\n\n";
        sVhdl = String.valueOf(sVhdl) + this.createFunctionArchitecture(this.top, 0);
        return sVhdl;
    }

    private String createHeader(String fileName, String description) {
        String sHeader = new String();
        Date curDate = new Date();
        sHeader = String.valueOf(sHeader) + "--------------------------------------------------------------------------------\n";
        sHeader = String.valueOf(sHeader) + "-- This file was automatically generated by Math2mat\n";
        sHeader = String.valueOf(sHeader) + "-- File:   " + fileName + "\n";
        sHeader = String.valueOf(sHeader) + "-- Author: Math2mat consortium\n";
        sHeader = String.valueOf(sHeader) + "-- Date:   " + curDate.toString() + "\n--\n";
        if (!description.isEmpty()) {
            sHeader = String.valueOf(sHeader) + description;
        }
        sHeader = String.valueOf(sHeader) + "--------------------------------------------------------------------------------\n";
        sHeader = String.valueOf(sHeader) + "\n";
        return sHeader;
    }

    public void wrapComponents(Vector<Element> body) throws VHDLException {
        String workFolder = this.project.getProperties().getProjectPath();
        for (Element el : body) {
            if (el instanceof IfThenElse) {
                this.wrapComponents(((IfThenElse)el).getBodyFalse());
                this.wrapComponents(((IfThenElse)el).getBodyTrue());
                this.wrapComponents(((IfThenElse)el).getCond());
                continue;
            }
            if (el instanceof LoopFor) {
                LoopFor loop = (LoopFor)el;
                String fileName = String.valueOf(workFolder) + this.project.getVHDLSubFolder() + "/loop_" + loop.getName() + ".vhd";
                File file = new File(fileName);
                try {
                    FileWriter fw = new FileWriter(file);
                    String sLoop = new String();
                    sLoop = this.createLoop(loop, 0);
                    fw.write(sLoop);
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.wrapComponents(loop.getBody());
                Vector<Element> addLoopFor = new Vector<Element>();
                addLoopFor.add(loop.getIterOperation());
                this.wrapComponents(addLoopFor);
                continue;
            }
            if (!(el instanceof Operation) || el instanceof Assignment) continue;
            Operation op = (Operation)el;
            BuildingBlock block = op.getBlock();
            if (block == null) {
                throw new VHDLException("No material description for the operation : " + op.getName());
            }
            String fileName = String.valueOf(workFolder) + this.project.getVHDLSubFolder() + "/wrapper_" + block.entityName() + ".vhd";
            File file = new File(fileName);
            try {
                FileWriter fw = new FileWriter(file);
                String sVhdl = new String();
                try {
                    sVhdl = this.createWrapper(op);
                }
                catch (NoNameException e) {
                    e.printStackTrace();
                }
                fw.write(sVhdl);
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String createWrapper(Operation op) throws NoNameException {
        String sOperator = new String();
        BuildingBlock blockOp = op.getBlock();
        sOperator = String.valueOf(sOperator) + "library ieee;\n";
        sOperator = String.valueOf(sOperator) + "use ieee.std_logic_1164.all;\n";
        if (blockOp.entityName().isEmpty()) {
            throw new NoNameException("Operator");
        }
        sOperator = String.valueOf(sOperator) + "entity wrapper_" + blockOp.entityName() + " is\n";
        sOperator = String.valueOf(sOperator) + "generic (\n";
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + "\tD_Sel_Fifo_Size : integer := 2;\n";
        }
        int i = 0;
        while (i < op.getNbInput()) {
            sOperator = String.valueOf(sOperator) + "\tD" + (i + 1) + "_Fifo_Size : integer := 2";
            sOperator = String.valueOf(sOperator) + (i == op.getNbInput() - 1 ? "\n);\n" : ";\n");
            ++i;
        }
        sOperator = String.valueOf(sOperator) + "port(\n";
        sOperator = String.valueOf(sOperator) + "\tClock_i:\tin std_logic;\n";
        sOperator = String.valueOf(sOperator) + "\tReset_i:\tin std_logic;\n";
        i = 0;
        while (i < blockOp.nbInputs()) {
            sOperator = op instanceof LogicOperation ? String.valueOf(sOperator) + this.tab(1) + "D" + (i + 1) + "_i\t: in Std_Logic;\n" : String.valueOf(sOperator) + this.tab(1) + "D" + (i + 1) + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D" + (i + 1) + "_Valid_i\t: in Std_Logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D" + (i + 1) + "_Ready_o\t: out Std_Logic;\n";
            ++i;
        }
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D_Sel_i\t: in Std_Logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D_Sel_Valid_i\t: in Std_Logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D_Sel_Ready_o\t: out Std_Logic;\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(1) + "Ready_i\t: in Std_Logic;\n";
        if (op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Smaller_o\t: out Std_Logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Bigger_o\t : out Std_Logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Equal_o\t  : out Std_Logic;\n";
        } else {
            sOperator = op instanceof LogicOperation ? String.valueOf(sOperator) + this.tab(1) + "Result_o\t: out Std_Logic;\n" : String.valueOf(sOperator) + this.tab(1) + "Result_o\t: out " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(1) + "Valid_o\t: out Std_Logic\n";
        sOperator = String.valueOf(sOperator) + ");\nend wrapper_" + blockOp.entityName() + ";\n\n";
        sOperator = String.valueOf(sOperator) + "architecture comp of wrapper_" + blockOp.entityName() + " is\n\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Stall_s : std_logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Ready_s : std_logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Valid_in_s : std_logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Op_Ready_s : std_logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Valid_s : std_logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Valid_Mem_s : std_logic;\n";
        if (op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Smaller_s : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Smaller_Mem_s : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Bigger_s : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Bigger_Mem_s : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Equal_s : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Equal_Mem_s : std_logic;\n\n";
        } else if (op instanceof LogicOperation) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Result_s : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Result_Mem_s : std_logic;\n\n";
        } else {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Result_s : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Result_Mem_s : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n\n";
        }
        i = 0;
        while (i < blockOp.nbInputs()) {
            sOperator = op instanceof LogicOperation ? String.valueOf(sOperator) + this.tab(1) + "signal D" + (i + 1) + "_s             : std_logic;\n" : String.valueOf(sOperator) + this.tab(1) + "signal D" + (i + 1) + "_s             : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal D" + (i + 1) + "_fifo_full_s   : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal D" + (i + 1) + "_fifo_empty_s  : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal D" + (i + 1) + "_Ready_s       : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal D" + (i + 1) + "_Valid_s       : std_logic;\n";
            ++i;
        }
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Sel_s            : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Sel_fifo_full_s  : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Sel_fifo_empty_s : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Sel_Ready_s      : std_logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "signal Sel_Valid_s      : std_logic;\n";
        }
        sOperator = String.valueOf(sOperator) + "\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "component " + blockOp.entityName() + " is\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "generic (\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "wValid_g : integer := 1";
        if (op instanceof Multiplexer || op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + ";\n" + this.tab(2) + "m_g : integer := 32\n";
        } else if (op instanceof Negation) {
            sOperator = String.valueOf(sOperator) + ";\n" + this.tab(2) + "data_size_g : integer := 32;\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "wE_g        : integer := 7;\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "wF_g        : integer := 24";
        }
        sOperator = String.valueOf(sOperator) + "\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + ");\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "port (\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "clk_i   : in std_logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "reset_i : in std_logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "valid_i : in std_logic_vector(wValid_g-1 downto 0);\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "stall_i : in std_logic;\n";
        i = 0;
        while (i < blockOp.nbInputs()) {
            sOperator = op instanceof LogicOperation ? String.valueOf(sOperator) + this.tab(2) + "D" + (i + 1) + "_i\t: in Std_Logic;\n" : String.valueOf(sOperator) + this.tab(2) + "D" + (i + 1) + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            ++i;
        }
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + this.tab(2) + "D_Sel_i\t: in Std_Logic;\n";
        }
        if (op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + this.tab(2) + "smaller_o : out Std_Logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "bigger_o  : out Std_Logic;\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "equal_o   : out Std_Logic;\n";
        } else {
            sOperator = op instanceof LogicOperation ? String.valueOf(sOperator) + this.tab(2) + "m_o     : out Std_Logic;\n" : String.valueOf(sOperator) + this.tab(2) + "m_o     : out " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(2) + "valid_o : out std_logic_vector(wValid_g-1 downto 0);\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "ready_o : out std_logic\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + ");\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "end component;\n\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "component fifo_Std is\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "generic (\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "FIFOSIZE  : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + ";\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "DATAWIDTH : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + "\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + ");\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "port (\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "Clock_i      : in Std_Logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "Reset_i      : in Std_Logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "Wr_Req_i     : in Std_Logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "Rd_Req_i     : in Std_Logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "Data_i       : in Std_Logic_Vector(DATAWIDTH-1 downto 0);\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "Data_o       : out Std_Logic_Vector(DATAWIDTH-1 downto 0);\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "Fifo_Full_o  : out Std_Logic;\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "Fifo_Empty_o : out Std_Logic\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + ");\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "end component;\n\n";
        sOperator = String.valueOf(sOperator) + "begin\n\n";
        i = 0;
        while (i < blockOp.nbInputs()) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Fifo_D" + (i + 1) + " : fifo_Std\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "generic map(\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "FIFOSIZE => D" + (i + 1) + "_Fifo_Size,\n";
            sOperator = op instanceof LogicOperation ? String.valueOf(sOperator) + this.tab(2) + "DATAWIDTH => 1\n" + this.tab(1) + ")\n" : String.valueOf(sOperator) + this.tab(2) + "DATAWIDTH => " + BuildingBlock.NumType.getDataSize(this.numType) + "\n" + this.tab(1) + ")\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "port map(\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Clock_i      => Clock_i,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Reset_i      => Reset_i,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Wr_Req_i     => D" + (i + 1) + "_Valid_i,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Rd_Req_i     => D" + (i + 1) + "_Ready_s,\n";
            if (op instanceof LogicOperation) {
                sOperator = String.valueOf(sOperator) + this.tab(2) + "Data_i(0)    => D" + (i + 1) + "_i,\n";
                sOperator = String.valueOf(sOperator) + this.tab(2) + "Data_o(0)    => D" + (i + 1) + "_s,\n";
            } else {
                sOperator = String.valueOf(sOperator) + this.tab(2) + "Data_i       => D" + (i + 1) + "_i,\n";
                sOperator = String.valueOf(sOperator) + this.tab(2) + "Data_o       => D" + (i + 1) + "_s,\n";
            }
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Fifo_Full_o  => D" + (i + 1) + "_fifo_full_s,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Fifo_Empty_o => D" + (i + 1) + "_fifo_empty_s\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + ");\n\n";
            ++i;
        }
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Fifo_Sel : fifo_Std\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "generic map(\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "FIFOSIZE => D_Sel_Fifo_Size,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "DATAWIDTH => 1\n" + this.tab(1) + ")\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "port map(\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Clock_i      => Clock_i,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Reset_i      => Reset_i,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Wr_Req_i     => D_Sel_Valid_i,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Rd_Req_i     => Sel_Ready_s,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Data_i(0)    => D_Sel_i,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Data_o(0)    => Sel_s,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Fifo_Full_o  => Sel_fifo_full_s,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "Fifo_Empty_o => Sel_fifo_empty_s\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + ");\n\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(1) + "Op : " + blockOp.entityName() + "\n";
        if (op instanceof Multiplexer || op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "generic map (\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "m_g => " + BuildingBlock.NumType.getDataSize(this.numType) + "\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + ")\n";
        } else if (op instanceof Negation) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "generic map (\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "data_size_g => " + BuildingBlock.NumType.getDataSize(this.numType) + ",\n";
            if (BuildingBlock.NumType.getDataSize(this.numType) == 32) {
                sOperator = String.valueOf(sOperator) + this.tab(2) + "wE_g        => 7,\n";
                sOperator = String.valueOf(sOperator) + this.tab(2) + "wF_g        => 24\n";
            } else if (BuildingBlock.NumType.getDataSize(this.numType) == 64) {
                sOperator = String.valueOf(sOperator) + this.tab(2) + "wE_g        => 10,\n";
                sOperator = String.valueOf(sOperator) + this.tab(2) + "wF_g        => 53\n";
            }
            sOperator = String.valueOf(sOperator) + this.tab(1) + ")\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(1) + "port map (\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "clk_i    => Clock_i,\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "reset_i    => Reset_i,\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "valid_i(0) => Valid_in_s,\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "stall_i    => Stall_s,\n";
        i = 0;
        while (i < blockOp.nbInputs()) {
            sOperator = String.valueOf(sOperator) + this.tab(2) + "D" + (i + 1) + "_i       => D" + (i + 1) + "_s,\n";
            ++i;
        }
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + this.tab(2) + "D_Sel_i    => Sel_s,\n";
        }
        if (op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + this.tab(2) + "smaller_o  => Smaller_s,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "bigger_o   => Bigger_s,\n";
            sOperator = String.valueOf(sOperator) + this.tab(2) + "equal_o    => Equal_s,\n";
        } else {
            sOperator = String.valueOf(sOperator) + this.tab(2) + "m_o        => Result_s,\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(2) + "valid_o(0) => Valid_s,\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "ready_o    => Op_Ready_s\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + ");\n\n";
        i = 0;
        while (i < blockOp.nbInputs()) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D" + (i + 1) + "_Ready_o <= not D" + (i + 1) + "_fifo_full_s;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D" + (i + 1) + "_Valid_s <= not D" + (i + 1) + "_fifo_empty_s;\n\n";
            ++i;
        }
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D_Sel_Ready_o <= not Sel_fifo_full_s;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Sel_Valid_s <= not Sel_fifo_empty_s;\n\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(1) + "Stall_s <= not Ready_s;\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "Valid_in_s <= ";
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + "Sel_Valid_s and ";
        }
        i = 0;
        while (i < blockOp.nbInputs()) {
            sOperator = i == 0 ? String.valueOf(sOperator) + "D" + (i + 1) + "_Valid_s" : String.valueOf(sOperator) + " and D" + (i + 1) + "_Valid_s";
            ++i;
        }
        sOperator = String.valueOf(sOperator) + " and Op_Ready_s;\n";
        i = 0;
        while (i < blockOp.nbInputs()) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "D" + (i + 1) + "_Ready_s <= not D" + (i + 1) + "_Valid_s or (";
            int j = 0;
            while (j < blockOp.nbInputs()) {
                sOperator = j == 0 ? String.valueOf(sOperator) + "(D" + (j + 1) + "_Valid_s" : String.valueOf(sOperator) + " and D" + (j + 1) + "_Valid_s";
                ++j;
            }
            if (op instanceof Multiplexer) {
                sOperator = String.valueOf(sOperator) + " and Sel_Valid_s";
            }
            sOperator = String.valueOf(sOperator) + ") and Op_Ready_s and (Ready_s or not Valid_s));\n";
            ++i;
        }
        if (op instanceof Multiplexer) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Sel_Ready_s <= not Sel_Valid_s or (";
            int j = 0;
            while (j < blockOp.nbInputs()) {
                sOperator = j == 0 ? String.valueOf(sOperator) + "(D" + (j + 1) + "_Valid_s" : String.valueOf(sOperator) + " and D" + (j + 1) + "_Valid_s";
                ++j;
            }
            sOperator = String.valueOf(sOperator) + " and Sel_Valid_s) and Op_Ready_s and (Ready_s or not Valid_s));\n";
        }
        sOperator = String.valueOf(sOperator) + "\n";
        if (op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Smaller_o <= Smaller_s when Ready_s = '1' else Smaller_Mem_s;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Bigger_o  <= Bigger_s when Ready_s = '1' else Bigger_Mem_s;\n";
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Equal_o   <= Equal_s when Ready_s = '1' else Equal_Mem_s;\n";
        } else {
            sOperator = String.valueOf(sOperator) + this.tab(1) + "Result_o <= Result_s when Ready_s = '1' else Result_Mem_s;\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(1) + "Valid_o <= Valid_s when Ready_s = '1' else Valid_Mem_s;\n";
        sOperator = String.valueOf(sOperator) + "\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "process (Clock_i, Reset_i)\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "begin\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "if (Reset_i = '1') then\n";
        if (op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + this.tab(3) + "Smaller_Mem_s <= '0';\n";
            sOperator = String.valueOf(sOperator) + this.tab(3) + "Bigger_Mem_s  <= '0';\n";
            sOperator = String.valueOf(sOperator) + this.tab(3) + "Equal_Mem_s   <= '0';\n";
        } else {
            sOperator = op instanceof LogicOperation ? String.valueOf(sOperator) + this.tab(3) + "Result_Mem_s <= '0';\n" : String.valueOf(sOperator) + this.tab(3) + "Result_Mem_s <= (others => '0');\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(3) + "Valid_Mem_s <= '0';\n";
        sOperator = String.valueOf(sOperator) + this.tab(3) + "Ready_s <= '1';\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "elsif Rising_Edge(Clock_i) then\n";
        sOperator = String.valueOf(sOperator) + this.tab(3) + "if (Ready_s = '1') then\n";
        if (op instanceof Comparison) {
            sOperator = String.valueOf(sOperator) + this.tab(4) + "Smaller_Mem_s <= Smaller_s;\n";
            sOperator = String.valueOf(sOperator) + this.tab(4) + "Bigger_Mem_s  <= Bigger_s;\n";
            sOperator = String.valueOf(sOperator) + this.tab(4) + "Equal_Mem_s   <= Equal_s;\n";
        } else {
            sOperator = String.valueOf(sOperator) + this.tab(4) + "Result_Mem_s <= Result_s;\n";
        }
        sOperator = String.valueOf(sOperator) + this.tab(4) + "Valid_Mem_s <= Valid_s;\n";
        sOperator = String.valueOf(sOperator) + this.tab(3) + "end if;\n";
        sOperator = String.valueOf(sOperator) + this.tab(3) + "Ready_s <= Ready_i;\n";
        sOperator = String.valueOf(sOperator) + this.tab(2) + "end if;\n";
        sOperator = String.valueOf(sOperator) + this.tab(1) + "end process;\n\n";
        sOperator = String.valueOf(sOperator) + "end comp;";
        return sOperator;
    }

    private String createFunctionEntity(Function f, int level) throws VHDLException {
        String sEntity = new String();
        sEntity = String.valueOf(sEntity) + this.tab(level) + "library ieee;\n";
        sEntity = String.valueOf(sEntity) + this.tab(level) + "use ieee.std_logic_1164.all;\n";
        sEntity = String.valueOf(sEntity) + this.tab(level) + "use ieee.std_logic_arith.all;\n";
        sEntity = String.valueOf(sEntity) + this.tab(level) + "use ieee.std_logic_unsigned.all;\n";
        sEntity = String.valueOf(sEntity) + this.tab(level) + "use work.pkg_cell.all;\n";
        if (f.getName().isEmpty()) {
            throw new NoNameException("top function");
        }
        sEntity = String.valueOf(sEntity) + this.tab(level) + "entity " + f.getName() + " is\n";
        sEntity = String.valueOf(sEntity) + this.tab(level) + "port(\n";
        sEntity = String.valueOf(sEntity) + this.tab(level) + "\tClock_i:\tin std_logic;\n";
        sEntity = String.valueOf(sEntity) + this.tab(level) + "\tReset_i:\tin std_logic;\n";
        for (Element el : f.getInput()) {
            if (el.getName().isEmpty()) {
                throw new NoNameException("input");
            }
            sEntity = String.valueOf(sEntity) + this.tab(level + 1) + el.getName() + "_i :\tin " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sEntity = String.valueOf(sEntity) + this.tab(level + 1) + el.getName() + "_Valid_i : \tin std_logic;\n";
            sEntity = String.valueOf(sEntity) + this.tab(level + 1) + el.getName() + "_Ready_o : \tout std_logic;\n";
        }
        int i = 0;
        while (i < f.getOutput().size()) {
            Element el = f.getOutput().elementAt(i);
            if (el.getName().isEmpty()) {
                throw new NoNameException("output");
            }
            sEntity = String.valueOf(sEntity) + this.tab(level + 1) + el.getName() + "_o :\tout " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sEntity = String.valueOf(sEntity) + this.tab(level + 1) + el.getName() + "_Ready_i : \tin std_logic;\n";
            sEntity = String.valueOf(sEntity) + this.tab(level + 1) + el.getName() + "_Valid_o : \tout std_logic";
            if (i != f.getOutput().size() - 1) {
                sEntity = String.valueOf(sEntity) + ";";
            }
            sEntity = String.valueOf(sEntity) + "\n";
            ++i;
        }
        sEntity = String.valueOf(sEntity) + this.tab(level + 1) + ");\n" + this.tab(level) + "end " + f.getName() + ";";
        return sEntity;
    }

    private String createLoopForEntity(LoopFor loop, int level) throws VHDLException {
        String sLoopForEntity = new String();
        sLoopForEntity = String.valueOf(sLoopForEntity) + "library ieee;\n";
        sLoopForEntity = String.valueOf(sLoopForEntity) + "\tuse ieee.std_logic_1164.all;\n";
        sLoopForEntity = String.valueOf(sLoopForEntity) + "\tuse work.log_pkg.all;\n";
        sLoopForEntity = String.valueOf(sLoopForEntity) + "\n" + this.tab(level) + "entity loop_" + loop.getName() + " is\n";
        sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level) + "port (\n";
        sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + "Clock_i\t: in Std_Logic;\n";
        sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + "Reset_i\t: in Std_Logic;\n";
        int i = 0;
        while (i < loop.getInput().size()) {
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getInput().elementAt(i).getName() + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getInput().elementAt(i).getName() + "_Valid_i\t: in Std_Logic;\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getInput().elementAt(i).getName() + "_Ready_o\t: out Std_Logic;\n";
            ++i;
        }
        if (!loop.getStart().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getStart())) {
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getStart().getName() + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getStart().getName() + "_Valid_i\t: in Std_Logic;\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getStart().getName() + "_Ready_o\t: out Std_Logic;\n";
        }
        if (!loop.getIncr().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getIncr())) {
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getIncr().getName() + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getIncr().getName() + "_Valid_i\t: in Std_Logic;\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getIncr().getName() + "_Ready_o\t: out Std_Logic;\n";
        }
        if (!loop.getEnd().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getEnd())) {
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getEnd().getName() + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getEnd().getName() + "_Valid_i\t: in Std_Logic;\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getEnd().getName() + "_Ready_o\t: out Std_Logic;\n";
        }
        i = 0;
        while (i < loop.getOutput().size()) {
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getOutput().elementAt(i).getName() + "_o\t: out " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getOutput().elementAt(i).getName() + "_Valid_o\t: out Std_Logic;\n";
            sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level + 1) + loop.getOutput().elementAt(i).getName() + "_Ready_i\t: in Std_Logic";
            sLoopForEntity = String.valueOf(sLoopForEntity) + (i == loop.getOutput().size() - 1 ? "\n" : ";\n");
            ++i;
        }
        sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level) + ");\n";
        sLoopForEntity = String.valueOf(sLoopForEntity) + this.tab(level) + "end loop_" + loop.getName() + ";\n\n";
        return sLoopForEntity;
    }

    private String createFunctionArchitecture(Function f, int level) throws VHDLException {
        String sArchitecture = new String();
        sArchitecture = String.valueOf(sArchitecture) + this.tab(level) + "architecture comp of " + f.getName() + " is\n";
        sArchitecture = String.valueOf(sArchitecture) + "\n" + this.createComponent(f, level + 1);
        sArchitecture = String.valueOf(sArchitecture) + "\n" + this.createInternals(f, level + 1);
        sArchitecture = String.valueOf(sArchitecture) + "\n" + this.tab(level) + "begin\n";
        sArchitecture = String.valueOf(sArchitecture) + this.createBody(level + 1, f.getBody(), f);
        sArchitecture = String.valueOf(sArchitecture) + "\n" + this.tab(level) + "end comp;";
        return sArchitecture;
    }

    private String createLoopForComponent(LoopFor loop, int level) throws VHDLException {
        String sLoopForComponent = new String();
        String fifoType = this.project.getOptimisationProperties().getFifoType();
        sLoopForComponent = fifoType.equalsIgnoreCase("Altera") ? String.valueOf(sLoopForComponent) + this.tab(level) + "component fifo_altera is\n" : (fifoType.equalsIgnoreCase("Xilinx") ? String.valueOf(sLoopForComponent) + this.tab(level) + "component fifo_Xilinx is\n" : String.valueOf(sLoopForComponent) + this.tab(level) + "component fifo_Std is\n");
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "generic (\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "FIFOSIZE  : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + ";\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "DATAWIDTH : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + "\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "port (\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "Clock_i      : in Std_Logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "Reset_i      : in Std_Logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "Wr_Req_i     : in Std_Logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "Rd_Req_i     : in Std_Logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "Data_i       : in Std_Logic_Vector(DATAWIDTH-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "Data_o       : out Std_Logic_Vector(DATAWIDTH-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "Fifo_Full_o  : out Std_Logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level + 1) + "Fifo_Empty_o : out Std_Logic\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "end component;\n\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "component Init_Input is\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "generic(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Size_g : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "port(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tClock_i             : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReset_i           : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_i            : in  std_logic_vector(data_Size_g-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Valid_i      : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Ready_o      : out std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Loop_i       : in  std_logic_vector(data_Size_g-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Loop_Valid_i : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Loop_Ready_o : out std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tCond_Loop_i       : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_o            : out std_logic_vector(Data_Size_g-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Valid_o      : out std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Ready_i      : in  std_logic\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "end component;\n\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "component Counter_Wr is\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "generic(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Size_g : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + ";\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tMem_Size_g  : integer := 1024);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "port(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tClock_i      : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReset_i      : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_i       : in  std_logic_vector(ilogup(Mem_Size_g)-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Valid_i : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReady_i      : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tCond_i       : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tRead_i       : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tAdr_Rd_i     : in  std_logic_vector(ilogup(Mem_Size_g)-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tFifo_Ready_i : in  std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_o       : out std_logic_vector(ilogup(Mem_Size_g)-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Valid_o : out std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReady_o     : out std_logic\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "end component;\n\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "component Memory is\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "generic(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Width_g : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + ";\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tMem_Size_g   : integer := 128);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "port(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tClock_i      : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReset_i      : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tWr_i         : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tRd_i         : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tAdr_Wr_i     : in std_logic_vector(ilogup(Mem_Size_g)-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tAdr_Rd_i     : in std_logic_vector(ilogup(Mem_Size_g)-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tAdr_Valid_i  : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_i       : in std_logic_vector(Data_Width_g-1 downto 0);\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Valid_o : out std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_o       : out std_logic_vector(Data_Width_g-1 downto 0)\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "end component;\n\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "component Counter_Rd is\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "generic(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tSize_g : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "port(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tClock_i   : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReset_i : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tEn_i    : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReady_i : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tCount_o : out std_logic_vector(ilogup(Size_g)-1 downto 0)\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "end component;\n\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "component Read_Result is\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "generic(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_Width_g : integer := " + BuildingBlock.NumType.getDataSize(this.numType) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "port(\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tClock_i   : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReset_i : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_i  : in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tValid_i : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReady_i : in std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tData_o  : out " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tValid_o : out std_logic;\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "\tReady_o : out std_logic\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + ");\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.tab(level) + "end component;\n\n";
        sLoopForComponent = String.valueOf(sLoopForComponent) + this.createComponent(loop, level);
        return sLoopForComponent;
    }

    private String createComponent(Function f, int level) throws VHDLException {
        String sComponent = new String();
        Vector body = (Vector)f.getBody().clone();
        if (f instanceof LoopFor) {
            body.add(((LoopFor)f).getIterOperation());
        }
        Vector<Element> components = this.findComponent(body);
        for (Element el : components) {
            if (el instanceof Operation && !(el instanceof Assignment)) {
                Operation op = (Operation)el;
                BuildingBlock blockOp = op.getBlock();
                if (blockOp == null) {
                    throw new VHDLException("No material description for the operation : " + op.getName());
                }
                sComponent = String.valueOf(sComponent) + this.tab(level) + "component wrapper_" + blockOp.entityName() + " is\n";
                sComponent = String.valueOf(sComponent) + this.tab(level) + "generic (\n";
                if (op instanceof Multiplexer) {
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "D_Sel_Fifo_Size : integer := 2;\n";
                }
                int i = 0;
                while (i < op.getNbInput()) {
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "D" + (i + 1) + "_Fifo_Size : integer := 2";
                    sComponent = String.valueOf(sComponent) + (i == op.getNbInput() - 1 ? "\n" + this.tab(level) + ");\n" : ";\n");
                    ++i;
                }
                sComponent = String.valueOf(sComponent) + this.tab(level) + "port (\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Clock_i    : in Std_Logic;\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Reset_i    : in Std_Logic;\n";
                i = 0;
                while (i < blockOp.nbInputs()) {
                    sComponent = op instanceof LogicOperation ? String.valueOf(sComponent) + this.tab(level + 1) + "D" + (i + 1) + "_i       : in Std_Logic;\n" : String.valueOf(sComponent) + this.tab(level + 1) + "D" + (i + 1) + "_i       : in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "D" + (i + 1) + "_Valid_i : in Std_Logic;\n";
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "D" + (i + 1) + "_Ready_o : out Std_Logic;\n";
                    ++i;
                }
                if (op instanceof Multiplexer) {
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "D_Sel_i       : in Std_Logic;\n";
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "D_Sel_Valid_i : in Std_Logic;\n";
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "D_Sel_Ready_o : out Std_Logic;\n";
                }
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Ready_i    : in Std_Logic;\n";
                if (op instanceof Comparison) {
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Smaller_o  : out Std_Logic;\n";
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Bigger_o   : out Std_Logic;\n";
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Equal_o    : out Std_Logic;\n";
                } else {
                    sComponent = op instanceof LogicOperation ? String.valueOf(sComponent) + this.tab(level + 1) + "Result_o   : out Std_Logic;\n" : String.valueOf(sComponent) + this.tab(level + 1) + "Result_o   : out " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                }
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Valid_o    : out Std_Logic\n";
                sComponent = String.valueOf(sComponent) + this.tab(level) + ");\n";
                sComponent = String.valueOf(sComponent) + this.tab(level) + "end component;\n\n";
                continue;
            }
            if (!(el instanceof LoopFor)) continue;
            LoopFor loop = (LoopFor)el;
            sComponent = String.valueOf(sComponent) + this.tab(level) + "component loop_" + loop.getName() + " is\n";
            sComponent = String.valueOf(sComponent) + this.tab(level) + "port (\n";
            sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Clock_i\t: in Std_Logic;\n";
            sComponent = String.valueOf(sComponent) + this.tab(level + 1) + "Reset_i\t: in Std_Logic;\n";
            int i = 0;
            while (i < loop.getInput().size()) {
                if (loop.getInput().elementAt(i) instanceof SimpleVariable) {
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getInput().elementAt(i).getName() + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getInput().elementAt(i).getName() + "_Valid_i\t: in Std_Logic;\n";
                    sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getInput().elementAt(i).getName() + "_Ready_o\t: out Std_Logic;\n";
                }
                ++i;
            }
            if (!loop.getStart().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getStart())) {
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getStart().getName() + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getStart().getName() + "_Valid_i\t: in Std_Logic;\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getStart().getName() + "_Ready_o\t: out Std_Logic;\n";
            }
            if (!loop.getIncr().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getIncr())) {
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getIncr().getName() + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getIncr().getName() + "_Valid_i\t: in Std_Logic;\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getIncr().getName() + "_Ready_o\t: out Std_Logic;\n";
            }
            if (!loop.getEnd().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getEnd())) {
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getEnd().getName() + "_i\t: in " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getEnd().getName() + "_Valid_i\t: in Std_Logic;\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getEnd().getName() + "_Ready_o\t: out Std_Logic;\n";
            }
            i = 0;
            while (i < loop.getOutput().size()) {
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getOutput().elementAt(i).getName() + "_o\t: out " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getOutput().elementAt(i).getName() + "_Valid_o\t: out Std_Logic;\n";
                sComponent = String.valueOf(sComponent) + this.tab(level + 1) + loop.getOutput().elementAt(i).getName() + "_Ready_i\t: in Std_Logic";
                sComponent = String.valueOf(sComponent) + (i == loop.getOutput().size() - 1 ? "\n" : ";\n");
                ++i;
            }
            sComponent = String.valueOf(sComponent) + this.tab(level) + ");\n";
            sComponent = String.valueOf(sComponent) + this.tab(level) + "end component;\n\n";
        }
        return sComponent;
    }

    private String createInternals(Function f, int level) throws VHDLException {
        String sInternals = new String();
        for (Element var : f.getInternalVars()) {
            if (var instanceof SimpleVariable) {
                if (var.getName().isEmpty()) {
                    throw new NoNameException("Internals");
                }
                if (((SimpleVariable)var).getType().equalsIgnoreCase("const")) continue;
                sInternals = String.valueOf(sInternals) + "\n" + this.tab(level) + "signal " + var.getName() + "_s            : ";
                if (((SimpleVariable)var).getType().equalsIgnoreCase("cond")) {
                    sInternals = String.valueOf(sInternals) + "std_logic;\n";
                } else if (((SimpleVariable)var).getType().equalsIgnoreCase("resultComp")) {
                    sInternals = String.valueOf(sInternals) + "std_logic;\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_smaller_s    : std_logic;\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_bigger_s     : std_logic;\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_equal_s      : std_logic;\n";
                } else {
                    sInternals = String.valueOf(sInternals) + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                }
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Valid_s      : std_logic;\n";
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Ready_s      : std_logic := '1';\n";
                if (((SimpleVariable)var).getSimpleFifo() || ((SimpleVariable)var).getLoopOutputCost(f) != 0 && ((SimpleVariable)var).getLoopOutputConnect(f)) {
                    sInternals = String.valueOf(sInternals) + this.createFifoSignals((SimpleVariable)var, level);
                }
                if (f instanceof LoopFor && ((LoopFor)f).getLoopVariables().contains(var)) {
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Init_s       : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Init_Ready_s : std_logic;\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Init_Valid_s : std_logic;\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Loop_s       : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Loop_Ready_s : std_logic;\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Loop_Valid_s : std_logic;\n";
                    if (((SimpleVariable)var).getType().equalsIgnoreCase("iter")) {
                        sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Add_s        : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                        sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Add_Ready_s  : std_logic;\n";
                        sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + var.getName() + "_Add_Valid_s  : std_logic;\n";
                        if (f.getMaxCost() > ((SimpleVariable)((LoopFor)f).getIterOperation().getOutputAt(0)).getCost()) {
                            sInternals = String.valueOf(sInternals) + this.createFifoSignals((SimpleVariable)((LoopFor)f).getIterOperation().getOutputAt(0), level);
                        }
                    }
                }
                if (((SimpleVariable)var).getVariableMap().get(f) == null) continue;
                for (SimpleVariable sv : ((SimpleVariable)var).getVariableMap().get(f).getMultSimpleVar()) {
                    if (!this.multUseSignal.get(f).variables.contains(var)) continue;
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + sv.getName() + "_s       : ";
                    sInternals = ((SimpleVariable)var).getType().equalsIgnoreCase("cond") || ((SimpleVariable)var).getType().equalsIgnoreCase("resultComp") ? String.valueOf(sInternals) + "std_logic;\n" : String.valueOf(sInternals) + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + sv.getName() + "_Ready_s : std_logic;\n";
                    sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + sv.getName() + "_Valid_s : std_logic;\n";
                    if (!sv.getSimpleFifo() && (sv.getLoopOutputCost(f) == 0 || !sv.getLoopOutputConnect(f))) continue;
                    sInternals = String.valueOf(sInternals) + this.createFifoSignals(sv, level);
                }
                continue;
            }
            throw new BadElementException(var.getName(), "Variable", var.getClass().getName());
        }
        if (f instanceof LoopFor) {
            for (SimpleVariable sv : ((LoopFor)f).getLoopVariables()) {
                Element var;
                if (sv.getType().equalsIgnoreCase("iter")) continue;
                var = ((LoopFor)f).getInitVariable(sv);
                if (var == null) {
                    var = sv;
                }
                sInternals = String.valueOf(sInternals) + "\n" + this.tab(level) + "signal D_" + var.getName() + "_s            : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal D_" + var.getName() + "_fifo_full_s  : std_logic;\n";
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal D_" + var.getName() + "_fifo_empty_s : std_logic;\n";
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal D_" + var.getName() + "_Ready_s      : std_logic;\n";
            }
            sInternals = String.valueOf(sInternals) + "\n" + this.tab(level) + "signal Data_Valid_s        : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Data_Ready_s        : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Data_Init_Valid_s   : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Data_Loop_Valid_s   : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Cond_Loop_s         : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Fifo_Ready_s        : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal n_Fifo_Ready_s        : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Counter_Ready_s     : std_logic;\n\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Ready_s      : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Valid_s      : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Write_s      : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Read_s       : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Write_s  : std_logic_vector(ilogup(" + f.getRelativeMaxCost() + ")-1 downto 0);\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Read_s   : std_logic_vector(ilogup(" + f.getRelativeMaxCost() + ")-1 downto 0);\n\n";
            for (Element e : f.getOutput()) {
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_" + e.getName() + "_Ready_s     : std_logic;\n";
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_" + e.getName() + "_Valid_s     : std_logic;\n";
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_" + e.getName() + "_s           : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
                sInternals = String.valueOf(sInternals) + this.tab(level) + "signal " + e.getName() + "_Delayed_s               : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n\n";
            }
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Adr_Wr_s              : std_logic_vector(ilogup(" + f.getRelativeMaxCost() + ") -1 downto 0);\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Adr_Wr_Valid_s        : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Adr_Wr_Ready_s        : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Adr_Wr_fifo_s         : std_logic_vector(ilogup(" + f.getRelativeMaxCost() + ") -1 downto 0);\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Adr_Wr_fifo_full_s    : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Adr_Wr_fifo_empty_s   : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Adr_Wr_fifo_write_s   : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Adr_Wr_fifo_read_s    : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal n_Adr_Wr_fifo_empty_s : std_logic;\n\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Wr_Valid_s              : std_logic_vector(0 downto 0);\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Wr_Valid_Valid_s        : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Wr_Valid_Ready_s        : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Wr_Valid_fifo_s         : std_logic_vector(0 downto 0);\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Wr_Valid_fifo_full_s    : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Wr_Valid_fifo_empty_s   : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Wr_Valid_fifo_write_s   : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal Loop_Memory_Adr_Wr_Valid_fifo_read_s    : std_logic;\n";
            sInternals = String.valueOf(sInternals) + this.tab(level) + "signal n_Loop_Memory_Adr_Wr_Valid_fifo_empty_s : std_logic;\n\n";
        }
        return sInternals;
    }

    private String createFifoSignals(SimpleVariable sv, int level) {
        String sFifoSignals = new String();
        String type = sv.getType();
        sFifoSignals = type.equalsIgnoreCase("cond") || type.equalsIgnoreCase("resultComp") ? String.valueOf(sFifoSignals) + this.tab(level) + "signal " + sv.getName() + "_fifo_s         : std_logic;\n" : String.valueOf(sFifoSignals) + this.tab(level) + "signal " + sv.getName() + "_fifo_s         : " + BuildingBlock.NumType.getVHDLType(this.numType) + ";\n";
        sFifoSignals = String.valueOf(sFifoSignals) + this.tab(level) + "signal " + sv.getName() + "_fifo_read_s    : std_logic;\n";
        sFifoSignals = String.valueOf(sFifoSignals) + this.tab(level) + "signal " + sv.getName() + "_fifo_write_s   : std_logic;\n";
        sFifoSignals = String.valueOf(sFifoSignals) + this.tab(level) + "signal " + sv.getName() + "_fifo_empty_s   : std_logic;\n";
        sFifoSignals = String.valueOf(sFifoSignals) + this.tab(level) + "signal " + sv.getName() + "_fifo_full_s    : std_logic;\n";
        sFifoSignals = String.valueOf(sFifoSignals) + this.tab(level) + "signal n_" + sv.getName() + "_fifo_empty_s : std_logic;\n";
        return sFifoSignals;
    }

    private String createBody(int level, Vector<Element> body, Function parentFunction) throws VHDLException {
        String sBody = new String();
        for (Element el : body) {
            if (el instanceof Assignment) {
                sBody = String.valueOf(sBody) + this.createAssignment((Assignment)el, level, parentFunction);
                continue;
            }
            if (el instanceof Operation) {
                sBody = String.valueOf(sBody) + this.createOp((Operation)el, level, parentFunction);
                continue;
            }
            if (el instanceof LoopFor) {
                sBody = String.valueOf(sBody) + this.createFunction((LoopFor)el, level, parentFunction);
                continue;
            }
            if (!(el instanceof IfThenElse) || el.getName().contains("loopfor")) continue;
            sBody = String.valueOf(sBody) + this.createBody(level, ((IfThenElse)el).getBodyFalse(), parentFunction);
            sBody = String.valueOf(sBody) + this.createBody(level, ((IfThenElse)el).getBodyTrue(), parentFunction);
            sBody = String.valueOf(sBody) + this.createBody(level, ((IfThenElse)el).getCond(), parentFunction);
        }
        return sBody;
    }

    private String createFunction(Function el, int level, Function parentFunction) throws VHDLException {
        String sFunc = new String();
        if (el instanceof LoopFor) {
            SimpleVariable var;
            LoopFor loop = (LoopFor)el;
            sFunc = String.valueOf(sFunc) + "\n" + this.tab(level) + loop.getName() + "_inst : loop_" + loop.getName() + "\n";
            sFunc = String.valueOf(sFunc) + this.tab(level) + "port map(\n";
            sFunc = String.valueOf(sFunc) + this.tab(level + 1) + "Clock_i\t=> Clock_i,\n";
            sFunc = String.valueOf(sFunc) + this.tab(level + 1) + "Reset_i\t=> Reset_i,\n";
            int i = 0;
            while (i < loop.getInput().size()) {
                if (!(loop.getInput().elementAt(i) instanceof SimpleVariable)) {
                    throw new VHDLException("Loop for inputs must be variables.");
                }
                var = (SimpleVariable)loop.getInput().elementAt(i);
                if (var.getType().equalsIgnoreCase("const")) {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + this.createValues(var.getValues()) + "," + "--=" + var.getValues() + "\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> '1',\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> open,\n";
                } else if (var.getVarFunctionMapping(el) != null) {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + var.getVarFunctionMapping(el).getName() + "_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> " + var.getVarFunctionMapping(el).getName() + "_Valid_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> " + var.getVarFunctionMapping(el).getName() + "_Ready_s,\n";
                } else {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + var.getName() + "_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> " + var.getName() + "_Valid_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> " + var.getName() + "_Ready_s,\n";
                }
                ++i;
            }
            if (!loop.getStart().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getStart())) {
                var = loop.getStart();
                if (el instanceof LoopFor) {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + var.getVarFunctionMapping(el).getName() + "_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> " + var.getVarFunctionMapping(el).getName() + "_Valid_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> " + var.getVarFunctionMapping(el).getName() + "_Ready_s,\n";
                } else {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + var.getName() + "_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> " + var.getName() + "_Valid_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> " + var.getName() + "_Ready_s,\n";
                }
            }
            if (!loop.getIncr().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getIncr())) {
                var = loop.getIncr();
                if (el instanceof LoopFor) {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + var.getVarFunctionMapping(el).getName() + "_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> " + var.getVarFunctionMapping(el).getName() + "_Valid_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> " + var.getVarFunctionMapping(el).getName() + "_Ready_s,\n";
                } else {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + var.getName() + "_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> " + var.getName() + "_Valid_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> " + var.getName() + "_Ready_s,\n";
                }
            }
            if (!loop.getEnd().getType().equalsIgnoreCase("const") && !loop.getInput().contains(loop.getEnd())) {
                var = loop.getEnd();
                if (el instanceof LoopFor) {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + var.getVarFunctionMapping(el).getName() + "_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> " + var.getVarFunctionMapping(el).getName() + "_Valid_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> " + var.getVarFunctionMapping(el).getName() + "_Ready_s,\n";
                } else {
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_i\t => " + var.getName() + "_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Valid_i\t=> " + var.getName() + "_Valid_s,\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level + 1) + var.getName() + "_Ready_o\t=> " + var.getName() + "_Ready_s,\n";
                }
            }
            i = 0;
            while (i < loop.getOutput().size()) {
                if (!(loop.getOutput().elementAt(i) instanceof SimpleVariable)) {
                    throw new VHDLException("Loop for inputs must be variables.");
                }
                var = (SimpleVariable)loop.getOutput().elementAt(i);
                sFunc = String.valueOf(sFunc) + this.tab(level + 1) + this.createVar(var, "_o") + "\t=> " + this.createVar(var, "_s,") + "\n";
                sFunc = String.valueOf(sFunc) + this.tab(level + 1) + this.createVar(var, "_Valid_o") + "\t=> " + this.createVar(var, "_Valid_s,") + "\n";
                sFunc = String.valueOf(sFunc) + this.tab(level + 1) + this.createVar(var, "_Ready_i") + "\t=> " + this.createVar(var, "_Ready_s");
                sFunc = String.valueOf(sFunc) + (i == loop.getOutput().size() - 1 ? "\n" : ",\n");
                ++i;
            }
            sFunc = String.valueOf(sFunc) + this.tab(level) + ");\n";
            int i2 = 0;
            while (i2 < loop.getOutput().size()) {
                SimpleVariable varOutput = (SimpleVariable)loop.getOutput().elementAt(i2);
                if (!(varOutput instanceof SimpleVariable)) {
                    throw new VHDLException("Loop for inputs must be variables.");
                }
                if (this.multUseSignal.get(parentFunction).variables.contains(varOutput)) {
                    sFunc = String.valueOf(sFunc) + "\n" + this.createTemporaryAssignment(parentFunction, (SimpleVariable)loop.getOutput().elementAt(i2), level);
                } else if (varOutput.getInputLoopVariable(parentFunction) != null) {
                    sFunc = String.valueOf(sFunc) + this.tab(level) + varOutput.getName() + "_Ready_s <= " + varOutput.getInputLoopVariable(parentFunction).getName() + "_Loop_Ready_s;\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level) + varOutput.getInputLoopVariable(parentFunction).getName() + "_Loop_s <= " + varOutput.getName() + "_s;\n";
                    sFunc = String.valueOf(sFunc) + this.tab(level) + varOutput.getInputLoopVariable(parentFunction).getName() + "_Loop_Valid_s <= " + varOutput.getName() + "_Valid_s;\n";
                }
                ++i2;
            }
        }
        return sFunc;
    }

    private String createLoop(LoopFor loop, int level) throws VHDLException {
        String sLoopFor = new String();
        sLoopFor = String.valueOf(sLoopFor) + this.createLoopForEntity(loop, level);
        sLoopFor = String.valueOf(sLoopFor) + "architecture comp of loop_" + loop.getName() + " is\n\n";
        sLoopFor = String.valueOf(sLoopFor) + this.createLoopForComponent(loop, level + 1);
        sLoopFor = String.valueOf(sLoopFor) + this.createInternals(loop, level + 1);
        sLoopFor = String.valueOf(sLoopFor) + "begin\n\n";
        for (SimpleVariable var : loop.getLoopVariables()) {
            if (var.getType().equalsIgnoreCase("iter")) {
                if (!loop.getStart().getType().equalsIgnoreCase("const")) {
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Init_s <= D_" + loop.getStart().getName() + "_s;\n";
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Init_Valid_s <= not D_" + loop.getStart().getName() + "_fifo_empty_s;\n";
                } else {
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Init_s <= " + this.createValues(loop.getStart().getValues()) + ";\n";
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Init_Valid_s <= '1';\n";
                }
            } else {
                SimpleVariable initVar = loop.getInitVariable(var);
                if (initVar != null) {
                    String name = initVar.getName();
                    Iterator<SimpleVariable> sv = initVar.getVarFunctionMapping(loop);
                    int cost = ((SimpleVariable)((Object)sv)).getSimpleFifoCost(this.project);
                    sLoopFor = String.valueOf(sLoopFor) + this.createFifoInitLoopVariable(cost, name, level);
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + initVar.getName() + "_Ready_o <= not D_" + initVar.getName() + "_fifo_full_s;\n";
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Init_s <= D_" + initVar.getName() + "_s;\n";
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "D_" + initVar.getName() + "_Ready_s <= not " + var.getName() + "_Init_Valid_s or (Data_Init_Valid_s and " + var.getName() + "_Init_Ready_s);\n";
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Init_Valid_s <=  not D_" + initVar.getName() + "_fifo_empty_s;\n";
                } else {
                    sLoopFor = String.valueOf(sLoopFor) + this.createFifoInitLoopVariable(var.getVarFunctionMapping(loop).getSimpleFifoCost(this.project), var.getName(), level);
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Ready_o <= not D_" + var.getName() + "_fifo_full_s;\n";
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Init_s <= D_" + var.getName() + "_s;\n";
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "D_" + var.getName() + "_Ready_s <= not " + var.getName() + "_Init_Valid_s or (Data_Init_Valid_s and " + var.getName() + "_Init_Ready_s);\n";
                    sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Init_Valid_s <=  not D_" + var.getName() + "_fifo_empty_s;\n";
                }
            }
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + var.getName() + "_Ready_s <= ";
            for (SimpleVariable sv : var.getVariableMap().get(loop).getMultSimpleVar()) {
                sLoopFor = String.valueOf(sLoopFor) + sv.getName() + "_Ready_s";
                sLoopFor = String.valueOf(sLoopFor) + (var.getVariableMap().get(loop).getMultSimpleVar().lastElement().equals(sv) ? ";\n" : " and ");
            }
            for (SimpleVariable sv : var.getVariableMap().get(loop).getMultSimpleVar()) {
                sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + sv.getName() + "_s <= " + var.getName() + "_s;\n";
                sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + sv.getName() + "_Valid_s <= Data_Ready_s;\n";
            }
            sLoopFor = String.valueOf(sLoopFor) + "\n";
        }
        String sDataInitValid = new String();
        String sDataReady = new String();
        String sDataValid = new String();
        String sDataLoopValid = new String();
        sDataInitValid = String.valueOf(sDataInitValid) + this.tab(level + 1) + "Data_Init_Valid_s   <= ";
        sDataValid = String.valueOf(sDataValid) + this.tab(level + 1) + "Data_Valid_s        <= ";
        sDataReady = String.valueOf(sDataReady) + this.tab(level + 1) + "Data_Ready_s        <= Data_Valid_s and ";
        sDataLoopValid = String.valueOf(sDataLoopValid) + this.tab(level + 1) + "Data_Loop_Valid_s   <= ";
        for (SimpleVariable var : loop.getLoopVariables()) {
            if (!loop.getLoopVariables().lastElement().equals(var)) {
                sDataInitValid = String.valueOf(sDataInitValid) + var.getName() + "_Init_Valid_s and ";
                sDataValid = String.valueOf(sDataValid) + var.getName() + "_Valid_s and ";
                sDataReady = String.valueOf(sDataReady) + var.getName() + "_Ready_s and ";
                sDataLoopValid = String.valueOf(sDataLoopValid) + var.getName() + "_Loop_Valid_s and ";
                continue;
            }
            sDataInitValid = String.valueOf(sDataInitValid) + var.getName() + "_Init_Valid_s;\n";
            sDataValid = String.valueOf(sDataValid) + var.getName() + "_Valid_s;\n";
            sDataReady = String.valueOf(sDataReady) + var.getName() + "_Ready_s;\n";
            sDataLoopValid = String.valueOf(sDataLoopValid) + var.getName() + "_Loop_Valid_s;\n";
        }
        sLoopFor = String.valueOf(sLoopFor) + sDataInitValid + sDataReady + sDataValid + sDataLoopValid;
        SimpleVariable cond = (SimpleVariable)((IfThenElse)loop.getBody().elementAt(0)).getInternalVars().elementAt(0);
        if (cond.getSimpleFifo()) {
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Fifo_Ready_s        <= n_" + cond.getName() + "_fifo_empty_s and Data_Loop_Valid_s;\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "n_Fifo_Ready_s      <= not Fifo_Ready_s;\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Cond_Loop_s         <= not (" + cond.getName() + "_fifo_s and Fifo_Ready_s);\n\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Loop_Memory_Write_s <= not " + cond.getName() + "_fifo_s and Fifo_Ready_s;\n";
        } else {
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Fifo_Ready_s        <= " + cond.getName() + "_Valid_s and Data_Loop_Valid_s;\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "n_Fifo_Ready_s      <= not Fifo_Ready_s;\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Cond_Loop_s         <= not (" + cond.getName() + "_s and Fifo_Ready_s);\n\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Loop_Memory_Write_s <= not " + cond.getName() + "_s and Fifo_Ready_s;\n";
        }
        String sLoopMemoryRead = new String();
        String sLoopMemoryValid = new String();
        String sLoopMemoryReady = new String();
        for (Element e : loop.getOutput()) {
            if (!loop.getOutput().lastElement().equals(e)) {
                sLoopMemoryRead = String.valueOf(sLoopMemoryRead) + "Loop_Memory_" + e.getName() + "_Ready_s and ";
                sLoopMemoryValid = String.valueOf(sLoopMemoryValid) + "Loop_Memory_" + e.getName() + "_Valid_s and ";
                sLoopMemoryReady = String.valueOf(sLoopMemoryReady) + e.getName() + "_Ready_i and ";
                continue;
            }
            sLoopMemoryRead = String.valueOf(sLoopMemoryRead) + "Loop_Memory_" + e.getName() + "_Ready_s;\n";
            sLoopMemoryValid = String.valueOf(sLoopMemoryValid) + "Loop_Memory_" + e.getName() + "_Valid_s;\n";
            sLoopMemoryReady = String.valueOf(sLoopMemoryReady) + e.getName() + "_Ready_i;\n\n";
        }
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Loop_Memory_Read_s  <= " + sLoopMemoryRead;
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Loop_Memory_Valid_s <= " + sLoopMemoryValid;
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Loop_Memory_Ready_s <= " + sLoopMemoryReady;
        for (SimpleVariable var : loop.getLoopVariables()) {
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Init_" + var.getName() + " : Init_Input\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "port map(\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Clock_i           => Clock_i,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Reset_i           => Reset_i,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_i            => " + var.getName() + "_Init_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Valid_i      => Data_Init_Valid_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Ready_o      => " + var.getName() + "_Init_Ready_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Loop_i       => " + var.getName() + "_Loop_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Loop_Valid_i => Data_Loop_Valid_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Loop_Ready_o => " + var.getName() + "_Loop_Ready_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Cond_Loop_i       => Counter_Ready_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_o            => " + var.getName() + "_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Valid_o      => " + var.getName() + "_Valid_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Ready_i      => Data_Ready_s\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ");\n\n";
        }
        sLoopFor = String.valueOf(sLoopFor) + this.createFifo(loop);
        Addition add = new Addition();
        add.setBlock(loop.getIterOperation().getBlock());
        SimpleVariable iter = (SimpleVariable)loop.getInternalVars().elementAt(0);
        int minCost = this.multUseSignal.get(loop).getMinCost(iter);
        add.setName("add_" + loop.getIterOperation().getName());
        if (loop.getIncr().getType().equalsIgnoreCase("const")) {
            add.addInput(loop.getIncr());
        } else {
            add.addInput(loop.getIncr().getVariableMap().get(loop).getMapVHDLSimpleVariable(0));
        }
        add.addInput(iter.getVariableMap().get(loop).getMapVHDLSimpleVariable(minCost));
        add.addOutput(new SimpleVariable(String.valueOf(iter.getName()) + "_Add"));
        sLoopFor = String.valueOf(sLoopFor) + this.createOp(add, level + 1, loop);
        if (iter.getCost() + loop.getIterOperation().getBlock().latencyTime() + 1 < loop.getRelativeMaxCost() - 1) {
            SimpleVariable sv = (SimpleVariable)loop.getIterOperation().getOutputAt(0);
            sLoopFor = String.valueOf(sLoopFor) + this.createFifoInstanciation(sv, loop.getRelativeMaxCost() - add.getBlock().latencyTime(), BuildingBlock.NumType.getDataSize(this.numType), false, loop);
            sLoopFor = String.valueOf(sLoopFor) + this.tab(1) + iter.getName() + "_Loop_s <= " + iter.getName() + "_Add_fifo_s;\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(1) + iter.getName() + "_Loop_Valid_s <= " + "n_" + iter.getName() + "_Add_fifo_empty_s;\n";
        } else {
            sLoopFor = String.valueOf(sLoopFor) + this.tab(1) + iter.getName() + "_Add_Ready_s <= " + iter.getName() + "_Loop_Ready_s;\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(1) + iter.getName() + "_Loop_s <= " + iter.getName() + "_Add_s;\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(1) + iter.getName() + "_Loop_Valid_s <= " + iter.getName() + "_Add_Valid_s;\n";
        }
        sLoopFor = String.valueOf(sLoopFor) + this.createBody(level + 1, ((IfThenElse)loop.getBody().firstElement()).getCond(), loop);
        sLoopFor = String.valueOf(sLoopFor) + this.createBody(level + 1, loop.getBody(), loop);
        sLoopFor = String.valueOf(sLoopFor) + "\n" + this.tab(level + 1) + "Inst_Counter_Wr : Counter_Wr\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "generic map(\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "\tData_Size_g => " + BuildingBlock.NumType.getDataSize(this.numType) + ",\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "\tMem_Size_g  => " + loop.getRelativeMaxCost() + "\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ")\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "port map(\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Clock_i      => Clock_i,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Reset_i      => Reset_i,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_i       => Adr_Wr_fifo_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Valid_i => Loop_Memory_Adr_Wr_Valid_fifo_s(0),\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Read_i       => Loop_Memory_Valid_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Adr_Rd_i     => Loop_Memory_Adr_Read_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Ready_i      => Data_Init_Valid_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Fifo_Ready_i => n_Fifo_Ready_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Cond_i       => Cond_Loop_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_o       => Adr_Wr_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Valid_o => Loop_Memory_Adr_Wr_Valid_s(0),\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Ready_o      => Counter_Ready_s\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ");\n";
        sLoopFor = String.valueOf(sLoopFor) + this.createFifoInstanciation(new SimpleVariable("Adr_Wr"), loop.getRelativeMaxCost(), loop.getRelativeMaxCost(), true, loop);
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Adr_Wr_Valid_s <= Data_Ready_s;\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Loop_Memory_Adr_Write_s <= Adr_Wr_fifo_s;\n\n";
        sLoopFor = String.valueOf(sLoopFor) + this.createFifoInstanciation(new SimpleVariable("Loop_Memory_Adr_Wr_Valid"), loop.getRelativeMaxCost(), 1, false, loop);
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Loop_Memory_Adr_Wr_Valid_Valid_s <= Data_Ready_s;\n\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Inst_Counter_Rd : Counter_Rd\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "generic map(\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Size_g => " + loop.getRelativeMaxCost() + "\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ")\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "port map(\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Clock_i => Clock_i,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Reset_i => Reset_i,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "En_i    => Loop_Memory_Valid_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Ready_i => Loop_Memory_Ready_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Count_o => Loop_Memory_Adr_Read_s\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ");\n\n";
        for (Element e : loop.getOutput()) {
            String name = e.getName();
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + name + "_Memory : Memory\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "generic map(\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Width_g => " + BuildingBlock.NumType.getDataSize(this.numType) + ",\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Mem_Size_g   => " + loop.getRelativeMaxCost() + "\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ")\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "port map(\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Clock_i      => Clock_i,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Reset_i      => Reset_i,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Wr_i         => Loop_Memory_Write_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Rd_i         => Loop_Memory_Read_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Adr_Wr_i     => Loop_Memory_Adr_Write_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Adr_Rd_i     => Loop_Memory_Adr_Read_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Adr_Valid_i  => Loop_Memory_Adr_Wr_Valid_fifo_s(0),\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_i       => " + name + "_Delayed_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Valid_o => Loop_Memory_" + name + "_Valid_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_o       => Loop_Memory_" + name + "_s\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ");\n\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Read_" + name + "_Mem_Result : Read_Result\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "generic map(\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_Width_g => " + BuildingBlock.NumType.getDataSize(this.numType) + "\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ")\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "port map(\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Clock_i => Clock_i,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Reset_i => Reset_i,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_i  => Loop_Memory_" + name + "_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Valid_i => Loop_Memory_" + name + "_Valid_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Ready_o => Loop_Memory_" + name + "_Ready_s,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_o  => " + name + "_o,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Valid_o => " + name + "_Valid_o,\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Ready_i => " + name + "_Ready_i\n";
            sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ");\n\n";
        }
        sLoopFor = String.valueOf(sLoopFor) + "end comp;";
        return sLoopFor;
    }

    private String createFifoInitLoopVariable(int size, String name, int level) {
        String sLoopFor = new String();
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "Fifo_D_" + name + ": fifo_Std\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "generic map (\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "FIFOSIZE  => " + (2 + size) + ",\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "DATAWIDTH => " + BuildingBlock.NumType.getDataSize(this.numType) + "\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ")\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + "port map(\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Clock_i      => Clock_i,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Reset_i      => Reset_i,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Wr_Req_i     => " + name + "_Valid_i,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Rd_Req_i     => D_" + name + "_Ready_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_i       => " + name + "_i,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Data_o       => D_" + name + "_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Fifo_Full_o  => D_" + name + "_fifo_full_s,\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 2) + "Fifo_Empty_o => D_" + name + "_fifo_empty_s\n";
        sLoopFor = String.valueOf(sLoopFor) + this.tab(level + 1) + ");\n";
        return sLoopFor;
    }

    private String createFifo(Function f) {
        String sFifo = new String();
        this.project.setUseFifo(false);
        for (Element var : f.getInternalVars()) {
            if (!(var instanceof SimpleVariable) || ((SimpleVariable)var).getType().equals("const")) continue;
            if (((SimpleVariable)var).getSimpleFifo()) {
                sFifo = String.valueOf(sFifo) + this.createFifoInstanciation((SimpleVariable)var, f.getRelativeMaxCost(), BuildingBlock.NumType.getDataSize(this.numType), false, f);
            }
            if (((SimpleVariable)var).getLoopOutputCost(f) != 0 && ((SimpleVariable)var).getLoopOutputConnect(f)) {
                sFifo = String.valueOf(sFifo) + this.createFifoInstanciation((SimpleVariable)var, f.getRelativeMaxCost() - ((SimpleVariable)var).getLoopOutputCost(f) + 1, BuildingBlock.NumType.getDataSize(this.numType), false, f);
            }
            if (((SimpleVariable)var).getVariableMap().get(f) == null) continue;
            for (SimpleVariable sv : ((SimpleVariable)var).getVariableMap().get(f).getMultSimpleVar()) {
                if (sv.getSimpleFifo()) {
                    sFifo = String.valueOf(sFifo) + this.createFifoInstanciation(sv, f.getRelativeMaxCost(), BuildingBlock.NumType.getDataSize(this.numType), false, f);
                }
                if (sv.getLoopOutputCost(f) == 0 || !sv.getLoopOutputConnect(f)) continue;
                sFifo = String.valueOf(sFifo) + this.createFifoInstanciation(sv, f.getRelativeMaxCost() - sv.getLoopOutputCost(f) + 1, BuildingBlock.NumType.getDataSize(this.numType), false, f);
            }
        }
        return sFifo;
    }

    private String createFifoInstanciation(SimpleVariable sv, int fifoSize, int dataSize, boolean ilogup, Function parentFunction) {
        int realFifoSize = this.project.getOptimisationProperties().getOptimizeFifo() ? this.project.getOptimisationProperties().getFifoSize() : fifoSize;
        String sFifoInstanciation = new String();
        String fifoType = this.project.getOptimisationProperties().getFifoType();
        String sigNameOut = sv.getName();
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + "\n" + this.tab(1) + "fifo" + "_" + sigNameOut + ": ";
        sFifoInstanciation = fifoType.equalsIgnoreCase("Altera") ? String.valueOf(sFifoInstanciation) + "fifo_Altera\n" : (fifoType.equalsIgnoreCase("Xilinx") ? String.valueOf(sFifoInstanciation) + "fifo_Xilinx\n" : String.valueOf(sFifoInstanciation) + "fifo_Std\n");
        if (sv.getType().equalsIgnoreCase("cond") || sv.getType().equalsIgnoreCase("resultComp")) {
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + "generic map(\n";
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "FIFOSIZE => " + realFifoSize + ",\n";
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "DATAWIDTH => 1)\n";
        } else {
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + "generic map(\n";
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "FIFOSIZE => " + realFifoSize + ",\n";
            sFifoInstanciation = !ilogup ? String.valueOf(sFifoInstanciation) + this.tab(2) + "DATAWIDTH => " + dataSize + ")\n" : String.valueOf(sFifoInstanciation) + this.tab(2) + "DATAWIDTH => ilogup(" + dataSize + "))\n";
        }
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + "port map(\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Clock_i      => Clock_i,\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Reset_i      => Reset_i,\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Wr_Req_i     => " + sigNameOut + "_fifo_write_s,\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Rd_Req_i     => " + sigNameOut + "_fifo_read_s,\n";
        if (sv.getType().equalsIgnoreCase("cond") || sv.getType().equalsIgnoreCase("resultComp")) {
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Data_i(0)    => " + sigNameOut + "_s,\n";
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Data_o(0)    => " + sigNameOut + "_fifo_s,\n";
        } else {
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Data_i       => " + sigNameOut + "_s,\n";
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Data_o       => " + sigNameOut + "_fifo_s,\n";
        }
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Fifo_Full_o  => " + sigNameOut + "_fifo_full_s,\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(2) + "Fifo_Empty_o => " + sigNameOut + "_fifo_empty_s\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + ");\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + "n_" + sigNameOut + "_fifo_empty_s <= " + "not " + sigNameOut + "_fifo_empty_s;\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + sigNameOut + "_fifo_write_s   <= " + sigNameOut + "_Valid_s;\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + sigNameOut + "_fifo_read_s    <= Fifo_Ready_s;\n";
        sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + sigNameOut + "_Ready_s        <= " + "not " + sigNameOut + "_fifo_full_s;\n";
        if (sv.getInputLoopVariable(parentFunction) != null) {
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + sv.getInputLoopVariable(parentFunction).getName() + "_Loop_s <= " + sigNameOut + "_fifo_s;\n";
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + sv.getInputLoopVariable(parentFunction).getName() + "_Loop_Valid_s <= " + "n_" + sigNameOut + "_fifo_empty_s;\n";
        } else if (sv.getOutputLoopVariable() != null && parentFunction.getOutput().contains(sv.getOutputLoopVariable())) {
            sFifoInstanciation = String.valueOf(sFifoInstanciation) + this.tab(1) + sv.getOutputLoopVariable().getName() + "_Delayed_s <= " + sigNameOut + "_fifo_s;\n";
        }
        return sFifoInstanciation;
    }

    private String createAssignment(Assignment aff, int level, Function parentFunction) {
        String sAssign = new String();
        if (aff.getOutputAt(0) instanceof SimpleVariable) {
            SimpleVariable varIn = (SimpleVariable)aff.getInputAt(0);
            SimpleVariable varOut = (SimpleVariable)aff.getOutputAt(0);
            if (!varIn.getType().equals("const")) {
                if (this.top.getInput().contains(varIn)) {
                    sAssign = String.valueOf(sAssign) + "\n" + this.tab(level) + this.createVar(varOut, "_s") + " <= " + this.createVar(varIn, "_i") + ";\n";
                    sAssign = String.valueOf(sAssign) + this.tab(level) + this.createVar(varIn, "_Ready_o") + " <= " + this.createVar(varOut, "_Ready_s") + ";\n";
                    sAssign = String.valueOf(sAssign) + this.tab(level) + this.createVar(varOut, "_Valid_s") + " <= " + this.createVar(varIn, "_Valid_i") + ";\n";
                } else if (this.top.getOutput().contains(varOut)) {
                    sAssign = String.valueOf(sAssign) + "\n" + this.tab(level) + this.createVar(varOut, "_o") + " <= " + this.createVar(varIn, "_s") + ";\n";
                    sAssign = String.valueOf(sAssign) + this.tab(level) + this.createVar(varIn, "_Ready_s") + " <= " + this.createVar(varOut, "_Ready_i") + ";\n";
                    sAssign = String.valueOf(sAssign) + this.tab(level) + this.createVar(varOut, "_Valid_o") + " <= " + this.createVar(varIn, "_Valid_s") + ";\n";
                } else {
                    sAssign = String.valueOf(sAssign) + "\n" + this.tab(level) + this.createVar(varOut, "_s") + " <= " + this.createVar(varIn, "_s") + ";\n";
                    sAssign = String.valueOf(sAssign) + this.tab(level) + this.createVar(varIn, "_Ready_s") + " <= " + this.createVar(varOut, "_Ready_s") + ";\n";
                    sAssign = String.valueOf(sAssign) + this.tab(level) + this.createVar(varOut, "_Valid_s") + " <= " + this.createVar(varIn, "_Valid_s") + ";\n";
                }
                if (this.multUseSignal.get(parentFunction).variables.contains(varOut)) {
                    sAssign = String.valueOf(sAssign) + this.createTemporaryAssignment(parentFunction, varOut, level);
                }
            }
        }
        return sAssign;
    }

    private String createTemporaryAssignment(Function parentFunction, SimpleVariable var, int level) {
        String sTempAssign = new String();
        sTempAssign = String.valueOf(sTempAssign) + this.tab(level) + this.createVar(var, "_Ready_s") + " <= ";
        for (SimpleVariable sv : var.getVariableMap().get(parentFunction).getMultSimpleVar()) {
            sTempAssign = sv.equals(var.getVariableMap().get(parentFunction).getMultSimpleVar().lastElement()) ? String.valueOf(sTempAssign) + this.createVar(sv, "_Ready_s") + ";\n" : String.valueOf(sTempAssign) + this.createVar(sv, "_Ready_s") + " and ";
        }
        for (SimpleVariable sv : var.getVariableMap().get(parentFunction).getMultSimpleVar()) {
            sTempAssign = String.valueOf(sTempAssign) + this.tab(level) + this.createVar(sv, "_s") + " <= " + this.createVar(var, "_s") + ";\n";
            sTempAssign = String.valueOf(sTempAssign) + this.tab(level) + this.createVar(sv, "_Valid_s") + " <= " + this.createVar(var, "_Valid_s");
            for (SimpleVariable sv2 : var.getVariableMap().get(parentFunction).getMultSimpleVar()) {
                if (sv2.equals(sv)) continue;
                sTempAssign = String.valueOf(sTempAssign) + " and " + this.createVar(sv2, "_Ready_s");
            }
            sTempAssign = String.valueOf(sTempAssign) + ";\n";
        }
        return sTempAssign;
    }

    private String createOp(Operation op, int level, Function parentFunction) throws VHDLException {
        SimpleVariable var;
        String sOp = new String();
        BuildingBlock blockOp = op.getBlock();
        if (blockOp == null) {
            throw new VHDLException("No material description for the operation : " + op.getName());
        }
        if (this.multUseSignal.get(parentFunction).variables.contains(op.getOutputAt(0))) {
            sOp = String.valueOf(sOp) + "\n" + this.createTemporaryAssignment(parentFunction, (SimpleVariable)op.getOutputAt(0), level);
        }
        sOp = String.valueOf(sOp) + "\n" + this.tab(level) + "m2m_" + op.getName() + ": wrapper_" + blockOp.entityName() + "\n";
        sOp = String.valueOf(sOp) + this.tab(level) + "generic map(\n";
        if (op instanceof Multiplexer) {
            sOp = String.valueOf(sOp) + this.tab(level + 1) + "D_Sel_Fifo_Size => " + (2 + ((SimpleVariable)((Multiplexer)op).getSel()).getSimpleFifoCost(this.project)) + ",\n";
        }
        int i = 0;
        while (i < op.getNbInput()) {
            var = (SimpleVariable)op.getInputAt(i);
            sOp = String.valueOf(sOp) + this.tab(level + 1) + "D" + (i + 1) + "_Fifo_Size => " + (2 + var.getSimpleFifoCost(this.project));
            sOp = String.valueOf(sOp) + (i == op.getNbInput() - 1 ? "\n" + this.tab(level) + ")\n" : ",\n");
            ++i;
        }
        sOp = String.valueOf(sOp) + this.tab(level) + "port map(\n";
        sOp = String.valueOf(sOp) + this.tab(level + 1) + "Clock_i      => Clock_i,\n";
        sOp = String.valueOf(sOp) + this.tab(level + 1) + "Reset_i      => Reset_i,\n";
        i = 0;
        while (i < blockOp.nbInputs()) {
            if (op.getInputAt(i) instanceof Operation) {
                throw new VHDLException("All operational entries must be variables.");
            }
            var = (SimpleVariable)op.getInputAt(i);
            if (var.getType().equals("const")) {
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D" + (i + 1) + "_i         => " + this.createValues(var.getValues()) + "," + "--=" + var.getValues() + "\n";
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D" + (i + 1) + "_Valid_i   => '1',\n";
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D" + (i + 1) + "_Ready_o   => open,\n";
            } else {
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D" + (i + 1) + "_i         => " + this.createVar(var, "_s") + ",\n";
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D" + (i + 1) + "_Valid_i   => " + this.createVar(var, "_Valid_s") + ",\n";
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D" + (i + 1) + "_Ready_o   => " + this.createVar(var, "_Ready_s") + ",\n";
            }
            ++i;
        }
        if (op instanceof Multiplexer) {
            SimpleVariable var2 = (SimpleVariable)((Multiplexer)op).getSel();
            if (var2.getType().equals("const")) {
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D_Sel_i       => '1',\n";
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D_Sel_Valid_i => '1',\n";
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D_Sel_Ready_o => open,\n";
            } else {
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D_Sel_i       => " + this.createVar(var2, "_s") + ",\n";
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D_Sel_Valid_i => " + this.createVar(var2, "_Valid_s") + ",\n";
                sOp = String.valueOf(sOp) + this.tab(level + 1) + "D_Sel_Ready_o => " + this.createVar(var2, "_Ready_s") + ",\n";
            }
        }
        SimpleVariable varOutput = (SimpleVariable)op.getOutputAt(0);
        sOp = String.valueOf(sOp) + this.tab(level + 1) + "Ready_i      => " + this.createVar(varOutput, "_Ready_s,") + "\n";
        if (op instanceof Comparison) {
            sOp = String.valueOf(sOp) + this.tab(level + 1) + "Smaller_o    => " + this.createVar(varOutput, "_smaller_s,") + "\n";
            sOp = String.valueOf(sOp) + this.tab(level + 1) + "Bigger_o     => " + this.createVar(varOutput, "_bigger_s,") + "\n";
            sOp = String.valueOf(sOp) + this.tab(level + 1) + "Equal_o      => " + this.createVar(varOutput, "_equal_s,") + "\n";
        } else {
            sOp = String.valueOf(sOp) + this.tab(level + 1) + "Result_o     => " + this.createVar(varOutput, "_s,") + "\n";
        }
        sOp = String.valueOf(sOp) + this.tab(level + 1) + "Valid_o      => " + this.createVar(varOutput, "_Valid_s") + "\n";
        sOp = String.valueOf(sOp) + this.tab(level) + ");\n";
        if (op instanceof Comparison) {
            if (op instanceof Less) {
                sOp = String.valueOf(sOp) + this.tab(level) + this.createVar(varOutput, "_s") + " <= " + this.createVar(varOutput, "_smaller_s") + ";\n";
            } else if (op instanceof LessEqual) {
                sOp = String.valueOf(sOp) + this.tab(level) + this.createVar(varOutput, "_s") + " <= " + this.createVar(varOutput, "_smaller_s") + " or " + this.createVar(varOutput, "_equal_s") + ";\n";
            } else if (op instanceof Greater) {
                sOp = String.valueOf(sOp) + this.tab(level) + this.createVar(varOutput, "_s") + " <= " + this.createVar(varOutput, "_bigger_s") + ";\n";
            } else if (op instanceof GreaterEqual) {
                sOp = String.valueOf(sOp) + this.tab(level) + this.createVar(varOutput, "_s") + " <= " + this.createVar(varOutput, "_bigger_s") + " or " + this.createVar(varOutput, "_equal_s") + ";\n";
            } else if (op instanceof Equal) {
                sOp = String.valueOf(sOp) + this.tab(level) + this.createVar(varOutput, "_s") + " <= " + this.createVar(varOutput, "_equal_s") + ";\n";
            }
        }
        if (varOutput.getInputLoopVariable(parentFunction) != null && varOutput.getLoopOutputCost(parentFunction) == 0 && varOutput.getVariableMap().get(parentFunction) == null) {
            sOp = String.valueOf(sOp) + this.tab(level) + varOutput.getName() + "_Ready_s <= " + varOutput.getInputLoopVariable(parentFunction).getName() + "_Loop_Ready_s;\n";
            sOp = String.valueOf(sOp) + this.tab(level) + varOutput.getInputLoopVariable(parentFunction).getName() + "_Loop_s <= " + varOutput.getName() + "_s;\n";
            sOp = String.valueOf(sOp) + this.tab(level) + varOutput.getInputLoopVariable(parentFunction).getName() + "_Loop_Valid_s <= " + varOutput.getName() + "_Valid_s;\n";
        }
        return sOp;
    }

    private String createVar(SimpleVariable var, String endLineChar) {
        String sVar = new String();
        sVar = var.getName().isEmpty() ? String.valueOf(sVar) + this.createValues(var.getValues()) + endLineChar + "--=" + var.getValues() : String.valueOf(sVar) + var.getName() + endLineChar;
        return sVar;
    }

    private String createValues(ArrayList<Double> val) {
        String sVal = new String();
        BinaryFloatingPoint bin = BinaryFloatingPoint.getInstance();
        if (BuildingBlock.NumType.getDataSize(this.numType) == 32) {
            bin.setSizeExp(8);
            bin.setSizeMant(23);
        } else if (BuildingBlock.NumType.getDataSize(this.numType) == 64) {
            bin.setSizeExp(11);
            bin.setSizeMant(52);
        }
        if (val.size() == 1) {
            sVal = String.valueOf(sVal) + "\"" + bin.getBinary(val.get(0)) + "\"";
        } else {
            sVal = String.valueOf(sVal) + "(";
            sVal = String.valueOf(sVal) + "\"" + bin.getBinary(val.get(0)) + "\"";
            int i = 1;
            while (i < val.size()) {
                sVal = String.valueOf(sVal) + ",\"" + bin.getBinary(val.get(i)) + "\"";
                ++i;
            }
            sVal = String.valueOf(sVal) + ")";
        }
        return sVal;
    }

    private String tab(int nb) {
        String s = new String();
        int i = 0;
        while (i < nb) {
            s = String.valueOf(s) + "\t";
            ++i;
        }
        return s;
    }

    private class MultiUseSignals {
        private Vector<SimpleVariable> variables;
        private Vector<Vector<Integer>> cost;

        public MultiUseSignals(Vector<SimpleVariable> vectorVar, Vector<Vector<Integer>> vectorCost) {
            this.variables = vectorVar;
            this.cost = vectorCost;
        }

        public void setNbrMultSimpleVariable(Function f, SimpleVariable e) {
            Vector<Integer> costs = this.cost.elementAt(this.variables.indexOf(e));
            boolean flag = false;
            int i = 0;
            while (i < costs.size()) {
                SimpleVariable var = new SimpleVariable(String.valueOf(e.getName()) + "_" + i);
                var.setCost(costs.elementAt(i));
                var.setType("mult");
                if (e.getLoopOutputCost(f) != 0 && e.getLoopOutputConnect(f) && !flag) {
                    var.setLoopOutputConnect(f, true);
                    var.setLoopOutputCost(f, e.getLoopOutputCost(f));
                    var.setInputLoopVariable(e.getInputLoopVariable(f), f);
                    flag = true;
                } else if (flag) {
                    var.setLoopOutputCost(f, e.getLoopOutputCost(f));
                }
                e.getVariableMap().get(f).getMultSimpleVar().add(var);
                if (f instanceof LoopFor && costs.elementAt(i).intValue() == f.getMaxCost()) {
                    var.setSimpleFifo(true);
                    var.setSimpleFifoCost(f.getMaxCost() - this.getMinCost(this.variables.indexOf(e)));
                    SimpleVariable loopVar = ((LoopFor)f).getLoopVariable(e);
                    if (loopVar != null) {
                        var.setOutputLoopVariable(loopVar);
                    } else {
                        var.setInputLoopVariable(e, f);
                    }
                }
                ++i;
            }
            e.setLoopOutputConnect(f, false);
            e.setSimpleFifo(false);
        }

        public int getMinCost(int index) {
            int minCost = this.cost.elementAt(index).elementAt(0);
            for (Integer val : this.cost.elementAt(index)) {
                if (minCost <= val) continue;
                minCost = val;
            }
            return minCost;
        }

        public int getMinCost(SimpleVariable var) {
            return this.getMinCost(this.variables.indexOf(var));
        }
    }
}

