/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import m2m.backend.project.ExternalToolsProperties;
import m2m.frontend.actions.M2MAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;

public class ConfigureExternalToolsAction
extends M2MAction {
    private String selectedPath;

    public ConfigureExternalToolsAction(IWorkbenchWindow window, String label) {
        super(window, label);
        this.setId("m2mgui.confoptimisation");
        this.setActionDefinitionId("m2mgui.confoptimisation");
    }

    public void run() {
        Display display = this.window.getShell().getDisplay();
        Shell shell = new Shell(display);
        shell.setText("External tools configuration");
        ExternalToolsPropertiesDlg dlg = new ExternalToolsPropertiesDlg(shell);
        dlg.open();
    }

    class ExternalToolsPropertiesDlg
    extends Dialog {
        private Text ubiduleIP;
        private Text isePath;
        private Text xilinxLicense;
        private Text libPath;
        private Text octavePath;
        private Text vsimPath;
        private Text dotPath;
        private Combo simulationFiles;
        private Combo simulator;

        public ExternalToolsPropertiesDlg(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("External tools properties");
        }

        public void create() {
            super.create();
        }

        protected Control createDialogArea(Composite parent) {
            GridLayout layout = new GridLayout();
            parent.setLayout((Layout)layout);
            GridLayout pathLayout = new GridLayout();
            pathLayout.numColumns = 3;
            GridLayout buttonLayout = new GridLayout();
            buttonLayout.numColumns = 2;
            Group pathExec = new Group(parent, 16);
            pathExec.setBounds(parent.getClientArea());
            pathExec.setLayout((Layout)layout);
            Composite pathComp = new Composite((Composite)pathExec, 4);
            pathComp.setLayout((Layout)pathLayout);
            Composite buttonComp = new Composite((Composite)pathExec, 131072);
            buttonComp.setLayout((Layout)buttonLayout);
            Label libPathLabel = new Label(pathComp, 0);
            libPathLabel.setText("Lib path :");
            libPathLabel.setBounds(parent.getClientArea());
            libPathLabel.setLocation(10, 25);
            libPathLabel.pack();
            GridData libPathGridDataText = new GridData();
            libPathGridDataText.widthHint = 250;
            libPathGridDataText.heightHint = 15;
            this.libPath = new Text(pathComp, 0);
            this.libPath.setBounds(105, 23, 1500, 25);
            this.libPath.setLocation(105, 23);
            this.libPath.setLayoutData((Object)libPathGridDataText);
            this.libPath.pack();
            Button findlibPath = new Button(pathComp, 0x1000000);
            findlibPath.setBounds(parent.getBounds());
            findlibPath.setText("Browse...");
            findlibPath.setLocation(250, 23);
            findlibPath.pack();
            class OpenDirListener
            implements Listener {
                private Text textEntry = null;
                private Shell shell;

                public OpenDirListener(Text textEntry, Shell shell) {
                    this.textEntry = textEntry;
                    this.shell = shell;
                }

                public void handleEvent(Event event) {
                    DirectoryDialog dlg = new DirectoryDialog(this.shell);
                    dlg.setText("Choose a directory");
                    dlg.setMessage("Please choose a directory");
                    dlg.setFilterPath(this.textEntry.getText());
                    String dir = dlg.open();
                    if (dir != null) {
                        this.textEntry.setText(dir);
                    }
                }
            }
            findlibPath.addListener(13, (Listener)new OpenDirListener(this.libPath, this.getShell()));
            Label octavePathLabel = new Label(pathComp, 0);
            octavePathLabel.setText("Octave path :");
            octavePathLabel.setBounds(parent.getClientArea());
            octavePathLabel.setLocation(10, 25);
            octavePathLabel.pack();
            GridData octaveGridDataText = new GridData();
            octaveGridDataText.widthHint = 250;
            octaveGridDataText.heightHint = 15;
            this.octavePath = new Text(pathComp, 0);
            this.octavePath.setBounds(105, 23, 1500, 25);
            this.octavePath.setLocation(105, 23);
            this.octavePath.setLayoutData((Object)octaveGridDataText);
            this.octavePath.pack();
            Button findOctavePath = new Button(pathComp, 0x1000000);
            findOctavePath.setBounds(parent.getBounds());
            findOctavePath.setText("Browse...");
            findOctavePath.setLocation(250, 23);
            findOctavePath.pack();
            class OpenListener
            implements Listener {
                private Text textEntry = null;

                public OpenListener(Text textEntry) {
                    this.textEntry = textEntry;
                }

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(new Shell(), 4096);
                    dialog.setText("Choose path...");
                    ConfigureExternalToolsAction.this.selectedPath = dialog.open();
                    if (ConfigureExternalToolsAction.this.selectedPath != null) {
                        this.textEntry.setText(ConfigureExternalToolsAction.this.selectedPath);
                    }
                }
            }
            findOctavePath.addListener(13, (Listener)new OpenListener(this.octavePath));
            Label vsimPathLabel = new Label(pathComp, 0);
            vsimPathLabel.setText("Vsim path :");
            vsimPathLabel.setBounds(parent.getClientArea());
            vsimPathLabel.setLocation(10, 50);
            vsimPathLabel.pack();
            GridData vsimGridDataText = new GridData();
            vsimGridDataText.widthHint = 250;
            vsimGridDataText.heightHint = 15;
            this.vsimPath = new Text(pathComp, 0);
            this.vsimPath.setBounds(parent.getBounds());
            this.vsimPath.setLocation(105, 50);
            this.vsimPath.setLayoutData((Object)vsimGridDataText);
            this.vsimPath.pack();
            Button findVsimPath = new Button(pathComp, 0);
            findVsimPath.setBounds(parent.getBounds());
            findVsimPath.setText("Browse...");
            findVsimPath.setLocation(250, 50);
            findVsimPath.pack();
            findVsimPath.addListener(13, (Listener)new OpenListener(this.vsimPath));
            Label isePathLabel = new Label(pathComp, 0);
            isePathLabel.setText("Xilinx ISE path :");
            isePathLabel.setBounds(parent.getClientArea());
            isePathLabel.setLocation(10, 50);
            isePathLabel.pack();
            GridData iseGridDataText = new GridData();
            iseGridDataText.widthHint = 250;
            iseGridDataText.heightHint = 15;
            this.isePath = new Text(pathComp, 0);
            this.isePath.setBounds(parent.getBounds());
            this.isePath.setLocation(105, 50);
            this.isePath.setLayoutData((Object)iseGridDataText);
            this.isePath.pack();
            Button findIsePath = new Button(pathComp, 0);
            findIsePath.setBounds(parent.getBounds());
            findIsePath.setText("Browse...");
            findIsePath.setLocation(250, 50);
            findIsePath.pack();
            findIsePath.addListener(13, (Listener)new OpenDirListener(this.isePath, this.getShell()));
            Label dotPathLabel = new Label(pathComp, 0);
            dotPathLabel.setText("Dot path :");
            dotPathLabel.setBounds(parent.getClientArea());
            dotPathLabel.setLocation(10, 50);
            dotPathLabel.pack();
            GridData dotGridDataText = new GridData();
            dotGridDataText.widthHint = 250;
            dotGridDataText.heightHint = 15;
            this.dotPath = new Text(pathComp, 0);
            this.dotPath.setBounds(parent.getBounds());
            this.dotPath.setLocation(105, 50);
            this.dotPath.setLayoutData((Object)dotGridDataText);
            this.dotPath.pack();
            Button findDotPath = new Button(pathComp, 0);
            findDotPath.setBounds(parent.getBounds());
            findDotPath.setText("Browse...");
            findDotPath.setLocation(250, 50);
            findDotPath.pack();
            findDotPath.addListener(13, (Listener)new OpenListener(this.dotPath));
            Label simFilesLabel = new Label(pathComp, 0);
            simFilesLabel.setText("Simulation files :");
            simFilesLabel.setBounds(parent.getClientArea());
            simFilesLabel.setLocation(10, 50);
            simFilesLabel.pack();
            GridData simFilesText = new GridData();
            simFilesText.widthHint = 250;
            simFilesText.heightHint = 15;
            this.simulationFiles = new Combo(pathComp, 0);
            this.simulationFiles.add("Original OVM");
            this.simulationFiles.add("M2M OVM");
            this.simulationFiles.add("Original UVM");
            Label emptyLabel = new Label(pathComp, 0);
            emptyLabel.setText("");
            Label simulatorLabel = new Label(pathComp, 0);
            simulatorLabel.setText("Simulator :");
            simulatorLabel.setBounds(parent.getClientArea());
            simulatorLabel.setLocation(10, 50);
            simulatorLabel.pack();
            GridData simulatorText = new GridData();
            simulatorText.widthHint = 250;
            simulatorText.heightHint = 15;
            this.simulator = new Combo(pathComp, 0);
            int i = 0;
            while (i < ExternalToolsProperties.simulatorTypes.length) {
                this.simulator.add(ExternalToolsProperties.simulatorTypes[i]);
                ++i;
            }
            Label emptyLabel0 = new Label(pathComp, 0);
            emptyLabel0.setText("");
            Label xilinxLicenseLabel = new Label(pathComp, 0);
            xilinxLicenseLabel.setText("Xilinx license :");
            xilinxLicenseLabel.setBounds(parent.getClientArea());
            xilinxLicenseLabel.setLocation(10, 50);
            xilinxLicenseLabel.pack();
            GridData xilinxLicenseText = new GridData();
            xilinxLicenseText.widthHint = 250;
            xilinxLicenseText.heightHint = 15;
            this.xilinxLicense = new Text(pathComp, 0);
            this.xilinxLicense.setBounds(parent.getBounds());
            this.xilinxLicense.setLocation(105, 50);
            this.xilinxLicense.setLayoutData((Object)xilinxLicenseText);
            this.xilinxLicense.pack();
            Label emptyLabel1 = new Label(pathComp, 0);
            emptyLabel1.setText("");
            Label ubiduleIPLabel = new Label(pathComp, 0);
            ubiduleIPLabel.setText("Ubidule IP :");
            ubiduleIPLabel.setBounds(parent.getClientArea());
            ubiduleIPLabel.setLocation(10, 50);
            ubiduleIPLabel.pack();
            GridData ubiduleIPText = new GridData();
            ubiduleIPText.widthHint = 250;
            ubiduleIPText.heightHint = 15;
            this.ubiduleIP = new Text(pathComp, 0);
            this.ubiduleIP.setBounds(parent.getBounds());
            this.ubiduleIP.setLocation(105, 50);
            this.ubiduleIP.setLayoutData((Object)ubiduleIPText);
            this.ubiduleIP.pack();
            Label emptyLabel2 = new Label(pathComp, 0);
            emptyLabel2.setText("");
            this.libPath.setText(ExternalToolsProperties.getReference().getLibPath());
            this.isePath.setText(ExternalToolsProperties.getReference().getIsePath());
            this.vsimPath.setText(ExternalToolsProperties.getReference().getVsimPath());
            this.octavePath.setText(ExternalToolsProperties.getReference().getOctavePath());
            this.dotPath.setText(ExternalToolsProperties.getReference().getDotPath());
            this.simulationFiles.select(ExternalToolsProperties.getReference().getSimulationFiles());
            this.simulator.select(ExternalToolsProperties.getReference().getSimulator());
            this.xilinxLicense.setText(ExternalToolsProperties.getReference().getXilinxLicense());
            this.ubiduleIP.setText(ExternalToolsProperties.getReference().getUbiduleIP());
            return parent;
        }

        protected void okPressed() {
            ExternalToolsProperties props = ExternalToolsProperties.getReference();
            if (this.libPath.getText().compareTo(props.getLibPath()) != 0) {
                MessageBox mess = new MessageBox(ConfigureExternalToolsAction.this.window.getShell(), 32);
                mess.setMessage("You changed the location of the lib files. Please restart the application.");
                mess.setText("Important notice");
                mess.open();
            }
            props.setLibPath(this.libPath.getText());
            props.setOctavePath(this.octavePath.getText());
            props.setVsimPath(this.vsimPath.getText());
            props.setIsePath(this.isePath.getText());
            props.setDotPath(this.dotPath.getText());
            props.setSimulationFiles(this.simulationFiles.getSelectionIndex());
            props.setSimulator(this.simulator.getSelectionIndex());
            props.setXilinxLicense(this.xilinxLicense.getText());
            props.setUbiduleIP(this.ubiduleIP.getText());
            this.close();
        }
    }
}

