/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.project.M2MProject;
import m2m.backend.project.OptimisationProperties;
import m2m.frontend.actions.M2MAction;
import m2m.frontend.view.Editor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchWindow;

public class ConfigureOptimisationAction
extends M2MAction {
    public ConfigureOptimisationAction(IWorkbenchWindow window, String label) {
        super(window, label);
        this.setId("m2mgui.confoptimisation");
        this.setActionDefinitionId("m2mgui.confoptimisation");
    }

    public void run() {
        if (!this.getEditor("Error", "Select the tab with the code you want to transform in VHDL")) {
            return;
        }
        Display display = this.window.getShell().getDisplay();
        Shell shell = new Shell(display);
        shell.setText("Simulation configuration");
        OptimisationPropertiesDlg dlg = new OptimisationPropertiesDlg(shell, this.editor.getM2MProject());
        dlg.setOptimisationProperties(this.editor.getM2MProject().getOptimisationProperties());
        dlg.open();
        if (dlg.pressedOk()) {
            this.editor.setModified(true);
        }
    }

    class OptimisationPropertiesDlg
    extends Dialog {
        private OptimisationProperties optimProp;
        private Editor editor;
        private Combo dataTypeChoice;
        private Combo fifoChoice;
        private Spinner fifoSize;
        private Button optFifo;
        private Button fifoComp;
        private Label warning;
        private M2MProject project;
        private boolean pressedOnOk;

        public OptimisationPropertiesDlg(Shell parentShell, M2MProject project) {
            super(parentShell);
            this.pressedOnOk = false;
            this.project = project;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Optimisation properties");
        }

        public void create() {
            super.create();
        }

        protected Control createDialogArea(Composite parent) {
            GridLayout globalGridLayout = new GridLayout();
            globalGridLayout.numColumns = 1;
            Group globalGroup = new Group(parent, 0);
            globalGroup.setLayout((Layout)globalGridLayout);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.verticalSpacing = 5;
            Group optimGroup = new Group((Composite)globalGroup, 16);
            optimGroup.setText("Optimisation settings");
            optimGroup.setBounds(globalGroup.getClientArea());
            optimGroup.setLayout((Layout)gridLayout);
            GridData gridFormat = new GridData();
            gridFormat.horizontalSpan = 2;
            Label formatLabel = new Label((Composite)optimGroup, 0);
            formatLabel.setText("Data type :");
            formatLabel.setBounds(optimGroup.getClientArea());
            formatLabel.pack();
            this.dataTypeChoice = new Combo((Composite)optimGroup, 128);
            this.dataTypeChoice.add(BuildingBlock.NumType.FLOAT32.name());
            this.dataTypeChoice.add(BuildingBlock.NumType.FLOAT64.name());
            this.dataTypeChoice.setLayoutData((Object)gridFormat);
            this.dataTypeChoice.pack();
            GridData gridFreqLabel = new GridData();
            gridFreqLabel.verticalSpan = 8;
            gridFreqLabel.verticalAlignment = 1024;
            GridData gridFifoLabel = new GridData();
            gridFifoLabel.verticalSpan = 8;
            gridFifoLabel.verticalAlignment = 1024;
            Label fifoLabel = new Label((Composite)optimGroup, 0);
            fifoLabel.setText("Fifo type :");
            fifoLabel.setLayoutData((Object)gridFifoLabel);
            fifoLabel.pack();
            GridData gridFifoChoice = new GridData();
            gridFifoChoice.verticalSpan = 8;
            gridFifoChoice.horizontalSpan = 2;
            gridFifoChoice.verticalAlignment = 1024;
            this.fifoChoice = new Combo((Composite)optimGroup, 128);
            this.fifoChoice.add("Standard");
            this.fifoChoice.add("Altera");
            this.fifoChoice.add("Xilinx");
            this.fifoChoice.setLayoutData((Object)gridFifoChoice);
            this.fifoChoice.pack();
            GridData gridFifoSizeLabel = new GridData();
            gridFifoSizeLabel.verticalSpan = 8;
            gridFifoSizeLabel.verticalAlignment = 1024;
            Label fifoSizeLabel = new Label((Composite)optimGroup, 0);
            fifoSizeLabel.setText("Fifo size :");
            fifoSizeLabel.setLayoutData((Object)gridFifoSizeLabel);
            fifoSizeLabel.pack();
            GridData gridFifoSize = new GridData();
            gridFifoSize.widthHint = 100;
            gridFifoSize.horizontalSpan = 2;
            gridFifoSize.verticalSpan = 8;
            gridFifoSize.verticalAlignment = 1024;
            gridFifoSize.horizontalAlignment = 16384;
            this.fifoSize = new Spinner((Composite)optimGroup, 16384);
            this.fifoSize.setLayoutData((Object)gridFifoSize);
            this.fifoSize.pack();
            GridData gridOptFifo = new GridData();
            gridOptFifo.widthHint = 200;
            gridOptFifo.horizontalSpan = 3;
            gridOptFifo.verticalSpan = 8;
            gridOptFifo.verticalAlignment = 1024;
            gridOptFifo.horizontalAlignment = 16384;
            this.optFifo = new Button((Composite)optimGroup, 16416);
            this.optFifo.setText("Optimize Fifos");
            this.optFifo.setLayoutData((Object)gridOptFifo);
            this.optFifo.pack();
            this.optFifo.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    OptimisationPropertiesDlg.this.warning.setVisible(!OptimisationPropertiesDlg.this.optFifo.getSelection());
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }
            });
            GridData gridFifoComp = new GridData();
            gridFifoComp.widthHint = 200;
            gridFifoComp.horizontalSpan = 3;
            gridFifoComp.verticalSpan = 8;
            gridFifoComp.verticalAlignment = 1024;
            gridFifoComp.horizontalAlignment = 16384;
            this.fifoComp = new Button((Composite)optimGroup, 16416);
            this.fifoComp.setText("Add Compensation Fifos");
            this.fifoComp.setLayoutData((Object)gridFifoComp);
            this.fifoComp.pack();
            GridData gridWarningLabel = new GridData();
            gridWarningLabel.widthHint = 280;
            gridWarningLabel.horizontalSpan = 3;
            gridWarningLabel.verticalSpan = 8;
            gridWarningLabel.verticalAlignment = 1024;
            gridWarningLabel.horizontalAlignment = 16384;
            this.warning = new Label((Composite)optimGroup, 16416);
            this.warning.setText("Warning: make sure that the fifos value is sufficient.");
            this.warning.setForeground(ColorConstants.red);
            this.warning.setLayoutData((Object)gridWarningLabel);
            this.warning.setVisible(!this.optFifo.getSelection());
            this.warning.pack();
            this.refreshOptimisationPage();
            return parent;
        }

        protected void okPressed() {
            this.saveOptimisationProperties();
            this.pressedOnOk = true;
            this.close();
        }

        public boolean pressedOk() {
            return this.pressedOnOk;
        }

        private void saveOptimisationProperties() {
            if (this.dataTypeChoice.getSelectionIndex() != -1) {
                try {
                    BuildingBlock.NumType newType = BuildingBlock.NumType.getNum(this.dataTypeChoice.getItem(this.dataTypeChoice.getSelectionIndex()));
                    if (this.optimProp.getOptimisationDataType() != newType) {
                        this.optimProp.setOptimisationDataType(newType);
                        this.project.getStructTreatment().modifyNumType(newType);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openError((Shell)this.editor.getSite().getShell(), (String)"Error", (String)"Data size should be an integer!");
                }
            }
            if (this.fifoChoice.getSelectionIndex() != -1) {
                this.optimProp.setFifoType(this.fifoChoice.getItem(this.fifoChoice.getSelectionIndex()));
            }
            this.optimProp.setFifoSize(this.fifoSize.getSelection());
            this.optimProp.setOptimizeFifo(this.optFifo.getSelection());
            this.optimProp.setFifoCompensation(this.fifoComp.getSelection());
        }

        public void setOptimisationProperties(OptimisationProperties optimProp) {
            this.optimProp = optimProp;
        }

        public void refreshOptimisationPage() {
            if (this.optimProp instanceof OptimisationProperties) {
                this.dataTypeChoice.setText(String.valueOf(this.optimProp.getOptimisationDataType().name()));
                this.fifoChoice.setText(this.optimProp.getFifoType());
                this.fifoSize.setValues(this.optimProp.getFifoSize(), 0, 1000, 0, 1, 1);
                this.optFifo.setSelection(this.optimProp.getOptimizeFifo());
                this.warning.setVisible(!this.optFifo.getSelection());
                this.fifoComp.setSelection(this.optimProp.getFifoCompensation());
            }
        }
    }
}

