/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import m2m.backend.project.SimulationProperties;
import m2m.frontend.actions.M2MAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;

public class ConfigureSimulationAction
extends M2MAction {
    public ConfigureSimulationAction(IWorkbenchWindow window, String label) {
        super(window, label);
        this.setId("m2mgui.confsimulation");
        this.setActionDefinitionId("m2mgui.confsimulation");
    }

    public void run() {
        if (!this.getEditor("Error", "Select the tab with the code you want to transform in VHDL")) {
            return;
        }
        Display display = this.window.getShell().getDisplay();
        Shell shell = new Shell(display);
        shell.setText("Simulation configuration");
        SimulationPropertiesDlg dlg = new SimulationPropertiesDlg(shell);
        dlg.setSimulationProperties(this.editor.getM2MProject().getSimulationProperties());
        dlg.open();
        if (dlg.pressedOk()) {
            this.editor.setModified(true);
        }
    }

    class SimulationPropertiesDlg
    extends Dialog {
        private SimulationProperties simProp;
        private Text calcPres;
        private Text nbSamplesEntry;
        private Text systemFreqEntry;
        private Text inputFreqEntry;
        private Text outputFreqEntry;
        private Text inactivityTimeoutEntry;
        private boolean pressedOnOk;

        public SimulationPropertiesDlg(Shell parentShell) {
            super(parentShell);
            this.pressedOnOk = false;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Simulation properties");
        }

        public void create() {
            super.create();
        }

        protected Control createDialogArea(Composite parent) {
            GridLayout globalGridLayout = new GridLayout();
            globalGridLayout.numColumns = 1;
            Group globalGroup = new Group(parent, 0);
            globalGroup.setLayout((Layout)globalGridLayout);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.verticalSpacing = 5;
            Group formatGroup = new Group((Composite)globalGroup, 16);
            formatGroup.setText("Data format");
            formatGroup.setBounds(globalGroup.getClientArea());
            formatGroup.setLayout((Layout)gridLayout);
            GridData gridCalc = new GridData();
            gridCalc.verticalSpan = 8;
            gridCalc.verticalAlignment = 1024;
            Label calcLabel = new Label((Composite)formatGroup, 0);
            calcLabel.setText("Number bit precision :");
            calcLabel.setLayoutData((Object)gridCalc);
            calcLabel.pack();
            GridData gridCalcPres = new GridData();
            gridCalcPres.widthHint = 100;
            gridCalcPres.verticalSpan = 8;
            gridCalcPres.verticalAlignment = 1024;
            this.calcPres = new Text((Composite)formatGroup, 0);
            this.calcPres.setLayoutData((Object)gridCalcPres);
            this.calcPres.pack();
            calcLabel.setToolTipText("The calculation precision defines how error calculations are detected. It corresponds to the number of bits of the mantissa that can differ between the expected and the real results.");
            this.calcPres.setToolTipText("The calculation precision defines how error calculations are detected. It corresponds to the number of bits of the mantissa that can differ between the expected and the real results.");
            Group freqGroup = new Group((Composite)globalGroup, 16);
            freqGroup.setText("Rating and sampling");
            freqGroup.setLocation(5, 200);
            freqGroup.setBounds(globalGroup.getClientArea());
            GridLayout freqGridLayout = new GridLayout();
            freqGridLayout.numColumns = 3;
            freqGridLayout.verticalSpacing = 5;
            freqGroup.setLayout((Layout)freqGridLayout);
            GridData gridNumberOfSample = new GridData();
            gridNumberOfSample.verticalSpan = 8;
            gridNumberOfSample.verticalAlignment = 1024;
            Label nbSamplesLabel = new Label((Composite)freqGroup, 0);
            nbSamplesLabel.setLayoutData((Object)gridNumberOfSample);
            nbSamplesLabel.setText("Number of samples :");
            nbSamplesLabel.pack();
            GridData gridNbSamplesEntry = new GridData();
            gridNbSamplesEntry.widthHint = 100;
            gridNbSamplesEntry.verticalSpan = 8;
            gridNbSamplesEntry.horizontalSpan = 2;
            gridNbSamplesEntry.verticalAlignment = 1024;
            this.nbSamplesEntry = new Text((Composite)freqGroup, 131072);
            this.nbSamplesEntry.setLayoutData((Object)gridNbSamplesEntry);
            this.nbSamplesEntry.pack();
            nbSamplesLabel.setToolTipText("The number of samples to test. One sample corresponds to a single call to the function.");
            this.nbSamplesEntry.setToolTipText("The number of samples to test. One sample corresponds to a single call to the function.");
            GridData gridSystFreq = new GridData();
            gridSystFreq.verticalSpan = 8;
            gridSystFreq.verticalAlignment = 1024;
            Label systFreq = new Label((Composite)freqGroup, 0);
            systFreq.setLayoutData((Object)gridSystFreq);
            systFreq.setText("System frequency :");
            systFreq.pack();
            GridData gridSystFreqEntry = new GridData();
            gridSystFreqEntry.widthHint = 100;
            gridSystFreqEntry.verticalSpan = 8;
            gridSystFreqEntry.verticalAlignment = 1024;
            this.systemFreqEntry = new Text((Composite)freqGroup, 131072);
            this.systemFreqEntry.setLayoutData((Object)gridSystFreqEntry);
            this.systemFreqEntry.pack();
            GridData gridSystFreqUnit = new GridData();
            gridSystFreqUnit.verticalSpan = 8;
            gridSystFreqUnit.verticalAlignment = 1024;
            Label systFreqUnit = new Label((Composite)freqGroup, 0);
            systFreqUnit.setLayoutData((Object)gridSystFreqUnit);
            systFreqUnit.setText("MHz");
            systFreqUnit.pack();
            systFreq.setToolTipText("The system frequency is the frequency at which the system should work.\nThe three frequencies are used in order to more or less stress the system. For each input of the system (each input variable), a valid input is applied at a random rate with probability (input frequency/system frequency). For each output of the system (each output variable), a ready signal is applied at a random rate with probability (output frequency/system frequency).");
            this.systemFreqEntry.setToolTipText("The system frequency is the frequency at which the system should work.\nThe three frequencies are used in order to more or less stress the system. For each input of the system (each input variable), a valid input is applied at a random rate with probability (input frequency/system frequency). For each output of the system (each output variable), a ready signal is applied at a random rate with probability (output frequency/system frequency).");
            GridData gridReadStimFreqSample = new GridData();
            gridReadStimFreqSample.verticalSpan = 8;
            gridReadStimFreqSample.verticalAlignment = 1024;
            Label readFreq = new Label((Composite)freqGroup, 0);
            readFreq.setLayoutData((Object)gridReadStimFreqSample);
            readFreq.setText("Input frequency :");
            readFreq.pack();
            GridData gridReadStimFreqEntry = new GridData();
            gridReadStimFreqEntry.widthHint = 100;
            gridReadStimFreqEntry.verticalSpan = 8;
            gridReadStimFreqEntry.verticalAlignment = 1024;
            this.inputFreqEntry = new Text((Composite)freqGroup, 131072);
            this.inputFreqEntry.setLayoutData((Object)gridReadStimFreqEntry);
            this.inputFreqEntry.pack();
            GridData gridReadStimFreqUnit = new GridData();
            gridReadStimFreqUnit.verticalSpan = 8;
            gridReadStimFreqUnit.verticalAlignment = 1024;
            Label readFreqUnit = new Label((Composite)freqGroup, 0);
            readFreqUnit.setLayoutData((Object)gridReadStimFreqUnit);
            readFreqUnit.setText("MHz");
            readFreqUnit.pack();
            readFreq.setToolTipText("The input frequency corresponds to the rate at which input data should be applied to the system.The three frequencies are used in order to more or less stress the system. For each input of the system (each input variable), a valid input is applied at a random rate with probability (input frequency/system frequency). For each output of the system (each output variable), a ready signal is applied at a random rate with probability (output frequency/system frequency).");
            this.inputFreqEntry.setToolTipText("The input frequency corresponds to the rate at which input data should be applied to the system.The three frequencies are used in order to more or less stress the system. For each input of the system (each input variable), a valid input is applied at a random rate with probability (input frequency/system frequency). For each output of the system (each output variable), a ready signal is applied at a random rate with probability (output frequency/system frequency).");
            GridData gridRefSample = new GridData();
            gridRefSample.verticalSpan = 8;
            gridRefSample.verticalAlignment = 1024;
            Label refSampleFreq = new Label((Composite)freqGroup, 0);
            refSampleFreq.setText("Output frequency :");
            refSampleFreq.setLayoutData((Object)gridRefSample);
            refSampleFreq.pack();
            GridData gridRefSampleEntry = new GridData();
            gridRefSampleEntry.widthHint = 100;
            gridRefSampleEntry.verticalSpan = 8;
            gridRefSampleEntry.verticalAlignment = 1024;
            this.outputFreqEntry = new Text((Composite)freqGroup, 131072);
            this.outputFreqEntry.setLayoutData((Object)gridRefSampleEntry);
            this.outputFreqEntry.pack();
            GridData gridRefSampleUnit = new GridData();
            gridRefSampleUnit.verticalSpan = 8;
            gridRefSampleUnit.verticalAlignment = 1024;
            Label refSampleUnit = new Label((Composite)freqGroup, 0);
            refSampleUnit.setText("MHz");
            refSampleUnit.setLayoutData((Object)gridRefSampleUnit);
            refSampleUnit.pack();
            refSampleFreq.setToolTipText("The output frequency corresponds to the rate at which output data should be retrieved.The three frequencies are used in order to more or less stress the system. For each input of the system (each input variable), a valid input is applied at a random rate with probability (input frequency/system frequency). For each output of the system (each output variable), a ready signal is applied at a random rate with probability (output frequency/system frequency).");
            this.outputFreqEntry.setToolTipText("The output frequency corresponds to the rate at which output data should be retrieved.The three frequencies are used in order to more or less stress the system. For each input of the system (each input variable), a valid input is applied at a random rate with probability (input frequency/system frequency). For each output of the system (each output variable), a ready signal is applied at a random rate with probability (output frequency/system frequency).");
            GridData gridInactivityTimeout = new GridData();
            gridInactivityTimeout.verticalSpan = 8;
            gridInactivityTimeout.verticalAlignment = 1024;
            Label inactivityTimeoutFreq = new Label((Composite)freqGroup, 0);
            inactivityTimeoutFreq.setText("Inactivity timeout :");
            inactivityTimeoutFreq.setLayoutData((Object)gridInactivityTimeout);
            inactivityTimeoutFreq.pack();
            GridData gridInactivityTimeoutEntry = new GridData();
            gridInactivityTimeoutEntry.widthHint = 100;
            gridInactivityTimeoutEntry.verticalSpan = 8;
            gridInactivityTimeoutEntry.verticalAlignment = 1024;
            this.inactivityTimeoutEntry = new Text((Composite)freqGroup, 131072);
            this.inactivityTimeoutEntry.setLayoutData((Object)gridInactivityTimeoutEntry);
            this.inactivityTimeoutEntry.pack();
            GridData gridInactivityTimeoutUnit = new GridData();
            gridInactivityTimeoutUnit.verticalSpan = 8;
            gridInactivityTimeoutUnit.verticalAlignment = 1024;
            Label inactivityTimeoutUnit = new Label((Composite)freqGroup, 0);
            inactivityTimeoutUnit.setText("Clock cycles");
            inactivityTimeoutUnit.setLayoutData((Object)gridInactivityTimeoutUnit);
            inactivityTimeoutUnit.pack();
            inactivityTimeoutFreq.setToolTipText("The period of inactivity allows to automatically end the simulation if no activity is detected on the output for a certain number of clock cycles.");
            this.inactivityTimeoutEntry.setToolTipText("The period of inactivity allows to automatically end the simulation if no activity is detected on the output for a certain number of clock cycles.");
            this.refreshSimulationPage();
            return parent;
        }

        private boolean validate() {
            try {
                if (this.calcPres.getText() != null) {
                    this.simProp.setSimulationCalcPrecision(Integer.parseInt(this.calcPres.getText()));
                }
                if (this.nbSamplesEntry.getText() != null) {
                    this.simProp.setNumberOfSamples(Integer.parseInt(this.nbSamplesEntry.getText()));
                }
                if (this.inputFreqEntry.getText() != null) {
                    this.simProp.setSystemFrequency(Float.parseFloat(this.systemFreqEntry.getText()));
                }
                if (this.inputFreqEntry.getText() != null) {
                    this.simProp.setInputFrequency(Float.parseFloat(this.inputFreqEntry.getText()));
                }
                if (this.outputFreqEntry.getText() != null) {
                    this.simProp.setOutputFrequency(Float.parseFloat(this.outputFreqEntry.getText()));
                }
                if (this.outputFreqEntry.getText() != null) {
                    this.simProp.setInactivityTimeout(Integer.parseInt(this.inactivityTimeoutEntry.getText()));
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                MessageBox mess = new MessageBox(this.getShell(), 33);
                mess.setMessage("Error in the one of the input field");
                mess.setText("Error");
                mess.open();
                return false;
            }
        }

        protected void okPressed() {
            this.saveSimulationProperties();
            this.pressedOnOk = true;
            this.close();
        }

        public boolean pressedOk() {
            return this.pressedOnOk;
        }

        private void saveSimulationProperties() {
            if (!this.validate()) {
                return;
            }
            if (this.calcPres.getText() != null) {
                this.simProp.setSimulationCalcPrecision(Integer.parseInt(this.calcPres.getText()));
            }
            if (this.nbSamplesEntry.getText() != null) {
                this.simProp.setNumberOfSamples(Integer.parseInt(this.nbSamplesEntry.getText()));
            }
            if (this.inputFreqEntry.getText() != null) {
                this.simProp.setSystemFrequency(Float.parseFloat(this.systemFreqEntry.getText()));
            }
            if (this.inputFreqEntry.getText() != null) {
                this.simProp.setInputFrequency(Float.parseFloat(this.inputFreqEntry.getText()));
            }
            if (this.outputFreqEntry.getText() != null) {
                this.simProp.setOutputFrequency(Float.parseFloat(this.outputFreqEntry.getText()));
            }
            if (this.inactivityTimeoutEntry.getText() != null) {
                this.simProp.setInactivityTimeout(Integer.parseInt(this.inactivityTimeoutEntry.getText()));
            }
        }

        public void setSimulationProperties(SimulationProperties simProp) {
            this.simProp = simProp;
        }

        public void refreshSimulationPage() {
            if (this.simProp instanceof SimulationProperties) {
                this.calcPres.setText(String.valueOf(this.simProp.getSimulationCalcPrecision()));
                this.nbSamplesEntry.setText(String.valueOf(this.simProp.getNumberOfSamples()));
                this.systemFreqEntry.setText(String.valueOf(this.simProp.getSystemFrequency()));
                this.inputFreqEntry.setText(String.valueOf(this.simProp.getInputFrequency()));
                this.outputFreqEntry.setText(String.valueOf(this.simProp.getOutputFrequency()));
                this.inactivityTimeoutEntry.setText(String.valueOf(this.simProp.getInactivityTimeout()));
            }
        }
    }
}

