/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import java.lang.reflect.InvocationTargetException;
import m2m.backend.processing.Errors;
import m2m.backend.processing.ExternalRuns;
import m2m.backend.processing.ProgressMonitoring;
import m2m.frontend.ErrorProcessing;
import m2m.frontend.GraphicalProgressMonitoring;
import m2m.frontend.actions.M2MAction;
import m2m.frontend.view.Editor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LaunchOctaveWithRegeneratedFileAction
extends M2MAction {
    public LaunchOctaveWithRegeneratedFileAction(IWorkbenchWindow window, String label) {
        super(window, label);
        this.setId("m2mgui.launchoctavewithregeneratedfile");
        this.setActionDefinitionId("m2mgui.launchoctavewithregeneratedfile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IProgressMonitor monitor) {
        boolean codeRegen = true;
        if (codeRegen && !this.editor.getM2MProject().reGenerateOctave()) {
            return;
        }
        Errors.clearError();
        monitor.beginTask("Running Octave", 100 + this.editor.getM2MProject().getStructTreatment().getInput().size() + this.editor.getM2MProject().getStructTreatment().getOutput().size());
        GraphicalProgressMonitoring mon = new GraphicalProgressMonitoring();
        mon.setIProgressMonitor(monitor);
        this.editor.getM2MProject().monitoring = mon;
        ExternalRuns.runOctave(this.editor.getM2MProject(), codeRegen);
        ErrorProcessing.processLastError(this.editor.getShell().getDisplay());
        if (codeRegen) {
            this.editor.getM2MProject().compareOctaveResult();
        }
        Editor editor = this.editor;
        synchronized (editor) {
            ((Object)((Object)this.editor)).notifyAll();
        }
        this.editor.getM2MProject().monitoring = new ProgressMonitoring();
    }

    public void run() {
        if (!this.getEditor("Error", "Select the tab with the m2m code")) {
            return;
        }
        if (this.editor.getParseDone()) {
            this.activateConsole();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    LaunchOctaveWithRegeneratedFileAction.this.execute(monitor);
                }
            };
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            Shell shell = win != null ? win.getShell() : null;
            try {
                new ProgressMonitorDialog(shell).run(true, false, op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"Parsing error", (String)"Parse the file to get inputs and outputs before trying to launch Octave");
        }
    }
}

