/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import java.lang.reflect.InvocationTargetException;
import m2m.backend.processing.Errors;
import m2m.backend.processing.ExternalRuns;
import m2m.backend.processing.ProgressMonitoring;
import m2m.frontend.Activator;
import m2m.frontend.ErrorProcessing;
import m2m.frontend.GraphicalProgressMonitoring;
import m2m.frontend.actions.M2MAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LaunchRunAllUbiduleAction
extends M2MAction {
    public LaunchRunAllUbiduleAction(IWorkbenchWindow window, String label) {
        super(window, label);
        this.setEnabled(true);
        this.window = window;
        this.setText(label);
        this.setImageDescriptor(Activator.getImageDescriptor("/icons/verif_ubidule.png"));
        this.setId("m2mgui.runallubidule");
        this.setActionDefinitionId("m2mgui.runallubidule");
    }

    public void execute(IProgressMonitor monitor) {
        Errors.clearError();
        monitor.beginTask("Running all", 100 + this.editor.getM2MProject().getSimulationProperties().getNumberOfSamples());
        GraphicalProgressMonitoring mon = new GraphicalProgressMonitoring();
        mon.setIProgressMonitor(monitor);
        this.editor.getM2MProject().monitoring = mon;
        ExternalRuns.runAllUbidule(this.editor.getM2MProject());
        ErrorProcessing.processLastError(this.editor.getShell().getDisplay());
        this.editor.getM2MProject().monitoring = new ProgressMonitoring();
    }

    public void run() {
        if (!this.getEditor("Error", "Select the tab with the code you want to transform in VHDL")) {
            return;
        }
        boolean octaveOK = this.editor.getM2MProject().isOctaveUpToDate();
        boolean vhdlOK = this.editor.getM2MProject().isVHDLUpToDate();
        if (!octaveOK || !vhdlOK) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)"Please generate VHDL and octave files before launch verification");
            return;
        }
        if (!vhdlOK) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)"Please generate VHDL files before launch verification");
            return;
        }
        if (!octaveOK) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)"Please generate Octave files before launch verification");
            return;
        }
        this.activateConsole();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                LaunchRunAllUbiduleAction.this.execute(monitor);
            }
        };
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        Shell shell = win != null ? win.getShell() : null;
        try {
            new ProgressMonitorDialog(shell).run(true, false, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

