/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import java.lang.reflect.InvocationTargetException;
import m2m.backend.processing.Errors;
import m2m.backend.processing.ExternalRuns;
import m2m.backend.processing.ProgressMonitoring;
import m2m.frontend.Activator;
import m2m.frontend.ErrorProcessing;
import m2m.frontend.GraphicalProgressMonitoring;
import m2m.frontend.actions.M2MAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RunAll
extends M2MAction {
    public RunAll(IWorkbenchWindow window, String label) {
        super(window, label);
        this.setImageDescriptor(Activator.getImageDescriptor("/icons/icon_play.png"));
        this.setId("m2mgui.clear");
        this.setActionDefinitionId("m2mgui.clear");
    }

    public void execute(IProgressMonitor monitor) {
        Errors.clearError();
        monitor.beginTask("Running all", ProgressMonitoring.workingTimeAll(this.editor.getM2MProject()));
        GraphicalProgressMonitoring mon = new GraphicalProgressMonitoring();
        mon.setIProgressMonitor(monitor);
        this.editor.getM2MProject().monitoring = mon;
        ExternalRuns.runAll(this.editor.getM2MProject());
        ErrorProcessing.processLastError(this.editor.getShell().getDisplay());
        this.editor.getM2MProject().monitoring = new ProgressMonitoring();
    }

    public void run() {
        if (!this.getEditor("Error", "Select the tab with the m2m code")) {
            return;
        }
        if (this.editor.getParseDone()) {
            this.activateConsole();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    RunAll.this.execute(monitor);
                }
            };
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            Shell shell = win != null ? win.getShell() : null;
            try {
                new ProgressMonitorDialog(shell).run(true, false, op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"Parsing error", (String)"Parse the file to get inputs and outputs before trying to launch Octave");
        }
    }
}

