/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import m2m.backend.processing.Errors;
import m2m.backend.processing.ProjectsValidator;
import m2m.frontend.GUIProperties;
import m2m.frontend.GraphicalProgressMonitoring;
import m2m.frontend.actions.M2MAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ValidateProjectsAction
extends M2MAction {
    private String path;

    public ValidateProjectsAction(IWorkbenchWindow window, String label) {
        super(window, label);
        this.setId("m2mgui.validateprojects");
        this.setActionDefinitionId("m2mgui.validateprojects");
    }

    public void execute(IProgressMonitor monitor) {
        Errors.clearError();
        ProjectsValidator validator = new ProjectsValidator();
        int nbWorkingSteps = validator.nbWorkingSteps(this.path);
        int nbProjects = validator.nbProjects;
        monitor.beginTask("Testing " + nbProjects + " projects", nbWorkingSteps);
        GraphicalProgressMonitoring mon = new GraphicalProgressMonitoring();
        mon.setIProgressMonitor(monitor);
        validator.testDir(this.path, mon);
        monitor.done();
    }

    public synchronized void run() {
        DirectoryDialog dlg = new DirectoryDialog(this.window.getShell());
        dlg.setFilterPath(GUIProperties.getReference().getValidateDir());
        this.path = dlg.open();
        if (this.path == null) {
            return;
        }
        File file = new File(this.path);
        if (!file.isDirectory()) {
            return;
        }
        GUIProperties.getReference().setValidateDir(this.path);
        GUIProperties.getReference().writeSettings();
        this.activateConsole();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ValidateProjectsAction.this.execute(monitor);
            }
        };
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        Shell shell = win != null ? win.getShell() : null;
        try {
            new ProgressMonitorDialog(shell).run(true, true, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

