/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.editPart;

import java.beans.PropertyChangeEvent;
import java.util.Vector;
import m2m.backend.structure.Function;
import m2m.frontend.dynamicview.ThreadRouteConnections;
import m2m.frontend.dynamicview.editPart.AbstractEditPart;
import m2m.frontend.dynamicview.editpolicies.EditLayoutPolicy;
import m2m.frontend.dynamicview.figure.FunctionFigure;
import m2m.frontend.dynamicview.model.Connection;
import m2m.frontend.dynamicview.model.GraphicFunction;
import m2m.frontend.dynamicview.model.GraphicLoop;
import m2m.frontend.dynamicview.model.Node;
import m2m.frontend.dynamicview.model.PointConnection;
import m2m.frontend.view.Editor;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FunctionPart
extends AbstractEditPart
implements ActionListener {
    private int redInY;
    private int redOutY;

    protected IFigure createFigure() {
        FunctionFigure figure = new FunctionFigure();
        figure.getBtnMinimize().addActionListener((ActionListener)this);
        figure.addMouseMotionListener(this);
        figure.addMouseListener(this);
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EditLayoutPolicy());
    }

    protected void refreshVisuals() {
        FunctionFigure figure = (FunctionFigure)this.getFigure();
        GraphicFunction model = (GraphicFunction)this.getModel();
        figure.setName(model.getName());
        figure.setLayout(model.getLayout());
        figure.setVisible(model.getVisible());
    }

    public Vector<Node> getModelChildren() {
        return ((GraphicFunction)this.getModel()).getChildrenArray();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Layout")) {
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("VisibleComponent")) {
            this.refreshVisuals();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        ((GraphicFunction)this.getModel()).setNotReduct(!((GraphicFunction)this.getModel()).getNotReduct());
        ((GraphicFunction)this.getModel()).setNotReduct(this.reductionWindow(((GraphicFunction)this.getModel()).getNotReduct()));
    }

    public boolean reductionWindow(boolean visible) {
        this.redInY = 20;
        this.redOutY = 20;
        GraphicFunction model = (GraphicFunction)this.getModel();
        if (!visible || visible && model.CanSetLayout(new Rectangle(model.getLayout().x, model.getLayout().y, model.getLayoutReduction().width, model.getLayoutReduction().height))) {
            Vector<Node> nodes = new Vector<Node>();
            for (Node node : model.getChildrenArray()) {
                nodes.add(0, node);
            }
            for (Node node : nodes) {
                if (!this.hasExternConnection(node, visible)) {
                    node.setVisible(visible);
                }
                if (node instanceof GraphicLoop && !((GraphicLoop)node).getIsReduct()) {
                    ((GraphicLoop)node).setConnectionsVisible(visible);
                    continue;
                }
                for (Connection conn : node.getSourceConnections()) {
                    if (!this.children.contains(conn.getTarget()) && conn.getTarget().getParent() == conn.getSource().getParent().getParent()) continue;
                    conn.setVisible(visible);
                }
                for (Connection conn : node.getTargetConnections()) {
                    if (!this.children.contains(conn.getSource()) && conn.getSource().getParent() == conn.getTarget().getParent().getParent()) continue;
                    conn.setVisible(visible);
                }
            }
            int space = 1;
            if (!visible) {
                for (PointConnection pc : model.getOutputPointsConnection()) {
                    int x = model.getLayout().x + model.getReductSizeWidth() + 15;
                    int y = model.getLayout().y + 20 * space + 2;
                    pc.setLayoutReduction(new Rectangle(x, y, 10, 10));
                    ++space;
                }
                int maxInOut = Math.max(model.getOutputPointsConnection().size(), ((Function)model.getElement()).getInput().size()) + 1;
                model.setSize(model.getReductSizeWidth(), maxInOut * 20 + model.getReductSizeHeight());
            } else {
                for (PointConnection pc : model.getOutputPointsConnection()) {
                    int x = pc.getLayoutReduction().x + model.getLayout().x - model.getLayoutReduction().x;
                    int y = pc.getLayoutReduction().y + model.getLayout().y - model.getLayoutReduction().y;
                    pc.setLayout(new Rectangle(x, y, 10, 10));
                    pc.removeLayoutReduction();
                }
                model.setSize(model.getFullSizeWidth(), model.getFullSizeHeight());
            }
            if (model instanceof GraphicLoop) {
                ((GraphicLoop)model).setIsReduct(!((GraphicLoop)model).getIsReduct());
            }
            Display.getCurrent().asyncExec((Runnable)new ThreadRouteConnections());
            return visible;
        }
        Editor editor = (Editor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"This action is not allowed!");
        return !visible;
    }

    public boolean hasExternConnection(Node node, boolean visible) {
        Vector<Node> children = ((GraphicFunction)this.getModel()).getChildrenArray();
        for (Connection conn : node.getSourceConnections()) {
            if (children.contains(conn.getTarget()) || conn.getTarget().getParent() != conn.getSource().getParent().getParent()) continue;
            if (!visible) {
                node.setLayoutReduction(new Rectangle(((GraphicFunction)this.getModel()).getReductSizeWidth() - 10 - 12, this.redOutY, 10, 10));
                this.redOutY += 20;
            } else {
                node.setLayout(node.getLayoutReduction());
                node.removeLayoutReduction();
            }
            return true;
        }
        for (Connection conn : node.getTargetConnections()) {
            if (children.contains(conn.getSource()) || conn.getSource().getParent() != conn.getTarget().getParent().getParent()) continue;
            if (!visible) {
                node.setLayoutReduction(new Rectangle(0, this.redInY, 10, 10));
                this.redInY += 20;
            } else {
                node.setLayout(node.getLayoutReduction());
                node.removeLayoutReduction();
            }
            return true;
        }
        return false;
    }
}

