/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.figure;

import java.util.ArrayList;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.buildingblocks.BuildingBlocksManager;
import m2m.backend.structure.Operation;
import m2m.frontend.dynamicview.model.GraphicLoopIterator;
import m2m.frontend.dynamicview.model.GraphicOperation;
import m2m.frontend.dynamicview.model.Node;
import m2m.frontend.dynamicview.model.Schema;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;

public class LoopIteratorPropertyFigure
extends Figure
implements ActionListener {
    private Schema schema;
    private GraphicLoopIterator graphicLoopIterator;
    private XYLayout layout;
    private Label labelName = new Label();
    private Label labelStart = new Label();
    private Label labelIncrementation = new Label();
    private Label labelEnd = new Label();
    private CheckBox checkBoxMonitor = new CheckBox("Monitor mode");
    private Label labelNameOperation = new Label();
    private Label labelDescriptionBlock = new Label();
    private ArrayList<BuildingBlock> blockList = new ArrayList();
    private ArrayList<CheckBox> checkBoxesBlockList = new ArrayList();
    private CheckBox checkBoxSelectAll = new CheckBox("Select for all same operation");

    public LoopIteratorPropertyFigure(Schema schema) {
        this.schema = schema;
        this.layout = new XYLayout();
        this.setLayoutManager((LayoutManager)this.layout);
        this.labelName.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelName, false);
        this.setConstraint((IFigure)this.labelName, new Rectangle(0, 0, -1, -1));
        this.labelName.setText("Unknown");
        this.labelStart.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelStart, false);
        this.setConstraint((IFigure)this.labelStart, new Rectangle(0, 30, -1, -1));
        this.labelStart.setText("Unknown");
        this.labelIncrementation.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelIncrementation, false);
        this.setConstraint((IFigure)this.labelIncrementation, new Rectangle(0, 45, -1, -1));
        this.labelIncrementation.setText("Unknown");
        this.labelEnd.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelEnd, false);
        this.setConstraint((IFigure)this.labelEnd, new Rectangle(0, 60, -1, -1));
        this.labelEnd.setText("Unknown");
        this.add((IFigure)this.checkBoxMonitor);
        this.setConstraint((IFigure)this.checkBoxMonitor, new Rectangle(0, 85, -1, -1));
        this.checkBoxMonitor.addActionListener((ActionListener)this);
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.menuBackground);
        this.setForegroundColor(ColorConstants.menuForeground);
        this.labelNameOperation.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelNameOperation, false);
        this.setConstraint((IFigure)this.labelNameOperation, new Rectangle(0, 150, -1, -1));
        this.labelNameOperation.setText("Unknown");
        this.labelDescriptionBlock.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.labelDescriptionBlock, false);
        this.setConstraint((IFigure)this.labelDescriptionBlock, new Rectangle(0, 300, -1, -1));
        this.labelDescriptionBlock.setText("Unknown");
        this.add((IFigure)this.checkBoxSelectAll);
        this.setConstraint((IFigure)this.checkBoxSelectAll, new Rectangle(0, 180, -1, -1));
        this.checkBoxSelectAll.addActionListener((ActionListener)this);
    }

    public void setProperty(GraphicLoopIterator graphicLoopIterator) {
        int space = 180;
        this.graphicLoopIterator = graphicLoopIterator;
        this.labelNameOperation.setText("Name : " + graphicLoopIterator.getIterOperation().getName());
        this.checkBoxMonitor.setEnabled(false);
        this.checkBoxMonitor.setSelected(graphicLoopIterator.getMonitor());
        this.labelName.setText("Name : " + graphicLoopIterator.getName());
        this.labelStart.setText("Start value : " + graphicLoopIterator.getStartInitialisation());
        this.labelIncrementation.setText("Increment value : " + graphicLoopIterator.getIncrementation());
        this.labelEnd.setText("End value : " + graphicLoopIterator.getEndCondition());
        if (graphicLoopIterator.getIterOperation().getBlock() == null) {
            if (this.getChildren().contains(this.checkBoxSelectAll)) {
                this.remove((IFigure)this.checkBoxSelectAll);
            }
            if (this.getChildren().contains(this.labelDescriptionBlock)) {
                this.remove((IFigure)this.labelDescriptionBlock);
            }
            for (CheckBox cb : this.checkBoxesBlockList) {
                if (!this.getChildren().contains(cb)) continue;
                this.remove((IFigure)cb);
            }
            System.out.println("There is no bloc for this operation. Please check the lib path.");
        } else {
            this.add((IFigure)this.labelDescriptionBlock, false);
            for (CheckBox cb : this.checkBoxesBlockList) {
                if (!this.getChildren().contains(cb)) continue;
                this.remove((IFigure)cb);
            }
            this.checkBoxesBlockList.removeAll(this.checkBoxesBlockList);
            this.blockList.removeAll(this.blockList);
            Operation opElement = graphicLoopIterator.getIterOperation();
            for (BuildingBlock block : BuildingBlocksManager.getInstance().blockNamed(opElement.getOpName())) {
                if (block.numType() != this.schema.getDataType()) continue;
                this.blockList.add(block);
            }
            if (this.blockList.size() != 0) {
                this.add((IFigure)this.checkBoxSelectAll);
                this.setConstraint((IFigure)this.checkBoxSelectAll, new Rectangle(0, space, -1, -1));
                this.checkBoxSelectAll.setSelected(graphicLoopIterator.getSelectAll());
                space += 15;
            }
            for (BuildingBlock block : this.blockList) {
                this.checkBoxesBlockList.add(new CheckBox(block.entityName()));
                this.add((IFigure)this.checkBoxesBlockList.get(this.blockList.indexOf(block)));
                this.setConstraint((IFigure)this.checkBoxesBlockList.get(this.blockList.indexOf(block)), new Rectangle(20, space, -1, -1));
                this.checkBoxesBlockList.get(this.blockList.indexOf(block)).addActionListener((ActionListener)this);
                if (opElement.getBlock() == block) {
                    this.checkBoxesBlockList.get(this.blockList.indexOf(block)).setSelected(true);
                }
                space += 15;
            }
            if (!this.blockList.contains(opElement.getBlock())) {
                this.checkBoxesBlockList.get(0).setSelected(true);
                opElement.setBlock(this.blockList.get(0));
            }
            this.setConstraint((IFigure)this.labelDescriptionBlock, new Rectangle(0, space + 15, -1, -1));
            this.labelDescriptionBlock.setText("--------------------------------------\nFunction name\t : " + opElement.getBlock().functionName() + "\n" + "Entity name\t : " + opElement.getBlock().entityName() + "\n" + "Author\t\t : " + opElement.getBlock().author() + "\n" + "Description\t : " + opElement.getBlock().description() + "\n" + "--------------------------------------\n");
        }
    }

    public void actionPerformed(ActionEvent arg) {
        this.graphicLoopIterator.setMonitor(this.checkBoxMonitor.isSelected());
        if (this.checkBoxesBlockList.contains(arg.getSource())) {
            int i = 0;
            while (i < this.blockList.size()) {
                if (this.checkBoxesBlockList.get(i) == arg.getSource()) {
                    this.checkBoxesBlockList.get(i).setSelected(true);
                    this.graphicLoopIterator.getIterOperation().setBlock(this.blockList.get(i));
                    this.labelDescriptionBlock.setText("--------------------------------------\nFunction name\t : " + this.graphicLoopIterator.getIterOperation().getBlock().functionName() + "\n" + "Entity name\t : " + this.graphicLoopIterator.getIterOperation().getBlock().entityName() + "\n" + "Author\t\t : " + this.graphicLoopIterator.getIterOperation().getBlock().author() + "\n" + "Description\t : " + this.graphicLoopIterator.getIterOperation().getBlock().description() + "\n" + "--------------------------------------\n");
                } else {
                    this.checkBoxesBlockList.get(i).setSelected(false);
                }
                ++i;
            }
        }
        BuildingBlock block = null;
        for (CheckBox cb : this.checkBoxesBlockList) {
            if (!cb.isSelected()) continue;
            block = this.blockList.get(this.checkBoxesBlockList.indexOf(cb));
        }
        if (this.checkBoxSelectAll.isSelected()) {
            for (Node node : this.schema.getAllNodes()) {
                if (node instanceof GraphicOperation && ((Operation)node.getElement()).getOpName() == block.functionName()) {
                    ((Operation)node.getElement()).setBlock(block);
                    ((GraphicOperation)node).setSelectAll(true);
                    continue;
                }
                if (!(node instanceof GraphicLoopIterator) || ((GraphicLoopIterator)node).getIterOperation().getOpName() != block.functionName()) continue;
                ((GraphicLoopIterator)node).getIterOperation().setBlock(block);
                ((GraphicLoopIterator)node).setSelectAll(true);
            }
        } else {
            for (Node node : this.schema.getAllNodes()) {
                if (node instanceof GraphicOperation && ((Operation)node.getElement()).getOpName() == block.functionName()) {
                    ((GraphicOperation)node).setSelectAll(false);
                    continue;
                }
                if (!(node instanceof GraphicLoopIterator) || ((GraphicLoopIterator)node).getIterOperation().getOpName() != block.functionName()) continue;
                ((GraphicLoopIterator)node).setSelectAll(false);
            }
        }
        this.graphicLoopIterator.setModified(true);
    }
}

