/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.dynamicview.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.project.M2MProject;
import m2m.backend.structure.Element;
import m2m.frontend.dynamicview.model.Connection;
import m2m.frontend.dynamicview.model.GraphicIf;
import m2m.frontend.dynamicview.model.GraphicLoopIterator;
import m2m.frontend.dynamicview.model.Node;
import m2m.frontend.dynamicview.model.PointConnection;

public class Schema
extends Node {
    public static final String PROPERTY = "Property";
    private GraphicIf lastIfSelected = null;
    private GraphicLoopIterator lastLoopIteratorSelected = null;
    private Node selectedNode;
    private Connection selectedConnection;
    private boolean propertyLock = false;
    public int maxDepth = 0;
    private M2MProject project;

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Node newNode) {
        Node oldNode = this.selectedNode;
        this.selectedNode = newNode;
        this.selectedConnection = null;
        this.firePropertyChange(PROPERTY, oldNode, newNode);
    }

    public Connection getSelectedConnection() {
        return this.selectedConnection;
    }

    public void setSelectedConnection(Connection newConn) {
        this.selectedConnection = newConn;
        this.selectedNode = null;
        this.firePropertyChange(PROPERTY, null, newConn);
    }

    public void setLastIfSelected(GraphicIf ifSelected) {
        this.lastIfSelected = ifSelected;
    }

    public GraphicIf getLastIfSelected() {
        return this.lastIfSelected;
    }

    public void setLastLoopIteratorSelected(GraphicLoopIterator iteratorSelected) {
        this.lastLoopIteratorSelected = iteratorSelected;
    }

    public GraphicLoopIterator getLastloopIteratorSelected() {
        return this.lastLoopIteratorSelected;
    }

    public void setPropertyLock(boolean val) {
        this.propertyLock = val;
    }

    public boolean getPropertyLock() {
        return this.propertyLock;
    }

    public Vector<Node> getAllNodes() {
        LinkedList<Node> tempNodeList = new LinkedList<Node>();
        Vector<Node> nodeList = new Vector<Node>();
        tempNodeList.addAll(this.getChildrenArray());
        nodeList.addAll(tempNodeList);
        Iterator iterNode = tempNodeList.iterator();
        while (iterNode.hasNext()) {
            Node node = (Node)iterNode.next();
            if (node.getChildrenArray().size() != 0) {
                tempNodeList.addAll(node.getChildrenArray());
                nodeList.addAll(node.getChildrenArray());
            }
            tempNodeList.remove(tempNodeList.indexOf(node));
            iterNode = tempNodeList.iterator();
        }
        return nodeList;
    }

    public Vector<Element> getInternalElements() {
        Vector<Element> internalElements = new Vector<Element>();
        Vector<Object> nodes = new Vector();
        nodes = this.getAllNodes();
        for (Node node : nodes) {
            if (!(node instanceof PointConnection) || node.getParent() == this || internalElements.contains(node.getElement())) continue;
            internalElements.add(node.getElement());
        }
        return internalElements;
    }

    public void setMaxDepth(Vector<Node> nodes) {
        for (Node node : nodes) {
            node.setDepthLevel();
            if (this.maxDepth >= node.getDepthLevel()) continue;
            this.maxDepth = node.getDepthLevel();
        }
    }

    public void setproject(M2MProject project) {
        this.project = project;
    }

    public BuildingBlock.NumType getDataType() {
        return this.project.getOptimisationProperties().getOptimisationDataType();
    }

    public boolean getFifoComp() {
        return this.project.getProperties().getOptimisationProperties().getFifoCompensation();
    }

    public void setFifoComp(boolean val) {
        this.project.getProperties().getOptimisationProperties().setFifoCompensation(val);
    }

    public void setDataType(BuildingBlock.NumType num) {
        if (num != this.project.getOptimisationProperties().getOptimisationDataType()) {
            this.project.getOptimisationProperties().setOptimisationDataType(num);
            this.project.getStructTreatment().modifyNumType(num);
        }
    }

    public void setFifoOpti(boolean selected) {
        this.project.getProperties().getOptimisationProperties().setOptimizeFifo(selected);
    }

    public boolean getFifoOpti() {
        return this.project.getProperties().getOptimisationProperties().getOptimizeFifo();
    }
}

