/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Stack;
import m2m.backend.octaveparser.ParsingException;
import m2m.backend.project.M2MProject;
import m2m.backend.project.OptimisationProperties;
import m2m.backend.project.SimulationProperties;
import m2m.backend.utils.FileUtils;
import m2m.frontend.MatlabLineStyler;
import m2m.frontend.actions.TextChange;
import m2m.frontend.dynamicview.Model;
import m2m.frontend.dynamicview.MyGraphicalEditor;
import m2m.frontend.dynamicview.MyGraphicalProperty;
import m2m.frontend.dynamicview.ThreadRouteConnections;
import m2m.frontend.view.M2MConsole;
import m2m.frontend.view.M2MFileStoreEditorInput;
import m2m.frontend.view.NavigationView;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;

public class Editor
extends EditorPart
implements ISaveablePart2 {
    public static final String ID = "m2mgui.editor";
    protected static final int UNDO_LIMIT = 200;
    private MatlabLineStyler lineStyler = new MatlabLineStyler();
    private FileInputStream fileToRead = null;
    private BufferedReader br;
    private Composite top;
    private StyledText styledText;
    private String filePath;
    private File inputFile;
    private boolean parseDone = false;
    private Stack<TextChange> undoChanges;
    private Stack<TextChange> redoChanges;
    private boolean ignoreUndo = false;
    private Model model;
    private M2MProject m2mProject;

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public void createPartControl(Composite parent) {
        this.undoChanges = new Stack();
        this.redoChanges = new Stack();
        this.top = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        this.top.setLayout((Layout)layout);
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn rulerColumn = new LineNumberRulerColumn();
        rulerColumn.setBackground(new Color((Device)parent.getDisplay(), 230, 230, 230));
        ruler.addDecorator(1, (IVerticalRulerColumn)rulerColumn);
        SourceViewer viewer = new SourceViewer(this.top, (IVerticalRuler)ruler, 2818);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        this.styledText = viewer.getTextWidget();
        this.styledText.setLayoutData((Object)new GridData(1808));
        this.styledText.addLineStyleListener((LineStyleListener)this.lineStyler);
        this.filePath = this.getEditorInput().getToolTipText();
        try {
            this.fileToRead = new FileInputStream(this.filePath);
            this.br = new BufferedReader(new InputStreamReader(this.fileToRead));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String strLine;
            while ((strLine = this.br.readLine()) != null) {
                this.styledText.append(String.valueOf(strLine) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!Editor.this.m2mProject.isModified()) {
                    Editor.this.m2mProject.setModified(true);
                    Editor.this.firePropertyChange(257);
                }
                Editor.this.m2mProject.clearStructTreatment();
                Editor.this.setParseDone(true);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if ((M2MConsole)page.findView("m2mgui.view.m2mConsole") == null) {
                    try {
                        page.showView("m2mgui.view.m2mConsole");
                    }
                    catch (PartInitException e1) {
                        e1.printStackTrace();
                    }
                }
                ((M2MConsole)page.findView("m2mgui.view.m2mConsole")).clearConsole();
                try {
                    Editor.this.m2mProject.getStructTreatment().parse(Editor.this.styledText.getText());
                    Editor.this.m2mProject.getStructTreatment().modifyNumType(Editor.this.m2mProject.getProperties().getOptimisationProperties().getOptimisationDataType());
                }
                catch (ParsingException e1) {
                    System.err.println(e1.getMessage());
                    Editor.this.setParseDone(false);
                }
                if (Editor.this.parseDone) {
                    Editor.this.getEditorSite().getActionBars().getStatusLineManager().setMessage("Parsing succesfull.");
                    MyGraphicalProperty graphProp = (MyGraphicalProperty)page.findView("dynamicview.mygraphicalproperty");
                    MyGraphicalEditor graphEditor = (MyGraphicalEditor)page.findView("dynamicview.mygraphicaleditor");
                    if (graphProp != null && graphEditor != null) {
                        Editor.this.model = new Model(Editor.this.m2mProject.getStructTreatment(), Editor.this.m2mProject);
                        graphProp.getGraphicalViewer().setContents((Object)Editor.this.model.getSchema());
                        graphEditor.getGraphicalViewer().setContents((Object)Editor.this.model.getSchema());
                        Display.getCurrent().asyncExec((Runnable)new ThreadRouteConnections());
                    }
                } else {
                    Editor.this.getEditorSite().getActionBars().getStatusLineManager().setMessage("Parsing Error. The dynamic view does not match with the octave code.");
                }
            }
        });
        this.styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.hideView((IViewPart)((MyGraphicalEditor)page.findView("dynamicview.mygraphicaleditor")));
                page.hideView((IViewPart)((MyGraphicalProperty)page.findView("dynamicview.mygraphicalproperty")));
                Editor.this.model = null;
                NavigationView.remList(Editor.this.m2mProject.getProperties().getProjectFullFilename());
            }
        });
        this.styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                if (!Editor.this.ignoreUndo) {
                    Editor.this.undoChanges.push(new TextChange(event.start, event.length, event.replacedText));
                    if (Editor.this.undoChanges.size() > 200) {
                        Editor.this.undoChanges.remove(0);
                    }
                } else {
                    Editor.this.redoChanges.push(new TextChange(event.start, event.length, event.replacedText));
                    if (Editor.this.redoChanges.size() > 200) {
                        Editor.this.redoChanges.remove(0);
                    }
                }
            }
        });
        Menu popupMenu = new Menu((Control)this.styledText);
        MenuItem copyItem = new MenuItem(popupMenu, 8);
        copyItem.setText("Copy\tCtrl+C");
        copyItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Editor.this.styledText.copy();
            }
        });
        MenuItem pasteItem = new MenuItem(popupMenu, 8);
        pasteItem.setText("Paste\tCtrl+V");
        pasteItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Editor.this.styledText.paste();
            }
        });
        MenuItem cutItem = new MenuItem(popupMenu, 8);
        cutItem.setText("Cut\tCtrl+X");
        cutItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Editor.this.styledText.cut();
            }
        });
        new MenuItem(popupMenu, 2);
        MenuItem deleteItem = new MenuItem(popupMenu, 8);
        deleteItem.setText("Delete\tDelete");
        deleteItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Editor.this.delete();
            }
        });
        new MenuItem(popupMenu, 2);
        MenuItem comUncomItem = new MenuItem(popupMenu, 8);
        comUncomItem.setText("Comment/Uncomment");
        comUncomItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Point selRange = Editor.this.styledText.getSelectionRange();
                int firstLine = Editor.this.styledText.getLineAtOffset(selRange.x);
                int lastLine = Editor.this.styledText.getLineAtOffset(selRange.x + selRange.y);
                Editor.this.ignoreUndo = true;
                StyledText commentText = new StyledText(Editor.this.top, 4);
                commentText.setText(Editor.this.styledText.getText(Editor.this.styledText.getOffsetAtLine(firstLine), selRange.x + selRange.y));
                Point commentRange = Editor.this.styledText.getSelectionRange();
                int i = 0;
                while (i <= lastLine - firstLine) {
                    char firstChar = commentText.getText().charAt(commentText.getOffsetAtLine(i));
                    if (firstChar == '%') {
                        commentText.replaceTextRange(commentText.getOffsetAtLine(i), 1, "");
                        if (i == 0 && selRange.x != Editor.this.styledText.getOffsetAtLine(firstLine)) {
                            --commentRange.x;
                        } else {
                            --commentRange.y;
                        }
                    } else {
                        commentText.replaceTextRange(commentText.getOffsetAtLine(i), 0, "%");
                        if (i == 0 && selRange.x != Editor.this.styledText.getOffsetAtLine(firstLine)) {
                            ++commentRange.x;
                        } else {
                            ++commentRange.y;
                        }
                    }
                    ++i;
                }
                Editor.this.ignoreUndo = false;
                Editor.this.styledText.replaceTextRange(Editor.this.styledText.getOffsetAtLine(firstLine), selRange.y + (selRange.x - Editor.this.styledText.getOffsetAtLine(firstLine) + 1), commentText.getText());
                Editor.this.styledText.setSelection(commentRange.x, commentRange.x + commentRange.y);
            }
        });
        this.styledText.setMenu(popupMenu);
    }

    public void copy() {
        this.styledText.copy();
    }

    public void cut() {
        this.styledText.cut();
    }

    public void paste() {
        this.styledText.paste();
    }

    public void selectAll() {
        this.styledText.selectAll();
    }

    public void delete() {
        int start = this.styledText.getSelectionRange().x;
        int length = this.styledText.getSelectionRange().y;
        this.styledText.replaceTextRange(start, length, "");
    }

    public void undo() {
        int oldLength = 0;
        int newLength = 0;
        if (!this.undoChanges.empty()) {
            TextChange change = this.undoChanges.pop();
            this.ignoreUndo = true;
            oldLength = this.styledText.getText().length();
            this.styledText.replaceTextRange(change.getStart(), change.getLength(), change.getReplacedText());
            newLength = this.styledText.getText().length();
            if (oldLength - newLength > 0) {
                this.styledText.setCaretOffset(change.getStart());
            } else {
                this.styledText.setCaretOffset(change.getStart() + change.getReplacedText().length());
            }
            this.styledText.setTopIndex(this.styledText.getLineAtOffset(change.getStart()));
            this.ignoreUndo = false;
        }
    }

    public void redo() {
        int oldLength = 0;
        int newLength = 0;
        if (!this.redoChanges.empty()) {
            TextChange change = this.redoChanges.pop();
            oldLength = this.styledText.getText().length();
            this.styledText.replaceTextRange(change.getStart(), change.getLength(), change.getReplacedText());
            newLength = this.styledText.getText().length();
            if (oldLength - newLength > 0) {
                this.styledText.setCaretOffset(change.getStart());
            } else {
                this.styledText.setCaretOffset(change.getStart() + change.getReplacedText().length());
            }
            this.styledText.setTopIndex(this.styledText.getLineAtOffset(change.getStart()));
        }
    }

    public void comUncom() {
        Point selRange = this.styledText.getSelectionRange();
        int firstLine = this.styledText.getLineAtOffset(selRange.x);
        int lastLine = this.styledText.getLineAtOffset(selRange.x + selRange.y);
        this.ignoreUndo = true;
        StyledText commentText = new StyledText(this.top, 4);
        commentText.setText(this.styledText.getText(this.styledText.getOffsetAtLine(firstLine), selRange.x + selRange.y));
        Point commentRange = this.styledText.getSelectionRange();
        int i = 0;
        while (i <= lastLine - firstLine) {
            char firstChar = commentText.getText().charAt(commentText.getOffsetAtLine(i));
            if (firstChar == '%') {
                commentText.replaceTextRange(commentText.getOffsetAtLine(i), 1, "");
                if (i == 0 && selRange.x != this.styledText.getOffsetAtLine(firstLine)) {
                    --commentRange.x;
                } else {
                    --commentRange.y;
                }
            } else {
                commentText.replaceTextRange(commentText.getOffsetAtLine(i), 0, "%");
                if (i == 0 && selRange.x != this.styledText.getOffsetAtLine(firstLine)) {
                    ++commentRange.x;
                } else {
                    ++commentRange.y;
                }
            }
            ++i;
        }
        this.ignoreUndo = false;
        this.styledText.replaceTextRange(this.styledText.getOffsetAtLine(firstLine), selRange.y + (selRange.x - this.styledText.getOffsetAtLine(firstLine) + 1), commentText.getText());
        this.styledText.setSelection(commentRange.x, commentRange.x + commentRange.y);
    }

    public void comment() {
        Point selRange = this.styledText.getSelectionRange();
        int firstLine = this.styledText.getLineAtOffset(selRange.x);
        int lastLine = this.styledText.getLineAtOffset(selRange.x + selRange.y);
        this.ignoreUndo = true;
        StyledText commentText = new StyledText(this.top, 4);
        commentText.setText(this.styledText.getText(this.styledText.getOffsetAtLine(firstLine), selRange.x + selRange.y));
        Point commentRange = this.styledText.getSelectionRange();
        int i = 0;
        while (i <= lastLine - firstLine) {
            commentText.replaceTextRange(commentText.getOffsetAtLine(i), 0, "%");
            if (i == 0 && selRange.x != this.styledText.getOffsetAtLine(firstLine)) {
                ++commentRange.x;
            } else {
                ++commentRange.y;
            }
            ++i;
        }
        this.ignoreUndo = false;
        this.styledText.replaceTextRange(this.styledText.getOffsetAtLine(firstLine), selRange.y + (selRange.x - this.styledText.getOffsetAtLine(firstLine) + 1), commentText.getText());
        this.styledText.setSelection(commentRange.x, commentRange.x + commentRange.y);
    }

    public void uncomment() {
        Point selRange = this.styledText.getSelectionRange();
        int firstLine = this.styledText.getLineAtOffset(selRange.x);
        int lastLine = this.styledText.getLineAtOffset(selRange.x + selRange.y);
        this.ignoreUndo = true;
        StyledText commentText = new StyledText(this.top, 4);
        commentText.setText(this.styledText.getText(this.styledText.getOffsetAtLine(firstLine), selRange.x + selRange.y));
        Point commentRange = this.styledText.getSelectionRange();
        int i = 0;
        while (i <= lastLine - firstLine) {
            char firstChar = commentText.getText().charAt(commentText.getOffsetAtLine(i));
            if (firstChar == '%') {
                commentText.replaceTextRange(commentText.getOffsetAtLine(i), 1, "");
            }
            if (i == 0 && selRange.x != this.styledText.getOffsetAtLine(firstLine)) {
                --commentRange.x;
            } else {
                --commentRange.y;
            }
            ++i;
        }
        this.ignoreUndo = false;
        this.styledText.replaceTextRange(this.styledText.getOffsetAtLine(firstLine), selRange.y + (selRange.x - this.styledText.getOffsetAtLine(firstLine) + 1), commentText.getText());
        this.styledText.setSelection(commentRange.x, commentRange.x + commentRange.y);
    }

    public void setFocus() {
    }

    public void doSaveAs() {
        String fileName;
        FileDialog dialog = new FileDialog(this.top.getShell(), 8192);
        dialog.setText("Save File");
        dialog.setFilterPath(this.m2mProject.getProperties().getAbsoluteSourceFilename());
        String[] filterExt = new String[]{"*.m"};
        dialog.setFilterExtensions(filterExt);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        if ((path.lastIndexOf(".") == -1 ? "" : path.substring(path.lastIndexOf(".") + 1, path.length())).equalsIgnoreCase(dialog.getFilterExtensions()[dialog.getFilterIndex()].substring(2))) {
            fileName = path;
        } else {
            String filterExtension = dialog.getFilterExtensions()[dialog.getFilterIndex()];
            fileName = String.valueOf(path) + filterExtension.substring(1, filterExtension.length());
        }
        if (!FileUtils.copyFile(this.m2mProject.getProperties().getAbsoluteSourceFilename(), fileName)) {
            return;
        }
        File file = new File(fileName);
        this.m2mProject.getProperties().setSourceFile(file);
        this.setPartName(this.m2mProject.getSourceFile().getName());
        try {
            IFileStore fileStore = EFS.getStore((URI)this.m2mProject.getSourceFile().toURI());
            this.setInput((IEditorInput)new FileStoreEditorInput(fileStore));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.saveProject();
        this.firePropertyChange(257);
    }

    public void doSave() {
        try {
            FileWriter fileWriter = new FileWriter(this.m2mProject.getSourceFile());
            fileWriter.write(this.styledText.getText());
            fileWriter.close();
        }
        catch (IOException iOException) {
            MessageBox messageBox = new MessageBox(this.top.getShell(), 33);
            messageBox.setMessage("File I/O Error.");
            messageBox.setText("Error");
            messageBox.open();
            return;
        }
        this.saveProject();
        this.firePropertyChange(257);
    }

    public void setModified(boolean modif) {
        if (this.m2mProject.isModified() != modif) {
            this.m2mProject.setModified(modif);
            this.firePropertyChange(257);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input != null) {
            this.setSite((IWorkbenchPartSite)site);
            if (input instanceof M2MFileStoreEditorInput) {
                this.m2mProject = ((M2MFileStoreEditorInput)input).getProject();
                this.setPartName(new File(this.m2mProject.getProjectFilename()).getName());
                this.inputFile = this.m2mProject.getSourceFile();
                try {
                    if (this.inputFile != null) {
                        IFileStore fileStore = EFS.getStore((URI)this.inputFile.toURI());
                        this.setInput((IEditorInput)new FileStoreEditorInput(fileStore));
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isDirty() {
        return this.m2mProject.isModified();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public M2MProject getM2MProject() {
        return this.m2mProject;
    }

    public void saveProject() {
        this.m2mProject.save();
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public String getText() {
        return this.styledText.getText();
    }

    public boolean getParseDone() {
        return this.parseDone;
    }

    public void setOptimisationProperties(OptimisationProperties optimProp) {
        this.m2mProject.getProperties().setOptimisationProperties(optimProp);
    }

    public void setSimulationProperties(SimulationProperties simProp) {
        this.m2mProject.getProperties().setSimulationProperties(simProp);
    }

    public void setParseDone(boolean bool) {
        this.parseDone = bool;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int promptToSaveOnClose() {
        MessageDialog dg = new MessageDialog(this.getEditorSite().getShell(), "Math2Mat", null, String.valueOf(this.m2mProject.getSourceFile().getName()) + " has changed, do you want to save changes?", 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        int result = dg.open();
        if (result == 0) {
            this.doSave();
        }
        return result;
    }

    public void doSave(IProgressMonitor monitor) {
    }
}

