/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend.view;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.part.ViewPart;

public class M2MConsole
extends ViewPart {
    public static final String ID = "m2mgui.view.m2mConsole";
    private MessageConsole console;
    private MessageConsoleStream stream;
    private MessageConsoleStream errStream;
    private MessageConsoleStream warStream;
    private TextConsoleViewer consoleViewer;

    public void createPartControl(Composite parent) {
        this.console = new MessageConsole("Console", null, false);
        this.stream = this.console.newMessageStream();
        this.errStream = this.console.newMessageStream();
        this.errStream.setColor(new Color(null, 255, 0, 0));
        this.warStream = this.console.newMessageStream();
        this.warStream.setColor(new Color(null, 0, 0, 255));
        System.setOut(new PrintStream((OutputStream)this.stream, true));
        System.setErr(new PrintStream((OutputStream)this.errStream, true));
        this.consoleViewer = new TextConsoleViewer(parent, (TextConsole)this.console);
        Menu popupMenu = new Menu((Control)this.consoleViewer.getTextWidget());
        MenuItem copyItem = new MenuItem(popupMenu, 8);
        copyItem.setText("Copy\tCtrl+C");
        copyItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                M2MConsole.this.consoleViewer.getTextWidget().copy();
            }
        });
        this.consoleViewer.getTextWidget().setMenu(popupMenu);
        this.consoleViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                StyledText textWidget = M2MConsole.this.consoleViewer.getTextWidget();
                if (textWidget != null) {
                    int lineCount = textWidget.getLineCount();
                    textWidget.setTopIndex(lineCount - 1);
                }
            }
        });
    }

    public void setFocus() {
    }

    public void addText(String text) {
        this.stream.println(text);
    }

    public void clearConsole() {
        this.console.clearConsole();
    }

    public MessageConsoleStream getErrStream() {
        return this.errStream;
    }

    public MessageConsoleStream getwarStream() {
        return this.warStream;
    }

    public void copy() {
        this.consoleViewer.getTextWidget().copy();
    }
}

