/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.buildingblocks;

import java.util.ArrayList;

public abstract class BuildingBlock {
    public boolean useGenericSize() {
        return false;
    }

    public abstract NumType numType();

    public abstract ImplType implType();

    public abstract int version();

    public abstract String author();

    public int latencyTime() {
        return 1;
    }

    public abstract int resources();

    public abstract int period();

    public int cycleTime() {
        return 1;
    }

    public abstract String functionName();

    public abstract String vhdlFileName();

    public abstract ArrayList<String> dependentFiles();

    public abstract String entityName();

    public int nbInputs() {
        return 2;
    }

    public int nbOutputs() {
        return 1;
    }

    public String device() {
        return null;
    }

    public abstract String description();

    public static enum ImplType {
        SEQUENTIAL,
        PIPELINE,
        COMBINATORIAL;

    }

    public static enum NumType {
        FLOAT,
        FLOAT32,
        FLOAT64,
        FIXED,
        INTUINT,
        INT,
        UINT,
        OTHER;


        public static NumType getNum(String text) {
            NumType[] numTypeArray = NumType.values();
            int n = numTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                NumType num = numTypeArray[n2];
                if (text.equalsIgnoreCase(num.name())) {
                    return num;
                }
                ++n2;
            }
            return OTHER;
        }

        public static String getVHDLType(NumType numType) {
            switch (numType) {
                case FLOAT32: {
                    return "std_logic_vector(31 downto 0)";
                }
                case FLOAT64: {
                    return "std_logic_vector(63 downto 0)";
                }
            }
            return "std_logic_vector(31 downto 0)";
        }

        public static int getDataSize(NumType numType) {
            switch (numType) {
                case FLOAT32: {
                    return 32;
                }
                case FLOAT64: {
                    return 64;
                }
            }
            return 32;
        }
    }
}

