/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.buildingblocks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.buildingblocks.BuildingBlockLoader;
import m2m.backend.utils.FileUtils;

public class BuildingBlocksManager {
    private static BuildingBlocksManager instance = null;
    protected String m_dirName = "m2m/backend/buildingblocks/blocks";
    protected String m_packageName = "m2m.backend.buildingblocks.blocks";
    protected ArrayList<BuildingBlock> m_list = new ArrayList();
    protected BuildingBlockLoader m_loader = BuildingBlockLoader.getInstance();

    private BuildingBlocksManager() {
    }

    public static BuildingBlocksManager getInstance() {
        if (instance == null) {
            instance = new BuildingBlocksManager();
        }
        return instance;
    }

    public void setDirName(String dirName) {
        this.m_dirName = dirName;
        this.m_loader.setDir(dirName);
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
        this.m_loader.setPackageName(packageName);
    }

    public String getDirName() {
        return this.m_dirName;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public boolean importFile(String fileName) {
        String className;
        File f = new File(fileName);
        String destFileName = String.valueOf(this.m_dirName) + "/" + f.getName();
        FileUtils.copyFile(fileName, destFileName);
        File destFile = new File(destFileName);
        if (f.getName().endsWith(".java")) {
            this.compileFile(destFileName);
            className = destFile.getName().replace(".java", "");
        } else {
            className = destFile.getName().replace(".class", "");
        }
        return this.load(className);
    }

    public boolean compileFile(String fileName) {
        try {
            String line;
            System.out.println("File to compile: " + fileName);
            ProcessBuilder pb = new ProcessBuilder("javac", fileName);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            int exitCode = p.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()), 50);
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
            if (exitCode != 0) {
                System.out.println("The file " + fileName + " could not be compiled");
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println("Error with the file compilation. Please check that javac is accessible in the current Path");
            return false;
        }
        return true;
    }

    public boolean load(BuildingBlockLoader loader, String fileName) {
        String className = fileName;
        className = className.replaceFirst(".class", "");
        try {
            BuildingBlock block = loader.newInstance(className);
            System.out.println("--------------------------------------");
            System.out.println("Adding a new building block:");
            System.out.println("Function name :" + block.functionName());
            System.out.println("Entity name   :" + block.entityName());
            System.out.println("Author        :" + block.author());
            System.out.println("Description   :" + block.description());
            System.out.println("--------------------------------------");
            this.addBuildingBlock(block);
            return true;
        }
        catch (Exception e) {
            System.out.println("Caught exception for class " + className + ": " + e);
            return false;
        }
    }

    public boolean load(String fileName) {
        if (this.m_loader != null) {
            return this.load(this.m_loader, fileName);
        }
        this.m_loader = BuildingBlockLoader.getInstance();
        return this.load(this.m_loader, fileName);
    }

    public boolean compileAll() {
        File dir = new File(this.m_dirName);
        File[] files = dir.listFiles(new JavaFilter());
        boolean ok = true;
        int i = 0;
        while (i < files.length) {
            try {
                ok &= this.compileFile(files[i].getCanonicalPath());
            }
            catch (IOException iOException) {
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    public boolean loadAll() {
        File dir = new File(this.m_dirName);
        System.out.println("Load blocks from folder: " + dir.getAbsolutePath());
        File[] files = dir.listFiles(new ClassFilter());
        if (files == null) {
            return false;
        }
        int i = 0;
        while (i < files.length) {
            this.load(files[i].getName());
            ++i;
        }
        return true;
    }

    public void addBuildingBlock(BuildingBlock block) {
        this.m_list.add(block);
    }

    public List<BuildingBlock> blockNamed(String functionName) {
        ArrayList<BuildingBlock> res = new ArrayList<BuildingBlock>();
        for (BuildingBlock block : this.m_list) {
            if (!block.functionName().equals(functionName)) continue;
            res.add(block);
        }
        return res;
    }

    public boolean isABlock(String functionName) {
        for (BuildingBlock block : this.m_list) {
            if (!block.functionName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    class ClassFilter
    implements FileFilter {
        ClassFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            try {
                return pathname.getCanonicalPath().endsWith(".class");
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    class JavaFilter
    implements FileFilter {
        JavaFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            try {
                return pathname.getCanonicalPath().endsWith(".java");
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }
}

