/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.octaveparser;

import java.util.Vector;

public class ReadWriteIndex {
    private int writeIndex;
    private Vector<Integer> readIndex;
    private int diff;

    public ReadWriteIndex() {
        this.writeIndex = 1;
        this.readIndex = new Vector();
        this.diff = 0;
    }

    public ReadWriteIndex(ReadWriteIndex rwi) {
        this.writeIndex = rwi.writeIndex;
        this.readIndex = new Vector<Integer>(rwi.readIndex);
        this.diff = 0;
    }

    public ReadWriteIndex getNextVariable() {
        this.readIndex.setElementAt(this.writeIndex, this.readIndex.size() - 1);
        ++this.writeIndex;
        return this;
    }

    public ReadWriteIndex getPreviousVariable() {
        --this.writeIndex;
        this.readIndex.setElementAt(this.writeIndex - 1, this.readIndex.size() - 1);
        return this;
    }

    public void addReadIndex() {
        if (this.readIndex.size() == 0) {
            this.readIndex.add(0);
        } else {
            this.readIndex.add(this.readIndex.lastElement());
        }
    }

    public void removeReadIndex() {
        if (this.readIndex.size() > 1) {
            this.readIndex.remove(this.readIndex.size() - 1);
        }
    }

    public int getReadIndex() {
        if (this.readIndex.size() == 0) {
            this.readIndex.add(0);
        }
        return this.readIndex.lastElement();
    }

    public int getReadIndexSize() {
        return this.readIndex.size();
    }

    public int getWriteIndex() {
        return this.writeIndex;
    }

    public void setDiff(int value) {
        this.diff = value;
    }

    public int getDiff() {
        return this.diff;
    }
}

