/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.processing;

public class Errors {
    private static Errors lastError = new Errors();
    private ErrorNum errorNum;
    private String message;

    public static Errors lastError() {
        return lastError;
    }

    public ErrorNum getNum() {
        return this.errorNum;
    }

    public String errorMessage() {
        switch (this.errorNum) {
            case QUESTALICENSE: {
                return "Can not find QuestaSim license. Please check your license.";
            }
            case QUESTANOTFOUND: {
                return "Can not find vsim, the executable of QuestaSim. Please check the external tools properties.";
            }
            case OCTAVENOTFOUND: {
                return "Can not find Octave. Please check the external tools properties.";
            }
            case ISENOTFOUND: {
                return "Can not find Xilinx tools. Please check the external tools properties.";
            }
            case UBIDULECONNECTIONERROR: {
                return "Can not connect to Ubidule. Please check the connection.";
            }
            case DOTNOTFOUND: {
                return "Can not find dot tool. Please check the external tools properties.";
            }
            case OCTAVEGEN: {
                return "Can not run Octave generation. Please save the projet before launching octave generation.";
            }
            case DIVERSE: {
                return this.message;
            }
        }
        return "Strange error...";
    }

    public static void setLastError(ErrorNum error) {
        Errors.lastError.errorNum = error;
    }

    public static void setLastErrorMessage(String mess) {
        Errors.lastError.message = mess;
        Errors.lastError.errorNum = ErrorNum.DIVERSE;
    }

    public static void clearError() {
        Errors.lastError.errorNum = ErrorNum.NOERROR;
    }

    public static enum ErrorNum {
        NOERROR,
        OCTAVELICENSE,
        OCTAVENOTFOUND,
        QUESTALICENSE,
        QUESTANOTFOUND,
        ISENOTFOUND,
        UBIDULECONNECTIONERROR,
        DOTNOTFOUND,
        OCTAVEGEN,
        DIVERSE;

    }
}

