/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.processing;

import java.util.Vector;
import m2m.backend.structure.Addition;
import m2m.backend.structure.Assignment;
import m2m.backend.structure.Element;
import m2m.backend.structure.Operation;
import m2m.backend.structure.StructTreatment;
import m2m.backend.structure.Subtraction;

public class OptimizeOperators {
    private StructTreatment struct;

    public OptimizeOperators(StructTreatment baseStruct) {
        this.struct = baseStruct;
    }

    public void optimise() {
        this.optimiseAddSub(this.struct.getTop().getBody());
    }

    private int optimiseAddSub(Vector<Element> inputs) {
        int i = 0;
        while (i < inputs.size()) {
            if (inputs.elementAt(i) instanceof Addition || inputs.elementAt(i) instanceof Subtraction) {
                Vector<Element> inputs2 = ((Operation)inputs.elementAt(i)).getInput();
                int j = 0;
                while (j < inputs2.size()) {
                    if (inputs2.elementAt(j) instanceof Addition || inputs2.elementAt(j) instanceof Subtraction) {
                        Vector<Element> inputs3 = ((Operation)inputs2.elementAt(j)).getInput();
                        int k = 0;
                        while (k < inputs3.size()) {
                            if (inputs3.elementAt(k) instanceof Addition || inputs3.elementAt(k) instanceof Subtraction) {
                                Element input;
                                Element output = ((Operation)inputs.elementAt(i)).getOutput().firstElement();
                                if (k > 0) {
                                    input = inputs3.elementAt(0);
                                    ((Operation)inputs2.elementAt(j)).setInputAt(0, inputs.elementAt(i));
                                } else {
                                    input = inputs3.elementAt(1);
                                    ((Operation)inputs2.elementAt(j)).setInputAt(1, inputs.elementAt(i));
                                }
                                try {
                                    ((Operation)inputs2.elementAt(j)).addOutput(output);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    System.err.println(e.getMessage());
                                }
                                inputs.setElementAt(inputs2.elementAt(j), i);
                                if (k > 0) {
                                    ((Operation)((Operation)inputs2.elementAt(j)).getInputAt(0)).getOutput().removeElementAt(0);
                                    ((Operation)((Operation)inputs2.elementAt(j)).getInputAt(0)).setInputAt(j, input);
                                } else {
                                    ((Operation)((Operation)inputs2.elementAt(j)).getInputAt(0)).getOutput().removeElementAt(0);
                                    ((Operation)((Operation)inputs2.elementAt(j)).getInputAt(1)).setInputAt(j, input);
                                }
                                return 1;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return 0;
    }

    public int opTreeDepth() {
        int depth = 0;
        Vector<Element> elements = this.struct.getTop().getBody();
        int i = 0;
        while (i < elements.size()) {
            if (elements.elementAt(i) instanceof Operation && !(elements.elementAt(i) instanceof Assignment)) {
                depth = this.treeDepth(elements.elementAt(i));
            }
            ++i;
        }
        System.out.println("profondeur de l'arbre : " + depth);
        return depth;
    }

    public int treeDepth(Element el) {
        int depth = 0;
        int subDepth = 0;
        if (el instanceof Operation) {
            Operation op = (Operation)el;
            depth = 1;
            int i = 0;
            while (i < op.getNbInput()) {
                subDepth = Math.max(subDepth, this.treeDepth(op.getInputAt(i)));
                ++i;
            }
            depth += subDepth;
        }
        return depth;
    }
}

