/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.processing;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.project.ExternalToolsProperties;
import m2m.backend.project.M2MProject;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.SimpleVariable;
import m2m.backend.utils.FileUtils;

public class SystemVerilogCreator {
    private Function top;

    public SystemVerilogCreator(Function top) {
        this.top = top;
    }

    public boolean createSystemVerilog(M2MProject project) {
        FileUtils.copyFile(new File(String.valueOf(M2MProject.getLibPath()) + "/SV/").getAbsolutePath(), project.getSVPath(), ".svn");
        String harnessName = String.valueOf(project.getSVPath()) + "/M2M_harness.sv";
        String commonName = String.valueOf(project.getSVPath()) + "/common.sv";
        File harnessFile = new File(harnessName);
        File commonFile = new File(commonName);
        int instanceIndex = 0;
        instanceIndex = this.findString("<instance DUT>", harnessFile);
        if (instanceIndex == -1) {
            return false;
        }
        String instance = this.instanceDUT();
        this.writeFile(instanceIndex, instance, harnessFile);
        String constants = this.createConstants(project);
        try {
            FileWriter fw = new FileWriter(commonFile);
            fw.write(constants);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private String createConstants(M2MProject project) {
        String sConstants = new String();
        sConstants = String.valueOf(sConstants) + "`define NUMBER_BIT_PRECISION " + project.getProperties().getSimulationProperties().getSimulationCalcPrecision() + "\n";
        sConstants = String.valueOf(sConstants) + "`define INACTIVITY_TIMEOUT " + project.getProperties().getSimulationProperties().getInactivityTimeout() + "\n";
        sConstants = String.valueOf(sConstants) + "`define SYSTEM_FREQ " + project.getProperties().getSimulationProperties().getSystemFrequency() + "\n";
        sConstants = String.valueOf(sConstants) + "`define INPUT_FREQ " + project.getProperties().getSimulationProperties().getInputFrequency() + "\n";
        sConstants = String.valueOf(sConstants) + "`define OUTPUT_FREQ " + project.getProperties().getSimulationProperties().getOutputFrequency() + "\n";
        sConstants = String.valueOf(sConstants) + "`define M2M_BUS_SIZE " + BuildingBlock.NumType.getDataSize(project.getOptimisationProperties().getOptimisationDataType()) + "\n\n";
        sConstants = String.valueOf(sConstants) + "`define CLOCK_TICKS 10\n\n";
        sConstants = String.valueOf(sConstants) + "`define NUMBER_OF_INPUTS " + this.top.getInput().size() + "\n";
        sConstants = String.valueOf(sConstants) + "`define NUMBER_OF_DUT_INPUTS " + this.top.getInput().size() + "\n";
        sConstants = String.valueOf(sConstants) + "`define READ_INPUT_WAY 1\n";
        sConstants = String.valueOf(sConstants) + "bit INPUT_PARALLEL [1:`NUMBER_OF_INPUTS] = '{";
        int i = 0;
        while (i < this.top.getInput().size()) {
            sConstants = i == 0 ? String.valueOf(sConstants) + "0" : String.valueOf(sConstants) + ", 0";
            ++i;
        }
        sConstants = String.valueOf(sConstants) + "};\n\n";
        sConstants = String.valueOf(sConstants) + "`define NUMBER_OF_OUTPUTS " + this.top.getOutput().size() + "\n";
        sConstants = String.valueOf(sConstants) + "`define NUMBER_OF_DUT_OUTPUTS " + this.top.getOutput().size() + "\n";
        sConstants = String.valueOf(sConstants) + "`define READ_OUTPUT_WAY 1\n";
        sConstants = String.valueOf(sConstants) + "bit OUTPUT_PARALLEL [1:`NUMBER_OF_OUTPUTS] = '{";
        i = 0;
        while (i < this.top.getOutput().size()) {
            sConstants = i == 0 ? String.valueOf(sConstants) + "0" : String.valueOf(sConstants) + ", 0";
            ++i;
        }
        sConstants = String.valueOf(sConstants) + "};\n\n";
        sConstants = String.valueOf(sConstants) + "`define NUMBER_OF_INTERNALS " + this.top.getMonitoringElement().size() + "\n";
        sConstants = String.valueOf(sConstants) + "`define NUMBER_OF_DUT_INTERNALS " + this.top.getMonitoringElement().size() + "\n";
        sConstants = String.valueOf(sConstants) + "`define READ_INTERNAL_WAY 1\n";
        sConstants = String.valueOf(sConstants) + "bit INTERNAL_PARALLEL [1:`NUMBER_OF_INTERNALS]";
        if (this.top.getMonitoringElement().size() != 0) {
            sConstants = String.valueOf(sConstants) + " = '{";
            i = 0;
            while (i < this.top.getMonitoringElement().size()) {
                sConstants = i == 0 ? String.valueOf(sConstants) + "0" : String.valueOf(sConstants) + ", 0";
                ++i;
            }
            sConstants = String.valueOf(sConstants) + "}";
        }
        sConstants = String.valueOf(sConstants) + ";\n";
        return sConstants;
    }

    private String instanceDUT() {
        Element el;
        String sInstance = new String();
        sInstance = String.valueOf(sInstance) + this.top.getName() + " DUT(\n";
        sInstance = String.valueOf(sInstance) + this.tab(1) + ".clock_i" + this.tab(1) + "(CLK),\n";
        sInstance = String.valueOf(sInstance) + this.tab(1) + ".reset_i" + this.tab(1) + "(reset),\n";
        int i = 0;
        while (i < this.top.getInput().size()) {
            el = this.top.getInput().get(i);
            if (el.getName().isEmpty()) {
                System.err.println("No name found for the DUT input n\u00ef\u00bf\u00bd" + (i + 1));
            }
            sInstance = String.valueOf(sInstance) + this.tab(1) + "." + el.getName() + "_i" + this.tab(1) + "(M2M_in_intf.Input_Value[" + (i + 1) + "]),\n";
            sInstance = String.valueOf(sInstance) + this.tab(1) + "." + el.getName() + "_Valid_i" + this.tab(1) + "(M2M_in_intf.Input_Valid[" + (i + 1) + "]),\n";
            sInstance = String.valueOf(sInstance) + this.tab(1) + "." + el.getName() + "_Ready_o" + this.tab(1) + "(M2M_in_intf.Input_Ready[" + (i + 1) + "]),\n";
            ++i;
        }
        i = 0;
        while (i < this.top.getOutput().size()) {
            sInstance = String.valueOf(sInstance) + this.tab(1) + "." + this.top.getOutput().get(i).getName() + "_o" + this.tab(1) + "(M2M_out_intf.Result[" + (i + 1) + "]),\n";
            sInstance = String.valueOf(sInstance) + this.tab(1) + "." + this.top.getOutput().get(i).getName() + "_Valid_o" + this.tab(1) + "(M2M_out_intf.Result_Valid[" + (i + 1) + "]),\n";
            sInstance = i == this.top.getOutput().size() - 1 ? String.valueOf(sInstance) + this.tab(1) + "." + this.top.getOutput().get(i).getName() + "_Ready_i" + this.tab(1) + "(M2M_in_intf.Result_Ready[" + (i + 1) + "])\n" : String.valueOf(sInstance) + this.tab(1) + "." + this.top.getOutput().get(i).getName() + "_Ready_i" + this.tab(1) + "(M2M_in_intf.Result_Ready[" + (i + 1) + "]),\n";
            ++i;
        }
        sInstance = String.valueOf(sInstance) + ");\n";
        if (ExternalToolsProperties.getReference().getSimulator() >= 2) {
            i = 0;
            while (i < this.top.getMonitoringElement().size()) {
                el = this.top.getMonitoringElement().get(i);
                if (((SimpleVariable)el).getType().equalsIgnoreCase("cond")) {
                    sInstance = String.valueOf(sInstance) + this.tab(1) + "initial begin\n";
                    sInstance = String.valueOf(sInstance) + this.tab(2) + "$init_signal_spy(\"DUT/" + el.getName() + "_s\"\t\t\t\t, \"" + "Internal_Data[" + (i + 1) + "][0]\" ,1,1);\n";
                    sInstance = String.valueOf(sInstance) + this.tab(2) + "$init_signal_spy(\"DUT/" + el.getName() + "_Ready_s\"\t\t\t, \"" + "Internal_Data_Ready[" + (i + 1) + "]\" ,1,1);\n";
                    sInstance = String.valueOf(sInstance) + this.tab(2) + "$init_signal_spy(\"DUT/" + el.getName() + "_Valid_s\"\t\t\t, \"" + "Internal_Data_Valid[" + (i + 1) + "]\",1,1);\n";
                    sInstance = String.valueOf(sInstance) + this.tab(1) + "end\n\n";
                    sInstance = String.valueOf(sInstance) + this.tab(1) + "assign M2M_int_intf.Data[" + (i + 1) + "]         = Internal_Data[" + (i + 1) + "][0];\n";
                } else {
                    sInstance = String.valueOf(sInstance) + this.tab(1) + "initial begin\n";
                    sInstance = String.valueOf(sInstance) + this.tab(2) + "$init_signal_spy(\"DUT/" + el.getName() + "_s\"\t\t\t\t, \"" + "Internal_Data[" + (i + 1) + "]\" ,1,1);\n";
                    sInstance = String.valueOf(sInstance) + this.tab(2) + "$init_signal_spy(\"DUT/" + el.getName() + "_Ready_s\"\t\t\t, \"" + "Internal_Data_Ready[" + (i + 1) + "]\" ,1,1);\n";
                    sInstance = String.valueOf(sInstance) + this.tab(2) + "$init_signal_spy(\"DUT/" + el.getName() + "_Valid_s\"\t\t\t, \"" + "Internal_Data_Valid[" + (i + 1) + "]\",1,1);\n";
                    sInstance = String.valueOf(sInstance) + this.tab(1) + "end\n\n";
                    sInstance = String.valueOf(sInstance) + this.tab(1) + "assign M2M_int_intf.Data[" + (i + 1) + "]         = Internal_Data[" + (i + 1) + "];\n";
                }
                ++i;
            }
            sInstance = String.valueOf(sInstance) + this.tab(1) + "assign M2M_int_intf.Data_Ready   = Internal_Data_Ready;\n";
            sInstance = String.valueOf(sInstance) + this.tab(1) + "assign M2M_int_intf.Data_Valid   = Internal_Data_Valid;\n";
        } else {
            i = 0;
            while (i < this.top.getMonitoringElement().size()) {
                el = this.top.getMonitoringElement().get(i);
                sInstance = String.valueOf(sInstance) + this.tab(1) + "assign " + "M2M_int_intf.mon_mp.Data[" + (i + 1) + "]\t\t\t = " + "DUT." + el.getName() + "_s;\n";
                sInstance = String.valueOf(sInstance) + this.tab(1) + "assign " + "M2M_int_intf.mon_mp.Data_Ready[" + (i + 1) + "]\t = " + "DUT." + el.getName() + "_Ready_s" + ";\n";
                sInstance = String.valueOf(sInstance) + this.tab(1) + "assign " + "M2M_int_intf.mon_mp.Data_Valid[" + (i + 1) + "]\t = " + "DUT." + el.getName() + "_Valid_s" + ";\n";
                ++i;
            }
        }
        return sInstance;
    }

    private void writeFile(int instanceIndex, String instance, File file) {
        try {
            int readChar;
            FileReader fr = new FileReader(file);
            String beginOfFile = new String();
            String endOfFile = new String();
            int i = 0;
            while (i <= instanceIndex) {
                beginOfFile = String.valueOf(beginOfFile) + (char)fr.read();
                ++i;
            }
            while ((readChar = fr.read()) != -1) {
                endOfFile = String.valueOf(endOfFile) + (char)readChar;
            }
            FileWriter fw = new FileWriter(file);
            fw.write(beginOfFile);
            fw.write(instance);
            fw.write(endOfFile);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    private int findString(String toFind, File file) {
        String readText = new String();
        try {
            int readChar;
            FileReader fr = new FileReader(file);
            while ((readChar = fr.read()) != -1) {
                readText = String.valueOf(readText) + (char)readChar;
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return readText.indexOf(toFind) + toFind.length();
    }

    private String tab(int nb) {
        String s = new String();
        int i = 0;
        while (i < nb) {
            s = String.valueOf(s) + "\t";
            ++i;
        }
        return s;
    }
}

