/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.project;

import java.util.prefs.Preferences;

public class ExternalToolsProperties {
    private String octavePath;
    private String vsimPath;
    private String isePath;
    private String dotPath;
    private int simulationFiles;
    private int simulator;
    private String ubiduleIP;
    private String xilinxLicense;
    private String libPath;
    public static final int SIMULATIONFILES_OVM = 0;
    public static final int SIMULATIONFILES_M2MOVM = 1;
    public static final int SIMULATIONFILES_UVM = 2;
    public static final String[] simulatorTypes = new String[]{"Questa_older", "Questa_v6.5", "Questa_v6.6", "Questa_younger"};
    private static ExternalToolsProperties externalToolsProperties;

    public static ExternalToolsProperties getReference() {
        if (externalToolsProperties == null) {
            externalToolsProperties = new ExternalToolsProperties();
        }
        return externalToolsProperties;
    }

    private ExternalToolsProperties() {
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        this.vsimPath = prefs.get("VsimPath", "vsim");
        this.octavePath = prefs.get("OctavePath", "octave");
        this.isePath = prefs.get("IsePath", "ise");
        this.dotPath = prefs.get("DotPath", "dot");
        this.simulationFiles = prefs.getInt("SimulationFiles", 1);
        this.simulator = prefs.getInt("Simulator", 2);
        this.ubiduleIP = prefs.get("UbiduleIP", "ip");
        this.xilinxLicense = prefs.get("XilinxLicense", "licence");
        this.libPath = prefs.get("LibPath", "lib");
    }

    protected void finalize() {
    }

    public String getLibPath() {
        return this.libPath;
    }

    public String getXilinxLicense() {
        return this.xilinxLicense;
    }

    public String getUbiduleIP() {
        return this.ubiduleIP;
    }

    public int getSimulationFiles() {
        return this.simulationFiles;
    }

    public int getSimulator() {
        return this.simulator;
    }

    public void setSimulationFiles(int type) {
        this.simulationFiles = type;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("SimulationFiles", String.valueOf(this.simulationFiles));
    }

    public String getOctavePath() {
        if (this.octavePath == null || this.octavePath.isEmpty()) {
            return "octave";
        }
        return this.octavePath;
    }

    public String getVsimPath() {
        if (this.vsimPath == null || this.vsimPath.isEmpty()) {
            return "vsim";
        }
        return this.vsimPath;
    }

    public String getIsePath() {
        if (this.isePath == null || this.isePath.isEmpty()) {
            return "ise";
        }
        return this.isePath;
    }

    public String getDotPath() {
        if (this.dotPath == null || this.dotPath.isEmpty()) {
            return "dot";
        }
        return this.dotPath;
    }

    public void setSimulator(int sim) {
        this.simulator = sim;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("Simulator", String.valueOf(this.simulator));
    }

    public void setLibPath(String path) {
        this.libPath = path;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("LibPath", this.libPath);
    }

    public void setOctavePath(String path) {
        this.octavePath = path;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("OctavePath", this.octavePath);
    }

    public void setVsimPath(String path) {
        this.vsimPath = path;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("VsimPath", this.vsimPath);
    }

    public void setIsePath(String path) {
        this.isePath = path;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("IsePath", this.isePath);
    }

    public void setDotPath(String path) {
        this.dotPath = path;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("DotPath", this.dotPath);
    }

    public void setXilinxLicense(String license) {
        this.xilinxLicense = license;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("XilinxLicense", this.xilinxLicense);
    }

    public void setUbiduleIP(String ip) {
        this.ubiduleIP = ip;
        Preferences prefs = Preferences.userNodeForPackage(ExternalToolsProperties.class);
        prefs.put("UbiduleIP", this.ubiduleIP);
    }

    static enum SimulationFilesType {
        OVM,
        M2MOVM;

    }
}

