/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.project;

import m2m.backend.buildingblocks.BuildingBlocksManager;
import m2m.backend.octaveparser.ParsingException;
import m2m.backend.processing.ExternalRuns;
import m2m.backend.processing.ProgressMonitoring;
import m2m.backend.processing.ProjectsValidator;
import m2m.backend.project.ExternalToolsProperties;
import m2m.backend.project.M2MProject;

public class M2MCmd {
    public static void main(String[] args) {
        String projectFileName = "";
        String testDirName = "";
        String libPath = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].compareTo("-testdir") == 0 && i + 1 < args.length) {
                testDirName = args[i + 1];
            }
            if (args[i].compareTo("-lib") == 0 && i + 1 < args.length) {
                libPath = args[i + 1];
            }
            if (args[i].compareTo("-project") == 0 && i + 1 < args.length) {
                projectFileName = args[i + 1];
            }
            if (args[i].compareTo("-vsim") == 0 && i + 1 < args.length) {
                ExternalToolsProperties.getReference().setVsimPath(args[i + 1]);
            }
            if (args[i].compareTo("-octave") == 0 && i + 1 < args.length) {
                ExternalToolsProperties.getReference().setOctavePath(args[i + 1]);
            }
            if (args[i].compareTo("-ise") == 0 && i + 1 < args.length) {
                ExternalToolsProperties.getReference().setIsePath(args[i + 1]);
            }
            ++i;
        }
        if (!libPath.isEmpty()) {
            ExternalToolsProperties.getReference().setLibPath(libPath);
        }
        String path = String.valueOf(M2MProject.getLibPath()) + "/blocks";
        BuildingBlocksManager.getInstance().setDirName(path);
        BuildingBlocksManager.getInstance().setPackageName("m2m.backend.buildingblocks.blocks");
        BuildingBlocksManager.getInstance().loadAll();
        if (!testDirName.isEmpty()) {
            System.out.println("Test dir");
            ProgressMonitoring monitor = new ProgressMonitoring();
            ProjectsValidator validator = new ProjectsValidator();
            validator.testDir(testDirName, monitor);
            return;
        }
        if (!projectFileName.isEmpty()) {
            M2MProject project = new M2MProject();
            project.openProject(projectFileName);
            try {
                project.getStructTreatment().parse(project.getSourceFile());
                project.getStructTreatment().modifyNumType(project.getProperties().getOptimisationProperties().getOptimisationDataType());
                ExternalRuns.runAll(project);
            }
            catch (ParsingException parsingException) {}
        }
    }
}

