/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.structure.Element;
import m2m.backend.structure.GraphParams;
import m2m.backend.structure.SimpleVariable;
import m2m.backend.structure.StructTreatment;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Function
extends Element {
    protected Vector<Element> inputVars = new Vector();
    protected Vector<Element> outputVars = new Vector();
    protected Vector<Element> internalVars = new Vector();
    protected Vector<Element> body = new Vector();
    protected int maxCost;
    protected int maxRelativeCost;

    @Override
    public void modifyNumType(BuildingBlock.NumType type) {
        for (Element e : this.body) {
            e.modifyNumType(type);
        }
    }

    @Override
    public String getXmlTagName() {
        return "Function";
    }

    public boolean fromXml(org.w3c.dom.Element el) {
        this.insideFromXml(el, this);
        return true;
    }

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        this.name = XMLUtils.getTextValue(el, "Name", "");
        this.monitor = XMLUtils.getBoolValue(el, "Monitor", false);
        if (this.name.isEmpty()) {
            return true;
        }
        Node node = el.getFirstChild();
        while (node != null) {
            Element element;
            Node nodeIn;
            org.w3c.dom.Element inputEl;
            if (node.getNodeName().equalsIgnoreCase("Input") && (inputEl = (org.w3c.dom.Element)node).getFirstChild() != null) {
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.inputVars.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("Output") && (inputEl = (org.w3c.dom.Element)node).getFirstChild() != null) {
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.outputVars.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("Internals") && (inputEl = (org.w3c.dom.Element)node).getFirstChild() != null) {
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.internalVars.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            if (node.getNodeName().equalsIgnoreCase("Body") && (inputEl = (org.w3c.dom.Element)node).getFirstChild() != null) {
                nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, this)) != null) {
                        this.body.add(element);
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        return false;
    }

    public void superInsideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        super.insideToXml(el, dom, shortRef);
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        super.insideToXml(el, dom, shortRef);
        org.w3c.dom.Element inputEl = dom.createElement("Input");
        for (Element e : this.inputVars) {
            inputEl.appendChild(e.toXml(dom, false));
        }
        el.appendChild(inputEl);
        org.w3c.dom.Element outputEl = dom.createElement("Output");
        for (Element e : this.outputVars) {
            outputEl.appendChild(e.toXml(dom, false));
        }
        el.appendChild(outputEl);
        org.w3c.dom.Element statEl = dom.createElement("Internals");
        for (Element e : this.internalVars) {
            statEl.appendChild(e.toXml(dom, false));
        }
        el.appendChild(statEl);
        org.w3c.dom.Element bodyEl = dom.createElement("Body");
        for (Element e : this.body) {
            bodyEl.appendChild(e.toXml(dom, true));
        }
        el.appendChild(bodyEl);
    }

    @Override
    public Element copy(Function newFunc) {
        Function fcopy = new Function();
        this.copyTo(fcopy, fcopy);
        return fcopy;
    }

    @Override
    public void copyTo(Element to, Function newFunc) {
        Function fcopy = (Function)to;
        super.copyTo(fcopy, newFunc);
        for (Element e : this.inputVars) {
            fcopy.inputVars.add(e.copy(newFunc));
        }
        for (Element e : this.outputVars) {
            fcopy.outputVars.add(e.copy(newFunc));
        }
        for (Element e : this.internalVars) {
            fcopy.internalVars.add(e.copy(newFunc));
        }
        for (Element e : this.body) {
            fcopy.body.add(e.copy(fcopy));
        }
    }

    @Override
    public Element findElement(String name) {
        for (Element e : this.inputVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.outputVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.internalVars) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        for (Element e : this.body) {
            if (e.findElement(name) == null) continue;
            return e.findElement(name);
        }
        return null;
    }

    public void modifAllNames(String prefix) {
        this.setName(String.valueOf(prefix) + this.getName());
        for (Element e : this.inputVars) {
            e.setName(String.valueOf(prefix) + e.getName());
        }
        for (Element e : this.outputVars) {
            e.setName(String.valueOf(prefix) + e.getName());
        }
        for (Element e : this.internalVars) {
            e.setName(String.valueOf(prefix) + e.getName());
        }
        for (Element e : this.body) {
            e.setName(String.valueOf(prefix) + e.getName());
        }
    }

    public void addInput(Element var) {
        this.inputVars.add(var);
    }

    public void setInput(Vector<Element> in) {
        this.inputVars = in;
    }

    public Vector<Element> getInput() {
        return this.inputVars;
    }

    public void addOutput(Element var) {
        this.outputVars.add(var);
    }

    public void setOutput(Vector<Element> out) {
        this.outputVars = out;
    }

    public Vector<Element> getOutput() {
        return this.outputVars;
    }

    public void addInternalVar(Element var) {
        this.internalVars.add(var);
    }

    public void setInternalVars(Vector<Element> list) {
        this.internalVars = list;
    }

    public Vector<Element> getInternalVars() {
        return this.internalVars;
    }

    public Vector<Element> getMonitoringElement() {
        LinkedList<Element> tempElementList = new LinkedList<Element>();
        Vector<Element> elementList = new Vector<Element>();
        tempElementList.addAll(this.getBody());
        for (Element e : this.getInternalVars()) {
            if (!e.getMonitor() || elementList.contains(e)) continue;
            elementList.add(e);
        }
        Iterator iterElement = tempElementList.iterator();
        while (iterElement.hasNext()) {
            Element element = (Element)iterElement.next();
            if (element instanceof Function) {
                tempElementList.addAll(((Function)element).getBody());
                for (Element e : ((Function)element).getInternalVars()) {
                    if (!e.getMonitor() || elementList.contains(e)) continue;
                    elementList.add(e);
                }
            }
            tempElementList.remove(tempElementList.indexOf(element));
            iterElement = tempElementList.iterator();
        }
        return elementList;
    }

    public void addBody(Element el) {
        this.body.add(el);
    }

    public void addBody(Vector<Element> vec) {
        this.body.addAll(vec);
    }

    public void addBodyToTop(Element el) {
        this.body.add(0, el);
    }

    public void setBody(Vector<Element> body) {
        this.body = body;
    }

    public Vector<Element> getBody() {
        return this.body;
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[Function]\tName: " + this.name;
        s = String.valueOf(s) + "\n" + this.toStringParam(level + 1);
        s = String.valueOf(s) + "\n" + this.tab(level) + ">>==========<<";
        for (Element el : this.body) {
            s = String.valueOf(s) + "\n" + el.toString(level + 1);
        }
        return s;
    }

    protected String toStringParam(int level) {
        String s = new String();
        boolean first = true;
        if (!this.inputVars.isEmpty()) {
            first = false;
            s = String.valueOf(s) + this.tab(level) + "Input:";
            for (Element el : this.inputVars) {
                s = String.valueOf(s) + "\n" + el.toString(level + 1);
            }
        }
        if (!this.outputVars.isEmpty()) {
            if (!first) {
                s = String.valueOf(s) + "\n";
            }
            first = false;
            s = String.valueOf(s) + this.tab(level) + "Output:";
            for (Element el : this.outputVars) {
                s = String.valueOf(s) + "\n" + el.toString(level + 1);
            }
        }
        if (!this.internalVars.isEmpty()) {
            if (!first) {
                s = String.valueOf(s) + "\n";
            }
            first = false;
            s = String.valueOf(s) + this.tab(level) + "Internal:";
            for (Element el : this.internalVars) {
                s = String.valueOf(s) + "\n" + el.toString(level + 1);
            }
        }
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        int cpt = 0;
        if (prefix.isEmpty()) {
            prefix = "top";
        }
        if (color.isEmpty()) {
            color = GraphParams.defaultColor;
        }
        s = String.valueOf(s) + this.tab(level) + prefix + "[shape = " + boxFormat + ", label = \"" + this.getName() + "\" color=\"" + color + "\" style=\"filled\"]";
        if (!this.inputVars.isEmpty()) {
            cpt = 0;
            for (Element var : this.inputVars) {
                s = String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_i_" + cpt, GraphParams.inputShape, GraphParams.inputColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_i_" + cpt;
                ++cpt;
            }
        }
        if (!this.outputVars.isEmpty()) {
            cpt = 0;
            for (Element var : this.outputVars) {
                s = String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_o_" + cpt, GraphParams.outputShape, GraphParams.outputColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_o_" + cpt;
                ++cpt;
            }
        }
        if (!this.internalVars.isEmpty()) {
            cpt = 0;
            for (Element var : this.internalVars) {
                s = String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_s_" + cpt, GraphParams.internalShape, GraphParams.internalColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_s_" + cpt;
                ++cpt;
            }
        }
        if (!this.body.isEmpty()) {
            cpt = 0;
            for (Element el : this.body) {
                s = String.valueOf(s) + "\n" + el.toSchematic(level, String.valueOf(prefix) + "_" + cpt, "box", GraphParams.defaultColor);
                s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_" + cpt;
                ++cpt;
            }
        }
        return s;
    }

    @Override
    public String toOctave(int level) {
        boolean first;
        String sOctave = new String();
        sOctave = String.valueOf(sOctave) + this.tab(level) + "function ";
        if (this.outputVars.size() == 1) {
            if (this.outputVars.firstElement() instanceof SimpleVariable) {
                sOctave = String.valueOf(sOctave) + this.outputVars.firstElement().getName();
            }
        } else {
            sOctave = String.valueOf(sOctave) + "[";
            first = true;
            for (Element e : this.outputVars) {
                if (!(e instanceof SimpleVariable)) continue;
                sOctave = String.valueOf(sOctave) + (first ? "" : ", ") + e.getName();
                first = false;
            }
            sOctave = String.valueOf(sOctave) + "]";
        }
        sOctave = String.valueOf(sOctave) + "=" + this.getName() + "(";
        first = true;
        for (Element e : this.inputVars) {
            if (!(e instanceof SimpleVariable)) continue;
            sOctave = String.valueOf(sOctave) + (first ? "" : ", ") + e.getName();
            first = false;
        }
        if (this.getMonitoringElement().size() != 0) {
            sOctave = String.valueOf(sOctave) + ", i_m2m_regen)\n";
            sOctave = String.valueOf(sOctave) + "global interns;\n";
        } else {
            sOctave = String.valueOf(sOctave) + ")\n";
        }
        for (Element e : this.body) {
            sOctave = String.valueOf(sOctave) + e.toOctave(level + 1) + "\n";
        }
        sOctave = String.valueOf(sOctave) + this.tab(level) + "endfunction;";
        return sOctave;
    }

    public boolean isInput(Element element) {
        if (element instanceof SimpleVariable) {
            String trueName = StructTreatment.getTrueName(element.getName());
            for (Element e : this.getInput()) {
                if (!e.getName().equals(trueName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsOuputName(String name) {
        for (Element e : this.outputVars) {
            if (!e.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsInputName(String name) {
        for (Element e : this.outputVars) {
            if (!e.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setMaxCost(int cost) {
        this.maxCost = cost;
    }

    public int getMaxCost() {
        return this.maxCost;
    }

    public void setRelativeMaxCost(int value) {
        this.maxRelativeCost = value + 1;
    }

    public int getRelativeMaxCost() {
        return this.maxRelativeCost;
    }
}

