/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.GraphParams;
import m2m.backend.structure.Operation;
import m2m.backend.structure.SimpleVariable;
import m2m.backend.structure.Variable;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Multiplexer
extends Operation {
    private int size;
    private Variable sel;

    public Multiplexer() {
        super("mux");
    }

    @Override
    public String getXmlTagName() {
        return "Multiplexer";
    }

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        this.size = XMLUtils.getIntValue(el, "SizeMux", 0);
        Node node = el.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equalsIgnoreCase("Sel")) {
                org.w3c.dom.Element inputEl = (org.w3c.dom.Element)node;
                Node nodeIn = inputEl.getFirstChild().getNextSibling();
                while (nodeIn != null) {
                    Element element;
                    if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                        this.sel = (Variable)element;
                    }
                    nodeIn = nodeIn.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
        return false;
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        super.insideToXml(el, dom, shortRef);
        el.appendChild(XMLUtils.createIntElement(dom, "SizeMux", this.size));
        if (this.sel != null) {
            org.w3c.dom.Element selEl = dom.createElement("Sel");
            selEl.appendChild(this.sel.toXml(dom, true));
            el.appendChild(selEl);
        }
    }

    @Override
    public void copyTo(Element e, Function newFunc) {
        Multiplexer mult = (Multiplexer)e;
        mult.size = this.size;
        mult.sel = (Variable)this.sel.copy(newFunc);
        super.copyTo(mult, newFunc);
    }

    @Override
    public Element copy(Function newFunc) {
        Multiplexer mult = new Multiplexer();
        this.copyTo(mult, newFunc);
        return mult;
    }

    public void setSize(int s) {
        this.size = s;
    }

    public int getSize() {
        return this.size;
    }

    public void setSel(Variable var) {
        this.sel = var;
    }

    public Variable getSel() {
        return this.sel;
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[" + this.opName + "]\tName: " + this.name;
        s = String.valueOf(s) + "\n" + this.tab(level + 1) + "Size: " + this.size;
        s = String.valueOf(s) + "\n" + this.tab(level + 1) + "Select: ";
        if (this.sel != null) {
            s = String.valueOf(s) + "\n" + this.sel.toString(level + 2);
        }
        s = String.valueOf(s) + "\n" + this.toStringParam(level + 1);
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        boolean first;
        String s = new String();
        if (prefix.isEmpty()) {
            prefix = "top";
        }
        int cpt = 0;
        s = String.valueOf(s) + this.tab(level) + prefix + "[shape = \"" + boxFormat + "\", label = \"" + (this.generic ? "fun_" : "") + this.opName + " : " + this.getName() + "\" color=\"" + color + "\" style=\"filled\"]";
        if (this.sel != null) {
            s = String.valueOf(s) + this.sel.toSchematic(level, String.valueOf(prefix) + "_sel_" + cpt, GraphParams.selShape, GraphParams.selColor);
            s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_sel_" + cpt + " [label = \"Sel\"]";
            ++cpt;
        }
        if (!this.input.isEmpty()) {
            cpt = 0;
            first = true;
            for (Element var : this.input) {
                s = var instanceof Variable ? String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_in_" + cpt, GraphParams.inputShape, GraphParams.inputColor) : String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_in_" + cpt, boxFormat, GraphParams.defaultColor);
                if (first) {
                    s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_in_" + cpt;
                    first = false;
                } else {
                    s = String.valueOf(s) + "\n" + this.tab(level) + prefix + "_in_" + (cpt - 1) + " -> " + prefix + "_in_" + cpt;
                    first = false;
                }
                ++cpt;
            }
        }
        if (!this.output.isEmpty()) {
            cpt = 0;
            first = true;
            for (Element var : this.output) {
                s = var instanceof Variable ? String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_out_" + cpt, GraphParams.outputShape, GraphParams.outputColor) : String.valueOf(s) + var.toSchematic(level, String.valueOf(prefix) + "_out_" + cpt, boxFormat, GraphParams.defaultColor);
                if (first) {
                    s = String.valueOf(s) + "\n" + this.tab(level) + prefix + " -> " + prefix + "_out_" + cpt;
                    first = false;
                } else {
                    s = String.valueOf(s) + "\n" + this.tab(level) + prefix + "_out_" + (cpt - 1) + " -> " + prefix + "_out_" + cpt;
                    first = false;
                }
                ++cpt;
            }
        }
        return s;
    }

    @Override
    public String toOctave(int level) {
        String sOctave = new String();
        Element out = (Element)this.output.firstElement();
        sOctave = String.valueOf(sOctave) + this.tab(level) + "switch " + this.sel.getName() + "\n";
        int i = 0;
        while (i < this.size - 1) {
            sOctave = String.valueOf(sOctave) + this.tab(level + 1) + "case " + i + "\n";
            sOctave = String.valueOf(sOctave) + this.tab(level + 2) + out.getName() + "=" + ((Element)this.input.elementAt(i)).getName();
            if (!this.monitor) {
                sOctave = String.valueOf(sOctave) + ";";
            }
            if (out instanceof SimpleVariable & out.monitor) {
                sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 2) + "for j_m2m_regen=1:length(interns)";
                sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 3) + "if(length(interns(j_m2m_regen).sname) == length(\"" + out.getName() + "\") && interns(j_m2m_regen).sname == \"" + out.getName() + "\")";
                sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 4) + "interns(j_m2m_regen).values(i_m2m_regen,:) = " + out.getName() + ";";
                sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 3) + "endif";
                sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 2) + "endfor\n";
            }
            ++i;
        }
        sOctave = String.valueOf(sOctave) + this.tab(level + 1) + "otherwise";
        sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 2) + out.getName() + "=" + ((Element)this.input.elementAt(this.size - 1)).getName();
        if (!this.monitor) {
            sOctave = String.valueOf(sOctave) + ";";
        }
        if (out instanceof SimpleVariable & out.monitor) {
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 2) + "for j_m2m_regen=1:length(interns)";
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 3) + "if(length(interns(j_m2m_regen).sname) == length(\"" + out.getName() + "\") && interns(j_m2m_regen).sname == \"" + out.getName() + "\")";
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 4) + "interns(j_m2m_regen).values(i_m2m_regen,:) = " + out.getName() + ";";
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 3) + "endif";
            sOctave = String.valueOf(sOctave) + "\n" + this.tab(level + 2) + "endfor\n";
        }
        sOctave = String.valueOf(sOctave) + this.tab(level) + "end";
        return sOctave;
    }
}

