/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.octaveparser.OctaveLexer;
import m2m.backend.octaveparser.OctaveParser;
import m2m.backend.octaveparser.ParsingException;
import m2m.backend.octaveparser.ReadWriteIndex;
import m2m.backend.project.ProjectRef;
import m2m.backend.structure.Assignment;
import m2m.backend.structure.Case;
import m2m.backend.structure.DotDivision;
import m2m.backend.structure.DotMultiplication;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.GraphParams;
import m2m.backend.structure.IfThenElse;
import m2m.backend.structure.LoopFor;
import m2m.backend.structure.LoopWhile;
import m2m.backend.structure.Multiplexer;
import m2m.backend.structure.Negation;
import m2m.backend.structure.Not;
import m2m.backend.structure.Operation;
import m2m.backend.structure.SimpleVariable;
import m2m.backend.structure.Switch;
import m2m.backend.structure.Variable;
import m2m.backend.structure.VectorVariable;
import m2m.backend.utils.FileUtils;
import m2m.backend.utils.XMLUtils;
import m2m.backend.vhdl.VHDLCreator;
import m2m.backend.vhdl.VHDLException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class StructTreatment
extends ProjectRef {
    private int tmpCpt = 0;
    private int opCpt = 0;
    private Function top = null;
    private Vector<String> negList = new Vector();
    private HashMap<String, String> pragmaMap = new HashMap();
    private HashMap<String, SimpleVariable> varMap = new HashMap();
    public static final String TMP_NAME = "m2mtmp";
    private int nbMonitor = 0;
    private long parseTime;
    private String sourceMd5;
    private String sourceCode;

    public StructTreatment copy() {
        StructTreatment clone = new StructTreatment();
        clone.tmpCpt = this.tmpCpt;
        clone.opCpt = this.opCpt;
        clone.top = new Function();
        clone.top = (Function)this.top.copy(null);
        clone.negList = (Vector)this.negList.clone();
        clone.pragmaMap = (HashMap)this.pragmaMap.clone();
        clone.varMap = (HashMap)this.varMap.clone();
        clone.nbMonitor = this.nbMonitor;
        return clone;
    }

    public void modifyNumType(BuildingBlock.NumType type) {
        this.top.modifyNumType(type);
    }

    public long getParseTime() {
        return this.parseTime;
    }

    public void setTop(Function top) {
        this.top = top;
    }

    public Function getTop() {
        return this.top;
    }

    public Vector<Element> getInput() {
        return this.top.getInput();
    }

    public Vector<Element> getOutput() {
        return this.top.getOutput();
    }

    public String getName() {
        return this.top.getName();
    }

    public void parse(File file) throws ParsingException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file.getPath());
        }
        catch (FileNotFoundException e) {
            System.out.println("Le fichier n'existe pas!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        OctaveLexer lexer = new OctaveLexer(in);
        OctaveParser parser = new OctaveParser(lexer);
        this.top = new Function();
        parser.setTop(this.top);
        parser.setTreat(this);
        try {
            parser.entry();
            if (!parser.isSuccessful()) {
                throw new ParsingException("Parsing error");
            }
            this.treeToVector();
            this.postParse(this.top);
            Calendar cal = Calendar.getInstance();
            this.parseTime = cal.getTime().getTime();
            this.modifyNumType(this.project.getOptimisationProperties().getOptimisationDataType());
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
        this.sourceMd5 = FileUtils.getMd5(file.getAbsolutePath());
        this.sourceCode = FileUtils.readFileAsString(file.getAbsolutePath());
    }

    public void parseNoFlat(File file) throws ParsingException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file.getPath());
        }
        catch (FileNotFoundException e) {
            System.out.println("Le fichier n'existe pas!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        OctaveLexer lexer = new OctaveLexer(in);
        OctaveParser parser = new OctaveParser(lexer);
        this.top = new Function();
        parser.setTop(this.top);
        parser.setTreat(this);
        try {
            parser.entry();
            if (!parser.isSuccessful()) {
                throw new ParsingException("Parsing error");
            }
            this.postParse(this.top);
            Calendar cal = Calendar.getInstance();
            this.parseTime = cal.getTime().getTime();
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
        this.sourceMd5 = FileUtils.getMd5(file.getAbsolutePath());
        this.sourceCode = FileUtils.readFileAsString(file.getAbsolutePath());
    }

    public String getSourceMd5() {
        return this.sourceMd5;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void parse(String code) throws ParsingException {
        ByteArrayInputStream in = null;
        in = new ByteArrayInputStream(code.getBytes());
        OctaveLexer lexer = new OctaveLexer(in);
        OctaveParser parser = new OctaveParser(lexer);
        this.top = new Function();
        parser.setTop(this.top);
        parser.setTreat(this);
        try {
            parser.entry();
            if (!parser.isSuccessful()) {
                throw new ParsingException("Parsing error");
            }
            this.treeToVector();
            this.postParse(this.top);
            Calendar cal = Calendar.getInstance();
            this.parseTime = cal.getTime().getTime();
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
        this.sourceMd5 = FileUtils.getStringMd5(code);
        this.sourceCode = code;
    }

    public Vector<Element> createOp(Vector<Element> a, Vector<Element> b, Operation op) {
        Vector<Element> vec = new Vector<Element>();
        vec.addAll(a);
        vec.remove(vec.lastIndexOf(a.lastElement()));
        if (a.lastElement() instanceof Negation) {
            vec.add(a.lastElement());
            op.addInput(((Negation)a.lastElement()).getOutputAt(0));
        } else {
            op.addInput(a.lastElement());
        }
        vec.addAll(b);
        vec.remove(vec.lastIndexOf(b.lastElement()));
        if (b.lastElement() instanceof Negation) {
            vec.add(b.lastElement());
            op.addInput(((Negation)b.lastElement()).getOutputAt(0));
        } else {
            op.addInput(b.lastElement());
        }
        op.setName(String.valueOf(op.getName()) + this.getNextOpCpt());
        vec.add(op);
        if (op instanceof DotDivision || op instanceof DotMultiplication) {
            for (Element e : op.getInput()) {
                if (!(e instanceof Variable)) continue;
                this.addPragma(StructTreatment.getTrueName(e.getName()), "vector");
            }
        }
        return vec;
    }

    public Vector<Element> createNot(Vector<Element> a, Not not) {
        Vector<Element> vec = new Vector<Element>();
        vec.addAll(a);
        vec.remove(vec.lastIndexOf(a.lastElement()));
        if (a.lastElement() instanceof Negation) {
            vec.add(a.lastElement());
            not.addInput(((Operation)a.lastElement()).getOutputAt(0));
        } else {
            not.addInput(a.lastElement());
        }
        not.setName(String.valueOf(not.getName()) + this.getNextOpCpt());
        vec.add(not);
        return vec;
    }

    public int getNextOpCpt() {
        return this.opCpt++;
    }

    public void treeToVector() {
        this.treeToVector(this.top);
    }

    public void treeToVector(Function parent) {
        parent.setBody(this.convertBody(parent.getBody(), parent));
        if (parent instanceof LoopWhile) {
            ((LoopWhile)parent).setCond(this.convertBody(((LoopWhile)parent).getCond(), parent));
        }
    }

    private Vector<Element> convertBody(Vector<Element> vec, Element parent) {
        Vector<Element> newel = new Vector<Element>();
        if (vec == null || vec.isEmpty()) {
            return vec;
        }
        for (Element e : vec) {
            if (e instanceof Operation) {
                newel.addAll(this.convertOperation((Operation)e, parent));
                continue;
            }
            if (e instanceof Switch) {
                Switch sw = (Switch)parent;
                for (Case c : sw.getCases()) {
                    c.setBody(this.convertBody(c.getBody(), parent));
                }
                continue;
            }
            if (e instanceof IfThenElse) {
                newel.add(e);
                IfThenElse ite = (IfThenElse)e;
                ite.setBodyTrue(this.convertBody(ite.getBodyTrue(), ite));
                ite.setBodyFalse(this.convertBody(ite.getBodyFalse(), ite));
                ite.setCond(this.convertBody(ite.getCond(), ite));
                for (Element element : ite.internalVars) {
                    if (((Function)parent).internalVars.contains(element)) continue;
                    ((Function)parent).addInternalVar(element);
                }
                continue;
            }
            if (!(e instanceof Function)) continue;
            newel.add(e);
            this.treeToVector((Function)e);
        }
        return newel;
    }

    private Vector<Element> convertOperation(Operation op, Element parent) {
        Vector<Element> vec = new Vector<Element>();
        Vector<Element> input = op.getInput();
        op.setInput(new Vector<Element>());
        for (Element e : input) {
            if (e instanceof Operation) {
                vec.addAll(this.convertOperation((Operation)e, parent));
                SimpleVariable tmp = new SimpleVariable(TMP_NAME + this.tmpCpt++ + "_m2m");
                ((Operation)e).addOutput(tmp);
                ((Function)parent).addInternalVar(tmp);
                op.addInput(tmp);
                continue;
            }
            if (!(e instanceof Variable)) continue;
            if (parent instanceof LoopFor && ((Variable)e).getType().equalsIgnoreCase("const") && !((LoopFor)parent).getInternalVars().contains(e)) {
                ((LoopFor)parent).addInternalVar(e);
            }
            op.addInput(e);
        }
        vec.add(op);
        return vec;
    }

    public Vector<Element> createAff(Variable var, Vector<Element> expr) {
        Vector<Element> vec = new Vector<Element>();
        Operation result = new Assignment();
        if (expr.lastElement() instanceof Variable) {
            vec.addAll(expr);
            vec.removeElementAt(vec.lastIndexOf(expr.lastElement()));
            result.addInput((Variable)expr.lastElement());
            result.setName("aff" + this.opCpt++);
            var.setType(((Variable)expr.lastElement()).getType());
            if (var instanceof SimpleVariable) {
                ((SimpleVariable)var).setSize(((Variable)expr.lastElement()).getSize());
            }
            if (((Variable)expr.lastElement()).getType().equals("const")) {
                ((SimpleVariable)var).setVal(((Variable)expr.lastElement()).getVal());
            }
        } else if (expr.lastElement() instanceof Negation) {
            vec.addAll(expr);
            result.addInput(((Negation)expr.lastElement()).getOutputAt(0));
            result.setName("aff" + this.opCpt++);
            var.setType(((Variable)((Negation)expr.lastElement()).getOutputAt(0)).getType());
        } else if (expr.lastElement() instanceof Operation) {
            vec.addAll(expr);
            vec.removeElementAt(vec.lastIndexOf(expr.lastElement()));
            result = (Operation)expr.lastElement();
        }
        result.addOutput(var);
        vec.add(result);
        return vec;
    }

    public SimpleVariable createInOut(String name) {
        SimpleVariable var = null;
        if (this.varMap.containsKey(name)) {
            var = this.varMap.get(name);
        } else {
            var = new SimpleVariable(name);
            this.varMap.put(name, var);
        }
        if (this.pragmaMap.containsKey(StructTreatment.getTrueName(name))) {
            var.setType(this.pragmaMap.get(StructTreatment.getTrueName(name)));
        }
        return var;
    }

    public Vector<Element> createVar(String name, ArrayList<Double> val, String type, int size, boolean minus) {
        SimpleVariable var = null;
        Vector<Element> vec = new Vector<Element>();
        if (name.isEmpty()) {
            vec.add(new SimpleVariable(val));
        } else if (minus && !this.negList.contains(name)) {
            Negation neg = null;
            neg = new Negation();
            var = (SimpleVariable)this.createVar(String.valueOf(StructTreatment.getTrueName(name)) + "_m2m_n", 0.0, "", false).lastElement();
            if (this.pragmaMap.containsKey(name)) {
                var.setType(this.pragmaMap.get(name));
            }
            neg.addOutput(var);
            neg.addInput(this.createVar(name, 0.0, "", false).lastElement());
            neg.setName("neg" + this.opCpt++);
            this.negList.add(name);
            vec.add(neg);
            vec.add(var);
        } else if (minus) {
            vec.add(this.createVar(String.valueOf(name) + "_m2m_n", 0.0, "", false).lastElement());
        } else {
            if (this.varMap.containsKey(name)) {
                var = this.varMap.get(name);
            } else {
                var = new SimpleVariable(name, val, type);
                var.setSize(size);
                this.top.addInternalVar(var);
                this.varMap.put(name, var);
            }
            if (this.pragmaMap.containsKey(StructTreatment.getTrueName(name))) {
                var.setType(this.pragmaMap.get(StructTreatment.getTrueName(name)));
            }
            vec.add(var);
        }
        return vec;
    }

    public static String getTrueName(String name) {
        StringTokenizer st = new StringTokenizer(name, "_");
        String trueName = new String();
        String tmp = new String();
        if (st.hasMoreTokens()) {
            trueName = st.nextToken();
        }
        while (st.hasMoreTokens()) {
            tmp = st.nextToken();
            if (tmp.equals("m2m")) {
                return trueName;
            }
            trueName = String.valueOf(trueName) + "_" + tmp;
        }
        return trueName;
    }

    public Vector<Element> createSimpleVar(SimpleVariable var) {
        return this.createVar(var.getName(), var.getValues(), var.getType(), var.getSize(), false);
    }

    public Vector<Element> createVar(Variable var) {
        Vector<Element> vec = null;
        if (var instanceof VectorVariable) {
            vec = this.createVar(((VectorVariable)var).getVar());
        } else if (var instanceof SimpleVariable) {
            vec = this.createSimpleVar((SimpleVariable)var);
        }
        return vec;
    }

    public Vector<Element> createVar(String name, double val, String type, boolean minus) {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(val);
        return this.createVar(name, values, type, 1, minus);
    }

    public Vector<Element> createVar(String name) {
        ArrayList<Double> values = new ArrayList<Double>();
        return this.createVar(name, values, "", 0, false);
    }

    public void count(Element el) {
        el.setName(String.valueOf(el.getName()) + this.opCpt++);
    }

    public void createInOutAff(Function top, HashMap<String, ReadWriteIndex> map) {
        Assignment aff;
        String name;
        int cpt = 0;
        if (top == null) {
            top = this.top;
        }
        for (Element var : top.getInput()) {
            name = var.getName();
            if (this.varMap.containsKey(String.valueOf(name) + "_m2m_0")) {
                aff = new Assignment();
                aff.setName("aff_final_" + cpt++);
                aff.addInput(var);
                aff.addOutput(this.varMap.get(String.valueOf(name) + "_m2m_0"));
                top.addBodyToTop(aff);
                continue;
            }
            aff = new Assignment();
            aff.setName("aff_final_" + cpt++);
            Variable tmp = (Variable)this.createVar(String.valueOf(name) + "_m2m_0", 0.0, "", false).lastElement();
            aff.addInput(var);
            aff.addOutput(tmp);
            top.addBodyToTop(aff);
        }
        for (Element var : top.getOutput()) {
            name = var.getName();
            if (!map.containsKey(name) || !this.varMap.containsKey(String.valueOf(name) + "_m2m_" + map.get(name).getReadIndex())) continue;
            aff = new Assignment();
            aff.setName("aff_final_" + cpt++);
            aff.addInput(this.varMap.get(String.valueOf(name) + "_m2m_" + map.get(name).getReadIndex()));
            aff.addOutput(var);
            top.addBody(aff);
        }
    }

    public void addPragma(String pragma) {
        StringTokenizer st = new StringTokenizer(pragma, " :\t");
        String name = null;
        String type = null;
        if (st.countTokens() == 3 & st.nextToken().equals("%m2m")) {
            name = st.nextToken();
            type = st.nextToken();
            this.pragmaMap.put(name, type);
            this.changeType(this.top, name, type);
        } else {
            System.out.println("#Le pragma ne respecte pas le standard!");
        }
    }

    public void addPragma(String name, String type) {
        this.pragmaMap.put(name, type);
        this.changeType(this.top, name, type);
        System.out.println("Nombre d'occurences de la variable modifi\u00c3\u00a9e :" + this.changeType(this.top, name, type));
    }

    private int changeType(Element top, String name, String type) {
        int nb = 0;
        if (top instanceof Function) {
            if (top instanceof LoopFor) {
                nb += this.changeType(((LoopFor)top).getStart(), name, type);
                nb += this.changeType(((LoopFor)top).getIncr(), name, type);
                nb += this.changeType(((LoopFor)top).getEnd(), name, type);
            }
            for (Element el : ((Function)top).getInput()) {
                nb += this.changeType(el, name, type);
            }
            for (Element el : ((Function)top).getOutput()) {
                nb += this.changeType(el, name, type);
            }
            for (Element el : ((Function)top).getInternalVars()) {
                nb += this.changeType(el, name, type);
            }
            for (Element el : ((Function)top).getBody()) {
                nb += this.changeType(el, name, type);
            }
        } else if (top instanceof Operation) {
            for (Element el : ((Operation)top).getInput()) {
                nb += this.changeType(el, name, type);
            }
            for (Element el : ((Operation)top).getOutput()) {
                nb += this.changeType(el, name, type);
            }
        } else if (top instanceof SimpleVariable) {
            if (StructTreatment.getTrueName(top.getName()).equals(name)) {
                ((SimpleVariable)top).setType(type);
                return 1;
            }
        } else if (top instanceof VectorVariable && StructTreatment.getTrueName(top.getName()).equals(name)) {
            ((SimpleVariable)((VectorVariable)top).getVar()).setType(type);
            return 1;
        }
        return nb;
    }

    public void changeVar(Element top, Variable varin, Variable varout) {
        block10: {
            block9: {
                if (!(top instanceof Function)) break block9;
                for (Element el : ((Function)top).getBody()) {
                    this.changeVar(el, varin, varout);
                }
                while (((Function)top).getInput().indexOf(varin) != -1) {
                    ((Function)top).getInput().set(((Function)top).getInput().indexOf(varin), varout);
                }
                while (((Function)top).getOutput().indexOf(varin) != -1) {
                    ((Function)top).getOutput().set(((Function)top).getOutput().indexOf(varin), varout);
                }
                if (!(top instanceof IfThenElse)) break block10;
                for (Element el : ((IfThenElse)top).getCond()) {
                    this.changeVar(el, varin, varout);
                }
                for (Element el : ((IfThenElse)top).getBodyTrue()) {
                    this.changeVar(el, varin, varout);
                }
                for (Element el : ((IfThenElse)top).getBodyFalse()) {
                    this.changeVar(el, varin, varout);
                }
                break block10;
            }
            if (top instanceof Operation) {
                while (((Operation)top).getInput().indexOf(varin) != -1) {
                    ((Operation)top).getInput().set(((Operation)top).getInput().indexOf(varin), varout);
                }
                while (((Operation)top).getOutput().indexOf(varin) != -1) {
                    ((Operation)top).getOutput().set(((Operation)top).getOutput().indexOf(varin), varout);
                }
            }
        }
    }

    public void findInBody(Element top, HashMap<String, ReadWriteIndex> cpt) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        if (top instanceof LoopFor) {
            for (Element el : ((LoopFor)top).getBody()) {
                String name;
                if (el instanceof Operation) {
                    for (Element in : ((Operation)el).getInput()) {
                        name = StructTreatment.getTrueName(in.getName());
                        if (!(in instanceof Variable & !((Variable)in).getType().equals("const") & !((Variable)in).getType().equals("iter") & !((LoopFor)top).getInput().contains(in) & !name.contains(TMP_NAME))) continue;
                        list.put(name, cpt.get(name).getReadIndex());
                    }
                    continue;
                }
                if (!(el instanceof Function)) continue;
                for (Element in : ((Function)el).getInput()) {
                    name = StructTreatment.getTrueName(in.getName());
                    if (!(in instanceof Variable & !((Variable)in).getType().equals("const") & !((LoopFor)top).getInput().contains(in) & !name.contains(TMP_NAME) & !((Variable)in).getType().equals("iter"))) continue;
                    list.put(name, cpt.get(name).getReadIndex());
                }
            }
        }
        for (String s : list.keySet()) {
            Element e = this.createVar(String.valueOf(s) + "_m2m_" + cpt.get(s).getReadIndex()).lastElement();
            if (((LoopFor)top).getInput().contains(e) || !((Variable)e).getType().equals("iter")) continue;
            ((LoopFor)top).addInput(e);
        }
    }

    public boolean isVariable(String name) {
        for (String var : this.varMap.keySet()) {
            if (!StructTreatment.getTrueName(var).equals(name)) continue;
            return true;
        }
        return false;
    }

    public Vector<Variable> monitoredVar() {
        Vector<Variable> vec = new Vector<Variable>();
        for (SimpleVariable var : this.varMap.values()) {
            if (!var.monitor) continue;
            vec.add(var);
        }
        return vec;
    }

    public void setBlock(Element top, String opName, BuildingBlock block) {
        if (top instanceof Function) {
            for (Element el : ((Function)top).getBody()) {
                this.setBlock(el, opName, block);
            }
        } else if (top instanceof Operation && ((Operation)top).getOpName().equals(opName)) {
            ((Operation)top).setBlock(block);
        }
    }

    public boolean writeVHDL(String vhdlPath) {
        File file = new File(String.valueOf(vhdlPath) + this.top.getName() + ".vhd");
        FileWriter fw = null;
        try {
            StructTreatment structCopy = this.copy();
            this.setCost(structCopy.top);
            fw = new FileWriter(file);
            String sVhdl = new String();
            VHDLCreator vhdl = new VHDLCreator(structCopy.top, this.project);
            vhdl.wrapTop(vhdlPath);
            sVhdl = vhdl.createVHDL(file.getName());
            fw.write(sVhdl);
            fw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (VHDLException e) {
            System.out.println("#Unable to create VHDL file! " + e.getMessage());
            return false;
        }
        catch (Exception exception) {
            System.out.println("#Unable to create VHDL file! ");
            return false;
        }
        System.out.println("VHDL file written!");
        return true;
    }

    public void print() {
        System.out.println(this.top.toString(0));
    }

    public boolean writeSchematic(String outFile) {
        File file = new File(outFile);
        try {
            FileWriter fw = new FileWriter(file);
            String str = this.createSchematic();
            fw.write(str);
            fw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        System.out.println("Schematic file written!");
        return true;
    }

    private String createSchematic() {
        String sSchema = new String();
        sSchema = String.valueOf(sSchema) + "digraph G  {\n";
        sSchema = String.valueOf(sSchema) + this.top.toSchematic(1, "", GraphParams.defaultShape, "");
        sSchema = String.valueOf(sSchema) + "\n}";
        return sSchema;
    }

    public void writeOctaveFile() {
        this.writeOctaveFile(null);
    }

    public boolean writeOctaveFile(String outFile) {
        File file;
        if (outFile == null) {
            file = new File("test/" + this.top.getName() + ".m");
            System.out.println(file.getName());
        } else {
            file = new File(outFile);
        }
        try {
            FileWriter fw = new FileWriter(file);
            String str = this.createOctave();
            fw.write(str);
            fw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        System.out.println("Octave file written!");
        return true;
    }

    private String createOctave() {
        String sOctave = new String();
        sOctave = String.valueOf(sOctave) + this.top.toOctave(0);
        return sOctave;
    }

    public void clean(Vector<Element> body, Vector<Element> varVector) {
        Vector<Function> functionVector = new Vector<Function>();
        Vector<Element> elementList = new Vector<Element>();
        elementList.addAll(body);
        Iterator iterElement = elementList.iterator();
        while (iterElement.hasNext()) {
            Element element = (Element)iterElement.next();
            if (element instanceof Operation) {
                for (Element input : ((Operation)element).getInput()) {
                    if (input instanceof Operation) {
                        elementList.add(input);
                        continue;
                    }
                    varVector.add(input);
                }
            } else if (element instanceof Function) {
                varVector.addAll(((Function)element).getInput());
                functionVector.add((Function)element);
            }
            elementList.remove(elementList.indexOf(element));
            iterElement = elementList.iterator();
        }
        Vector<Element> tmpVarVector = new Vector<Element>();
        for (Function function : functionVector) {
            for (Element variable : function.outputVars) {
                if (varVector.contains(variable)) continue;
                tmpVarVector.add(variable);
            }
            function.outputVars.removeAll(tmpVarVector);
            if (function instanceof IfThenElse) {
                this.clean(((IfThenElse)function).getBodyTrue(), varVector);
                this.clean(((IfThenElse)function).getBodyFalse(), varVector);
                continue;
            }
            this.clean(function.body, varVector);
        }
    }

    public void updateConditionsFor(HashMap<String, ReadWriteIndex> tmpVar, HashMap<String, ReadWriteIndex> cptVar, LoopFor loopFor) {
        String name = StructTreatment.getTrueName(loopFor.getEnd().getName());
        if (cptVar.get(name) != null && cptVar.get(name).getReadIndex() - tmpVar.get(name).getReadIndex() != tmpVar.get(name).getDiff()) {
            loopFor.setEnd((SimpleVariable)this.createVar(String.valueOf(name) + "_m2m_" + cptVar.get(name).getReadIndex()).lastElement());
        }
        if (cptVar.get(name = StructTreatment.getTrueName(loopFor.getIncr().getName())) != null && cptVar.get(name).getReadIndex() - tmpVar.get(name).getReadIndex() != tmpVar.get(name).getDiff()) {
            loopFor.setIncr((SimpleVariable)this.createVar(String.valueOf(name) + "_m2m_" + cptVar.get(name).getReadIndex()).lastElement());
        }
    }

    public void updateConditionsWhile(HashMap<String, ReadWriteIndex> tmpVar, HashMap<String, ReadWriteIndex> cptVar, LoopWhile loopWhile) {
        for (Element op : loopWhile.getCond()) {
            int i = 0;
            while (i < ((Operation)op).getInput().size()) {
                Element e = ((Operation)op).getInputAt(i);
                String name = StructTreatment.getTrueName(e.getName());
                if (cptVar.get(name) != null && !name.equals(TMP_NAME) && tmpVar.get(name).getReadIndex() != cptVar.get(name).getReadIndex() - 1) {
                    ((Operation)op).setInputAt(i, (SimpleVariable)this.createVar(String.valueOf(name) + "_m2m_" + cptVar.get(name).getReadIndex()).lastElement());
                }
                ++i;
            }
        }
    }

    private void setCost(Function func) {
        for (Element e : func.getInput()) {
            ((SimpleVariable)e).setCost(0);
        }
        func.setMaxCost(this.setCost(func.getBody()));
    }

    private int setCost(Vector<Element> elements) {
        int maxCost = 0;
        int tempMaxCost = 0;
        for (Element e : elements) {
            if (e instanceof Operation) {
                tempMaxCost = this.setCost((Operation)e);
            } else if (e instanceof IfThenElse) {
                tempMaxCost = this.setCost((IfThenElse)e);
            } else if (e instanceof LoopFor) {
                LoopFor loop = (LoopFor)e;
                Vector<Integer> costs = new Vector<Integer>();
                int maxLoopCost = 0;
                for (Element sv : ((LoopFor)e).getInput()) {
                    costs.add(((SimpleVariable)sv).getCost());
                    maxLoopCost = ((SimpleVariable)sv).getCost() > maxLoopCost ? ((SimpleVariable)sv).getCost() : maxLoopCost;
                    ((SimpleVariable)sv).setCost(0);
                }
                tempMaxCost = this.setCost(((LoopFor)e).getBody());
                ((SimpleVariable)loop.getIterOperation().getOutputAt(0)).setCost(loop.getIterOperation().getBlock().latencyTime() + 1);
                tempMaxCost = tempMaxCost > loop.getIterOperation().getBlock().latencyTime() + 1 ? tempMaxCost : loop.getIterOperation().getBlock().latencyTime() + 1;
                loop.setMaxCost(tempMaxCost + maxLoopCost);
                loop.setRelativeMaxCost(tempMaxCost);
                for (Element sv : ((LoopFor)e).getInput()) {
                    ((SimpleVariable)sv).setCost((Integer)costs.elementAt(((LoopFor)e).getInput().indexOf(sv)));
                }
                for (Element sv : ((LoopFor)e).getOutput()) {
                    if (((SimpleVariable)sv).getCost() != tempMaxCost) {
                        ((SimpleVariable)sv).setLoopOutputCost(loop, ((SimpleVariable)sv).getCost());
                        ((SimpleVariable)sv).setLoopOutputConnect(loop, true);
                    }
                    ((SimpleVariable)sv).setCost(tempMaxCost + maxLoopCost);
                }
            }
            int n = maxCost = maxCost < tempMaxCost ? tempMaxCost : maxCost;
        }
        return maxCost;
    }

    private int setCost(Operation op) {
        int maxCost = 0;
        int tmpCost = 0;
        Vector<SimpleVariable> inputs = new Vector<SimpleVariable>();
        Vector<Vector<Element>> variablesDependencies = new Vector<Vector<Element>>();
        Vector<Element> resultDependencies = new Vector<Element>();
        int i = 0;
        while (i < op.getInput().size()) {
            inputs.add((SimpleVariable)op.getInputAt(i));
            ++i;
        }
        if (op instanceof Multiplexer) {
            inputs.add((SimpleVariable)((Multiplexer)op).getSel());
        }
        i = 0;
        while (i < inputs.size()) {
            SimpleVariable sv = (SimpleVariable)inputs.elementAt(i);
            variablesDependencies.add(sv.getVariableDependencies());
            ((Vector)variablesDependencies.elementAt(i)).add(sv);
            if (op.getBlock() == null) {
                maxCost = sv.getCost();
                break;
            }
            tmpCost = sv.getCost() + op.getBlock().latencyTime() + 1;
            maxCost = tmpCost > maxCost ? tmpCost : maxCost;
            ++i;
        }
        i = 0;
        while (i < variablesDependencies.size()) {
            int j = 0;
            while (j < ((Vector)variablesDependencies.elementAt(i)).size()) {
                if (!resultDependencies.contains(((Vector)variablesDependencies.elementAt(i)).elementAt(j))) {
                    resultDependencies.add((Element)((Vector)variablesDependencies.elementAt(i)).elementAt(j));
                }
                ++j;
            }
            ++i;
        }
        for (Element e : op.getOutput()) {
            if (((SimpleVariable)e).getCost() < maxCost) {
                ((SimpleVariable)e).setCost(maxCost);
            }
            ((SimpleVariable)e).getVariableDependencies().addAll(resultDependencies);
        }
        return maxCost;
    }

    private int setCost(IfThenElse ite) {
        int maxCost = 0;
        int tempMaxCost = 0;
        tempMaxCost = this.setCost(ite.getCond());
        maxCost = maxCost < tempMaxCost ? tempMaxCost : maxCost;
        tempMaxCost = this.setCost(ite.getBodyTrue());
        maxCost = maxCost < tempMaxCost ? tempMaxCost : maxCost;
        tempMaxCost = this.setCost(ite.getBodyFalse());
        maxCost = maxCost < tempMaxCost ? tempMaxCost : maxCost;
        return maxCost;
    }

    public boolean getMonitor() {
        return this.nbMonitor > 0;
    }

    public void modifyMonitor(boolean monitor) {
        this.nbMonitor = monitor ? ++this.nbMonitor : --this.nbMonitor;
    }

    public boolean isEmpty() {
        if (this.top == null) {
            return true;
        }
        return this.top.name.isEmpty();
    }

    public boolean fromXml(org.w3c.dom.Element el) {
        this.sourceMd5 = XMLUtils.getTextValue(el, "sourceMd5", "");
        this.nbMonitor = XMLUtils.getIntValue(el, "nbMonitor", 0);
        this.sourceCode = XMLUtils.getTextValue(el, "SourceCode", "");
        this.top = new Function();
        NodeList nl = el.getElementsByTagName("Function");
        if (nl != null && nl.getLength() > 0) {
            org.w3c.dom.Element e = (org.w3c.dom.Element)nl.item(0);
            if (e != null) {
                this.top.fromXml(e);
            } else {
                this.top = null;
            }
        }
        return true;
    }

    public String getXmlTagName() {
        return "Struct";
    }

    public org.w3c.dom.Element toXml(Document dom) {
        org.w3c.dom.Element el = dom.createElement(this.getXmlTagName());
        el.appendChild(XMLUtils.createTextElement(dom, "sourceMd5", this.sourceMd5));
        el.appendChild(XMLUtils.createIntElement(dom, "nbMonitor", this.nbMonitor));
        el.appendChild(XMLUtils.createTextElement(dom, "SourceCode", this.sourceCode));
        if (this.top != null) {
            el.appendChild(this.top.toXml(dom, false));
        }
        return el;
    }

    public Vector<Element> postParse(Function function) {
        Vector<Object> elements = new Vector();
        Vector<Element> removeElements = new Vector<Element>();
        if (function instanceof LoopFor) {
            for (Element e : function.getInput()) {
                function.addInternalVar(e);
            }
            if (!((LoopFor)function).getStart().getType().equalsIgnoreCase("const") && !function.getInput().contains(((LoopFor)function).getStart())) {
                function.addInput(((LoopFor)function).getStart());
                if (!function.getInternalVars().contains(((LoopFor)function).getStart())) {
                    function.addInternalVar(((LoopFor)function).getStart());
                }
            }
            if (!((LoopFor)function).getIncr().getType().equalsIgnoreCase("const") && !function.getInput().contains(((LoopFor)function).getIncr())) {
                function.addInput(((LoopFor)function).getIncr());
                if (!function.getInternalVars().contains(((LoopFor)function).getIncr())) {
                    function.addInternalVar(((LoopFor)function).getIncr());
                }
            }
        }
        elements = this.postParse(function.getBody());
        int i = 0;
        while (i < function.getInternalVars().size()) {
            if (!elements.contains(function.getInternalVars().elementAt(i)) && !function.inputVars.contains(function.getInternalVars().elementAt(i))) {
                removeElements.add(function.getInternalVars().elementAt(i));
            }
            ++i;
        }
        function.getInternalVars().removeAll(removeElements);
        return elements;
    }

    public Vector<Element> postParse(Vector<Element> vector) {
        Vector<Element> elements = new Vector<Element>();
        for (Element e : vector) {
            if (e instanceof Operation) {
                for (Element input : ((Operation)e).getInput()) {
                    if (elements.contains(input)) continue;
                    elements.add(input);
                }
                for (Element output : ((Operation)e).getOutput()) {
                    if (elements.contains(output)) continue;
                    elements.add(output);
                }
                continue;
            }
            if (e instanceof IfThenElse) {
                elements.addAll(this.postParse(((IfThenElse)e).getBodyFalse()));
                elements.addAll(this.postParse(((IfThenElse)e).getBodyTrue()));
                elements.addAll(this.postParse(((IfThenElse)e).getCond()));
                continue;
            }
            if (!(e instanceof Function)) continue;
            this.postParse((Function)e);
            elements.addAll(((Function)e).getInput());
            elements.addAll(((Function)e).getOutput());
        }
        return elements;
    }
}

