/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.structure;

import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.Variable;
import m2m.backend.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VectorVariable
extends Variable {
    private Variable var;
    private int indice;

    @Override
    public boolean insideFromXml(org.w3c.dom.Element el, Function newFunc) {
        super.insideFromXml(el, newFunc);
        this.indice = XMLUtils.getIntValue(el, "Indice", 0);
        Node node = el.getFirstChild();
        while (node != null) {
            if (!node.getNodeName().equalsIgnoreCase("InntVar")) continue;
            org.w3c.dom.Element inputEl = (org.w3c.dom.Element)node;
            Node nodeIn = inputEl.getFirstChild().getNextSibling();
            while (nodeIn != null) {
                Element element;
                if (nodeIn.getNodeType() == 1 && (element = this.getElement((org.w3c.dom.Element)nodeIn, newFunc)) != null) {
                    this.var = (Variable)element;
                }
                nodeIn = nodeIn.getNextSibling();
            }
        }
        return !this.name.isEmpty();
    }

    @Override
    public String getXmlTagName() {
        return "VectorVariable";
    }

    @Override
    public void insideToXml(org.w3c.dom.Element el, Document dom, boolean shortRef) {
        if (shortRef) {
            el.appendChild(XMLUtils.createTextElement(dom, "Name", this.name));
        } else {
            super.insideToXml(el, dom, shortRef);
            el.appendChild(XMLUtils.createIntElement(dom, "Indice", this.indice));
            org.w3c.dom.Element v = dom.createElement("IntVar");
            v.appendChild(this.var.toXml(dom, shortRef));
            el.appendChild(v);
        }
    }

    @Override
    public Element copy(Function newFunc) {
        VectorVariable newVect = new VectorVariable();
        newVect.var = (Variable)this.var.copy(newFunc);
        newVect.indice = this.indice;
        return newVect;
    }

    public VectorVariable() {
        this.var = null;
        this.indice = 0;
    }

    public VectorVariable(Variable var, int i) {
        this.var = var;
        this.indice = i;
    }

    public void setVar(Variable var) {
        this.var = var;
    }

    public Variable getVar() {
        return this.var;
    }

    public void setInd(int i) {
        this.indice = i;
    }

    public int getInd() {
        return this.indice;
    }

    @Override
    public void setVal(double val) {
        this.var.setVal(val);
    }

    @Override
    public double getVal() {
        return this.var.getVal();
    }

    @Override
    public void setType(String t) {
        this.var.setType(t);
    }

    @Override
    public String getType() {
        return this.var.getType();
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public String getName() {
        return this.var.getName();
    }

    @Override
    public void setName(String name) {
        this.var.setName(name);
    }

    @Override
    public String toString(int level) {
        String s = new String();
        s = String.valueOf(s) + this.tab(level) + "[VectorVariable]\tIndice: " + this.indice + "\n";
        s = String.valueOf(s) + this.var.toString(level + 1);
        return s;
    }

    @Override
    public String toSchematic(int level, String prefix, String boxFormat, String color) {
        String s = new String();
        if (prefix.isEmpty()) {
            prefix = "var";
        }
        s = this.getName().isEmpty() ? String.valueOf(s) + "\n" + this.tab(level) + prefix + "[shape=\"" + boxFormat + "\" label = \"" + this.getVal() + "\" color=\"" + color + "\" style=\"filled\"]" : String.valueOf(s) + "\n" + this.tab(level) + prefix + "[shape=\"" + boxFormat + "\" label = \"" + this.getName() + "[" + this.indice + "]" + "\" color=\"" + color + "\" style=\"filled\"]";
        return s;
    }
}

