/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileUtils {
    public static String readFileAsString(String filePath) {
        byte[] buffer;
        block17: {
            buffer = new byte[(int)new File(filePath).length()];
            BufferedInputStream f = null;
            try {
                f = new BufferedInputStream(new FileInputStream(filePath));
                f.read(buffer);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = new String("");
                if (f != null) {
                    try {
                        f.close();
                    }
                    catch (IOException iOException) {}
                }
                return string;
            }
            catch (IOException iOException) {
                String string;
                block16: {
                    try {
                        string = new String("");
                        if (f == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (f != null) {
                            try {
                                f.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        f.close();
                    }
                    catch (IOException iOException3) {}
                }
                return string;
            }
            if (f == null) break block17;
            try {
                f.close();
            }
            catch (IOException iOException) {}
        }
        return new String(buffer);
    }

    public static String getStringMd5(String buf) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(buf.getBytes());
            byte[] digest = messageDigest.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            String hashtext = bigInt.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    public static String getMd5(String fileName) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            InputStream is = new FileInputStream(fileName);
            try {
                is = new DigestInputStream(is, md);
                byte[] b = new byte[is.available()];
                is.read(b, 0, is.available());
            }
            finally {
                is.close();
            }
            byte[] digest = md.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            String hashtext = bigInt.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "";
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public String getFileExtension(String fileName) {
        String ext = fileName.lastIndexOf(".") == -1 ? "" : fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        return ext;
    }

    public static boolean deleteDirContent(File file, String fileToKeep) {
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].getName().equalsIgnoreCase(fileToKeep)) {
                if (files[i].isDirectory()) {
                    FileUtils.deleteDirContent(files[i], fileToKeep);
                    files[i].delete();
                } else if (!files[i].delete()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean compareDataFiles(File origFile, File regenFile) {
        boolean identical = true;
        try {
            int charRead;
            FileReader frOrig = new FileReader(origFile);
            FileReader frRegen = new FileReader(regenFile);
            while ((charRead = frOrig.read()) != -1) {
                if (charRead == frRegen.read()) continue;
                identical = false;
                break;
            }
            if (charRead != frRegen.read()) {
                identical = false;
            }
            frOrig.close();
            frRegen.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return identical;
    }

    public static boolean copyFile(String orig, String copy) {
        return FileUtils.copyFile(orig, copy, "");
    }

    public static boolean copyFile(String orig, String copy, String ignore) {
        File input = new File(orig);
        File output = new File(copy);
        if (input.isDirectory()) {
            output.mkdir();
            File[] fileList = input.listFiles();
            int i = 0;
            while (i < fileList.length) {
                String name = fileList[i].getName();
                if (!name.equalsIgnoreCase(ignore) && !FileUtils.copyFile(fileList[i].getAbsolutePath(), String.valueOf(output.getAbsolutePath()) + "/" + name, ignore)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        try {
            int c;
            FileReader in = new FileReader(input);
            FileWriter out = new FileWriter(output);
            while ((c = in.read()) != -1) {
                out.write((char)c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

