/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.utils;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    public static String getTextValue(Element ele, String tagName, String defaultValue) {
        Element el;
        String textVal = defaultValue;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0 && (el = (Element)nl.item(0)) != null && el.getFirstChild() != null) {
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    public static boolean getBoolValue(Element ele, String tagName, boolean defaultValue) {
        Element el;
        String textVal = "";
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0 && (el = (Element)nl.item(0)) != null && el.getFirstChild() != null) {
            textVal = el.getFirstChild().getNodeValue();
            return textVal.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public static int getIntValue(Element ele, String tagName, int defaultValue) {
        try {
            return Integer.parseInt(XMLUtils.getTextValue(ele, tagName, ""));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static float getFloatValue(Element ele, String tagName, float defaultValue) {
        try {
            return Float.parseFloat(XMLUtils.getTextValue(ele, tagName, ""));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static double getDoubleValue(Element ele, String tagName, double defaultValue) {
        try {
            return Double.parseDouble(XMLUtils.getTextValue(ele, tagName, ""));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Element createTextElement(Document dom, String tagName, String value) {
        if (tagName == null) {
            System.out.println("Error in XML creation. Empty tagname\n");
        } else if (tagName.isEmpty()) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        Element El = dom.createElement(tagName);
        Text text = value == null ? dom.createTextNode("") : dom.createTextNode(value);
        El.appendChild(text);
        return El;
    }

    public static Element createIntElement(Document dom, String tagName, int value) {
        if (tagName == null) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        if (tagName.isEmpty()) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        Element El = dom.createElement(tagName);
        String s = "";
        s = String.valueOf(s) + value;
        Text text = dom.createTextNode(s);
        El.appendChild(text);
        return El;
    }

    public static Element createFloatElement(Document dom, String tagName, float value) {
        if (tagName == null) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        if (tagName.isEmpty()) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        Element El = dom.createElement(tagName);
        String s = "";
        s = String.valueOf(s) + value;
        Text text = dom.createTextNode(s);
        El.appendChild(text);
        return El;
    }

    public static Element createDoubleElement(Document dom, String tagName, double value) {
        if (tagName == null) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        if (tagName.isEmpty()) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        Element El = dom.createElement(tagName);
        String s = "";
        s = String.valueOf(s) + value;
        Text text = dom.createTextNode(s);
        El.appendChild(text);
        return El;
    }

    public static Element createBoolElement(Document dom, String tagName, boolean value) {
        if (tagName == null) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        if (tagName.isEmpty()) {
            System.out.println("Error in XML creation. Empty tagname\n");
        }
        Element El = dom.createElement(tagName);
        String sValue = value ? "true" : "false";
        Text text = dom.createTextNode(sValue);
        El.appendChild(text);
        return El;
    }
}

