/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.verifpga;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public final class BinaryOut {
    private BufferedOutputStream out;
    private int buffer;
    private int N;

    public BinaryOut(OutputStream os) {
        this.out = new BufferedOutputStream(os);
    }

    public BinaryOut() {
        this(System.out);
    }

    public BinaryOut(String s) {
        try {
            FileOutputStream os = new FileOutputStream(s);
            this.out = new BufferedOutputStream(os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BinaryOut(Socket socket) {
        try {
            OutputStream os = socket.getOutputStream();
            this.out = new BufferedOutputStream(os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeBit(boolean bit) {
        this.buffer <<= 1;
        if (bit) {
            this.buffer |= 1;
        }
        ++this.N;
        if (this.N == 8) {
            this.clearBuffer();
        }
    }

    private void writeByte(int x) {
        assert (x >= 0 && x < 256);
        if (this.N == 0) {
            try {
                this.out.write(x);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        int i = 0;
        while (i < 8) {
            boolean bit = (x >>> 8 - i - 1 & 1) == 1;
            this.writeBit(bit);
            ++i;
        }
    }

    private void clearBuffer() {
        if (this.N == 0) {
            return;
        }
        if (this.N > 0) {
            this.buffer <<= 8 - this.N;
        }
        try {
            this.out.write(this.buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.N = 0;
        this.buffer = 0;
    }

    public void flush() {
        this.clearBuffer();
        try {
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.flush();
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(boolean x) {
        this.writeBit(x);
    }

    public void write(byte x) {
        this.writeByte(x & 0xFF);
    }

    public void write(int x) {
        this.writeByte(x >>> 24 & 0xFF);
        this.writeByte(x >>> 16 & 0xFF);
        this.writeByte(x >>> 8 & 0xFF);
        this.writeByte(x >>> 0 & 0xFF);
    }

    public void write(int x, int r) {
        if (r == 32) {
            this.write(x);
        }
        if (r < 1 || r > 32) {
            throw new RuntimeException("Illegal value for r = " + r);
        }
        if (x < 0 || x >= 1 << r) {
            throw new RuntimeException("Illegal " + r + "-bit char = " + x);
        }
        int i = 0;
        while (i < r) {
            boolean bit = (x >>> r - i - 1 & 1) == 1;
            this.writeBit(bit);
            ++i;
        }
    }

    public void write(double x) {
        this.write(Double.doubleToRawLongBits(x));
    }

    public void write(long x) {
        this.writeByte((int)(x >>> 56 & 0xFFL));
        this.writeByte((int)(x >>> 48 & 0xFFL));
        this.writeByte((int)(x >>> 40 & 0xFFL));
        this.writeByte((int)(x >>> 32 & 0xFFL));
        this.writeByte((int)(x >>> 24 & 0xFFL));
        this.writeByte((int)(x >>> 16 & 0xFFL));
        this.writeByte((int)(x >>> 8 & 0xFFL));
        this.writeByte((int)(x >>> 0 & 0xFFL));
    }

    public void write(float x) {
        this.write(Float.floatToRawIntBits(x));
    }

    public void write(short x) {
        this.writeByte(x >>> 8 & 0xFF);
        this.writeByte(x >>> 0 & 0xFF);
    }

    public void write(char x) {
        if (x < '\u0000' || x >= '\u0100') {
            throw new RuntimeException("Illegal 8-bit char = " + x);
        }
        this.writeByte(x);
    }

    public void write(char x, int r) {
        if (r == 8) {
            this.write(x);
        }
        if (r < 1 || r > 16) {
            throw new RuntimeException("Illegal value for r = " + r);
        }
        if (x < '\u0000' || x >= 1 << r) {
            throw new RuntimeException("Illegal " + r + "-bit char = " + x);
        }
        int i = 0;
        while (i < r) {
            boolean bit = (x >>> r - i - 1 & 1) == 1;
            this.writeBit(bit);
            ++i;
        }
    }

    public void write(String s) {
        int i = 0;
        while (i < s.length()) {
            this.write(s.charAt(i));
            ++i;
        }
    }

    public void write(String s, int r) {
        int i = 0;
        while (i < s.length()) {
            this.write(s.charAt(i), r);
            ++i;
        }
    }
}

