/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.verifpga;

import java.util.Vector;
import m2m.backend.verifpga.BinaryIn;

public class M2MData {
    private int nbTests;
    private int nbInputs;
    private int nbOutputs;
    private String dataPath;
    private Vector<Float>[] inputData;

    public M2MData(int nbTests, int nbInputs, int nbOutputs, String dataPath) {
        this.dataPath = dataPath;
        this.nbTests = nbTests;
        this.nbInputs = nbInputs;
        this.nbOutputs = nbOutputs;
        this.inputData = new Vector[nbInputs];
        int i = 0;
        while (i < nbInputs) {
            this.inputData[i] = new Vector(nbTests);
            ++i;
        }
    }

    public void readInputData() {
        BinaryIn[] isFiles = new BinaryIn[this.nbInputs];
        int i = 0;
        while (i < this.nbInputs) {
            isFiles[i] = new BinaryIn(String.valueOf(this.dataPath) + "file_input" + (i + 1) + ".dat");
            ++i;
        }
        i = 0;
        while (i < this.nbInputs) {
            System.out.println("file_input" + (i + 1) + ".dat, nbsamples: " + isFiles[i].readInt());
            System.out.println("file_input" + (i + 1) + ".dat, size: " + isFiles[i].readInt());
            ++i;
        }
        i = 0;
        while (i < this.nbInputs) {
            int j = 0;
            while (j < this.nbTests) {
                float entry = isFiles[i].readFloat();
                this.inputData[i].insertElementAt(Float.valueOf(entry), j);
                ++j;
            }
            ++i;
        }
    }

    public void setNbTests(int nbTests) {
        this.nbTests = nbTests;
    }

    public int getNbTests() {
        return this.nbTests;
    }

    public void setNbInputs(int nbInputs) {
        this.nbInputs = nbInputs;
    }

    public int getNbInputs() {
        return this.nbInputs;
    }

    public void setNbOutputs(int nbOutputs) {
        this.nbOutputs = nbOutputs;
    }

    public int getNbOutputs() {
        return this.nbOutputs;
    }

    public Vector<Float>[] getInputData() {
        return this.inputData;
    }
}

