/*
 * Decompiled with CFR 0.152.
 */
package m2m.backend.vhdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import m2m.backend.buildingblocks.BuildingBlock;
import m2m.backend.project.ExternalToolsProperties;
import m2m.backend.project.M2MProject;
import m2m.backend.structure.Assignment;
import m2m.backend.structure.Element;
import m2m.backend.structure.Function;
import m2m.backend.structure.IfThenElse;
import m2m.backend.structure.LoopFor;
import m2m.backend.structure.Operation;
import m2m.backend.utils.FileUtils;
import m2m.backend.vhdl.VHDLException;

public class CompileScriptCreator {
    private Function top;
    private boolean loopFor;

    public CompileScriptCreator(Function top) {
        this.top = top;
        this.loopFor = false;
    }

    public boolean createCompileScript(M2MProject project, String projectPath, String outFile) {
        String fileName = String.valueOf(project.getSimPath()) + "/simulation.do";
        File compileFile = new File(fileName);
        try {
            FileWriter fw = new FileWriter(compileFile);
            String script = new String();
            script = this.createScript(project, projectPath, outFile);
            fw.write(script);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (VHDLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String createScript(M2MProject project, String projectPath, String outFile) throws VHDLException {
        File xilinxDir;
        File alteraDir;
        String script = new String();
        String fifoType = project.getOptimisationProperties().getFifoType();
        String libDir = String.valueOf(M2MProject.getLibPath()) + "/VHDL/";
        String vhdlDir = String.valueOf(project.getVHDLPath()) + "/";
        script = String.valueOf(script) + "set Path \"..\"\n";
        script = String.valueOf(script) + "set compPath \"$Path/" + M2MProject.getCompDirName() + "\"\n";
        script = String.valueOf(script) + "set srcSVPath \"$Path/" + M2MProject.getSVDirName() + "\"\n";
        script = String.valueOf(script) + "set srcVHDLPath \"$Path/" + M2MProject.getVHDLDirName() + "\"\n";
        script = String.valueOf(script) + "set workPath \"$Path/" + M2MProject.getCompDirName() + "/work\"\n";
        script = String.valueOf(script) + "vlib $workPath\n\n";
        script = String.valueOf(script) + "vmap work $workPath\n\n";
        if (ExternalToolsProperties.getReference().getSimulationFiles() == 2) {
            script = String.valueOf(script) + "## compile uvm\n";
            script = String.valueOf(script) + "set uvmPath \"$Path/" + M2MProject.getCompDirName() + "/m2mUvm\"\n";
            script = String.valueOf(script) + "vlib $uvmPath\n";
            script = String.valueOf(script) + "vmap m2mUvm $uvmPath\n";
        } else {
            script = String.valueOf(script) + "## compile ovm\n";
            script = String.valueOf(script) + "set ovmPath \"$Path/" + M2MProject.getCompDirName() + "/m2mOvm\"\n";
            script = String.valueOf(script) + "vlib $ovmPath\n";
            script = String.valueOf(script) + "vmap m2mOvm $ovmPath\n";
        }
        script = ExternalToolsProperties.getReference().getSimulationFiles() == 2 ? String.valueOf(script) + "vlog -work m2mUvm +incdir+$srcSVPath/uvm/src $srcSVPath/uvm/src/uvm_pkg.sv\n\n" : (ExternalToolsProperties.getReference().getSimulationFiles() == 1 ? String.valueOf(script) + "vlog -work m2mOvm +define+M2M_USE_OVM +incdir+$srcSVPath/ovm/src $srcSVPath/ovm/src/ovm_pkg.sv\n\n" : String.valueOf(script) + "vlog -work m2mOvm +define+M2M_USE_OVM +incdir+$srcSVPath/ovm_original/src $srcSVPath/ovm_original/src/ovm_pkg.sv\n\n");
        FileUtils.copyFile(String.valueOf(libDir) + "pkg_definition.vhd", String.valueOf(vhdlDir) + "pkg_definition.vhd");
        FileUtils.copyFile(String.valueOf(libDir) + "pkg_cellule.vhd", String.valueOf(vhdlDir) + "pkg_cellule.vhd");
        FileUtils.copyFile(String.valueOf(libDir) + "misc.vhd", String.valueOf(vhdlDir) + "misc.vhd");
        FileUtils.copyFile(String.valueOf(libDir) + "fifo_std.vhd", String.valueOf(vhdlDir) + "fifo_std.vhd");
        script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/pkg_definition.vhd\" \"$srcVHDLPath/fifo_std.vhd\" \"$srcVHDLPath/pkg_cellule.vhd\" \"$srcVHDLPath/misc.vhd\"\n";
        Vector<Element> body = this.top.getBody();
        Vector bodyclone = (Vector)body.clone();
        Vector<Element> operations = this.findOperations(bodyclone);
        int i = 0;
        while (i < operations.size() - 1) {
            int j = i + 1;
            while (j < operations.size()) {
                if (operations.elementAt(i) instanceof Operation && operations.elementAt(j) instanceof Operation && !(operations.elementAt(i) instanceof Assignment) && !(operations.elementAt(j) instanceof Assignment)) {
                    Operation op1 = (Operation)operations.elementAt(i);
                    Operation op2 = (Operation)operations.elementAt(j);
                    if (op1.getBlock().entityName().equalsIgnoreCase(op2.getBlock().entityName())) {
                        operations.remove(j);
                        --j;
                    }
                }
                ++j;
            }
            ++i;
        }
        for (Element el : operations) {
            if (!(el instanceof Operation) || el instanceof Assignment) continue;
            Operation op = (Operation)el;
            BuildingBlock block = op.getBlock();
            script = String.valueOf(script) + "vcom -work \"$workPath\"";
            if (block.dependentFiles() != null) {
                int i2 = 0;
                while (i2 < block.dependentFiles().size()) {
                    FileUtils.copyFile(String.valueOf(libDir) + block.dependentFiles().get(i2), String.valueOf(vhdlDir) + block.dependentFiles().get(i2));
                    script = String.valueOf(script) + " \"$srcVHDLPath/" + block.dependentFiles().get(i2) + "\"";
                    ++i2;
                }
            }
            FileUtils.copyFile(String.valueOf(libDir) + block.vhdlFileName(), String.valueOf(vhdlDir) + block.vhdlFileName());
            script = String.valueOf(script) + " \"$srcVHDLPath/" + block.vhdlFileName() + "\"";
            script = String.valueOf(script) + " \"$srcVHDLPath/wrapper_" + block.entityName() + ".vhd\"\n";
        }
        Vector<Element> functions = this.findFunctions(bodyclone);
        for (Element el : functions) {
            if (!(el instanceof LoopFor)) continue;
            LoopFor loop = (LoopFor)el;
            script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/log_pkg.vhd\"";
            script = String.valueOf(script) + " \"$srcVHDLPath/loop_" + loop.getName() + ".vhd\"\n";
            FileUtils.copyFile(String.valueOf(libDir) + "log_pkg.vhd", String.valueOf(vhdlDir) + "log_pkg.vhd");
        }
        if (project.getUseFifo()) {
            if (fifoType.equalsIgnoreCase("Altera")) {
                alteraDir = new File(String.valueOf(vhdlDir) + "altera_mf");
                alteraDir.mkdir();
                FileUtils.copyFile(String.valueOf(libDir) + "log_pkg.vhd", String.valueOf(vhdlDir) + "log_pkg.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "fifo_Altera.vhd", String.valueOf(vhdlDir) + "fifo_Altera.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "altera_mf/altera_mf.vhd", String.valueOf(vhdlDir) + "altera_mf/altera_mf.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "altera_mf/altera_mf_components.vhd", String.valueOf(vhdlDir) + "altera_mf/altera_mf_components.vhd");
                script = String.valueOf(script) + "vmap altera_mf work\n";
                script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/log_pkg.vhd\"\n";
                script = String.valueOf(script) + "vcom -work altera_mf \"$srcVHDLPath/altera_mf/altera_mf_components.vhd\" \"$srcVHDLPath/altera_mf/altera_mf.vhd\"\n";
                script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/fifo_Altera.vhd\"\n";
            } else if (fifoType.equalsIgnoreCase("Xilinx")) {
                xilinxDir = new File(String.valueOf(vhdlDir) + "XilinxCoreLib");
                xilinxDir.mkdir();
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/fifo_generator_v4_3.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/fifo_generator_v4_3.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/iputils_conv.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/iputils_conv.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/iputils_misc.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/iputils_misc.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/iputils_std_logic_arith.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/iputils_std_logic_arith.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/iputils_std_logic_unsigned.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/iputils_std_logic_unsigned.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "fifo_Xilinx.vhd", String.valueOf(vhdlDir) + "fifo_Xilinx.vhd");
                script = String.valueOf(script) + "vmap XilinxCoreLib work\n";
                script = String.valueOf(script) + "vcom -work XilinxCoreLib \"$srcVHDLPath/XilinxCoreLib/iputils_conv.vhd\" \"$srcVHDLPath/XilinxCoreLib/iputils_misc.vhd\" \"$srcVHDLPath/XilinxCoreLib/iputils_std_logic_arith.vhd\" \"$srcVHDLPath/XilinxCoreLib/iputils_std_logic_unsigned.vhd\" \"$srcVHDLPath/XilinxCoreLib/fifo_generator_v4_3.vhd\"\n";
                script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/fifo_Xilinx.vhd\"\n";
            } else {
                FileUtils.copyFile(String.valueOf(libDir) + "fifo_std.vhd", String.valueOf(vhdlDir) + "fifo_std.vhd");
                script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/fifo_std.vhd\"\n";
            }
        }
        if (this.loopFor) {
            FileUtils.copyFile(String.valueOf(libDir) + "Init_Input.vhd", String.valueOf(vhdlDir) + "Init_Input.vhd");
            FileUtils.copyFile(String.valueOf(libDir) + "Counter_Wr.vhd", String.valueOf(vhdlDir) + "Counter_Wr.vhd");
            FileUtils.copyFile(String.valueOf(libDir) + "Counter_Rd.vhd", String.valueOf(vhdlDir) + "Counter_Rd.vhd");
            FileUtils.copyFile(String.valueOf(libDir) + "Read_Result.vhd", String.valueOf(vhdlDir) + "Read_Result.vhd");
            FileUtils.copyFile(String.valueOf(libDir) + "Memory.vhd", String.valueOf(vhdlDir) + "Memory.vhd");
            script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/Init_Input.vhd\" \"$srcVHDLPath/Counter_Rd.vhd\" \"$srcVHDLPath/Read_Result.vhd\" \"$srcVHDLPath/Memory.vhd\" \"$srcVHDLPath/Counter_Wr.vhd\"\n";
            if (fifoType.equalsIgnoreCase("Altera")) {
                alteraDir = new File(String.valueOf(vhdlDir) + "altera_mf");
                alteraDir.mkdir();
                FileUtils.copyFile(String.valueOf(libDir) + "log_pkg.vhd", String.valueOf(vhdlDir) + "log_pkg.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "fifo_Altera.vhd", String.valueOf(vhdlDir) + "fifo_Altera.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "altera_mf/altera_mf.vhd", String.valueOf(vhdlDir) + "altera_mf/altera_mf.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "altera_mf/altera_mf_components.vhd", String.valueOf(vhdlDir) + "altera_mf/altera_mf_components.vhd");
                script = String.valueOf(script) + "vmap altera_mf work\n";
                script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/log_pkg.vhd\"\n";
                script = String.valueOf(script) + "vcom -work altera_mf \"$srcVHDLPath/altera_mf/altera_mf_components.vhd\" \"$srcVHDLPath/altera_mf/altera_mf.vhd\"\n";
                script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/fifo_Altera.vhd\"\n";
            } else if (fifoType.equalsIgnoreCase("Xilinx")) {
                xilinxDir = new File(String.valueOf(vhdlDir) + "XilinxCoreLib");
                xilinxDir.mkdir();
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/fifo_generator_v4_3.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/fifo_generator_v4_3.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/iputils_conv.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/iputils_conv.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/iputils_misc.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/iputils_misc.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/iputils_std_logic_arith.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/iputils_std_logic_arith.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "XilinxCoreLib/iputils_std_logic_unsigned.vhd", String.valueOf(vhdlDir) + "XilinxCoreLib/iputils_std_logic_unsigned.vhd");
                FileUtils.copyFile(String.valueOf(libDir) + "fifo_Xilinx.vhd", String.valueOf(vhdlDir) + "fifo_Xilinx.vhd");
                script = String.valueOf(script) + "vmap XilinxCoreLib work\n";
                script = String.valueOf(script) + "vcom -work XilinxCoreLib \"$srcVHDLPath/XilinxCoreLib/iputils_conv.vhd\" \"$srcVHDLPath/XilinxCoreLib/iputils_misc.vhd\" \"$srcVHDLPath/XilinxCoreLib/iputils_std_logic_arith.vhd\" \"$srcVHDLPath/XilinxCoreLib/iputils_std_logic_unsigned.vhd\" \"$srcVHDLPath/XilinxCoreLib/fifo_generator_v4_3.vhd\"\n";
                script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/fifo_Xilinx.vhd\"\n";
            } else {
                FileUtils.copyFile(String.valueOf(libDir) + "fifo_std.vhd", String.valueOf(vhdlDir) + "fifo_std.vhd");
                script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/fifo_std.vhd\"\n";
            }
        }
        script = String.valueOf(script) + "vcom -work \"$workPath\" \"$srcVHDLPath/" + this.top.getName() + ".vhd\"\n\n";
        if (ExternalToolsProperties.getReference().getSimulationFiles() == 2) {
            script = String.valueOf(script) + "vlog -work \"$workPath\" +incdir+$srcSVPath -L m2mUvm \"$srcSVPath/M2M_harness.sv\" \"$srcSVPath/M2M_tb.sv\"\n";
            script = String.valueOf(script) + "vsim -vopt  +incdir+\"$srcSVPath\" -L m2mUvm work.M2M_TB work.M2M_harness\n";
        } else {
            script = String.valueOf(script) + "vlog -work \"$workPath\" +incdir+$srcSVPath +define+M2M_USE_OVM -L m2mOvm \"$srcSVPath/M2M_harness.sv\" \"$srcSVPath/M2M_tb.sv\"\n";
            script = String.valueOf(script) + "vsim -vopt  +incdir+\"$srcSVPath\" -L m2mOvm work.M2M_TB work.M2M_harness\n";
        }
        script = String.valueOf(script) + "run -all";
        return script;
    }

    private Vector<Element> findOperations(Vector<Element> elements) throws VHDLException {
        Vector<Element> operations = new Vector<Element>();
        for (Element el : elements) {
            if (el instanceof Function) {
                if (el instanceof IfThenElse) {
                    operations.addAll(this.findOperations(((IfThenElse)el).getBodyFalse()));
                    operations.addAll(this.findOperations(((IfThenElse)el).getBodyTrue()));
                    operations.addAll(this.findOperations(((IfThenElse)el).getCond()));
                    continue;
                }
                if (!(el instanceof LoopFor)) continue;
                operations.addAll(this.findOperations(((LoopFor)el).getBody()));
                operations.add(((LoopFor)el).getIterOperation());
                this.loopFor = true;
                continue;
            }
            if (!(el instanceof Operation) || el instanceof Assignment) continue;
            Operation op = (Operation)el;
            BuildingBlock blockOp = op.getBlock();
            if (blockOp == null) {
                throw new VHDLException("No material description for the operation : " + op.getName());
            }
            operations.add(op);
            int j = 0;
            while (j < blockOp.nbInputs()) {
                if (op.getInputAt(j) instanceof Operation) {
                    Vector<Element> item = new Vector<Element>();
                    item.add(op.getInputAt(j));
                    operations.addAll(this.findOperations(item));
                }
                ++j;
            }
        }
        return operations;
    }

    private Vector<Element> findFunctions(Vector<Element> elements) throws VHDLException {
        Vector<Element> functions = new Vector<Element>();
        for (Element el : elements) {
            if (el instanceof Function) {
                functions.add(el);
                if (el instanceof IfThenElse) {
                    functions.addAll(this.findFunctions(((IfThenElse)el).getBodyFalse()));
                    functions.addAll(this.findFunctions(((IfThenElse)el).getBodyTrue()));
                    functions.addAll(this.findFunctions(((IfThenElse)el).getCond()));
                    continue;
                }
                if (!(el instanceof LoopFor)) continue;
                functions.addAll(this.findFunctions(((LoopFor)el).getBody()));
                continue;
            }
            if (!(el instanceof Operation) || el instanceof Assignment) continue;
            Operation op = (Operation)el;
            int j = 0;
            while (j < op.getInput().size()) {
                if (op.getInputAt(j) instanceof Operation) {
                    Vector<Element> item = new Vector<Element>();
                    item.add(op.getInputAt(j));
                    functions.addAll(this.findFunctions(item));
                }
                ++j;
            }
        }
        return functions;
    }
}

