/*
 * Decompiled with CFR 0.152.
 */
package m2m.frontend;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import m2m.backend.utils.XMLUtils;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class GUIProperties {
    private static GUIProperties singleProp = null;
    private String validateDir;
    private String[] reOpenFile = new String[5];

    public static GUIProperties getReference() {
        if (singleProp == null) {
            singleProp = new GUIProperties();
        }
        return singleProp;
    }

    public String getValidateDir() {
        return this.validateDir;
    }

    public void setValidateDir(String dir) {
        this.validateDir = dir;
    }

    public String getXmlTagName() {
        return "ReOpenFile";
    }

    public boolean fromXml(Element fstNmElmnt) {
        this.setValidateDir(XMLUtils.getTextValue(fstNmElmnt, "validateDir", ""));
        int findex = 1;
        while (findex < 6) {
            this.setReOpenFileAtIndex(XMLUtils.getTextValue(fstNmElmnt, "File" + findex, "No file"), findex - 1);
            ++findex;
        }
        return true;
    }

    public Element toXml(Document dom) {
        Element el = dom.createElement(this.getXmlTagName());
        el.appendChild(XMLUtils.createTextElement(dom, "validateDir", this.validateDir));
        int i = 1;
        while (i < 6) {
            Element fEl = dom.createElement("File" + i);
            Text path = dom.createTextNode(this.reOpenFile[i - 1]);
            fEl.appendChild(path);
            el.appendChild(fEl);
            ++i;
        }
        return el;
    }

    public String getReOpenFileAtIndex(int index) {
        return this.reOpenFile[index];
    }

    public String[] getReOpenFile() {
        return this.reOpenFile;
    }

    public void setReOpenFileAtIndex(String value, int index) {
        this.reOpenFile[index] = value;
    }

    private GUIProperties() {
        this.validateDir = new String("");
        int i = 0;
        while (i < 5) {
            this.reOpenFile[i] = new String("No file");
            ++i;
        }
        this.readSettings();
    }

    protected void finalize() {
    }

    public boolean writeSettings() {
        File file = Platform.getBundle((String)"m2mgui").getBundleContext().getDataFile("m2mprop");
        return this.writeSettings(file);
    }

    public boolean readSettings() {
        File file = Platform.getBundle((String)"m2mgui").getBundleContext().getDataFile("m2mprop");
        if (file == null) {
            return false;
        }
        if (file.length() == 0L) {
            return false;
        }
        return this.readSettings(file);
    }

    public boolean readSettings(File f) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(f);
            dom.getDocumentElement().normalize();
            System.out.println("Root element " + dom.getDocumentElement().getNodeName());
            Element docEl = dom.getDocumentElement();
            NodeList reOpenLst = docEl.getElementsByTagName(this.getXmlTagName());
            if (reOpenLst != null && reOpenLst.getLength() > 0) {
                Element fstNmElmnt = (Element)reOpenLst.item(0);
                this.fromXml(fstNmElmnt);
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return false;
        }
        catch (SAXException se) {
            se.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean writeSettings(File f) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            Element rootEl = dom.createElement("M2MSettings");
            dom.appendChild(rootEl);
            rootEl.appendChild(this.toXml(dom));
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(dom);
            trans.transform(source, result);
            String xmlString = sw.toString();
            try {
                FileWriter fstream = new FileWriter(f);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write(xmlString);
                out.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
        catch (ParserConfigurationException pce) {
            System.out.println("Error while trying to instantiate DocumentBuilder " + pce);
            return false;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

